/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.Map;
import java.util.logging.Logger;
import javax.swing.tree.TreeModel;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.util.logging.Logging;

public abstract class AbstractMetadata {
    protected static final Logger LOGGER;
    private transient int hashCode;
    private transient Map asMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractMetadata() {
    }

    protected AbstractMetadata(Object source) throws ClassCastException, UnmodifiableMetadataException {
        this.getStandard().shallowCopy(source, this, true);
    }

    public abstract MetadataStandard getStandard();

    public Class getInterface() {
        return this.getStandard().getInterface(this.getClass());
    }

    boolean isModifiable() {
        return this.getStandard().isModifiable(this.getClass());
    }

    void invalidate() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.hashCode = 0;
    }

    public synchronized Map asMap() {
        if (this.asMap == null) {
            this.asMap = this.getStandard().asMap(this);
        }
        return this.asMap;
    }

    public synchronized TreeModel asTree() {
        return this.getStandard().asTree(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        MetadataStandard standard = this.getStandard();
        return standard.shallowEquals(this, object, false);
    }

    public synchronized int hashCode() {
        int code = this.hashCode;
        if (code == 0) {
            code = this.getStandard().hashCode(this);
            if (!this.isModifiable()) {
                this.hashCode = code;
            }
        }
        return code;
    }

    public synchronized String toString() {
        return this.getStandard().toString(this);
    }

    static {
        $assertionsDisabled = !AbstractMetadata.class.desiredAssertionStatus();
        LOGGER = Logging.getLogger("org.geotools.metadata");
    }
}

