/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.geotools.resources.Utilities;

public class IndentedLineWriter
extends FilterWriter {
    private String margin = "";
    private boolean newLine = true;
    private boolean waitLF;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndentedLineWriter(Writer out) {
        super(out);
    }

    public int getIdentation() {
        return this.margin.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndentation(int width) {
        Object object = this.lock;
        synchronized (object) {
            this.margin = Utilities.spaces(width);
        }
    }

    protected void beginNewLine() throws IOException {
        this.out.write(this.margin);
    }

    private void doWrite(int c) throws IOException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (this.newLine && (c != 10 || !this.waitLF)) {
            this.beginNewLine();
        }
        this.out.write(c);
        this.newLine = c == 13 || c == 10;
        if (this.newLine) {
            this.waitLF = c == 13;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doWrite(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buffer, int offset, int length) throws IOException {
        int upper = offset + length;
        Object object = this.lock;
        synchronized (object) {
            block3: while (offset < upper) {
                if (this.newLine) {
                    this.doWrite(buffer[offset++]);
                    continue;
                }
                int lower = offset;
                do {
                    char c;
                    if ((c = buffer[offset]) != '\r' && c != '\n') continue;
                    this.out.write(buffer, lower, offset - lower);
                    this.doWrite(c);
                    ++offset;
                    continue block3;
                } while (++offset < upper);
                this.out.write(buffer, lower, offset - lower);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int offset, int length) throws IOException {
        int upper = offset + length;
        Object object = this.lock;
        synchronized (object) {
            block3: while (offset < upper) {
                if (this.newLine) {
                    this.doWrite(string.charAt(offset++));
                    continue;
                }
                int lower = offset;
                do {
                    char c;
                    if ((c = string.charAt(offset)) != '\r' && c != '\n') continue;
                    this.out.write(string, lower, offset - lower);
                    this.doWrite(c);
                    ++offset;
                    continue block3;
                } while (++offset < upper);
                this.out.write(string, lower, offset - lower);
                break;
            }
        }
    }

    static {
        $assertionsDisabled = !IndentedLineWriter.class.desiredAssertionStatus();
    }
}

