/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.GeoTools;
import org.geotools.factory.StrictHints;
import org.geotools.resources.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

public class Hints
extends RenderingHints {
    private static final Hints GLOBAL;
    private static boolean needScan;
    public static final ClassKey JTS_GEOMETRY_FACTORY;
    public static final ClassKey JTS_COORDINATE_SEQUENCE_FACTORY;
    public static final Key JTS_PRECISION_MODEL;
    public static final Key JTS_SRID;
    public static final ClassKey CRS_AUTHORITY_FACTORY;
    public static final ClassKey CS_AUTHORITY_FACTORY;
    public static final ClassKey DATUM_AUTHORITY_FACTORY;
    public static final ClassKey CRS_FACTORY;
    public static final ClassKey CS_FACTORY;
    public static final ClassKey DATUM_FACTORY;
    public static final ClassKey COORDINATE_OPERATION_FACTORY;
    public static final ClassKey COORDINATE_OPERATION_AUTHORITY_FACTORY;
    public static final ClassKey MATH_TRANSFORM_FACTORY;
    public static final ClassKey FEATURE_LOCK_FACTORY;
    public static final ClassKey FEATURE_COLLECTIONS;
    public static final ClassKey FEATURE_TYPE_FACTORY;
    public static final Key FEATURE_TYPE_FACTORY_NAME;
    public static final Key FEATURE_DETACHED;
    public static final Key FEATURE_2D;
    public static final ClassKey STYLE_FACTORY;
    public static final ClassKey ATTRIBUTE_TYPE_FACTORY;
    public static final ClassKey FILTER_FACTORY;
    public static final Key DEFAULT_COORDINATE_REFERENCE_SYSTEM;
    public static final FileKey CRS_AUTHORITY_EXTRA_DIRECTORY;
    public static final Key EPSG_DATA_SOURCE;
    public static final OptionKey DATUM_SHIFT_METHOD;
    public static final Key LENIENT_DATUM_SHIFT;
    public static final Key FORCE_LONGITUDE_FIRST_AXIS_ORDER;
    public static final Key FORCE_AXIS_ORDER_HONORING;
    public static final Key FORCE_STANDARD_AXIS_DIRECTIONS;
    public static final Key FORCE_STANDARD_AXIS_UNITS;
    public static final OptionKey BUFFER_POLICY;
    public static final IntegerKey BUFFER_LIMIT;
    public static final IntegerKey AUTHORITY_MAX_ACTIVE;
    public static final IntegerKey AUTHORITY_MIN_IDLE;
    public static final IntegerKey AUTHORITY_MAX_IDLE;
    public static final IntegerKey AUTHORITY_MIN_EVICT_IDLETIME;
    public static final IntegerKey AUTHORITY_SOFTMIN_EVICT_IDLETIME;
    public static final IntegerKey AUTHORITY_TIME_BETWEEN_EVICTION_RUNS;
    public static final Key VERSION;
    public static final Key GRID_COVERAGE_PROCESSOR;
    public static final Key IGNORE_COVERAGE_OVERVIEW;
    public static final Key USE_JAI_IMAGEREAD;
    public static final Key REPLACE_NON_GEOPHYSICS_VIEW;
    public static final Key TILE_ENCODING;
    public static final Key JAI_INSTANCE;
    public static final Key SAMPLE_DIMENSION_TYPE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$geotools$factory$Hints$Key;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$javax$sql$DataSource;

    public Hints(RenderingHints.Key key, Object value) {
        super(key, value);
    }

    public Hints(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2) {
        this(Hints.fromPairs(new Object[]{key1, value1, key2, value2}));
    }

    public Hints(RenderingHints.Key key1, Object value1, Object[] pairs) {
        this(Hints.fromPairs(key1, value1, pairs));
    }

    public Hints(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2, Object[] pairs) {
        this(Hints.fromPairs(key1, value1, key2, value2, pairs));
    }

    private static Map fromPairs(RenderingHints.Key key1, Object value1, Object[] pairs) {
        Map map = Hints.fromPairs(pairs);
        map.put(key1, value1);
        return map;
    }

    private static Map fromPairs(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2, Object[] pairs) {
        Map map = Hints.fromPairs(pairs);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    private static Map fromPairs(Object[] pairs) {
        HashMap<Key, Object> map = new HashMap<Key, Object>();
        for (int i = 0; i < pairs.length; i += 2) {
            Key key = (Key)pairs[i];
            Object value = pairs[i + 1];
            if (!key.isCompatibleValue(value)) {
                throw new ClassCastException(key + " requires " + key.getValueClass() + " - could cast " + value);
            }
            map.put(key, value);
        }
        return map;
    }

    public Hints(Map hints) {
        super(Hints.stripNonKeys(hints));
    }

    static Map stripNonKeys(Map hints) {
        if (hints == null) {
            return null;
        }
        HashMap filtered = hints;
        Iterator it = hints.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (key instanceof RenderingHints.Key) continue;
            if (filtered == hints) {
                filtered = new HashMap(hints);
            }
            filtered.remove(key);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanSystemProperties() {
        Hints hints = GLOBAL;
        synchronized (hints) {
            needScan = true;
        }
    }

    private static boolean ensureSystemDefaultLoaded() {
        if (!$assertionsDisabled && !Thread.holdsLock(GLOBAL)) {
            throw new AssertionError();
        }
        if (needScan) {
            needScan = false;
            return GeoTools.scanForSystemHints(GLOBAL);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hints getDefaults(boolean strict) {
        Hints hints;
        boolean changed;
        Hints hints2 = GLOBAL;
        synchronized (hints2) {
            changed = Hints.ensureSystemDefaultLoaded();
            hints = strict ? new StrictHints(GLOBAL) : new Hints((Map)GLOBAL);
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putSystemDefault(RenderingHints hints) {
        Hints hints2 = GLOBAL;
        synchronized (hints2) {
            Hints.ensureSystemDefaultLoaded();
            GLOBAL.add(hints);
        }
        GeoTools.fireConfigurationChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSystemDefault(RenderingHints.Key key) {
        Object value;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            value = GLOBAL.get(key);
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object putSystemDefault(RenderingHints.Key key, Object value) {
        Object old;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            old = GLOBAL.put(key, value);
        }
        if (changed || !Utilities.equals(value, old)) {
            GeoTools.fireConfigurationChanged();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object removeSystemDefault(RenderingHints.Key key) {
        Object old;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            old = GLOBAL.remove(key);
        }
        if (changed || old != null) {
            GeoTools.fireConfigurationChanged();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean changed;
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer("Hints:");
        buffer.append(lineSeparator).append(AbstractFactory.toString(this));
        HashMap<Object, Object> extra = null;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            if (!GLOBAL.isEmpty()) {
                extra = new HashMap<Object, Object>(GLOBAL);
            }
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        if (extra != null) {
            extra.keySet().removeAll(this.keySet());
            if (!extra.isEmpty()) {
                buffer.append("System defaults:").append(lineSeparator).append(AbstractFactory.toString(extra));
            }
        }
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !Hints.class.desiredAssertionStatus();
        GLOBAL = new Hints(Collections.EMPTY_MAP);
        needScan = true;
        JTS_GEOMETRY_FACTORY = new ClassKey("com.vividsolutions.jts.geom.GeometryFactory");
        JTS_COORDINATE_SEQUENCE_FACTORY = new ClassKey("com.vividsolutions.jts.geom.CoordinateSequenceFactory");
        JTS_PRECISION_MODEL = new Key("com.vividsolutions.jts.geom.PrecisionModel");
        JTS_SRID = new Key(Integer.class);
        CRS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSAuthorityFactory");
        CS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.cs.CSAuthorityFactory");
        DATUM_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumAuthorityFactory");
        CRS_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSFactory");
        CS_FACTORY = new ClassKey("org.opengis.referencing.cs.CSFactory");
        DATUM_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumFactory");
        COORDINATE_OPERATION_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationFactory");
        COORDINATE_OPERATION_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationAuthorityFactory");
        MATH_TRANSFORM_FACTORY = new ClassKey("org.opengis.referencing.operation.MathTransformFactory");
        FEATURE_LOCK_FACTORY = new ClassKey("org.geotools.data.FeatureLockFactory");
        FEATURE_COLLECTIONS = new ClassKey("org.geotools.feature.FeatureCollections");
        FEATURE_TYPE_FACTORY = new ClassKey("org.geotools.feature.FeatureTypeFactory");
        FEATURE_TYPE_FACTORY_NAME = new Key(String.class);
        FEATURE_DETACHED = new Key(Boolean.class);
        FEATURE_2D = new Key(Boolean.class);
        STYLE_FACTORY = new ClassKey("org.geotools.styling.StyleFactory");
        ATTRIBUTE_TYPE_FACTORY = new ClassKey("org.geotools.feature.AttributeTypeFactory");
        FILTER_FACTORY = new ClassKey("org.opengis.filter.FilterFactory");
        DEFAULT_COORDINATE_REFERENCE_SYSTEM = new Key("org.opengis.referencing.crs.CoordinateReferenceSystem");
        CRS_AUTHORITY_EXTRA_DIRECTORY = new FileKey(false);
        EPSG_DATA_SOURCE = new DataSourceKey();
        DATUM_SHIFT_METHOD = new OptionKey("Molodenski", "Abridged_Molodenski", "Geocentric", "*");
        LENIENT_DATUM_SHIFT = new Key(Boolean.class);
        FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Key(Boolean.class);
        FORCE_AXIS_ORDER_HONORING = new Key(String.class);
        FORCE_STANDARD_AXIS_DIRECTIONS = new Key(Boolean.class);
        FORCE_STANDARD_AXIS_UNITS = new Key(Boolean.class);
        BUFFER_POLICY = new OptionKey("weak", "all", "fixed", "none", "default");
        BUFFER_LIMIT = new IntegerKey(50);
        AUTHORITY_MAX_ACTIVE = new IntegerKey(8);
        AUTHORITY_MIN_IDLE = new IntegerKey(1);
        AUTHORITY_MAX_IDLE = new IntegerKey(8);
        AUTHORITY_MIN_EVICT_IDLETIME = new IntegerKey(0);
        AUTHORITY_SOFTMIN_EVICT_IDLETIME = new IntegerKey(0);
        AUTHORITY_TIME_BETWEEN_EVICTION_RUNS = new IntegerKey(0);
        VERSION = new Key("org.geotools.util.Version");
        GRID_COVERAGE_PROCESSOR = new Key(Object.class);
        IGNORE_COVERAGE_OVERVIEW = new Key(Boolean.class);
        USE_JAI_IMAGEREAD = new Key(Boolean.class);
        REPLACE_NON_GEOPHYSICS_VIEW = new Key(Boolean.class);
        TILE_ENCODING = new Key(String.class);
        JAI_INSTANCE = new Key("javax.media.jai.JAI");
        SAMPLE_DIMENSION_TYPE = new Key("org.opengis.coverage.SampleDimensionType");
    }

    static final class DataSourceKey
    extends Key {
        public DataSourceKey() {
            super(class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = Hints.class$("javax.sql.DataSource")) : class$javax$sql$DataSource);
        }

        public boolean isCompatibleValue(Object value) {
            return value instanceof DataSource || value instanceof String;
        }
    }

    public static final class OptionKey
    extends Key {
        private final Set options;
        private final boolean wildcard;

        public OptionKey(String option1, String option2) {
            this(new String[]{option1, option2});
        }

        public OptionKey(String option1, String option2, String option3) {
            this(new String[]{option1, option2, option3});
        }

        public OptionKey(String option1, String option2, String option3, String option4) {
            this(new String[]{option1, option2, option3, option4});
        }

        public OptionKey(String option1, String option2, String option3, String option4, String option5) {
            this(new String[]{option1, option2, option3, option4, option5});
        }

        public OptionKey(String[] alternatives) {
            super(class$java$lang$String == null ? (class$java$lang$String = Hints.class$("java.lang.String")) : class$java$lang$String);
            TreeSet<String> options = new TreeSet<String>(Arrays.asList(alternatives));
            this.wildcard = options.remove("*");
            this.options = Collections.unmodifiableSet(options);
        }

        public Set getOptions() {
            return this.options;
        }

        public boolean isCompatibleValue(Object value) {
            return this.wildcard ? value instanceof String : this.options.contains(value);
        }
    }

    public static final class IntegerKey
    extends Key {
        private final int number;

        public IntegerKey(int number) {
            super(class$java$lang$Integer == null ? (class$java$lang$Integer = Hints.class$("java.lang.Integer")) : class$java$lang$Integer);
            this.number = number;
        }

        public int getDefault() {
            return this.number;
        }

        public int toValue(Hints hints) {
            if (hints != null) {
                Object value = hints.get(this);
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof CharSequence) {
                    return Integer.parseInt(value.toString());
                }
            }
            return this.number;
        }

        public boolean isCompatibleValue(Object value) {
            if (value instanceof Short || value instanceof Integer) {
                return true;
            }
            if (value instanceof String || value instanceof InternationalString) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    Logging.getLogger("org.geotools.factory").finer(e.toString());
                }
            }
            return false;
        }
    }

    public static final class FileKey
    extends Key {
        private final boolean writable;

        public FileKey(boolean writable) {
            super(class$java$io$File == null ? (class$java$io$File = Hints.class$("java.io.File")) : class$java$io$File);
            this.writable = writable;
        }

        /*
         * WARNING - void declaration
         */
        public boolean isCompatibleValue(Object value) {
            void var2_2;
            File file;
            if (value instanceof File) {
                file = (File)value;
            } else if (value instanceof String) {
                file = new File((String)value);
            } else {
                return false;
            }
            if (var2_2.exists()) {
                return !this.writable || var2_2.canWrite();
            }
            File parent = var2_2.getParentFile();
            return parent != null && parent.canWrite();
        }
    }

    public static final class ClassKey
    extends Key {
        public ClassKey(Class classe) {
            super(classe);
        }

        ClassKey(String className) {
            super(className);
        }

        public boolean isCompatibleValue(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Class[]) {
                Class[] types = (Class[])value;
                for (int i = 0; i < types.length; ++i) {
                    if (this.isCompatibleValue(types[i])) continue;
                    return false;
                }
                return types.length != 0;
            }
            Class<?> type = value instanceof Class ? (Class<?>)value : value.getClass();
            return this.getValueClass().isAssignableFrom(type);
        }
    }

    public static class Key
    extends RenderingHints.Key {
        private static int count;
        private final String className;
        private transient Class valueClass;

        public Key(Class classe) {
            this(classe.getName());
            this.valueClass = classe;
        }

        Key(String className) {
            super(Key.count());
            this.className = className;
        }

        private static synchronized int count() {
            return count++;
        }

        public Class getValueClass() {
            if (this.valueClass == null) {
                try {
                    this.valueClass = Class.forName(this.className);
                }
                catch (ClassNotFoundException exception) {
                    Logging.unexpectedException("org.geotools.factory", class$org$geotools$factory$Hints$Key == null ? (class$org$geotools$factory$Hints$Key = Hints.class$("org.geotools.factory.Hints$Key")) : class$org$geotools$factory$Hints$Key, "getValueClass", (Throwable)exception);
                    this.valueClass = class$java$lang$Object == null ? (class$java$lang$Object = Hints.class$("java.lang.Object")) : class$java$lang$Object;
                }
            }
            return this.valueClass;
        }

        public boolean isCompatibleValue(Object value) {
            return this.getValueClass().isInstance(value);
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            int t = 0;
            block6: while (true) {
                void var2_2;
                switch (t++) {
                    case 0: {
                        Class type = class$org$geotools$factory$Hints == null ? Hints.class$("org.geotools.factory.Hints") : class$org$geotools$factory$Hints;
                        break;
                    }
                    case 1: {
                        Class type = this.getValueClass();
                        break;
                    }
                    default: {
                        return super.toString();
                    }
                }
                Field[] fields = var2_2.getFields();
                int i = 0;
                while (true) {
                    block10: {
                        if (i >= fields.length) continue block6;
                        Field f = fields[i];
                        if (Modifier.isStatic(f.getModifiers())) {
                            Object v;
                            try {
                                v = f.get(null);
                            }
                            catch (IllegalAccessException e) {
                                break block10;
                            }
                            if (v == this) {
                                return f.getName();
                            }
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

