/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.resources.XArray;

public final class Factories {
    private static final Factories GLOBAL = new Factories();
    private int modifications = 0;
    private Set iteratorProviders;

    Factories() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FactoryIteratorProvider[] synchronizeIteratorProviders() {
        FactoryIteratorProvider[] newProviders = null;
        int count = 0;
        Factories factories = GLOBAL;
        synchronized (factories) {
            if (this.modifications == Factories.GLOBAL.modifications) {
                return null;
            }
            this.modifications = Factories.GLOBAL.modifications;
            if (Factories.GLOBAL.iteratorProviders == null) {
                throw new AssertionError(this.modifications);
            }
            if (this.iteratorProviders != null) {
                this.iteratorProviders.retainAll(Factories.GLOBAL.iteratorProviders);
            } else if (!Factories.GLOBAL.iteratorProviders.isEmpty()) {
                this.iteratorProviders = new LinkedHashSet();
            }
            int remaining = Factories.GLOBAL.iteratorProviders.size();
            Iterator it = Factories.GLOBAL.iteratorProviders.iterator();
            while (it.hasNext()) {
                FactoryIteratorProvider candidate = (FactoryIteratorProvider)it.next();
                if (this.iteratorProviders.add(candidate)) {
                    if (newProviders == null) {
                        newProviders = new FactoryIteratorProvider[remaining];
                    }
                    newProviders[count++] = candidate;
                }
                --remaining;
            }
        }
        return (FactoryIteratorProvider[])XArray.resize(newProviders, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFactoryIteratorProvider(FactoryIteratorProvider provider) {
        Factories factories = GLOBAL;
        synchronized (factories) {
            if (Factories.GLOBAL.iteratorProviders == null) {
                Factories.GLOBAL.iteratorProviders = new LinkedHashSet();
            }
            if (Factories.GLOBAL.iteratorProviders.add(provider)) {
                ++Factories.GLOBAL.modifications;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFactoryIteratorProvider(FactoryIteratorProvider provider) {
        Factories factories = GLOBAL;
        synchronized (factories) {
            if (Factories.GLOBAL.iteratorProviders != null && Factories.GLOBAL.iteratorProviders.remove(provider)) {
                ++Factories.GLOBAL.modifications;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FactoryIteratorProvider[] getIteratorProviders() {
        Factories factories = GLOBAL;
        synchronized (factories) {
            if (Factories.GLOBAL.iteratorProviders == null) {
                return new FactoryIteratorProvider[0];
            }
            return Factories.GLOBAL.iteratorProviders.toArray(new FactoryIteratorProvider[Factories.GLOBAL.iteratorProviders.size()]);
        }
    }
}

