/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryComparator;
import org.geotools.io.TableWriter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.AuthorityFactory;

public class AbstractFactory
implements Factory,
RegisterableService {
    public static final int MINIMUM_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 50;
    public static final int MAXIMUM_PRIORITY = 100;
    protected final int priority;
    protected final Map hints = new LinkedHashMap();
    private final Map unmodifiableHints = Collections.unmodifiableMap(this.hints);

    protected AbstractFactory() {
        this(50);
    }

    protected AbstractFactory(int priority) {
        this.priority = priority;
        if (priority < 1 || priority > 100) {
            throw new IllegalArgumentException(Errors.format(42, "priority", new Integer(priority)));
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public Map getImplementationHints() {
        return this.unmodifiableHints;
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        Iterator it = registry.getServiceProviders(category, false);
        while (it.hasNext()) {
            AbstractFactory second;
            AbstractFactory first;
            int compare;
            Object provider = it.next();
            if (provider == this || !(provider instanceof AbstractFactory)) continue;
            AbstractFactory factory = (AbstractFactory)provider;
            int priority = this.getPriority();
            if (priority > (compare = factory.getPriority())) {
                first = this;
                second = factory;
            } else {
                if (priority >= compare) continue;
                first = factory;
                second = this;
            }
            registry.setOrdering(category, first, second);
        }
    }

    public void onDeregistration(ServiceRegistry registry, Class category) {
    }

    public final int hashCode() {
        return this.getClass().hashCode() + 37 * this.priority;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractFactory that = (AbstractFactory)object;
            return this.priority == that.priority && new FactoryComparator(this, that).compare(new HashSet());
        }
        return false;
    }

    public String toString() {
        String name = AbstractFactory.format(this);
        IdentityHashMap<AbstractFactory, String> done = new IdentityHashMap<AbstractFactory, String>();
        done.put(this, name);
        String tree = AbstractFactory.format(this.getImplementationHints(), done);
        return name + System.getProperty("line.separator", "\n") + tree;
    }

    static String toString(Map hints) {
        return AbstractFactory.format(hints, new IdentityHashMap());
    }

    private static String format(Factory factory) {
        String name = Utilities.getShortClassName(factory);
        if (factory instanceof AuthorityFactory) {
            name = name + "[\"" + ((AuthorityFactory)((Object)factory)).getAuthority().getTitle() + "\"]";
        }
        return name;
    }

    private static String format(Map hints, Map done) {
        TableWriter table;
        try {
            table = new TableWriter(null, " ");
            AbstractFactory.format(table, hints, "  ", done);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)table).toString();
    }

    private static void format(Writer table, Map hints, String indent, Map done) throws IOException {
        String[] keys = new String[hints.size()];
        Object[] values = new Object[keys.length];
        Iterator it = hints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            table.write(indent);
            table.write(key);
            table.write("\t= ");
            Factory recursive = null;
            if (value instanceof Factory) {
                recursive = (Factory)value;
                value = AbstractFactory.format(recursive);
                String previous = done.put(recursive, key);
                if (previous != null) {
                    done.put(recursive, previous);
                    table.write("(same as ");
                    table.write(previous);
                    value = ")";
                    recursive = null;
                }
            }
            table.write(String.valueOf(value));
            table.write(10);
            if (recursive == null) continue;
            String nextIndent = Utilities.spaces(indent.length() + 2);
            AbstractFactory.format(table, recursive.getImplementationHints(), nextIndent, done);
        }
    }
}

