/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.VRMLParseException;
import org.xj3d.core.loading.FileCache;
import org.xj3d.core.loading.LoadRequestHandler;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.impl.core.loading.WorldLoadDetails;
import org.xj3d.io.ReadProgressListener;

public class WorldLoadHandler
implements LoadRequestHandler,
ReadProgressListener {
    private static final String LOAD_URL_FAIL_MSG = "No valid URLs found for loadURL call.";
    private static final String CREATE_FAIL_MSG = "No valid URLs found for createVrmlFromURL call.";
    private static final String SET_FIELD_MSG = "Odd field error in createVrmlFromUrl";
    private boolean terminateCurrent;
    private FileCache fileCache;
    private ProgressListener progressListener;
    String final_url;

    public WorldLoadHandler(FileCache fileCache) {
        this.fileCache = fileCache;
        this.terminateCurrent = false;
    }

    public void progressUpdate(long l) {
        if (this.progressListener != null) {
            ProgressEvent progressEvent = new ProgressEvent((ResourceConnection)null, 5, this.final_url, (int)l);
            this.progressListener.downloadUpdate(progressEvent);
        }
    }

    public void streamClosed() {
        ProgressEvent progressEvent = new ProgressEvent((ResourceConnection)null, 4, this.final_url, 0);
        this.progressListener.downloadEnded(progressEvent);
    }

    public void processLoadRequest(ErrorReporter errorReporter, String[] stringArray, Vector vector) {
        VRMLWorldRootNodeType vRMLWorldRootNodeType;
        BasicScene basicScene = null;
        WorldLoadDetails worldLoadDetails = (WorldLoadDetails)vector.remove(0);
        WorldLoader worldLoader = worldLoadDetails.worldLoader.fetchLoader();
        for (int i = 0; i < stringArray.length && !this.terminateCurrent; ++i) {
            URL uRL;
            if (this.terminateCurrent) {
                worldLoadDetails.worldLoader.releaseLoader(worldLoader);
                continue;
            }
            try {
                uRL = new URL(stringArray[i]);
                this.final_url = stringArray[i];
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    this.final_url = worldLoadDetails.core.getWorldURL() + stringArray[i];
                    uRL = new URL(this.final_url);
                }
                catch (MalformedURLException malformedURLException2) {
                    errorReporter.warningReport("Invalid URL: " + stringArray[i], null);
                    this.final_url = "<NONE>";
                    continue;
                }
            }
            if (this.terminateCurrent) {
                worldLoadDetails.worldLoader.releaseLoader(worldLoader);
                return;
            }
            vRMLWorldRootNodeType = new InputSource(uRL);
            if (worldLoadDetails.progressListener != null) {
                this.progressListener = worldLoadDetails.progressListener;
                vRMLWorldRootNodeType.setProgressListener(worldLoadDetails.progressListener);
                vRMLWorldRootNodeType.setReadProgressListener(this, 100000);
            }
            try {
                basicScene = worldLoader.loadNow(worldLoadDetails.core, (InputSource)vRMLWorldRootNodeType, false, worldLoadDetails.majorVersion, worldLoadDetails.minorVersion);
            }
            catch (IOException iOException) {
                errorReporter.warningReport("I/O Error loading " + this.final_url, iOException);
            }
            catch (VRMLParseException vRMLParseException) {
                errorReporter.warningReport("VRML Parse exception loading " + this.final_url, (Exception)((Object)vRMLParseException));
            }
            this.progressListener = null;
            if (basicScene != null) break;
        }
        worldLoadDetails.worldLoader.releaseLoader(worldLoader);
        if (basicScene == null) {
            String string = worldLoadDetails.isLoadURL ? LOAD_URL_FAIL_MSG : CREATE_FAIL_MSG;
            errorReporter.warningReport(string, null);
            worldLoadDetails.core.sendURLFailEvent(string);
            return;
        }
        if (this.terminateCurrent) {
            return;
        }
        if (worldLoadDetails.isLoadURL) {
            worldLoadDetails.core.setScene((VRMLScene)basicScene, null);
        } else {
            VRMLNode vRMLNode = basicScene.getRootNode();
            vRMLWorldRootNodeType = (VRMLWorldRootNodeType)vRMLNode;
            VRMLNodeType[] vRMLNodeTypeArray = vRMLWorldRootNodeType.getChildren();
            vRMLWorldRootNodeType.setChildren((VRMLNodeType)null);
            ArrayList arrayList = basicScene.getRoutes();
            int n = arrayList.size();
            for (int i = 0; i < n && !this.terminateCurrent; ++i) {
                ROUTE rOUTE = (ROUTE)arrayList.get(i);
                worldLoadDetails.routeManager.addRoute(worldLoadDetails.space, rOUTE);
            }
            if (this.terminateCurrent) {
                return;
            }
            try {
                worldLoadDetails.node.setValue(worldLoadDetails.fieldIndex, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
            }
            catch (VRMLException vRMLException) {
                errorReporter.errorReport(SET_FIELD_MSG, vRMLException);
            }
        }
    }

    public void abortCurrentFile() {
        this.terminateCurrent = true;
    }

    public void shutdown() {
        this.terminateCurrent = true;
    }
}

