/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import java.util.LinkedList;
import java.util.Map;
import org.ietf.uri.event.ProgressListener;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.loading.ContentLoadQueue;
import org.xj3d.core.loading.FileCache;
import org.xj3d.core.loading.LoaderThreadPool;
import org.xj3d.core.loading.SceneBuilderFactory;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.loading.DefaultWorldLoader;
import org.xj3d.impl.core.loading.WeakRefFileCache;
import org.xj3d.impl.core.loading.WorldLoadDetails;
import org.xj3d.impl.core.loading.WorldLoadHandler;

public class DefaultWorldLoaderManager
implements WorldLoaderManager,
BrowserCoreListener {
    private static FileCache cache = new WeakRefFileCache();
    private BrowserCore browserCore;
    private RouteManager routeManager;
    private ErrorReporter errorReporter;
    private FrameStateManager stateManager;
    private LinkedList availableLoaders;
    private HashSet allLoaders;
    private LoaderThreadPool loaderPool;
    private ProgressListener progressListener;

    public DefaultWorldLoaderManager(BrowserCore browserCore, FrameStateManager frameStateManager, RouteManager routeManager) {
        this.stateManager = frameStateManager;
        this.browserCore = browserCore;
        this.routeManager = routeManager;
        this.loaderPool = LoaderThreadPool.getLoaderThreadPool();
        this.availableLoaders = new LinkedList();
        this.allLoaders = new HashSet();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.browserCore.addCoreListener((BrowserCoreListener)this);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        if (this.allLoaders.size() != 0) {
            Object[] objectArray = this.allLoaders.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                DefaultWorldLoader defaultWorldLoader = (DefaultWorldLoader)objectArray[i];
                defaultWorldLoader.setErrorReporter(this.errorReporter);
            }
        }
        this.loaderPool.setErrorReporter(this.errorReporter);
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void queueLoadURL(String[] stringArray, Map map) {
        this.loaderPool.clear();
        WorldLoadDetails worldLoadDetails = new WorldLoadDetails();
        worldLoadDetails.isLoadURL = true;
        worldLoadDetails.core = this.browserCore;
        worldLoadDetails.worldLoader = this;
        worldLoadDetails.params = map;
        worldLoadDetails.progressListener = this.progressListener;
        ContentLoadQueue contentLoadQueue = this.loaderPool.getWaitingList();
        contentLoadQueue.add("url", stringArray, new WorldLoadHandler(cache), worldLoadDetails);
    }

    public void queueCreateURL(String[] stringArray, VRMLNodeType vRMLNodeType, int n, VRMLExecutionSpace vRMLExecutionSpace) {
        WorldLoadDetails worldLoadDetails = new WorldLoadDetails();
        worldLoadDetails.isLoadURL = false;
        worldLoadDetails.core = this.browserCore;
        worldLoadDetails.worldLoader = this;
        worldLoadDetails.node = vRMLNodeType;
        worldLoadDetails.fieldIndex = n;
        worldLoadDetails.routeManager = this.routeManager;
        worldLoadDetails.space = vRMLExecutionSpace;
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        worldLoadDetails.majorVersion = basicScene.getSpecificationMajorVersion();
        worldLoadDetails.minorVersion = basicScene.getSpecificationMinorVersion();
        ContentLoadQueue contentLoadQueue = this.loaderPool.getWaitingList();
        contentLoadQueue.add("create", stringArray, new WorldLoadHandler(cache), worldLoadDetails);
    }

    public synchronized WorldLoader fetchLoader() {
        WorldLoader worldLoader = null;
        if (this.availableLoaders.size() != 0) {
            worldLoader = (WorldLoader)this.availableLoaders.remove(0);
        } else {
            DefaultWorldLoader defaultWorldLoader = new DefaultWorldLoader(this.stateManager);
            defaultWorldLoader.setErrorReporter(this.errorReporter);
            this.allLoaders.add(defaultWorldLoader);
            worldLoader = defaultWorldLoader;
        }
        return worldLoader;
    }

    public synchronized void releaseLoader(WorldLoader worldLoader) {
        this.availableLoaders.add(worldLoader);
    }

    public void registerBuilderFactory(int n, SceneBuilderFactory sceneBuilderFactory) {
        DefaultWorldLoader.registerBuilderFactory(n, sceneBuilderFactory);
    }

    public SceneBuilderFactory getBuilderFactory(int n) {
        return DefaultWorldLoader.getBuilderFactory(n);
    }

    public void registerParserFactory(int n, VRMLParserFactory vRMLParserFactory) {
        DefaultWorldLoader.registerParserFactory(n, vRMLParserFactory);
    }

    public VRMLParserFactory getParserFactory(int n) {
        return DefaultWorldLoader.getParserFactory(n);
    }

    public int getNumberLoadersActive() {
        return this.allLoaders.size() - this.availableLoaders.size();
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browserDisposed() {
        DefaultWorldLoaderManager defaultWorldLoaderManager = this;
        synchronized (defaultWorldLoaderManager) {
            if (this.allLoaders.size() != 0) {
                Object[] objectArray = this.allLoaders.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    DefaultWorldLoader defaultWorldLoader = (DefaultWorldLoader)objectArray[i];
                    defaultWorldLoader.shutdown();
                }
                this.allLoaders.clear();
                this.availableLoaders.clear();
            }
        }
    }
}

