/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLTimeListener;
import org.xj3d.core.eventmodel.TimeSensorManager;

public class RealTimeSensorManager
implements TimeSensorManager {
    private static final int DEFAULT_LISTENER_SIZE = 10;
    private static final int LISTENER_SIZE_INC = 5;
    private static final int TIME_FUDGE_FACTOR = 1;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private double currentTime = -1.0;
    private long currentWallTime;
    private long lastWallTime;
    private VRMLTimeListener[] timeListeners = new VRMLTimeListener[10];
    private int numTimeListeners = 0;

    public RealTimeSensorManager() {
        this.currentWallTime = this.lastWallTime = System.currentTimeMillis();
        this.currentTime = (double)this.currentWallTime * 0.001;
    }

    public double getTime() {
        return this.currentTime;
    }

    public long getWallTime() {
        return this.currentWallTime;
    }

    public void resetTimeZero() {
        this.currentWallTime = this.lastWallTime = System.currentTimeMillis();
    }

    public void addTimeListener(VRMLTimeListener vRMLTimeListener) {
        if (this.findListener(vRMLTimeListener) != -1) {
            return;
        }
        if (this.numTimeListeners == this.timeListeners.length) {
            int n = this.timeListeners.length;
            VRMLTimeListener[] vRMLTimeListenerArray = new VRMLTimeListener[n + 5];
            System.arraycopy(this.timeListeners, 0, vRMLTimeListenerArray, 0, n);
            this.timeListeners = vRMLTimeListenerArray;
        }
        this.timeListeners[this.numTimeListeners++] = vRMLTimeListener;
    }

    public void removeTimeListener(VRMLTimeListener vRMLTimeListener) {
        int n = this.findListener(vRMLTimeListener);
        if (n == -1) {
            return;
        }
        if (n != --this.numTimeListeners) {
            System.arraycopy(this.timeListeners, n + 1, this.timeListeners, n, this.numTimeListeners - n);
        }
        this.timeListeners[this.numTimeListeners] = null;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void clockTick(long l) {
        this.currentWallTime = l;
        if (this.currentWallTime - this.lastWallTime <= 0L) {
            ++this.currentWallTime;
        }
        this.lastWallTime = this.currentWallTime;
        this.currentTime = (double)this.currentWallTime * 0.001;
        int n = this.numTimeListeners;
        while (--n >= 0) {
            try {
                this.timeListeners[n].timeClick(this.currentWallTime);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Problem sending clock ticks", exception);
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.numTimeListeners; ++i) {
            this.timeListeners[i] = null;
        }
        this.numTimeListeners = 0;
    }

    private int findListener(VRMLTimeListener vRMLTimeListener) {
        int n = -1;
        int n2 = this.numTimeListeners;
        while (--n2 >= 0) {
            if (this.timeListeners[n2] != vRMLTimeListener) continue;
            n = n2;
            break;
        }
        return n;
    }
}

