/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.odejava.Body;
import org.odejava.Odejava;
import org.odejava.PlaceableGeom;
import org.odejava.ode.Ode;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNBodyGroupNodeType;
import org.web3d.vrml.nodes.VRMLNBodySensorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLRigidBodyGroupNodeType;
import org.web3d.vrml.nodes.VRMLRigidBodyNodeType;
import org.web3d.vrml.nodes.VRMLRigidJointNodeType;
import org.web3d.vrml.util.NodeArray;
import org.xj3d.core.eventmodel.NodeManager;

public class DefaultRigidBodyPhysicsManager
implements NodeManager {
    private static final int[] MANAGED_NODE_TYPES = new int[]{83, 81, 82, 84, 86, 87};
    private static final int RECALC_INTERVAL = 10;
    private static boolean odeLoadFailed;
    private ErrorReporter errorReporter;
    private NodeArray collections = new NodeArray();
    private HashSet collectionSet;
    private NodeArray joints = new NodeArray();
    private HashSet jointSet;
    private NodeArray bodies = new NodeArray();
    private HashSet bodySet;
    private NodeArray collidables = new NodeArray();
    private HashSet collidableSet;
    private NodeArray collisionSpaces = new NodeArray();
    private HashSet collisionSpaceSet;
    private NodeArray sensors = new NodeArray();
    private HashSet sensorSet;
    private long lastTime;
    private long elapsedTime = 0L;
    private int countTick = 0;
    private float deltaT = 0.02f;
    private VRMLClock clock;
    private IntHashMap bodyIdMap;
    private IntHashMap geomIdMap;

    public DefaultRigidBodyPhysicsManager() {
        this.collectionSet = new HashSet();
        this.jointSet = new HashSet();
        this.bodySet = new HashSet();
        this.collidableSet = new HashSet();
        this.collisionSpaceSet = new HashSet();
        this.sensorSet = new HashSet();
        this.bodyIdMap = new IntHashMap();
        this.geomIdMap = new IntHashMap();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public boolean initialize() {
        return !odeLoadFailed;
    }

    public void shutdown() {
        if (!odeLoadFailed) {
            Ode.dCloseODE();
            odeLoadFailed = true;
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public ComponentInfo[] getSupportedComponents() {
        return new ComponentInfo[]{new ComponentInfo("xj3d_RigidBodyPhysics", 1)};
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.clock = vRMLClock;
        this.lastTime = vRMLClock.getWallTime();
    }

    public void resetTimeZero() {
        this.lastTime = this.clock.getWallTime();
        this.countTick = 0;
        this.elapsedTime = 0L;
        this.deltaT = 0.02f;
    }

    public int[] getManagedNodeTypes() {
        return MANAGED_NODE_TYPES;
    }

    public boolean evaluatePreEventModel() {
        return !odeLoadFailed;
    }

    public boolean evaluatePostEventModel() {
        return !odeLoadFailed;
    }

    public void addManagedNode(VRMLNodeType vRMLNodeType) {
        int n = vRMLNodeType.getPrimaryType();
        switch (n) {
            case 83: {
                if (this.collectionSet.contains(vRMLNodeType)) break;
                this.collections.add(vRMLNodeType);
                this.collectionSet.add(vRMLNodeType);
                ((VRMLRigidBodyGroupNodeType)vRMLNodeType).setTimestep(this.deltaT);
                break;
            }
            case 81: {
                if (this.jointSet.contains(vRMLNodeType)) break;
                this.joints.add(vRMLNodeType);
                this.jointSet.add(vRMLNodeType);
                break;
            }
            case 82: {
                if (this.bodySet.contains(vRMLNodeType)) break;
                this.bodies.add(vRMLNodeType);
                this.bodySet.add(vRMLNodeType);
                VRMLRigidBodyNodeType vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
                Body body = vRMLRigidBodyNodeType.getODEBody();
                int n2 = body.getNativeAddr();
                this.bodyIdMap.put(n2, vRMLRigidBodyNodeType);
                break;
            }
            case 84: {
                if (this.collidableSet.contains(vRMLNodeType)) break;
                this.collidables.add(vRMLNodeType);
                this.collidableSet.add(vRMLNodeType);
                VRMLNBodyCollidableNodeType vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType;
                PlaceableGeom placeableGeom = vRMLNBodyCollidableNodeType.getODEGeometry();
                int n3 = placeableGeom.getNativeAddr();
                this.geomIdMap.put(n3, vRMLNBodyCollidableNodeType);
                break;
            }
            case 87: {
                if (this.sensorSet.contains(vRMLNodeType)) break;
                this.sensors.add(vRMLNodeType);
                this.sensorSet.add(vRMLNodeType);
                break;
            }
            case 86: {
                if (this.collisionSpaceSet.contains(vRMLNodeType)) break;
                this.collisionSpaces.add(vRMLNodeType);
                this.collisionSpaceSet.add(vRMLNodeType);
                break;
            }
            default: {
                this.errorReporter.warningReport("Non-Physics node added to the manager", null);
            }
        }
    }

    public void removeManagedNode(VRMLNodeType vRMLNodeType) {
        int n = vRMLNodeType.getPrimaryType();
        switch (n) {
            case 83: {
                this.collections.remove(vRMLNodeType);
                this.collectionSet.remove(vRMLNodeType);
                break;
            }
            case 82: {
                this.bodies.remove(vRMLNodeType);
                this.bodySet.remove(vRMLNodeType);
                VRMLRigidBodyNodeType vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
                Body body = vRMLRigidBodyNodeType.getODEBody();
                int n2 = body.getNativeAddr();
                this.bodyIdMap.remove(n2);
                break;
            }
            case 81: {
                this.joints.remove(vRMLNodeType);
                this.jointSet.remove(vRMLNodeType);
                VRMLNBodyCollidableNodeType vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType;
                PlaceableGeom placeableGeom = vRMLNBodyCollidableNodeType.getODEGeometry();
                int n3 = placeableGeom.getNativeAddr();
                this.geomIdMap.remove(n3);
                break;
            }
            case 84: {
                this.collidables.remove(vRMLNodeType);
                this.collidableSet.remove(vRMLNodeType);
                break;
            }
            case 87: {
                this.sensors.remove(vRMLNodeType);
                this.sensorSet.remove(vRMLNodeType);
                break;
            }
            case 86: {
                this.collisionSpaces.remove(vRMLNodeType);
                this.collisionSpaceSet.remove(vRMLNodeType);
                break;
            }
            default: {
                this.errorReporter.warningReport("Non-physics node removed from the manager", null);
            }
        }
    }

    public void executePreEventModel(long l) {
        VRMLNodeType vRMLNodeType;
        int n;
        double d = l - this.lastTime;
        if (d == 0.0) {
            return;
        }
        int n2 = this.collisionSpaces.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNBodyGroupNodeType)this.collisionSpaces.get(n);
            if (!vRMLNodeType.isEnabled()) continue;
            vRMLNodeType.evaluateCollisions();
        }
        n2 = this.joints.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLRigidJointNodeType)this.joints.get(n);
            if (vRMLNodeType.numOutputs() == 0) continue;
            vRMLNodeType.updateRequestedOutputs();
        }
        n2 = this.sensors.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNBodySensorNodeType)this.sensors.get(n);
            vRMLNodeType.updateContacts(this.bodyIdMap, this.geomIdMap);
        }
        n2 = this.collections.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLRigidBodyGroupNodeType)this.collections.get(n);
            if (!vRMLNodeType.isEnabled()) continue;
            vRMLNodeType.updatePostSimulation();
        }
    }

    public void executePostEventModel(long l) {
        VRMLNodeType vRMLNodeType;
        int n;
        int n2 = this.collections.size();
        if (++this.countTick == 10) {
            this.deltaT = (float)this.elapsedTime / (float)this.countTick * 0.001f;
            this.countTick = 0;
            this.elapsedTime = 0L;
            for (n = 0; n < n2; ++n) {
                vRMLNodeType = (VRMLRigidBodyGroupNodeType)this.collections.get(n);
                vRMLNodeType.setTimestep(this.deltaT);
            }
        } else {
            this.elapsedTime += l - this.lastTime;
        }
        this.lastTime = l;
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLRigidBodyGroupNodeType)this.collections.get(n);
            if (!vRMLNodeType.isEnabled()) continue;
            vRMLNodeType.processInputContacts();
            vRMLNodeType.evaluateModel();
        }
        n2 = this.collidables.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNBodyCollidableNodeType)this.collidables.get(n);
            vRMLNodeType.updateFromODE();
        }
    }

    public void clear() {
        VRMLNodeType vRMLNodeType;
        int n;
        int n2 = this.joints.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLRigidJointNodeType)this.joints.get(n);
            vRMLNodeType.delete();
        }
        n2 = this.collisionSpaces.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNBodyGroupNodeType)this.collisionSpaces.get(n);
            vRMLNodeType.delete();
        }
        n2 = this.collections.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLRigidBodyGroupNodeType)this.collections.get(n);
            vRMLNodeType.delete();
        }
        this.collections.clear();
        this.joints.clear();
        this.bodies.clear();
        this.collidables.clear();
        this.collisionSpaces.clear();
        this.sensors.clear();
        this.collectionSet.clear();
        this.jointSet.clear();
        this.bodySet.clear();
        this.collidableSet.clear();
        this.collisionSpaceSet.clear();
        this.sensorSet.clear();
        this.bodyIdMap.clear();
        this.geomIdMap.clear();
    }

    static {
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    Boolean bl = Boolean.FALSE;
                    try {
                        if (!Odejava.init()) {
                            bl = Boolean.TRUE;
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        System.err.println("Unable to initialise ODE due to missing class definitions: " + noClassDefFoundError.getMessage());
                        bl = Boolean.TRUE;
                    }
                    return bl;
                }
            });
            odeLoadFailed = bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.err.println("Failed to partake priviledged action to load odejava DLL");
        }
    }
}

