/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.IntHashMap;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.SceneGraphTraverser;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTerrainSource;
import org.web3d.vrml.util.NodeArray;
import org.web3d.vrml.util.NodeTemplateArray;

public class DefaultFrameStateManager
implements FrameStateManager,
SceneGraphTraversalSimpleObserver {
    private static final int NUM_FRAME_LISTENERS = 20;
    private static final int NUM_FRAME_INC = 5;
    private static final String EOF_NOTIF_MSG = "An error was generated during the end of frame processing";
    private HashSet[] registeredFrameStateListeners;
    private FrameStateListener[][] currentFrameListeners;
    private int currentListenerIdx;
    private int lastFrameStateIndexA;
    private int lastFrameStateIndexB;
    private ErrorReporter errorReporter;
    private IntHashMap removedNodes;
    private IntHashMap removedIndex;
    private IntHashMap addedNodes = new IntHashMap();
    private IntHashMap addedIndex;
    private int[] nodeTypeList;
    private NodeArray[] removedScripts;
    private NodeArray[] addedScripts;
    private NodeArray[] removedSensors;
    private NodeArray[] addedSensors;
    private NodeArray[] addedUrls;
    private NodeTemplateArray[] addedExternProtos;
    private NodeArray[] removedViewDependentNodes;
    private NodeArray[] addedViewDependentNodes;
    private NodeArray[] removedBindables;
    private NodeArray[] addedBindables;
    private ObjectArray[] addedScenes;
    private ObjectArray[] removedScenes;
    private NodeArray[] addedTerrains;
    private NodeArray[] removedTerrains;
    private NodeArray[] addedExternals;
    private NodeArray[] removedExternals;
    protected SceneGraphTraverser traverser;
    private boolean addTraversal;
    private int idxRScripts;
    private int idxAScripts;
    private int idxRSensors;
    private int idxASensors;
    private int idxAUrls;
    private int idxAViewDependents;
    private int idxRViewDependents;
    private int idxRBindables;
    private int idxABindables;
    private int idxRScenes;
    private int idxAScenes;
    private int idxRTerrains;
    private int idxATerrains;
    private int idxRExternals;
    private int idxAExternals;
    private int idxAEPs;

    public DefaultFrameStateManager() {
        this.removedNodes = new IntHashMap();
        this.addedIndex = new IntHashMap();
        this.removedIndex = new IntHashMap();
        this.removedScripts = new NodeArray[2];
        this.removedScripts[0] = new NodeArray();
        this.removedScripts[1] = new NodeArray();
        this.addedScripts = new NodeArray[2];
        this.addedScripts[0] = new NodeArray();
        this.addedScripts[1] = new NodeArray();
        this.removedSensors = new NodeArray[2];
        this.removedSensors[0] = new NodeArray();
        this.removedSensors[1] = new NodeArray();
        this.addedSensors = new NodeArray[2];
        this.addedSensors[0] = new NodeArray();
        this.addedSensors[1] = new NodeArray();
        this.addedUrls = new NodeArray[2];
        this.addedUrls[0] = new NodeArray();
        this.addedUrls[1] = new NodeArray();
        this.removedViewDependentNodes = new NodeArray[2];
        this.removedViewDependentNodes[0] = new NodeArray();
        this.removedViewDependentNodes[1] = new NodeArray();
        this.addedViewDependentNodes = new NodeArray[2];
        this.addedViewDependentNodes[0] = new NodeArray();
        this.addedViewDependentNodes[1] = new NodeArray();
        this.removedBindables = new NodeArray[2];
        this.removedBindables[0] = new NodeArray();
        this.removedBindables[1] = new NodeArray();
        this.addedBindables = new NodeArray[2];
        this.addedBindables[0] = new NodeArray();
        this.addedBindables[1] = new NodeArray();
        this.addedScenes = new ObjectArray[2];
        this.addedScenes[0] = new ObjectArray();
        this.addedScenes[1] = new ObjectArray();
        this.removedScenes = new ObjectArray[2];
        this.removedScenes[0] = new ObjectArray();
        this.removedScenes[1] = new ObjectArray();
        this.removedTerrains = new NodeArray[2];
        this.removedTerrains[0] = new NodeArray();
        this.removedTerrains[1] = new NodeArray();
        this.addedTerrains = new NodeArray[2];
        this.addedTerrains[0] = new NodeArray();
        this.addedTerrains[1] = new NodeArray();
        this.removedExternals = new NodeArray[2];
        this.removedExternals[0] = new NodeArray();
        this.removedExternals[1] = new NodeArray();
        this.addedExternals = new NodeArray[2];
        this.addedExternals[0] = new NodeArray();
        this.addedExternals[1] = new NodeArray();
        this.addedExternProtos = new NodeTemplateArray[2];
        this.addedExternProtos[0] = new NodeTemplateArray();
        this.addedExternProtos[1] = new NodeTemplateArray();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.registeredFrameStateListeners = new HashSet[2];
        this.registeredFrameStateListeners[0] = new HashSet();
        this.registeredFrameStateListeners[1] = new HashSet();
        this.currentFrameListeners = new FrameStateListener[2][20];
        this.currentListenerIdx = 0;
        this.lastFrameStateIndexA = 0;
        this.lastFrameStateIndexB = 0;
        this.traverser = new SceneGraphTraverser();
        this.traverser.setObserver(this);
        this.traverser.setErrorReporter(this.errorReporter);
        this.idxRScripts = 0;
        this.idxAScripts = 0;
        this.idxRSensors = 0;
        this.idxASensors = 0;
        this.idxAUrls = 0;
        this.idxAViewDependents = 0;
        this.idxRViewDependents = 0;
        this.idxRBindables = 0;
        this.idxABindables = 0;
        this.idxRScenes = 0;
        this.idxAScenes = 0;
        this.idxRTerrains = 0;
        this.idxATerrains = 0;
        this.idxRExternals = 0;
        this.idxAExternals = 0;
        this.idxAEPs = 0;
    }

    public synchronized void addEndOfThisFrameListener(FrameStateListener frameStateListener) {
        int n = this.currentListenerIdx;
        if (this.registeredFrameStateListeners[n].contains(frameStateListener)) {
            return;
        }
        this.registeredFrameStateListeners[n].add(frameStateListener);
        if (n == 0) {
            if (this.lastFrameStateIndexA == this.currentFrameListeners[0].length) {
                int n2 = this.lastFrameStateIndexA + 5;
                FrameStateListener[] frameStateListenerArray = new FrameStateListener[n2];
                System.arraycopy(this.currentFrameListeners[0], 0, frameStateListenerArray, 0, this.lastFrameStateIndexA);
                this.currentFrameListeners[0] = frameStateListenerArray;
            }
            this.currentFrameListeners[0][this.lastFrameStateIndexA++] = frameStateListener;
        } else {
            if (this.lastFrameStateIndexB == this.currentFrameListeners[1].length) {
                int n3 = this.lastFrameStateIndexB + 5;
                FrameStateListener[] frameStateListenerArray = new FrameStateListener[n3];
                System.arraycopy(this.currentFrameListeners[1], 0, frameStateListenerArray, 0, this.lastFrameStateIndexB);
                this.currentFrameListeners[1] = frameStateListenerArray;
            }
            this.currentFrameListeners[1][this.lastFrameStateIndexB++] = frameStateListener;
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void listenFor(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            NodeArray[] nodeArrayArray = new NodeArray[]{new NodeArray(), new NodeArray()};
            this.addedNodes.put(nArray[i], nodeArrayArray);
            nodeArrayArray = new NodeArray[]{new NodeArray(), new NodeArray()};
            this.removedNodes.put(nArray[i], nodeArrayArray);
            this.addedIndex.put(nArray[i], Boolean.FALSE);
            this.removedIndex.put(nArray[i], Boolean.FALSE);
        }
        this.nodeTypeList = this.addedNodes.keySet();
    }

    public void removeListenFor(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            this.addedNodes.remove(nArray[n]);
            this.removedNodes.remove(nArray[n]);
        }
        n = this.nodeTypeList == null ? 0 : this.nodeTypeList.length;
        this.nodeTypeList = (int[])(n == nArray.length ? null : this.addedNodes.keySet());
    }

    public void clear() {
        int n;
        for (n = 0; n < this.lastFrameStateIndexA; ++n) {
            this.currentFrameListeners[0][n] = null;
        }
        for (n = 0; n < this.lastFrameStateIndexB; ++n) {
            this.currentFrameListeners[1][n] = null;
        }
        this.removedScripts[0].clear();
        this.addedScripts[0].clear();
        this.removedSensors[0].clear();
        this.addedSensors[0].clear();
        this.addedUrls[0].clear();
        this.removedViewDependentNodes[0].clear();
        this.addedViewDependentNodes[0].clear();
        this.removedBindables[0].clear();
        this.addedBindables[0].clear();
        this.removedScenes[0].clear();
        this.addedScenes[0].clear();
        this.removedTerrains[0].clear();
        this.addedTerrains[0].clear();
        this.addedExternals[0].clear();
        this.removedExternals[0].clear();
        this.addedExternProtos[0].clear();
        this.removedScripts[1].clear();
        this.addedScripts[1].clear();
        this.removedSensors[1].clear();
        this.addedSensors[1].clear();
        this.addedUrls[1].clear();
        this.removedViewDependentNodes[1].clear();
        this.addedViewDependentNodes[1].clear();
        this.removedBindables[1].clear();
        this.addedBindables[1].clear();
        this.removedScenes[1].clear();
        this.addedScenes[1].clear();
        this.removedTerrains[1].clear();
        this.addedTerrains[1].clear();
        this.removedExternals[1].clear();
        this.addedExternals[1].clear();
        this.addedExternProtos[1].clear();
        this.idxRScripts = 0;
        this.idxAScripts = 0;
        this.idxRSensors = 0;
        this.idxASensors = 0;
        this.idxAUrls = 0;
        this.idxAViewDependents = 0;
        this.idxRViewDependents = 0;
        this.idxRBindables = 0;
        this.idxABindables = 0;
        this.idxRScenes = 0;
        this.idxAScenes = 0;
        this.idxRTerrains = 0;
        this.idxATerrains = 0;
        this.idxRExternals = 0;
        this.idxAExternals = 0;
        this.idxAEPs = 0;
        n = this.nodeTypeList == null ? 0 : this.nodeTypeList.length;
        for (int i = 0; i < n; ++i) {
            NodeArray[] nodeArrayArray = (NodeArray[])this.addedNodes.get(this.nodeTypeList[i]);
            nodeArrayArray[0].clear();
            nodeArrayArray[1].clear();
            nodeArrayArray = (NodeArray[])this.removedNodes.get(this.nodeTypeList[i]);
            nodeArrayArray[0].clear();
            nodeArrayArray[1].clear();
            this.addedIndex.put(this.nodeTypeList[i], Boolean.FALSE);
            this.removedIndex.put(this.nodeTypeList[i], Boolean.FALSE);
        }
        this.registeredFrameStateListeners[0].clear();
        this.registeredFrameStateListeners[1].clear();
        this.currentListenerIdx = 0;
        this.traverser.reset();
    }

    public void frameFinished() {
        int n = this.currentListenerIdx;
        int n2 = this.currentListenerIdx = this.currentListenerIdx == 0 ? 1 : 0;
        if (n == 0) {
            if (this.lastFrameStateIndexA == 0) {
                return;
            }
            this.registeredFrameStateListeners[0].clear();
            for (int i = 0; i < this.lastFrameStateIndexA; ++i) {
                try {
                    if (this.currentFrameListeners[0][i] != null) {
                        this.currentFrameListeners[0][i].allEventsComplete();
                    }
                    this.currentFrameListeners[0][i] = null;
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(EOF_NOTIF_MSG, exception);
                }
            }
            this.lastFrameStateIndexA = 0;
        } else {
            if (this.lastFrameStateIndexB == 0) {
                return;
            }
            this.registeredFrameStateListeners[1].clear();
            for (int i = 0; i < this.lastFrameStateIndexB; ++i) {
                try {
                    if (this.currentFrameListeners[1][i] != null) {
                        this.currentFrameListeners[1][i].allEventsComplete();
                    }
                    this.currentFrameListeners[1][i] = null;
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(EOF_NOTIF_MSG, exception);
                }
            }
            this.lastFrameStateIndexB = 0;
        }
    }

    public synchronized void registerRemovedNode(VRMLNode vRMLNode) {
        this.addTraversal = false;
        this.traverser.reset();
        this.traverser.traverseGraph(vRMLNode);
    }

    public synchronized void registerRemovedNodes(VRMLNode[] vRMLNodeArray) {
        this.addTraversal = false;
        for (int i = 0; i < vRMLNodeArray.length; ++i) {
            if (vRMLNodeArray[i] == null) continue;
            this.traverser.reset();
            this.traverser.traverseGraph(vRMLNodeArray[i]);
        }
    }

    public synchronized void registerAddedNode(VRMLNode vRMLNode) {
        this.addTraversal = true;
        this.traverser.reset();
        this.traverser.traverseGraph(vRMLNode);
    }

    public synchronized void registerAddedNodes(VRMLNode[] vRMLNodeArray) {
        this.addTraversal = true;
        for (int i = 0; i < vRMLNodeArray.length; ++i) {
            if (vRMLNodeArray[i] == null) continue;
            this.traverser.reset();
            this.traverser.traverseGraph(vRMLNodeArray[i]);
        }
    }

    public synchronized void registerAddedScene(VRMLExecutionSpace vRMLExecutionSpace) {
        this.addedScenes[this.idxAScenes].add(vRMLExecutionSpace);
    }

    public synchronized void registerRemovedScene(VRMLExecutionSpace vRMLExecutionSpace) {
        this.removedScenes[this.idxRScenes].add(vRMLExecutionSpace);
    }

    public synchronized void registerAddedExternProto(VRMLNodeTemplate vRMLNodeTemplate) {
        this.addedExternProtos[this.idxAEPs].add(vRMLNodeTemplate);
    }

    public void clearRemovedNodes() {
        this.removedScripts[this.idxRScripts == 0 ? 1 : 0].clear();
        this.removedSensors[this.idxRSensors == 0 ? 1 : 0].clear();
        this.removedBindables[this.idxRBindables == 0 ? 1 : 0].clear();
        this.removedViewDependentNodes[this.idxRViewDependents == 0 ? 1 : 0].clear();
        this.removedExternals[this.idxRExternals == 0 ? 1 : 0].clear();
        this.removedScenes[this.idxRScenes == 0 ? 1 : 0].clear();
        int n = this.nodeTypeList == null ? 0 : this.nodeTypeList.length;
        for (int i = 0; i < n; ++i) {
            NodeArray[] nodeArrayArray = (NodeArray[])this.removedNodes.get(this.nodeTypeList[i]);
            Boolean bl = (Boolean)this.removedIndex.get(this.nodeTypeList[i]);
            NodeArray nodeArray = nodeArrayArray[bl != false ? 1 : 0];
            int n2 = nodeArray.size();
            for (int j = 0; j < n2; ++j) {
                VRMLNodeType vRMLNodeType = (VRMLNodeType)nodeArray.get(j);
                vRMLNodeType.clearRemovedLayerIds();
            }
            nodeArray.clear();
        }
    }

    public void clearAddedNodes() {
        this.addedScripts[this.idxAScripts == 0 ? 1 : 0].clear();
        this.addedSensors[this.idxASensors == 0 ? 1 : 0].clear();
        this.addedBindables[this.idxABindables == 0 ? 1 : 0].clear();
        this.addedUrls[this.idxAUrls == 0 ? 1 : 0].clear();
        this.addedViewDependentNodes[this.idxAViewDependents == 0 ? 1 : 0].clear();
        this.addedExternals[this.idxAExternals == 0 ? 1 : 0].clear();
        this.addedExternProtos[this.idxAEPs == 0 ? 1 : 0].clear();
        int n = this.nodeTypeList == null ? 0 : this.nodeTypeList.length;
        for (int i = 0; i < n; ++i) {
            NodeArray[] nodeArrayArray = (NodeArray[])this.addedNodes.get(this.nodeTypeList[i]);
            Boolean bl = (Boolean)this.addedIndex.get(this.nodeTypeList[i]);
            nodeArrayArray[bl != false ? 0 : 1].clear();
        }
    }

    public void clearAddedScenes() {
        this.addedScenes[this.idxAScenes == 0 ? 1 : 0].clear();
    }

    public void clearRemovedScenes() {
        this.removedScenes[this.idxAScenes == 0 ? 1 : 0].clear();
    }

    public NodeArray getRemovedNodes(int n) {
        Boolean bl = (Boolean)this.removedIndex.get(n);
        NodeArray[] nodeArrayArray = (NodeArray[])this.removedNodes.get(n);
        if (!bl.booleanValue()) {
            this.removedIndex.put(n, Boolean.TRUE);
            return nodeArrayArray[0];
        }
        this.removedIndex.put(n, Boolean.FALSE);
        return nodeArrayArray[1];
    }

    public NodeArray getRemovedScripts() {
        if (this.idxRScripts == 0) {
            this.idxRScripts = 1;
            return this.removedScripts[0];
        }
        this.idxRScripts = 0;
        return this.removedScripts[1];
    }

    public NodeArray getRemovedSensors() {
        if (this.idxRSensors == 0) {
            this.idxRSensors = 1;
            return this.removedSensors[0];
        }
        this.idxRSensors = 0;
        return this.removedSensors[1];
    }

    public NodeArray getRemovedViewDependents() {
        if (this.idxRViewDependents == 0) {
            this.idxRViewDependents = 1;
            return this.removedViewDependentNodes[0];
        }
        this.idxRViewDependents = 0;
        return this.removedViewDependentNodes[1];
    }

    public NodeArray getRemovedBindables() {
        if (this.idxRBindables == 0) {
            this.idxRBindables = 1;
            return this.removedBindables[0];
        }
        this.idxRBindables = 0;
        return this.removedBindables[1];
    }

    public ObjectArray getRemovedScenes() {
        if (this.idxRScenes == 0) {
            this.idxRScenes = 1;
            return this.removedScenes[0];
        }
        this.idxRScenes = 0;
        return this.removedScenes[1];
    }

    public NodeArray getRemovedTerrains() {
        if (this.idxRTerrains == 0) {
            this.idxRTerrains = 1;
            return this.removedTerrains[0];
        }
        this.idxRTerrains = 0;
        return this.removedTerrains[1];
    }

    public NodeArray getRemovedExtSynchronizedNodes() {
        if (this.idxRExternals == 0) {
            this.idxRExternals = 1;
            return this.removedExternals[0];
        }
        this.idxRExternals = 0;
        return this.removedExternals[1];
    }

    public NodeArray getAddedNodes(int n) {
        Boolean bl = (Boolean)this.addedIndex.get(n);
        NodeArray[] nodeArrayArray = (NodeArray[])this.addedNodes.get(n);
        if (!bl.booleanValue()) {
            this.addedIndex.put(n, Boolean.TRUE);
            return nodeArrayArray[0];
        }
        this.addedIndex.put(n, Boolean.FALSE);
        return nodeArrayArray[1];
    }

    public NodeArray getAddedSensors() {
        if (this.idxASensors == 0) {
            this.idxASensors = 1;
            return this.addedSensors[0];
        }
        this.idxASensors = 0;
        return this.addedSensors[1];
    }

    public ObjectArray getAddedScenes() {
        if (this.idxAScenes == 0) {
            this.idxAScenes = 1;
            return this.addedScenes[0];
        }
        this.idxAScenes = 0;
        return this.addedScenes[1];
    }

    public NodeArray getAddedUrlNodes() {
        if (this.idxAUrls == 0) {
            this.idxAUrls = 1;
            return this.addedUrls[0];
        }
        this.idxAUrls = 0;
        return this.addedUrls[1];
    }

    public NodeArray getAddedScripts() {
        if (this.idxAScripts == 0) {
            this.idxAScripts = 1;
            return this.addedScripts[0];
        }
        this.idxAScripts = 0;
        return this.addedScripts[1];
    }

    public NodeArray getAddedViewDependents() {
        if (this.idxAViewDependents == 0) {
            this.idxAViewDependents = 1;
            return this.addedViewDependentNodes[0];
        }
        this.idxAViewDependents = 0;
        return this.addedViewDependentNodes[1];
    }

    public NodeArray getAddedBindables() {
        if (this.idxABindables == 0) {
            this.idxABindables = 1;
            return this.addedBindables[0];
        }
        this.idxABindables = 0;
        return this.addedBindables[1];
    }

    public NodeArray getAddedTerrains() {
        if (this.idxATerrains == 0) {
            this.idxATerrains = 1;
            return this.addedTerrains[0];
        }
        this.idxATerrains = 0;
        return this.addedTerrains[1];
    }

    public NodeArray getAddedExtSynchronizedNodes() {
        if (this.idxAExternals == 0) {
            this.idxAExternals = 1;
            return this.addedExternals[0];
        }
        this.idxAExternals = 0;
        return this.addedExternals[1];
    }

    public NodeTemplateArray getAddedExternProtos() {
        if (this.idxAEPs == 0) {
            this.idxAEPs = 1;
            return this.addedExternProtos[0];
        }
        this.idxAEPs = 0;
        return this.addedExternProtos[1];
    }

    public void observedNode(VRMLNodeType vRMLNodeType, VRMLNodeType vRMLNodeType2, int n, boolean bl) {
        if (vRMLNodeType2 instanceof VRMLExternalNodeType) {
            if (this.addTraversal) {
                this.addedUrls[this.idxAUrls].add(vRMLNodeType2);
            }
        } else if (vRMLNodeType2 instanceof VRMLTerrainSource) {
            if (this.addTraversal) {
                this.addedTerrains[this.idxATerrains].add(vRMLNodeType2);
            } else {
                this.removedTerrains[this.idxRTerrains].add(vRMLNodeType2);
            }
        }
        switch (vRMLNodeType2.getPrimaryType()) {
            case 13: 
            case 14: 
            case 26: 
            case 36: 
            case 42: 
            case 73: 
            case 78: {
                if (this.addTraversal) {
                    this.addedSensors[this.idxASensors].add(vRMLNodeType2);
                    break;
                }
                this.removedSensors[this.idxRSensors].add(vRMLNodeType2);
                break;
            }
            case 41: {
                if (this.addTraversal) {
                    this.addedScripts[this.idxAScripts].add(vRMLNodeType2);
                    break;
                }
                this.removedScripts[this.idxRScripts].add(vRMLNodeType2);
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 31: 
            case 55: {
                if (this.addTraversal) {
                    this.addedBindables[this.idxABindables].add(vRMLNodeType2);
                    break;
                }
                this.removedBindables[this.idxRBindables].add(vRMLNodeType2);
                break;
            }
            case 38: {
                if (!bl) {
                    if (this.addTraversal) {
                        this.registerAddedScene((VRMLExecutionSpace)((Object)vRMLNodeType2));
                    } else {
                        this.registerRemovedScene((VRMLExecutionSpace)((Object)vRMLNodeType2));
                    }
                }
            }
            default: {
                NodeArray[] nodeArrayArray;
                Boolean bl2;
                int n2 = vRMLNodeType2.getPrimaryType();
                if (!this.addedNodes.containsKey(n2)) break;
                if (this.addTraversal) {
                    bl2 = (Boolean)this.addedIndex.get(n2);
                    nodeArrayArray = (NodeArray[])this.addedNodes.get(n2);
                    nodeArrayArray[bl2 != false ? 1 : 0].add(vRMLNodeType2);
                    break;
                }
                bl2 = (Boolean)this.removedIndex.get(n2);
                nodeArrayArray = (NodeArray[])this.removedNodes.get(n2);
                nodeArrayArray[bl2 != false ? 1 : 0].add(vRMLNodeType2);
            }
        }
        int[] nArray = vRMLNodeType2.getSecondaryType();
        block10: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 74: {
                    if (this.addTraversal) {
                        this.addedExternals[this.idxAExternals].add(vRMLNodeType2);
                        continue block10;
                    }
                    this.removedExternals[this.idxRExternals].add(vRMLNodeType2);
                    continue block10;
                }
                case 88: {
                    if (this.addTraversal) {
                        this.addedViewDependentNodes[this.idxAViewDependents].add(vRMLNodeType2);
                        continue block10;
                    }
                    this.removedViewDependentNodes[this.idxRViewDependents].add(vRMLNodeType2);
                }
            }
        }
    }
}

