/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.web3d.browser.NodeObserver;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.IntHashMap;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLExternalSynchronizedNodeType;
import org.web3d.vrml.nodes.VRMLLayerNodeType;
import org.web3d.vrml.nodes.VRMLLayerSetNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.util.NodeArray;
import org.web3d.vrml.util.NodeTemplateArray;
import org.xj3d.core.eventmodel.BindableNodeManager;
import org.xj3d.core.eventmodel.EventModelEvaluator;
import org.xj3d.core.eventmodel.EventModelInitListener;
import org.xj3d.core.eventmodel.ExternalView;
import org.xj3d.core.eventmodel.LayerManager;
import org.xj3d.core.eventmodel.LayerManagerFactory;
import org.xj3d.core.eventmodel.LayerRenderingManager;
import org.xj3d.core.eventmodel.NodeManager;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.SensorManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ContentLoadManager;

public class DefaultEventModelEvaluator
implements EventModelEvaluator {
    private static final String SYNCH_START_MSG = "Error during external synchronised node pre-event callback";
    private static final String SYNCH_STOP_MSG = "Error during external synchronised node post-event callback";
    private static final String NO_BINDABLE_MGR_MSG = "attempting to add a bindable node that has no manager for its layer.";
    private static final int[] LAYER_NODE_TYPES = new int[]{89};
    private static final int NUM_NODES = 32;
    private static final int NUM_NODES_INC = 8;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private EventModelInitListener initListener;
    private RouteManager routeManager;
    private SensorManager sensorManager;
    private ViewpointManager viewpointManager;
    private ScriptManager scriptManager;
    private FrameStateManager stateManager;
    private ContentLoadManager contentLoader;
    private ArrayList externalViews = new ArrayList();
    private NodeArray externalSyncNodes = new NodeArray();
    private VRMLScene currentScene;
    private boolean active = false;
    private VRMLNodeType[] tmpNodes;
    private NodeArray tmpArray;
    private HashMap scriptToSceneMap = new HashMap();
    private boolean sceneNeedsChanging = false;
    private VRMLScene sceneToLoad;
    private VRMLViewpointNodeType pendingViewpoint;
    private String initialViewpoint;
    private NodeManager[] preEventManagers;
    private int numPreEventManagers;
    private NodeManager[] postEventManagers;
    private int numPostEventManagers;
    private HashMap sceneToScriptListMap = new HashMap();
    private boolean justStarted = false;
    private boolean initialWorldLoadComplete = false;
    private VRMLExecutionSpace rootSpace;
    private long lastTime;
    private boolean shutdownNow = false;
    private LayerManagerFactory layerManagerFactory;
    private LayerRenderingManager layerRenderer;
    private LayerManager[] layerManagers;
    private int numValidLayerManagers;
    private int numActiveLayerManagers;
    private int activeNavigationLayer;
    private int[] renderOrder;
    private HashMap layerToRendererMap;
    private boolean haveLayerSet = false;
    private IntHashMap nodeObserverMap;

    public DefaultEventModelEvaluator() {
        this.tmpNodes = new VRMLNodeType[32];
        this.tmpArray = new NodeArray(32);
        this.renderOrder = new int[1];
        this.layerManagers = new LayerManager[1];
        this.layerToRendererMap = new HashMap();
        this.nodeObserverMap = new IntHashMap();
    }

    public void initialize(ScriptManager scriptManager, RouteManager routeManager, SensorManager sensorManager, FrameStateManager frameStateManager, ContentLoadManager contentLoadManager, ViewpointManager viewpointManager, LayerManagerFactory layerManagerFactory, LayerRenderingManager layerRenderingManager, NodeManager[] nodeManagerArray) {
        this.scriptManager = scriptManager;
        this.routeManager = routeManager;
        this.sensorManager = sensorManager;
        this.stateManager = frameStateManager;
        this.contentLoader = contentLoadManager;
        this.viewpointManager = viewpointManager;
        this.layerManagerFactory = layerManagerFactory;
        this.layerRenderer = layerRenderingManager;
        int n = nodeManagerArray == null ? 0 : nodeManagerArray.length;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (nodeManagerArray[i].evaluatePreEventModel()) {
                ++n3;
            }
            if (!nodeManagerArray[i].evaluatePostEventModel()) continue;
            ++n2;
        }
        this.preEventManagers = new NodeManager[n3];
        this.postEventManagers = new NodeManager[n2];
        n3 = 0;
        n2 = 0;
        VRMLClock vRMLClock = this.sensorManager.getVRMLClock();
        for (int i = 0; i < n; ++i) {
            if (!nodeManagerArray[i].initialize()) {
                this.errorReporter.warningReport("Manager " + nodeManagerArray[i].getClass() + " failed to initialise. Ignoring", null);
                continue;
            }
            if (nodeManagerArray[i].evaluatePreEventModel()) {
                this.preEventManagers[n3++] = nodeManagerArray[i];
            }
            if (nodeManagerArray[i].evaluatePostEventModel()) {
                this.postEventManagers[n2++] = nodeManagerArray[i];
            }
            this.stateManager.listenFor(nodeManagerArray[i].getManagedNodeTypes());
            nodeManagerArray[i].setErrorReporter(this.errorReporter);
            nodeManagerArray[i].setVRMLClock(vRMLClock);
        }
        this.stateManager.listenFor(new int[]{55});
        this.numPreEventManagers = n3;
        this.numPostEventManagers = n2;
        this.layerManagers = new LayerManager[1];
        this.layerManagers[0] = this.layerManagerFactory.createLayerManager();
        this.layerManagers[0].setLayerId(0);
        this.layerManagers[0].initialise(this.sensorManager);
        this.numValidLayerManagers = 1;
        this.numActiveLayerManagers = 0;
    }

    public void addNodeObserver(int n, NodeObserver nodeObserver) {
        ArrayList<NodeObserver> arrayList = (ArrayList<NodeObserver>)this.nodeObserverMap.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<NodeObserver>();
            this.nodeObserverMap.put(n, arrayList);
        }
        if (arrayList.size() == 0) {
            this.stateManager.listenFor(new int[]{n});
        }
        if (!arrayList.contains(nodeObserver)) {
            arrayList.add(nodeObserver);
        }
    }

    public void removeNodeObserver(int n, NodeObserver nodeObserver) {
        List list = (List)this.nodeObserverMap.get(n);
        if (list == null) {
            return;
        }
        list.remove(nodeObserver);
        if (list.size() == 0) {
            this.stateManager.removeListenFor(new int[]{n});
        }
    }

    public void shutdown() {
        int n;
        this.shutdownNow = true;
        for (n = 0; n < this.numPreEventManagers; ++n) {
            this.preEventManagers[n].clear();
            this.preEventManagers[n].shutdown();
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            this.postEventManagers[n].clear();
            this.postEventManagers[n].shutdown();
        }
        this.viewpointManager.shutdown();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        int n;
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.routeManager.setErrorReporter(this.errorReporter);
        this.sensorManager.setErrorReporter(this.errorReporter);
        this.viewpointManager.setErrorReporter(this.errorReporter);
        this.scriptManager.setErrorReporter(this.errorReporter);
        this.stateManager.setErrorReporter(this.errorReporter);
        this.contentLoader.setErrorReporter(this.errorReporter);
        this.layerManagerFactory.setErrorReporter(this.errorReporter);
        for (n = 0; n < this.numValidLayerManagers; ++n) {
            this.layerManagers[n].setErrorReporter(this.errorReporter);
        }
        for (n = 0; n < this.numPreEventManagers; ++n) {
            this.preEventManagers[n].setErrorReporter(this.errorReporter);
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            this.postEventManagers[n].setErrorReporter(this.errorReporter);
        }
    }

    public LayerManager getLayerManager(int n) {
        if (n < this.numValidLayerManagers) {
            return this.layerManagers[n];
        }
        return null;
    }

    public VRMLClock getVRMLClock() {
        return this.sensorManager.getVRMLClock();
    }

    public void addExternalView(ExternalView externalView) {
        if (!this.externalViews.contains(externalView)) {
            this.externalViews.add(externalView);
        }
    }

    public void removeExternalView(ExternalView externalView) {
        this.externalViews.remove(externalView);
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.sceneNeedsChanging = true;
        this.sceneToLoad = vRMLScene;
        this.initialViewpoint = string;
    }

    public void changeViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.pendingViewpoint = vRMLViewpointNodeType;
    }

    public void clear() {
        int n;
        this.active = false;
        this.scriptManager.shutdown();
        this.routeManager.clear();
        this.sensorManager.clear();
        this.stateManager.clear();
        this.contentLoader.clear();
        this.externalViews.clear();
        this.externalSyncNodes.clear();
        this.scriptToSceneMap.clear();
        this.sceneToScriptListMap.clear();
        for (n = 0; n < this.numValidLayerManagers; ++n) {
            this.layerManagers[n].clear();
        }
        for (n = 0; n < this.numPreEventManagers; ++n) {
            this.preEventManagers[n].clear();
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            this.postEventManagers[n].clear();
        }
        for (n = 0; n < this.tmpNodes.length; ++n) {
            this.tmpNodes[n] = null;
        }
        this.pendingViewpoint = null;
        this.currentScene = null;
        this.rootSpace = null;
        this.haveLayerSet = false;
    }

    public void evaluate(long l) {
        this.lastTime = l;
        if (this.sceneNeedsChanging) {
            if (this.initListener != null) {
                this.initListener.changeWorld();
            }
            this.finishSetScene(l);
            this.sceneNeedsChanging = false;
            return;
        }
        if (!this.active) {
            return;
        }
        if (!this.initialWorldLoadComplete) {
            this.evaluateTimeZero(l);
        } else {
            if (this.justStarted) {
                int n;
                if (this.initListener != null) {
                    try {
                        this.initListener.worldInitComplete();
                    }
                    catch (Exception exception) {
                        this.errorReporter.warningReport("Error sending core init", exception);
                    }
                }
                for (n = 0; n < this.numPreEventManagers; ++n) {
                    this.preEventManagers[n].resetTimeZero();
                }
                for (n = 0; n < this.numPostEventManagers; ++n) {
                    this.postEventManagers[n].resetTimeZero();
                }
                this.justStarted = false;
            }
            this.evaluateRunning(l);
        }
    }

    public void setInitListener(EventModelInitListener eventModelInitListener) {
        this.initListener = eventModelInitListener;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    public ContentLoadManager getContentLoader() {
        return this.contentLoader;
    }

    public FrameStateManager getFrameStateManager() {
        return this.stateManager;
    }

    public NodeManager[] getNodeManagers() {
        int n;
        int n2 = this.numPreEventManagers + this.numPostEventManagers;
        if (n2 == 0) {
            return null;
        }
        NodeManager[] nodeManagerArray = new NodeManager[n2];
        int n3 = 0;
        for (n = 0; n < this.numPreEventManagers; ++n) {
            nodeManagerArray[n3++] = this.preEventManagers[n];
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            nodeManagerArray[n3++] = this.postEventManagers[n];
        }
        return nodeManagerArray;
    }

    private void finishSetScene(double d) {
        if (this.active) {
            this.clear();
        }
        this.currentScene = this.sceneToLoad;
        this.sceneToLoad = null;
        if (this.currentScene == null) {
            this.active = false;
            return;
        }
        this.rootSpace = (VRMLExecutionSpace)((Object)this.currentScene.getRootNode());
        ((VRMLNodeType)((Object)this.rootSpace)).setFrameStateManager(this.stateManager);
        SceneMetaData sceneMetaData = this.currentScene.getMetaData();
        this.layerManagers[0].clear();
        if (sceneMetaData.isVrmlSpec()) {
            this.loadVRMLScripts(this.rootSpace, this.currentScene, this.currentScene, true);
            this.stateManager.removeListenFor(LAYER_NODE_TYPES);
            this.haveLayerSet = false;
        } else {
            if (this.currentScene.getFirstLayerSet() != null) {
                this.haveLayerSet = true;
                this.stateManager.listenFor(LAYER_NODE_TYPES);
            } else {
                this.haveLayerSet = false;
                this.stateManager.removeListenFor(LAYER_NODE_TYPES);
            }
            this.loadX3DScene(this.rootSpace, this.currentScene, true);
        }
        this.routeManager.updateSpaces();
        this.routeManager.updateRoutes();
        this.active = true;
        this.initialWorldLoadComplete = this.justStarted = this.scriptToSceneMap.size() == 0;
    }

    private void evaluateTimeZero(long l) {
        this.processScripts();
        if (this.shutdownNow) {
            return;
        }
        this.processViewpoints(l);
        if (this.scriptToSceneMap.size() != 0) {
            return;
        }
        this.scriptManager.initializeScripts(l);
        if (this.shutdownNow) {
            return;
        }
        this.scriptManager.processEvents();
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.processRoutes((double)l * 0.001);
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.updateSpaces();
        if (this.shutdownNow) {
            return;
        }
        NodeArray nodeArray = this.stateManager.getAddedUrlNodes();
        if (this.shutdownNow) {
            return;
        }
        this.contentLoader.queueNodesLoad(nodeArray);
        if (this.shutdownNow) {
            return;
        }
        this.processBindables();
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.updateRoutes();
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.addSensors(this.stateManager.getAddedSensors());
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.addViewDependentNodes(this.stateManager.getAddedViewDependents());
        if (this.shutdownNow) {
            return;
        }
        this.scriptManager.addScripts(this.stateManager.getAddedScripts());
        if (this.shutdownNow) {
            return;
        }
        this.stateManager.clearRemovedNodes();
        this.stateManager.clearAddedNodes();
        if (this.shutdownNow) {
            return;
        }
        this.stateManager.frameFinished();
        this.justStarted = true;
        this.initialWorldLoadComplete = true;
    }

    private void evaluateRunning(long l) {
        int n;
        Object object;
        int n2;
        int n3;
        VRMLLayerSetNodeType vRMLLayerSetNodeType;
        if (this.pendingViewpoint != null) {
            this.pendingViewpoint.setBind(true, true, l);
            this.pendingViewpoint = null;
        }
        if ((vRMLLayerSetNodeType = this.currentScene.getFirstLayerSet()) != null) {
            n3 = vRMLLayerSetNodeType.getActiveNavigationLayer();
            if (n3 != this.activeNavigationLayer) {
                this.layerManagers[this.activeNavigationLayer].setActiveNavigationLayer(false);
                this.layerManagers[n3].setActiveNavigationLayer(true);
                this.activeNavigationLayer = n3;
            }
            if (!this.haveLayerSet) {
                this.haveLayerSet = true;
                this.stateManager.listenFor(LAYER_NODE_TYPES);
            }
        } else if (this.activeNavigationLayer != 0) {
            this.layerManagers[this.activeNavigationLayer].setActiveNavigationLayer(false);
            this.layerManagers[0].setActiveNavigationLayer(true);
            this.activeNavigationLayer = 0;
            this.haveLayerSet = false;
            this.stateManager.removeListenFor(LAYER_NODE_TYPES);
        }
        this.processViewpoints(l);
        this.externalSyncNodes.remove(this.stateManager.getRemovedExtSynchronizedNodes());
        if (this.shutdownNow) {
            return;
        }
        this.externalSyncNodes.add(this.stateManager.getAddedExtSynchronizedNodes());
        if (this.shutdownNow) {
            return;
        }
        this.processSynchronisedNodes(true);
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.processUserInput(this.activeNavigationLayer, l);
        if (this.shutdownNow) {
            return;
        }
        this.processPreEventManagers(l);
        this.processNodeObservers();
        if (this.shutdownNow) {
            return;
        }
        for (n3 = 0; n3 < this.externalViews.size(); ++n3) {
            ExternalView externalView = (ExternalView)this.externalViews.get(n3);
            if (this.shutdownNow) {
                return;
            }
            externalView.processEvents();
        }
        if (this.shutdownNow) {
            return;
        }
        double d = (double)l * 0.001;
        this.scriptManager.prepareEvents(d);
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.processRoutes(d);
        if (this.shutdownNow) {
            return;
        }
        this.scriptManager.processEvents();
        if (this.shutdownNow) {
            return;
        }
        this.loadScenes(this.stateManager.getAddedScenes());
        if (this.shutdownNow) {
            return;
        }
        this.stateManager.clearAddedScenes();
        if (this.shutdownNow) {
            return;
        }
        NodeArray nodeArray = this.stateManager.getAddedUrlNodes();
        if (this.shutdownNow) {
            return;
        }
        this.contentLoader.queueNodesLoad(nodeArray);
        if (this.shutdownNow) {
            return;
        }
        NodeTemplateArray nodeTemplateArray = this.stateManager.getAddedExternProtos();
        if (this.shutdownNow) {
            return;
        }
        if (nodeTemplateArray.size() != 0) {
            int n4 = nodeTemplateArray.size();
            for (n2 = 0; n2 < n4; ++n2) {
                object = (VRMLExternProtoDeclare)nodeTemplateArray.get(n2);
                if (this.shutdownNow) {
                    return;
                }
                this.contentLoader.queueExternProtoLoad((VRMLExternProtoDeclare)object);
            }
        }
        do {
            this.scriptManager.shutdownActiveScripts();
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.removeScripts(this.stateManager.getRemovedScripts());
            if (this.shutdownNow) {
                return;
            }
            ObjectArray objectArray = this.stateManager.getRemovedScenes();
            n2 = objectArray.size();
            for (n = 0; n < n2; ++n) {
                object = (VRMLExecutionSpace)objectArray.get(n);
                this.removeScene((VRMLExecutionSpace)object);
            }
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.removeSensors(this.stateManager.getRemovedSensors());
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.removeViewDependentNodes(this.stateManager.getRemovedViewDependents());
            if (this.shutdownNow) {
                return;
            }
            this.routeManager.updateSpaces();
            if (this.shutdownNow) {
                return;
            }
            this.processBindables();
            if (this.shutdownNow) {
                return;
            }
            this.routeManager.updateRoutes();
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.addSensors(this.stateManager.getAddedSensors());
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.addViewDependentNodes(this.stateManager.getAddedViewDependents());
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.eventsProcessed();
            if (this.shutdownNow) {
                return;
            }
            this.processScripts();
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.addScripts(this.stateManager.getAddedScripts());
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.initializeScripts(l);
            if (this.shutdownNow) {
                return;
            }
            this.stateManager.clearRemovedNodes();
            this.stateManager.clearAddedNodes();
            if (!this.shutdownNow) continue;
            return;
        } while (this.routeManager.processRoutes(d));
        if (this.shutdownNow) {
            return;
        }
        this.processPostEventManagers(l);
        if (this.shutdownNow) {
            return;
        }
        if (vRMLLayerSetNodeType != null) {
            int n5 = vRMLLayerSetNodeType.getNumRenderedLayers();
            LayerManager layerManager = this.layerManagers[0];
            if (this.renderOrder.length < n5) {
                this.renderOrder = new int[n5];
                this.layerManagers = new LayerManager[n5];
            }
            if (vRMLLayerSetNodeType.hasLayerListChanged()) {
                LayerManager layerManager2;
                VRMLLayerNodeType vRMLLayerNodeType;
                int n6;
                object = this.stateManager.getRemovedNodes(89);
                n = ((NodeArray)object).size();
                for (n6 = 0; n6 < n; ++n6) {
                    vRMLLayerNodeType = (VRMLLayerNodeType)((NodeArray)object).get(n6);
                    layerManager2 = (LayerManager)this.layerToRendererMap.remove(vRMLLayerNodeType);
                    layerManager2.clear();
                    layerManager2.shutdown();
                }
                this.numValidLayerManagers -= n;
                object = this.stateManager.getAddedNodes(89);
                n = ((NodeArray)object).size();
                for (n6 = 0; n6 < n; ++n6) {
                    vRMLLayerNodeType = (VRMLLayerNodeType)((NodeArray)object).get(n6);
                    layerManager2 = this.layerManagerFactory.createLayerManager();
                    layerManager2.setLayerId(vRMLLayerNodeType.getLayerId());
                    layerManager2.initialise(this.sensorManager);
                    layerManager2.setManagedLayer(vRMLLayerNodeType);
                    this.layerToRendererMap.put(vRMLLayerNodeType, layerManager2);
                }
                this.numValidLayerManagers += n;
                VRMLNodeType[] vRMLNodeTypeArray = vRMLLayerSetNodeType.getLayers();
                this.layerManagers[0] = layerManager;
                for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                    this.layerManagers[i + 1] = (LayerManager)this.layerToRendererMap.get(vRMLNodeTypeArray[i]);
                }
                this.layerRenderer.setActiveLayers(this.layerManagers, this.numValidLayerManagers);
            }
            if (vRMLLayerSetNodeType.hasRenderOrderChanged()) {
                vRMLLayerSetNodeType.getRenderOrder(this.renderOrder);
                this.layerRenderer.setRenderOrder(this.renderOrder, n5);
                this.sensorManager.setRenderOrder(this.renderOrder, n5);
            }
        }
        this.stateManager.frameFinished();
        if (this.shutdownNow) {
            return;
        }
        for (int i = 0; i < this.numActiveLayerManagers; ++i) {
            this.layerManagers[i].updateViewMatrix();
        }
        if (this.shutdownNow) {
            return;
        }
        this.processSynchronisedNodes(false);
    }

    private void processViewpoints(long l) {
        this.viewpointManager.updateViewpoint(l);
    }

    private void processBindables() {
        int n;
        int[] nArray;
        BindableNodeManager bindableNodeManager;
        int n2;
        int n3;
        int[] nArray2;
        VRMLNodeType vRMLNodeType;
        int n4;
        NodeArray nodeArray = this.stateManager.getRemovedBindables();
        int n5 = nodeArray.size();
        for (n4 = 0; n4 < n5; ++n4) {
            vRMLNodeType = (VRMLNodeType)nodeArray.get(n4);
            nArray2 = vRMLNodeType.getRemovedLayerIds();
            if (nArray2 == null) continue;
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                n2 = vRMLNodeType.getPrimaryType();
                bindableNodeManager = this.layerManagers[nArray2[n3]].getBindableManager(n2);
                if (bindableNodeManager == null) {
                    this.errorReporter.warningReport("attempting to remove a bindable node that has no manager", null);
                    continue;
                }
                bindableNodeManager.removeNode((VRMLBindableNodeType)vRMLNodeType);
                if (n2 == 31) continue;
                nArray = vRMLNodeType.getSecondaryType();
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] != 31 || (bindableNodeManager = this.layerManagers[nArray2[n3]].getBindableManager(nArray[n])) == null) continue;
                    bindableNodeManager.removeNode((VRMLBindableNodeType)vRMLNodeType);
                }
            }
        }
        if (this.shutdownNow) {
            return;
        }
        nodeArray = this.stateManager.getAddedBindables();
        n5 = nodeArray.size();
        for (n4 = 0; n4 < n5; ++n4) {
            vRMLNodeType = (VRMLNodeType)nodeArray.get(n4);
            nArray2 = vRMLNodeType.getLayerIds();
            if (nArray2 == null) continue;
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                n2 = vRMLNodeType.getPrimaryType();
                bindableNodeManager = this.layerManagers[nArray2[n3]].getBindableManager(n2);
                if (bindableNodeManager == null) {
                    this.errorReporter.warningReport("attempting to remove a bindable node that has no manager", null);
                    continue;
                }
                if (!bindableNodeManager.contains((VRMLBindableNodeType)vRMLNodeType)) {
                    bindableNodeManager.addNode((VRMLBindableNodeType)vRMLNodeType, false);
                }
                if (n2 == 31) continue;
                nArray = vRMLNodeType.getSecondaryType();
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] != 31 || (bindableNodeManager = this.layerManagers[nArray2[n3]].getBindableManager(nArray[n])) == null || bindableNodeManager.contains((VRMLBindableNodeType)vRMLNodeType)) continue;
                    bindableNodeManager.addNode((VRMLBindableNodeType)vRMLNodeType, false);
                }
            }
        }
    }

    private void processNodeObservers() {
        int[] nArray = this.nodeObserverMap.keySet();
        for (int i = 0; i < nArray.length && !this.shutdownNow; ++i) {
            NodeObserver nodeObserver;
            int n;
            List list = (List)this.nodeObserverMap.get(nArray[i]);
            if (list.size() == 0) continue;
            NodeArray nodeArray = this.stateManager.getRemovedNodes(nArray[i]);
            int n2 = nodeArray.size();
            if (n2 > 0) {
                if (n2 > this.tmpNodes.length) {
                    this.tmpNodes = new VRMLNodeType[n2];
                }
                nodeArray.toArray(this.tmpNodes);
                for (n = 0; n < list.size() && !this.shutdownNow; ++n) {
                    nodeObserver = (NodeObserver)list.get(n);
                    nodeObserver.nodesRemoved(nArray[i], this.tmpNodes, n2);
                }
            }
            if ((n2 = (nodeArray = this.stateManager.getAddedNodes(nArray[i])).size()) == 0) continue;
            if (n2 > this.tmpNodes.length) {
                this.tmpNodes = new VRMLNodeType[n2];
            }
            nodeArray.toArray(this.tmpNodes);
            for (n = 0; n < list.size() && !this.shutdownNow; ++n) {
                nodeObserver = (NodeObserver)list.get(n);
                nodeObserver.nodesAdded(nArray[i], this.tmpNodes, n2);
            }
        }
    }

    private void processPreEventManagers(long l) {
        for (int i = 0; i < this.numPreEventManagers && !this.shutdownNow; ++i) {
            int[] nArray = this.preEventManagers[i].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int j = 0; j < nArray.length; ++j) {
                VRMLNodeType vRMLNodeType;
                int n;
                NodeArray nodeArray = this.stateManager.getRemovedNodes(nArray[j]);
                int n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.preEventManagers[i].removeManagedNode(vRMLNodeType);
                }
                if (this.shutdownNow) {
                    return;
                }
                nodeArray = this.stateManager.getAddedNodes(nArray[j]);
                n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.preEventManagers[i].addManagedNode(vRMLNodeType);
                }
            }
            if (this.shutdownNow) {
                return;
            }
            this.preEventManagers[i].executePreEventModel(l);
        }
    }

    private void processPostEventManagers(long l) {
        for (int i = 0; i < this.numPostEventManagers && !this.shutdownNow; ++i) {
            int[] nArray = this.postEventManagers[i].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int j = 0; j < nArray.length; ++j) {
                VRMLNodeType vRMLNodeType;
                int n;
                NodeArray nodeArray = this.stateManager.getRemovedNodes(nArray[j]);
                int n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.postEventManagers[i].removeManagedNode(vRMLNodeType);
                }
                if (this.shutdownNow) {
                    return;
                }
                nodeArray = this.stateManager.getAddedNodes(nArray[j]);
                n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.postEventManagers[i].addManagedNode(vRMLNodeType);
                }
                if (!this.shutdownNow) continue;
                return;
            }
            if (this.shutdownNow) {
                return;
            }
            this.postEventManagers[i].executePostEventModel(l);
        }
    }

    private void processScripts() {
        if (this.scriptToSceneMap.size() == 0) {
            return;
        }
        this.scriptManager.getProcessedScripts(this.tmpArray);
        if (this.shutdownNow) {
            return;
        }
        int n = this.tmpArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.tmpArray.get(i);
            BasicScene basicScene = (BasicScene)this.scriptToSceneMap.get(vRMLScriptNodeType);
            if (this.shutdownNow) {
                return;
            }
            if (basicScene == null) continue;
            this.scriptToSceneMap.remove(vRMLScriptNodeType);
            HashSet hashSet = (HashSet)this.sceneToScriptListMap.get(basicScene);
            if (!hashSet.contains(vRMLScriptNodeType)) {
                System.out.println("processScripts.invalid mapping happened!");
                continue;
            }
            if (this.shutdownNow) {
                return;
            }
            if (hashSet.size() == 1) {
                this.completeVRMLSceneLoad(basicScene);
                this.sceneToScriptListMap.remove(basicScene);
                continue;
            }
            hashSet.remove(vRMLScriptNodeType);
        }
        this.tmpArray.clear();
    }

    private void loadScenes(ObjectArray objectArray) {
        int n = objectArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)objectArray.get(i);
            BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
            if (basicScene instanceof VRMLScene) {
                VRMLScene vRMLScene = (VRMLScene)basicScene;
                SceneMetaData sceneMetaData = vRMLScene.getMetaData();
                if (sceneMetaData.isVrmlSpec()) {
                    this.loadVRMLScripts(vRMLExecutionSpace, vRMLScene, vRMLScene, false);
                } else {
                    this.loadX3DScene(vRMLExecutionSpace, vRMLScene, false);
                }
            } else {
                this.loadX3DScene(vRMLExecutionSpace, basicScene, false);
            }
            if (!this.shutdownNow) continue;
            return;
        }
    }

    private void completeVRMLSceneLoad(BasicScene basicScene) {
        Object object;
        VRMLNodeType vRMLNodeType;
        int n;
        ArrayList arrayList = basicScene.getBySecondaryType(5);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)arrayList.get(n);
            object = this.layerManagers[0].getBindableManager(vRMLNodeType.getPrimaryType());
            ((BindableNodeManager)object).addNode((VRMLBindableNodeType)vRMLNodeType, false);
            int[] nArray = vRMLNodeType.getSecondaryType();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 31 || (object = this.layerManagers[0].getBindableManager(nArray[i])) == null || ((BindableNodeManager)object).contains((VRMLBindableNodeType)vRMLNodeType)) continue;
                ((BindableNodeManager)object).addNode((VRMLBindableNodeType)vRMLNodeType, false);
            }
        }
        if (this.shutdownNow) {
            return;
        }
        this.contentLoader.queueSceneLoad(basicScene);
        if (this.shutdownNow) {
            return;
        }
        arrayList = basicScene.getByPrimaryType(38);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLProtoInstance)arrayList.get(n);
            object = vRMLNodeType.getContainedScene();
            if (this.shutdownNow) {
                return;
            }
            this.completeVRMLSceneLoad((BasicScene)object);
        }
        if (this.shutdownNow) {
            return;
        }
        if (this.currentScene == basicScene) {
            this.initialBind();
        }
    }

    private void loadVRMLScripts(VRMLExecutionSpace vRMLExecutionSpace, VRMLScene vRMLScene, BasicScene basicScene, boolean bl) {
        int n;
        Object object;
        if (bl) {
            object = (VRMLWorldRootNodeType)vRMLScene.getRootNode();
            object.setRootWorld();
            this.renderOrder[0] = 0;
            this.layerManagers[0].setSpecVersion(2, 0);
            this.layerManagers[0].setManagedNodes((VRMLWorldRootNodeType)object);
            this.layerManagers[0].setActiveNavigationLayer(true);
            this.activeNavigationLayer = 0;
            this.numValidLayerManagers = 1;
            this.numActiveLayerManagers = 1;
            this.haveLayerSet = false;
            this.layerRenderer.setActiveLayers(this.layerManagers, 1);
            this.layerRenderer.setRenderOrder(this.renderOrder, 1);
            this.sensorManager.setRenderOrder(this.renderOrder, 1);
            for (n = 1; n < this.numValidLayerManagers; ++n) {
                this.layerManagers[n].clear();
            }
        }
        if ((n = ((ArrayList)(object = basicScene.getByPrimaryType(41))).size()) != 0) {
            this.checkTmpArray(n);
            ((ArrayList)object).toArray(this.tmpNodes);
            this.tmpArray.add(this.tmpNodes, 0, n);
            this.scriptManager.addScripts(this.tmpArray);
            this.tmpArray.clear();
            HashSet<VRMLNodeType> hashSet = (HashSet<VRMLNodeType>)this.sceneToScriptListMap.get(vRMLScene);
            if (hashSet == null) {
                hashSet = new HashSet<VRMLNodeType>(n);
                this.sceneToScriptListMap.put(vRMLScene, hashSet);
            }
            for (int i = 0; i < n; ++i) {
                hashSet.add(this.tmpNodes[i]);
                this.scriptToSceneMap.put(this.tmpNodes[i], vRMLScene);
            }
        } else {
            this.completeVRMLSceneLoad(basicScene);
        }
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.addSpace(vRMLExecutionSpace);
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.loadScene(basicScene);
        if (this.shutdownNow) {
            return;
        }
        object = basicScene.getByPrimaryType(38);
        n = ((ArrayList)object).size();
        for (int i = 0; i < n; ++i) {
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)((ArrayList)object).get(i);
            if (vRMLProtoInstance.getImplementationNode() == null) continue;
            if (this.shutdownNow) {
                return;
            }
            BasicScene basicScene2 = vRMLProtoInstance.getContainedScene();
            this.loadVRMLScripts(vRMLProtoInstance, vRMLScene, basicScene2, false);
        }
    }

    private void loadX3DScene(VRMLExecutionSpace vRMLExecutionSpace, BasicScene basicScene, boolean bl) {
        int n;
        ArrayList arrayList;
        int n2;
        Object object;
        int n3;
        Object object2;
        Object object3;
        int n4;
        if (bl) {
            int n5 = basicScene.getSpecificationMajorVersion();
            n4 = basicScene.getSpecificationMinorVersion();
            VRMLScene vRMLScene = (VRMLScene)basicScene;
            object3 = (VRMLWorldRootNodeType)vRMLScene.getRootNode();
            object3.setRootWorld();
            this.layerManagers[0].setSpecVersion(n5, n4);
            this.layerManagers[0].setManagedNodes((VRMLWorldRootNodeType)object3);
            object2 = vRMLScene.getFirstLayerSet();
            for (n3 = 1; n3 < this.numValidLayerManagers; ++n3) {
                this.layerManagers[n3].clear();
            }
            n3 = 0;
            if (object2 != null) {
                int n6;
                n3 = object2.getNumRenderedLayers();
                if (this.renderOrder.length < n3) {
                    this.renderOrder = new int[n3];
                }
                int n7 = n6 = (object = object2.getLayers()) == null ? 0 : ((VRMLNodeType[])object).length;
                if (this.layerManagers.length < n6 + 1) {
                    LayerManager[] layerManagerArray = new LayerManager[n6 + 1];
                    System.arraycopy(this.layerManagers, 0, layerManagerArray, 0, this.numValidLayerManagers);
                    this.layerManagers = layerManagerArray;
                }
                for (n2 = 0; n2 < n6; ++n2) {
                    VRMLLayerNodeType vRMLLayerNodeType = (VRMLLayerNodeType)object[n2];
                    LayerManager layerManager = this.layerManagers[n2 + 1];
                    if (layerManager == null) {
                        this.layerManagers[n2 + 1] = layerManager = this.layerManagerFactory.createLayerManager();
                        layerManager.setLayerId(vRMLLayerNodeType.getLayerId());
                        layerManager.initialise(this.sensorManager);
                    } else {
                        layerManager.setLayerId(vRMLLayerNodeType.getLayerId());
                    }
                    layerManager.setSpecVersion(n5, n4);
                    layerManager.setManagedLayer(vRMLLayerNodeType);
                    this.layerToRendererMap.put(vRMLLayerNodeType, layerManager);
                }
                object2.getRenderOrder(this.renderOrder);
                n2 = object2.getActiveNavigationLayer();
                this.layerManagers[n2].setActiveNavigationLayer(true);
                this.activeNavigationLayer = n2;
                this.numValidLayerManagers = n6 + 1;
                this.numActiveLayerManagers = n6 + 1;
            } else {
                this.layerManagers[0].setActiveNavigationLayer(true);
                this.activeNavigationLayer = 0;
                this.numValidLayerManagers = 1;
                this.numActiveLayerManagers = 1;
                this.renderOrder[0] = 0;
                n3 = 1;
            }
            this.layerRenderer.setActiveLayers(this.layerManagers, this.numActiveLayerManagers);
            this.layerRenderer.setRenderOrder(this.renderOrder, n3);
            this.sensorManager.setRenderOrder(this.renderOrder, n3);
        }
        if ((n4 = (arrayList = basicScene.getByPrimaryType(41)).size()) != 0) {
            this.checkTmpArray(n4);
            arrayList.toArray(this.tmpNodes);
            this.tmpArray.add(this.tmpNodes, 0, n4);
            this.scriptManager.addScripts(this.tmpArray);
            this.tmpArray.clear();
        }
        if (this.shutdownNow) {
            return;
        }
        arrayList = basicScene.getBySecondaryType(5);
        n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            object3 = (VRMLNodeType)arrayList.get(n);
            object2 = object3.getLayerIds();
            if (object2 == null) continue;
            for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
                object = this.layerManagers[object2[n3]].getBindableManager(object3.getPrimaryType());
                if (object == null) {
                    this.errorReporter.warningReport(NO_BINDABLE_MGR_MSG, null);
                    continue;
                }
                if (!((BindableNodeManager)object).contains((VRMLBindableNodeType)object3)) {
                    ((BindableNodeManager)object).addNode((VRMLBindableNodeType)object3, false);
                }
                int[] nArray = object3.getSecondaryType();
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != 31 || (object = this.layerManagers[object2[n3]].getBindableManager(nArray[n2])) == null || ((BindableNodeManager)object).contains((VRMLBindableNodeType)object3)) continue;
                    ((BindableNodeManager)object).addNode((VRMLBindableNodeType)object3, false);
                }
            }
        }
        if (this.shutdownNow) {
            return;
        }
        arrayList = basicScene.getBySecondaryType(74);
        n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            object3 = (VRMLNodeType)arrayList.get(n);
            this.externalSyncNodes.add((VRMLNode)object3);
        }
        for (n = 0; n < this.numPreEventManagers; ++n) {
            object3 = this.preEventManagers[n].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int i = 0; i < ((Object)object3).length; ++i) {
                ArrayList arrayList2 = basicScene.getByPrimaryType((int)object3[i]);
                if (this.shutdownNow) {
                    return;
                }
                n4 = arrayList2.size();
                for (int j = 0; j < n4; ++j) {
                    VRMLNodeType vRMLNodeType = (VRMLNodeType)arrayList2.get(j);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.preEventManagers[n].addManagedNode(vRMLNodeType);
                }
            }
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            object3 = this.postEventManagers[n].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int i = 0; i < ((Object)object3).length; ++i) {
                ArrayList arrayList3 = basicScene.getByPrimaryType((int)object3[i]);
                if (this.shutdownNow) {
                    return;
                }
                n4 = arrayList3.size();
                for (int j = 0; j < n4; ++j) {
                    VRMLNodeType vRMLNodeType = (VRMLNodeType)arrayList3.get(j);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.postEventManagers[n].addManagedNode(vRMLNodeType);
                }
            }
        }
        this.contentLoader.queueSceneLoad(basicScene);
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.addSpace(vRMLExecutionSpace);
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.loadScene(basicScene);
        if (this.shutdownNow) {
            return;
        }
        arrayList = basicScene.getByPrimaryType(38);
        n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            object3 = (VRMLProtoInstance)arrayList.get(n);
            if (object3.getImplementationNode() == null) continue;
            object2 = object3.getContainedScene();
            if (this.shutdownNow) {
                return;
            }
            this.loadX3DScene((VRMLExecutionSpace)object3, (BasicScene)object2, false);
        }
        if (this.shutdownNow) {
            return;
        }
        if (this.currentScene == basicScene) {
            this.initialBind();
        }
    }

    private void checkTmpArray(int n) {
        if (this.tmpNodes.length < n) {
            int n2;
            for (n2 = this.tmpNodes.length + 8; n2 < n; n2 += 8) {
            }
            this.tmpNodes = new VRMLNodeType[n2];
        }
    }

    private void initialBind() {
        for (int i = 0; i < this.numActiveLayerManagers; ++i) {
            this.layerManagers[i].initialBind();
        }
    }

    private void processSynchronisedNodes(boolean bl) {
        int n = this.externalSyncNodes.size();
        if (n == 0) {
            return;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                try {
                    VRMLExternalSynchronizedNodeType vRMLExternalSynchronizedNodeType = (VRMLExternalSynchronizedNodeType)this.externalSyncNodes.get(i);
                    vRMLExternalSynchronizedNodeType.preEventEvaluation();
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(SYNCH_START_MSG, exception);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                try {
                    VRMLExternalSynchronizedNodeType vRMLExternalSynchronizedNodeType = (VRMLExternalSynchronizedNodeType)this.externalSyncNodes.get(i);
                    vRMLExternalSynchronizedNodeType.postEventEvaluation();
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(SYNCH_STOP_MSG, exception);
                }
            }
        }
    }

    private void removeScene(VRMLExecutionSpace vRMLExecutionSpace) {
        VRMLProtoInstance vRMLProtoInstance;
        VRMLNodeType vRMLNodeType;
        int n;
        Object object;
        Object object2;
        int n2;
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        ArrayList arrayList = basicScene.getByPrimaryType(41);
        int n3 = arrayList.size();
        if (n3 != 0) {
            this.checkTmpArray(n3);
            arrayList.toArray(this.tmpNodes);
            this.tmpArray.add(this.tmpNodes, 0, n3);
            this.scriptManager.removeScripts(this.tmpArray);
            this.tmpArray.clear();
        }
        arrayList = basicScene.getBySecondaryType(5);
        n3 = arrayList.size();
        int n4 = basicScene.getLayerId();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (VRMLNodeType)arrayList.get(n2);
            BindableNodeManager bindableNodeManager = this.layerManagers[n4].getBindableManager(object2.getPrimaryType());
            if (bindableNodeManager == null) {
                this.errorReporter.warningReport("attempting to remove a bindable node that has no manager", null);
                continue;
            }
            bindableNodeManager.removeNode((VRMLBindableNodeType)object2);
            object = object2.getSecondaryType();
            for (n = 0; n < ((int[])object).length; ++n) {
                if (object[n] != 31 || (bindableNodeManager = this.layerManagers[n4].getBindableManager((int)object[n])) == null) continue;
                bindableNodeManager.removeNode((VRMLBindableNodeType)object2);
            }
        }
        arrayList = basicScene.getBySecondaryType(74);
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (VRMLNodeType)arrayList.get(n2);
            this.externalSyncNodes.remove((VRMLNode)object2);
        }
        for (n2 = 0; n2 < this.numPreEventManagers; ++n2) {
            object2 = this.preEventManagers[n2].getManagedNodeTypes();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = basicScene.getByPrimaryType((int)object2[i]);
                n3 = ((ArrayList)object).size();
                for (n = 0; n < n3; ++n) {
                    vRMLNodeType = (VRMLNodeType)((ArrayList)object).get(n);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.preEventManagers[n2].removeManagedNode(vRMLNodeType);
                }
            }
        }
        for (n2 = 0; n2 < this.numPostEventManagers; ++n2) {
            object2 = this.postEventManagers[n2].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = basicScene.getByPrimaryType((int)object2[i]);
                if (this.shutdownNow) {
                    return;
                }
                n3 = ((ArrayList)object).size();
                for (n = 0; n < n3; ++n) {
                    vRMLNodeType = (VRMLNodeType)((ArrayList)object).get(n);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.postEventManagers[n2].removeManagedNode(vRMLNodeType);
                }
            }
        }
        this.routeManager.removeSpace(vRMLExecutionSpace);
        this.sensorManager.unloadScene(basicScene);
        arrayList = basicScene.getByPrimaryType(38);
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (VRMLProtoInstance)arrayList.get(n2);
            if (object2.getImplementationNode() == null) continue;
            this.removeScene((VRMLExecutionSpace)object2);
        }
        if (this.shutdownNow) {
            return;
        }
        if (this.currentScene == basicScene) {
            this.initialBind();
        }
    }
}

