/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.eventmodel;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.xj3d.core.eventmodel.ViewpointStatusListener;

public class ViewpointStatusListenerMulticaster
implements ViewpointStatusListener {
    private static final String VP_REMOVE_ERROR_MSG = "Error sending viewpoint remove message: ";
    private static final String VP_ADD_ERROR_MSG = "Error sending viewpoint add message: ";
    private static final String VP_CHANGE_ERROR_MSG = "Error sending viewpoint list change message: ";
    private static final String VP_SELECT_ERROR_MSG = "Error sending viewpoint change selection message: ";
    private static final String DEFAULT_ERR_MSG = "Unknown error sending viewpoint event: ";
    private final ViewpointStatusListener a;
    private final ViewpointStatusListener b;
    private static ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    ViewpointStatusListenerMulticaster(ViewpointStatusListener viewpointStatusListener, ViewpointStatusListener viewpointStatusListener2) {
        this.a = viewpointStatusListener;
        this.b = viewpointStatusListener2;
    }

    ViewpointStatusListener remove(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener == this.a) {
            return this.b;
        }
        if (viewpointStatusListener == this.b) {
            return this.a;
        }
        ViewpointStatusListener viewpointStatusListener2 = ViewpointStatusListenerMulticaster.removeInternal(this.a, viewpointStatusListener);
        ViewpointStatusListener viewpointStatusListener3 = ViewpointStatusListenerMulticaster.removeInternal(this.b, viewpointStatusListener);
        if (viewpointStatusListener2 == this.a && viewpointStatusListener3 == this.b) {
            return this;
        }
        return ViewpointStatusListenerMulticaster.addInternal(viewpointStatusListener2, viewpointStatusListener3);
    }

    public static void setErrorReporter(ErrorReporter errorReporter) {
        ViewpointStatusListenerMulticaster.errorReporter = errorReporter;
        if (errorReporter == null) {
            ViewpointStatusListenerMulticaster.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public static ViewpointStatusListener add(ViewpointStatusListener viewpointStatusListener, ViewpointStatusListener viewpointStatusListener2) {
        return ViewpointStatusListenerMulticaster.addInternal(viewpointStatusListener, viewpointStatusListener2);
    }

    public static ViewpointStatusListener remove(ViewpointStatusListener viewpointStatusListener, ViewpointStatusListener viewpointStatusListener2) {
        return ViewpointStatusListenerMulticaster.removeInternal(viewpointStatusListener, viewpointStatusListener2);
    }

    public void availableViewpointsChanged(VRMLViewpointNodeType[] vRMLViewpointNodeTypeArray) {
        try {
            this.a.availableViewpointsChanged(vRMLViewpointNodeTypeArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_CHANGE_ERROR_MSG + this.a, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
        try {
            this.b.availableViewpointsChanged(vRMLViewpointNodeTypeArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_CHANGE_ERROR_MSG + this.b, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
    }

    public void selectedViewpointChanged(VRMLViewpointNodeType vRMLViewpointNodeType) {
        try {
            this.a.selectedViewpointChanged(vRMLViewpointNodeType);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_SELECT_ERROR_MSG + this.a, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
        try {
            this.b.selectedViewpointChanged(vRMLViewpointNodeType);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_SELECT_ERROR_MSG + this.b, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
    }

    public void viewpointAdded(VRMLViewpointNodeType vRMLViewpointNodeType) {
        try {
            this.a.viewpointAdded(vRMLViewpointNodeType);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_ADD_ERROR_MSG + this.a, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
        try {
            this.b.viewpointAdded(vRMLViewpointNodeType);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_ADD_ERROR_MSG + this.b, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
    }

    public void viewpointRemoved(VRMLViewpointNodeType vRMLViewpointNodeType) {
        try {
            this.a.viewpointRemoved(vRMLViewpointNodeType);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_REMOVE_ERROR_MSG + this.a, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
        try {
            this.b.viewpointRemoved(vRMLViewpointNodeType);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                errorReporter.errorReport(VP_REMOVE_ERROR_MSG + this.b, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
    }

    private static ViewpointStatusListener addInternal(ViewpointStatusListener viewpointStatusListener, ViewpointStatusListener viewpointStatusListener2) {
        if (viewpointStatusListener == null) {
            return viewpointStatusListener2;
        }
        if (viewpointStatusListener2 == null) {
            return viewpointStatusListener;
        }
        return new ViewpointStatusListenerMulticaster(viewpointStatusListener, viewpointStatusListener2);
    }

    private static ViewpointStatusListener removeInternal(ViewpointStatusListener viewpointStatusListener, ViewpointStatusListener viewpointStatusListener2) {
        if (viewpointStatusListener == viewpointStatusListener2 || viewpointStatusListener == null) {
            return null;
        }
        if (viewpointStatusListener instanceof ViewpointStatusListenerMulticaster) {
            return ((ViewpointStatusListenerMulticaster)viewpointStatusListener).remove(viewpointStatusListener2);
        }
        return viewpointStatusListener;
    }
}

