/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.proto;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.NodeTemplateToInstanceCreator;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.DefaultLocator;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.ProtoInstancePlaceHolder;
import org.web3d.vrml.nodes.proto.ProtoROUTE;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.parser.FieldParserFactory;
import org.web3d.vrml.parser.VRMLFieldReader;
import org.web3d.vrml.sav.BinaryContentHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.StringContentHandler;
import org.web3d.vrml.sav.VRMLParseException;

public class ProtoBuilder
implements StringContentHandler,
BinaryContentHandler,
ProtoHandler,
ScriptHandler,
RouteHandler {
    private static final int STACK_START_SIZE = 50;
    private static final int STACK_INCREMENT = 25;
    private static final String VRML97_PROFILE_STRING = "VRML97";
    private static final String VRML_IMPORT_ERROR = "IMPORT statements are not permitted in VRML97 files";
    private static final String VRML_EXPORT_ERROR = "EXPORT statements are not permitted in VRML97 files";
    private static final String NESTED_PROTO_ERROR = "Nested PROTO declarations not allowed";
    private boolean init;
    private ErrorReporter errorReporter;
    private Locator locator;
    private VRMLFieldReader fieldParser;
    private boolean inScript = false;
    private boolean inProtoDecl = false;
    private boolean inProtoBody = false;
    private boolean inExternProtoDecl = false;
    private boolean inExternProtoURI = false;
    private int ignoreNodeCounter;
    private int currentFieldIndex;
    private VRMLNodeType currentNode;
    private AbstractProto currentProto;
    private VRMLScriptNodeType currentScript;
    private AbstractProto rootProto;
    private VRMLNodeType[] nodeStack;
    private int[] childIndexStack;
    private int topOfStack;
    private Map globalDefMap;
    private Map globalProtoMap;
    private Map globalExternProtoMap;
    private HashMap defMap;
    private HashMap protoMap;
    private HashMap externProtoMap;
    private Map importProxyMap;
    private Map exportProxyMap;
    private SimpleStack protoDeclStack;
    private SimpleStack scriptStack;
    private SimpleStack defMapStack;
    private SimpleStack protoMapStack;
    private SimpleStack importMapStack;
    private SimpleStack exportMapStack;
    private VRMLNodeFactory nodeFactory;
    private boolean isVrml97;
    private HashSet dontLoadTypes;
    private HashSet ignoreDefSet;
    private String worldURL;
    private int majorVersion;
    private int minorVersion;
    private NodeTemplateToInstanceCreator protoCreator;

    public ProtoBuilder(VRMLNodeFactory vRMLNodeFactory) throws NullPointerException {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("The factory is null");
        }
        this.nodeFactory = vRMLNodeFactory;
        this.defMap = new HashMap();
        this.protoMap = new HashMap();
        this.externProtoMap = new HashMap();
        this.importProxyMap = new HashMap();
        this.exportProxyMap = new HashMap();
        this.protoDeclStack = new SimpleStack();
        this.scriptStack = new SimpleStack();
        this.defMapStack = new SimpleStack();
        this.protoMapStack = new SimpleStack();
        this.importMapStack = new SimpleStack();
        this.exportMapStack = new SimpleStack();
        this.dontLoadTypes = new HashSet();
        this.ignoreDefSet = new HashSet();
        this.nodeStack = new VRMLNodeType[50];
        this.childIndexStack = new int[50];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        this.rootProto = null;
        this.topOfStack = -1;
        this.currentFieldIndex = 0;
        this.worldURL = string2;
        this.inScript = false;
        this.inProtoDecl = false;
        this.inProtoBody = false;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
        int n = 3;
        int n2 = 0;
        int n3 = 2;
        if (string4.charAt(1) == 'V') {
            this.nodeFactory.setSpecVersion(2, 0);
            this.nodeFactory.setProfile(VRML97_PROFILE_STRING);
            n = 2;
        } else {
            n3 = string3.equals("utf8") ? 2 : 3;
            int n4 = string5.indexOf(46);
            String string7 = string5.substring(n4 + 1);
            n2 = Integer.parseInt(string7);
            this.nodeFactory.setSpecVersion(n, n2);
        }
        if (n != this.majorVersion || n2 != this.minorVersion) {
            FieldParserFactory fieldParserFactory = FieldParserFactory.getFieldParserFactory();
            this.fieldParser = fieldParserFactory.newFieldParser(n, n2);
        }
        this.majorVersion = n;
        this.minorVersion = n2;
        if (this.majorVersion == 3 && n3 == 3) {
            this.fieldParser.setCaseSensitive(false);
        } else {
            this.fieldParser.setCaseSensitive(true);
        }
        if (this.locator == null) {
            this.locator = new DefaultLocator();
        }
        if (!this.init) {
            this.globalDefMap = new HashMap();
            this.globalProtoMap = new HashMap();
            this.globalExternProtoMap = new HashMap();
            this.init = true;
        }
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.nodeFactory.setProfile(string);
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        Object object;
        int n = string.indexOf(58);
        String string2 = string;
        int n2 = -1;
        if (n != -1) {
            string2 = string.substring(0, n);
            object = string.substring(n + 1);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Component level is malformed");
            }
        }
        object = this.nodeFactory.addComponent(string2, n2);
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        if (this.majorVersion < 3) {
            throw new VRMLException(VRML_IMPORT_ERROR);
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new VRMLException("DEF name not known for Inline referenced by import " + string);
        }
        if (vRMLNodeType.getPrimaryType() != 24) {
            throw new VRMLException("Import statement refers to a DEF name that is not an Inline node" + string);
        }
        ImportNodeProxy importNodeProxy = new ImportNodeProxy(string3, string, string2);
        importNodeProxy.setErrorReporter(this.errorReporter);
        ((PrototypeDecl)this.currentProto).addImportDecl(string3, importNodeProxy);
        this.importProxyMap.put(string3, importNodeProxy);
        HashMap<String, ImportNodeProxy> hashMap = (HashMap<String, ImportNodeProxy>)this.exportProxyMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, ImportNodeProxy>();
            this.exportProxyMap.put(string, hashMap);
            ((VRMLInlineNodeType)vRMLNodeType).setImportNodes(hashMap);
        }
        hashMap.put(string2, importNodeProxy);
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        if (this.majorVersion < 3) {
            throw new VRMLException(VRML_EXPORT_ERROR);
        }
        throw new VRMLException("Protos cannot contain EXPORT statements");
    }

    public void endDocument() throws SAVException, VRMLException {
        for (int i = 0; i < this.topOfStack; ++i) {
            this.nodeStack[i] = null;
        }
        this.topOfStack = 0;
        this.currentNode = null;
        this.currentProto = null;
        this.currentScript = null;
        this.currentFieldIndex = -1;
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        if (this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Node declaration in externproto decl");
        }
        if (this.ignoreNodeCounter > 0) {
            ++this.ignoreNodeCounter;
            if (string2 != null) {
                this.defMap.remove(string2);
                this.ignoreDefSet.add(string2);
            }
            return;
        }
        VRMLNodeType vRMLNodeType = null;
        VRMLNodeTemplate vRMLNodeTemplate = null;
        vRMLNodeTemplate = this.protoMap.containsKey(string) ? (VRMLNodeTemplate)this.protoMap.get(string) : (this.externProtoMap.containsKey(string) ? (VRMLNodeTemplate)this.externProtoMap.get(string) : (this.globalProtoMap.containsKey(string) ? (VRMLNodeTemplate)this.globalProtoMap.get(string) : (VRMLNodeTemplate)this.globalExternProtoMap.get(string)));
        vRMLNodeType = vRMLNodeTemplate != null ? new ProtoInstancePlaceHolder(vRMLNodeTemplate, this.majorVersion, this.minorVersion, false, this.protoCreator) : (VRMLNodeType)this.nodeFactory.createVRMLNode(string, false);
        if (vRMLNodeType != null) {
            VRMLProtoInstance vRMLProtoInstance;
            VRMLNodeType vRMLNodeType2;
            Class<?> clazz = vRMLNodeType.getClass();
            boolean bl = false;
            if (this.dontLoadTypes.contains(clazz)) {
                bl = true;
            } else if (vRMLNodeType instanceof VRMLProtoInstance && (vRMLNodeType2 = (vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType).getImplementationNode()) != null && this.dontLoadTypes.contains(vRMLNodeType2.getClass())) {
                bl = true;
            }
            if (bl) {
                this.ignoreNodeCounter = 1;
                if (string2 != null) {
                    this.defMap.remove(string2);
                    this.ignoreDefSet.add(string2);
                }
                return;
            }
        } else {
            this.ignoreNodeCounter = 1;
            if (string2 != null) {
                this.defMap.remove(string2);
                this.ignoreDefSet.add(string2);
            }
            return;
        }
        if (string2 != null) {
            if (this.majorVersion > 2 && this.defMap.containsKey(string2)) {
                throw new VRMLException("DEF name \"" + string2 + "\" already declared in this scope. " + "X3D requires unique DEF names per file");
            }
            vRMLNodeType.setDEF();
            this.ignoreDefSet.remove(string2);
            this.defMap.put(string2, vRMLNodeType);
        }
        if (this.inProtoDecl && this.nodeStack[this.topOfStack] == null) {
            ((VRMLProtoDeclare)((Object)this.currentProto)).addFieldNodeValue(this.currentFieldIndex, vRMLNodeType);
        } else {
            this.nodeStack[this.topOfStack].setValue(this.currentFieldIndex, vRMLNodeType);
        }
        ++this.topOfStack;
        this.nodeStack[this.topOfStack] = vRMLNodeType;
        this.currentNode = vRMLNodeType;
    }

    public void endNode() throws SAVException, VRMLException {
        if (this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "End Node declaration in externproto");
        }
        if (this.ignoreNodeCounter > 0) {
            --this.ignoreNodeCounter;
            return;
        }
        this.nodeStack[this.topOfStack] = null;
        --this.topOfStack;
        if (this.topOfStack >= 0) {
            this.currentNode = this.nodeStack[this.topOfStack];
            this.currentFieldIndex = this.childIndexStack[this.topOfStack];
        } else {
            this.currentNode = null;
            this.currentFieldIndex = -1;
        }
    }

    public void startField(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        int n = this.nodeStack[this.topOfStack].getFieldIndex(string);
        if (n == -1) {
            throw new InvalidFieldException("Unknown field name: " + string + " for node: " + this.currentNode.getVRMLNodeName());
        }
        this.currentFieldIndex = n;
        this.childIndexStack[this.topOfStack] = n;
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = this.currentNode.getFieldDeclaration(this.currentFieldIndex);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("Invalid field: " + this.currentNode.getVRMLNodeName() + " " + this.currentFieldIndex);
        }
        int n = vRMLFieldDeclaration.getFieldType();
        if (n == 1 || n == 2) {
            string = string.toUpperCase();
        }
        try {
            this.parseField(this.currentNode, this.currentFieldIndex, vRMLFieldDeclaration.getFieldType(), string);
        }
        catch (FieldException fieldException) {
            fieldException.setFieldName(vRMLFieldDeclaration.getName());
            throw fieldException;
        }
        catch (Exception exception) {
            this.errorReporter.messageReport("Problem in PROTO: " + this.currentProto.getVRMLNodeName() + "  field: " + vRMLFieldDeclaration + "  value: " + string);
            VRMLException vRMLException = new VRMLException("Internal error in parsing field: " + vRMLFieldDeclaration);
            vRMLException.initCause(exception);
            throw vRMLException;
        }
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        if (!this.inProtoDecl && stringArray.length != 0) {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.currentNode.getFieldDeclaration(this.currentFieldIndex);
            if (vRMLFieldDeclaration == null) {
                throw new InvalidFieldException("Invalid field: " + this.currentNode.getVRMLNodeName() + " " + this.currentFieldIndex);
            }
            try {
                this.parseField(this.currentNode, this.currentFieldIndex, vRMLFieldDeclaration.getFieldType(), stringArray);
            }
            catch (FieldException fieldException) {
                fieldException.setFieldName(vRMLFieldDeclaration.getName());
                throw fieldException;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append("\n");
                }
                this.errorReporter.messageReport("Problem in PROTO: " + this.currentProto.getVRMLNodeName() + "  field: " + vRMLFieldDeclaration + "  value:   " + stringBuffer.toString());
                VRMLException vRMLException = new VRMLException("Internal error in parsing field: " + vRMLFieldDeclaration);
                vRMLException.initCause(exception);
                throw vRMLException;
            }
        }
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        VRMLNodeType vRMLNodeType;
        if (this.importProxyMap.containsKey(string)) {
            throw new InvalidFieldValueException("Line: " + this.locator.getLineNumber() + " Column: " + this.locator.getColumnNumber() + " Illegal to USE an IMPORTed node: " + string);
        }
        if (this.inProtoDecl) {
            vRMLNodeType = (VRMLNodeType)this.globalDefMap.get(string);
        } else {
            if (this.ignoreNodeCounter > 0 || this.ignoreDefSet.contains(string)) {
                return;
            }
            vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        }
        if (vRMLNodeType == null) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE declares an unknown source node DEF \"" + string + '\"');
        }
        if (this.inProtoDecl && this.topOfStack == 0) {
            if (this.currentProto.getPrimaryType() != 41) {
                if (vRMLNodeType instanceof VRMLBindableNodeType) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a bindable node \"" + string + '\"');
                }
                if (vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes()) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a grouping node that contains  bindable node(s).");
                }
            }
            ((VRMLProtoDeclare)((Object)this.currentProto)).addFieldNodeValue(this.currentFieldIndex, vRMLNodeType);
        } else {
            if (!(this.nodeStack[this.topOfStack] instanceof VRMLScriptNodeType)) {
                if (vRMLNodeType instanceof VRMLBindableNodeType) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a bindable node \"" + string + '\"');
                }
                if (vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes()) {
                    throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a grouping node that contains bindable node(s). \"" + string + '\"');
                }
            }
            this.nodeStack[this.topOfStack].setValue(this.currentFieldIndex, vRMLNodeType);
        }
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void fieldValue(int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, n);
    }

    public void fieldValue(int[] nArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, nArray, n);
    }

    public void fieldValue(boolean bl) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, bl);
    }

    public void fieldValue(boolean[] blArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, blArray, n);
    }

    public void fieldValue(float f) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, f);
    }

    public void fieldValue(float[] fArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, fArray, n);
    }

    public void fieldValue(long l) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, l);
    }

    public void fieldValue(long[] lArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, lArray, n);
    }

    public void fieldValue(double d) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, d);
    }

    public void fieldValue(double[] dArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, dArray, n);
    }

    public void fieldValue(String[] stringArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.inProtoDecl) {
            return;
        }
        this.currentNode.setValue(this.currentFieldIndex, stringArray, n);
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        if (this.inProtoDecl || this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), NESTED_PROTO_ERROR);
        }
        PrototypeDecl prototypeDecl = new PrototypeDecl(string, this.majorVersion, this.minorVersion, this.protoCreator);
        if (this.currentProto != null) {
            ((PrototypeDecl)this.currentProto).addPrototypeDecl(prototypeDecl);
        }
        this.protoMap.put(string, prototypeDecl);
        this.protoDeclStack.push(this.currentProto);
        this.currentProto = prototypeDecl;
        if (this.rootProto == null) {
            this.topOfStack = 0;
            this.rootProto = prototypeDecl;
        } else {
            ++this.topOfStack;
        }
        this.inProtoDecl = true;
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        this.inProtoDecl = false;
        --this.topOfStack;
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        int n2;
        if (!this.inProtoDecl && !this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "proto field declaration not in proto!");
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        this.currentFieldIndex = n2 = this.currentProto.appendField(vRMLFieldDeclaration);
        if (object != null && this.currentProto instanceof VRMLProtoDeclare) {
            VRMLProtoDeclare vRMLProtoDeclare = (VRMLProtoDeclare)((Object)this.currentProto);
            try {
                if (object instanceof String) {
                    this.parseField(vRMLProtoDeclare, n2, vRMLFieldDeclaration.getFieldType(), (String)object);
                } else {
                    this.parseField(vRMLProtoDeclare, n2, vRMLFieldDeclaration.getFieldType(), (String[])object);
                }
            }
            catch (FieldException fieldException) {
                fieldException.setFieldName(vRMLFieldDeclaration.getName());
                throw fieldException;
            }
        }
        this.childIndexStack[this.topOfStack] = n2;
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (!(this.currentProto instanceof PrototypeDecl)) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "proto IS declaration not in proto!");
        }
        ((PrototypeDecl)this.currentProto).addIS(string, this.currentNode, this.currentFieldIndex);
    }

    public void startProtoBody() throws SAVException, VRMLException {
        if (this.inProtoDecl || this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Starting proto body while still in declaration");
        }
        ++this.topOfStack;
        this.nodeStack[this.topOfStack] = this.currentNode = ((PrototypeDecl)this.currentProto).getBodyGroup();
        this.childIndexStack[this.topOfStack] = this.currentFieldIndex = this.currentNode.getFieldIndex("children");
        this.protoMapStack.push(this.protoMap);
        this.defMapStack.push(this.defMap);
        this.importMapStack.push(this.importProxyMap);
        this.exportMapStack.push(this.exportProxyMap);
        this.protoMap = new HashMap();
        this.defMap = new HashMap();
        this.exportProxyMap = new HashMap();
        this.importProxyMap = new HashMap();
        this.inProtoBody = true;
    }

    public void endProtoBody() throws SAVException, VRMLException {
        this.currentNode.setupFinished();
        PrototypeDecl prototypeDecl = (PrototypeDecl)this.currentProto;
        prototypeDecl.setDEFMap(this.defMap);
        this.currentProto = (AbstractProto)this.protoDeclStack.pop();
        this.nodeStack[this.topOfStack] = null;
        --this.topOfStack;
        if (this.topOfStack >= 0) {
            this.currentNode = this.nodeStack[this.topOfStack];
            this.currentFieldIndex = this.childIndexStack[this.topOfStack];
            this.protoMap = (HashMap)this.protoMapStack.pop();
            this.defMap = (HashMap)this.defMapStack.pop();
            this.importProxyMap = (HashMap)this.importMapStack.pop();
            this.exportProxyMap = (HashMap)this.exportMapStack.pop();
        } else {
            this.currentNode = null;
            this.currentFieldIndex = -1;
            this.inProtoBody = false;
            this.defMap = new HashMap();
            this.protoMap = new HashMap();
            this.importProxyMap = new HashMap();
            this.exportProxyMap = new HashMap();
        }
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        if (this.inProtoDecl || this.inExternProtoDecl) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), NESTED_PROTO_ERROR);
        }
        ExternalPrototypeDecl externalPrototypeDecl = new ExternalPrototypeDecl(string, this.majorVersion, this.minorVersion, this.protoCreator);
        this.externProtoMap.put(string, externalPrototypeDecl);
        this.currentProto = externalPrototypeDecl;
        this.rootProto = externalPrototypeDecl;
        this.topOfStack = 0;
        this.inExternProtoDecl = true;
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        this.inExternProtoDecl = false;
        this.inExternProtoURI = true;
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        if (!this.inExternProtoURI) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "EXTERNPROTO URI declaration not allowed here");
        }
        ((ExternalPrototypeDecl)this.currentProto).setUrl(stringArray, stringArray.length);
        this.currentProto = null;
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.currentNode;
        this.scriptStack.push(this.currentScript);
        this.inScript = true;
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.scriptStack.pop();
        if (this.currentScript == null) {
            this.inScript = false;
        }
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        boolean bl;
        if (!this.inScript) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Script declaration not in script!");
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        int n2 = this.currentScript.appendField(vRMLFieldDeclaration);
        int n3 = vRMLFieldDeclaration.getFieldType();
        boolean bl2 = bl = n3 == 11 || n3 == 12;
        if (!(bl || n != 2 && n != 3)) {
            try {
                if (object instanceof String) {
                    this.parseField((VRMLNodeType)this.currentScript, n2, vRMLFieldDeclaration.getFieldType(), (String)object);
                } else if (object instanceof String[]) {
                    this.parseField((VRMLNodeType)this.currentScript, n2, vRMLFieldDeclaration.getFieldType(), (String[])object);
                }
            }
            catch (FieldException fieldException) {
                fieldException.setFieldName(vRMLFieldDeclaration.getName());
                throw fieldException;
            }
        }
        this.currentFieldIndex = n2;
        this.childIndexStack[this.topOfStack] = n2;
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        int n;
        VRMLNodeType vRMLNodeType;
        if (this.ignoreDefSet.contains(string) || this.ignoreDefSet.contains(string3)) {
            return;
        }
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.defMap.get(string);
        boolean bl = false;
        if (vRMLNodeType2 == null) {
            if (this.majorVersion < 3 || !this.importProxyMap.containsKey(string)) {
                throw new InvalidFieldConnectionException("ROUTE declares an unknown source node DEF: " + string);
            }
            bl = true;
            vRMLNodeType2 = (VRMLNodeType)this.importProxyMap.get(string);
        }
        if ((vRMLNodeType = (VRMLNodeType)this.defMap.get(string3)) == null) {
            if (this.majorVersion < 3 || !this.importProxyMap.containsKey(string3)) {
                throw new InvalidFieldConnectionException("ROUTE declares an unknown destination node DEF: " + string3);
            }
            bl = true;
            vRMLNodeType = (VRMLNodeType)this.importProxyMap.get(string3);
        }
        if ((n = vRMLNodeType2.getFieldIndex(string2)) == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown source node field DEF: " + string + "." + string2);
        }
        int n2 = vRMLNodeType.getFieldIndex(string4);
        if (n2 == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown destination node field DEF: " + string3 + "." + string4);
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType2.getFieldDeclaration(n);
        VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(n2);
        if (!bl && vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType()) {
            throw new InvalidFieldConnectionException("The source field(" + string + "." + vRMLFieldDeclaration.getName() + ") type " + vRMLFieldDeclaration.getFieldTypeString() + " and destination field(" + string3 + "." + vRMLFieldDeclaration2.getName() + ") type " + vRMLFieldDeclaration2.getFieldTypeString() + " don't match");
        }
        ProtoROUTE protoROUTE = new ProtoROUTE(vRMLNodeType2, n, vRMLNodeType, n2);
        ((PrototypeDecl)this.currentProto).addRouteDecl(protoROUTE);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.nodeFactory.setErrorReporter(this.errorReporter);
    }

    public AbstractProto getPrototype() {
        return this.rootProto;
    }

    public void reset() {
        this.inScript = false;
        this.inProtoDecl = false;
        this.inProtoBody = false;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
        this.protoCreator = null;
        this.worldURL = null;
        this.dontLoadTypes.clear();
        this.ignoreDefSet.clear();
        this.defMap.clear();
        this.protoMap.clear();
        this.externProtoMap.clear();
        this.importProxyMap.clear();
        this.exportProxyMap.clear();
        this.protoDeclStack.clear();
        this.defMapStack.clear();
        this.protoMapStack.clear();
        this.importMapStack.clear();
        this.exportMapStack.clear();
    }

    public void setGlobals(Map map, Map map2, Map map3) {
        this.globalDefMap = map == null ? new HashMap() : map;
        this.globalProtoMap = map2 == null ? new HashMap() : map2;
        this.globalExternProtoMap = map3 == null ? new HashMap() : map3;
        this.init = true;
    }

    public void setLoadRequirements(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.isVrml97 = bl;
        if (!bl2) {
            this.dontLoadTypes.add(VRMLBackgroundNodeType.class);
        }
        if (!bl3) {
            this.dontLoadTypes.add(VRMLFogNodeType.class);
        }
        if (!bl4) {
            this.dontLoadTypes.add(VRMLLightNodeType.class);
        }
        if (!bl5) {
            this.dontLoadTypes.add(VRMLAudioClipNodeType.class);
        }
        if (!bl6) {
            this.dontLoadTypes.add(VRMLViewpointNodeType.class);
        }
        if (!bl7) {
            this.dontLoadTypes.add(VRMLInlineNodeType.class);
        }
    }

    public void newProto(NodeTemplateToInstanceCreator nodeTemplateToInstanceCreator) {
        this.protoCreator = nodeTemplateToInstanceCreator;
        this.rootProto = null;
        this.topOfStack = -1;
        this.currentFieldIndex = 0;
        this.inScript = false;
        this.inProtoDecl = false;
        this.inProtoBody = false;
        this.inExternProtoDecl = false;
        this.inExternProtoURI = false;
    }

    private final void resizeStack() {
        if (this.topOfStack + 1 == this.nodeStack.length) {
            int n = this.nodeStack.length;
            int n2 = n + 25;
            VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.nodeStack, 0, vRMLNodeTypeArray, 0, n);
            System.arraycopy(this.childIndexStack, 0, vRMLNodeTypeArray, 0, n);
            this.nodeStack = vRMLNodeTypeArray;
            this.childIndexStack = nArray;
        }
    }

    private void parseField(VRMLNodeType vRMLNodeType, int n, int n2, String string) {
        if (n2 != 27 && (string = string.trim()).length() == 0) {
            return;
        }
        switch (n2) {
            case 3: {
                vRMLNodeType.setValue(n, this.fieldParser.SFInt32(string));
                break;
            }
            case 4: {
                int[] nArray = this.fieldParser.MFInt32(string);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 5: {
                vRMLNodeType.setValue(n, this.fieldParser.SFFloat(string));
                break;
            }
            case 9: {
                vRMLNodeType.setValue(n, this.fieldParser.SFTime(string));
                break;
            }
            case 7: {
                vRMLNodeType.setValue(n, this.fieldParser.SFDouble(string));
                break;
            }
            case 10: {
                double[] dArray = this.fieldParser.MFTime(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 8: {
                double[] dArray = this.fieldParser.MFDouble(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 31: {
                vRMLNodeType.setValue(n, this.fieldParser.SFLong(string));
                break;
            }
            case 32: {
                long[] lArray = this.fieldParser.MFLong(string);
                vRMLNodeType.setValue(n, lArray, lArray.length);
                break;
            }
            case 1: {
                vRMLNodeType.setValue(n, this.fieldParser.SFBool(string));
                break;
            }
            case 19: {
                float[] fArray = this.fieldParser.SFRotation(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 20: {
                float[] fArray = this.fieldParser.MFRotation(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 2: {
                boolean[] blArray = this.fieldParser.MFBool(string);
                vRMLNodeType.setValue(n, blArray, blArray.length);
                break;
            }
            case 6: {
                float[] fArray = this.fieldParser.MFFloat(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 13: {
                float[] fArray = this.fieldParser.SFVec2f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 15: {
                float[] fArray = this.fieldParser.SFVec3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 33: {
                float[] fArray = this.fieldParser.SFVec4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 14: {
                float[] fArray = this.fieldParser.MFVec2f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 16: {
                float[] fArray = this.fieldParser.MFVec3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 34: {
                float[] fArray = this.fieldParser.MFVec4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 17: {
                double[] dArray = this.fieldParser.SFVec3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 35: {
                double[] dArray = this.fieldParser.SFVec4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 30: {
                double[] dArray = this.fieldParser.MFVec2d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 18: {
                double[] dArray = this.fieldParser.MFVec3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 36: {
                double[] dArray = this.fieldParser.MFVec4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 27: {
                vRMLNodeType.setValue(n, this.fieldParser.SFString(string));
                break;
            }
            case 28: {
                String[] stringArray = this.fieldParser.MFString(string);
                vRMLNodeType.setValue(n, stringArray, stringArray.length);
                break;
            }
            case 25: {
                int[] nArray = this.fieldParser.SFImage(string);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 26: {
                int[] nArray = this.fieldParser.MFImage(string);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 21: {
                float[] fArray = this.fieldParser.SFColor(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 22: {
                float[] fArray = this.fieldParser.MFColor(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 23: {
                float[] fArray = this.fieldParser.SFColorRGBA(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 24: {
                float[] fArray = this.fieldParser.MFColorRGBA(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 37: {
                float[] fArray = this.fieldParser.SFMatrix3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 39: {
                float[] fArray = this.fieldParser.SFMatrix4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 38: {
                float[] fArray = this.fieldParser.MFMatrix3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 40: {
                float[] fArray = this.fieldParser.MFMatrix4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 41: {
                double[] dArray = this.fieldParser.SFMatrix3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 43: {
                double[] dArray = this.fieldParser.SFMatrix4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 42: {
                double[] dArray = this.fieldParser.MFMatrix3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 44: {
                double[] dArray = this.fieldParser.MFMatrix4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type provided to ProtoBuilder in parseField(VRMLNodeType,int,int,String)! " + n2, null);
            }
        }
    }

    private void parseField(VRMLProtoDeclare vRMLProtoDeclare, int n, int n2, String string) {
        if (n2 != 27 && (string = string.trim()).length() == 0) {
            return;
        }
        switch (n2) {
            case 3: {
                vRMLProtoDeclare.setValue(n, this.fieldParser.SFInt32(string));
                break;
            }
            case 4: {
                int[] nArray = this.fieldParser.MFInt32(string);
                vRMLProtoDeclare.setValue(n, nArray, nArray.length);
                break;
            }
            case 5: {
                vRMLProtoDeclare.setValue(n, this.fieldParser.SFFloat(string));
                break;
            }
            case 9: {
                vRMLProtoDeclare.setValue(n, this.fieldParser.SFTime(string));
                break;
            }
            case 7: {
                vRMLProtoDeclare.setValue(n, this.fieldParser.SFDouble(string));
                break;
            }
            case 10: {
                double[] dArray = this.fieldParser.MFTime(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 8: {
                double[] dArray = this.fieldParser.MFDouble(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 31: {
                vRMLProtoDeclare.setValue(n, this.fieldParser.SFLong(string));
                break;
            }
            case 32: {
                long[] lArray = this.fieldParser.MFLong(string);
                vRMLProtoDeclare.setValue(n, lArray, lArray.length);
                break;
            }
            case 1: {
                vRMLProtoDeclare.setValue(n, this.fieldParser.SFBool(string));
                break;
            }
            case 19: {
                float[] fArray = this.fieldParser.SFRotation(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 20: {
                float[] fArray = this.fieldParser.MFRotation(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 2: {
                boolean[] blArray = this.fieldParser.MFBool(string);
                vRMLProtoDeclare.setValue(n, blArray, blArray.length);
                break;
            }
            case 6: {
                float[] fArray = this.fieldParser.MFFloat(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 13: {
                float[] fArray = this.fieldParser.SFVec2f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 15: {
                float[] fArray = this.fieldParser.SFVec3f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 21: {
                float[] fArray = this.fieldParser.SFColor(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 14: {
                float[] fArray = this.fieldParser.MFVec2f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 16: {
                float[] fArray = this.fieldParser.MFVec3f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 22: {
                float[] fArray = this.fieldParser.MFColor(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 17: {
                double[] dArray = this.fieldParser.SFVec3d(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 30: {
                double[] dArray = this.fieldParser.MFVec2d(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 18: {
                double[] dArray = this.fieldParser.MFVec3d(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 27: {
                if (string.length() <= 0) break;
                vRMLProtoDeclare.setValue(n, this.fieldParser.SFString(string));
                break;
            }
            case 28: {
                if (string.length() <= 0) break;
                String[] stringArray = this.fieldParser.MFString(string);
                vRMLProtoDeclare.setValue(n, stringArray, stringArray.length);
                break;
            }
            case 25: {
                int[] nArray = this.fieldParser.SFImage(string);
                vRMLProtoDeclare.setValue(n, nArray, nArray.length);
                break;
            }
            case 26: {
                int[] nArray = this.fieldParser.MFImage(string);
                vRMLProtoDeclare.setValue(n, nArray, nArray.length);
                break;
            }
            case 23: {
                float[] fArray = this.fieldParser.SFColorRGBA(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 24: {
                float[] fArray = this.fieldParser.MFColorRGBA(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 37: {
                float[] fArray = this.fieldParser.SFMatrix3f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 39: {
                float[] fArray = this.fieldParser.SFMatrix4f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 38: {
                float[] fArray = this.fieldParser.MFMatrix3f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 40: {
                float[] fArray = this.fieldParser.MFMatrix4f(string);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 41: {
                double[] dArray = this.fieldParser.SFMatrix3d(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 43: {
                double[] dArray = this.fieldParser.SFMatrix4d(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 42: {
                double[] dArray = this.fieldParser.MFMatrix3d(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 44: {
                double[] dArray = this.fieldParser.MFMatrix4d(string);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type provided to ProtoBuilder in parseField(VRMLProtoDeclare,int,int,String)! " + n2, null);
            }
        }
    }

    private void parseField(VRMLNodeType vRMLNodeType, int n, int n2, String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 27: 
            case 31: {
                this.errorReporter.warningReport("Field not parsable as String[]. " + vRMLNodeType.getVRMLNodeName() + " index: " + n + " val: " + stringArray[0], null);
                break;
            }
            case 4: {
                int[] nArray = this.fieldParser.MFInt32(stringArray);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 10: {
                double[] dArray = this.fieldParser.MFTime(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 8: {
                double[] dArray = this.fieldParser.MFDouble(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 32: {
                long[] lArray = this.fieldParser.MFLong(stringArray);
                vRMLNodeType.setValue(n, lArray, lArray.length);
                break;
            }
            case 19: {
                float[] fArray = this.fieldParser.SFRotation(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 20: {
                float[] fArray = this.fieldParser.MFRotation(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 2: {
                boolean[] blArray = this.fieldParser.MFBool(stringArray);
                vRMLNodeType.setValue(n, blArray, blArray.length);
                break;
            }
            case 6: {
                float[] fArray = this.fieldParser.MFFloat(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 13: {
                float[] fArray = this.fieldParser.SFVec2f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 15: {
                float[] fArray = this.fieldParser.SFVec3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 33: {
                float[] fArray = this.fieldParser.SFVec4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 14: {
                float[] fArray = this.fieldParser.MFVec2f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 16: {
                float[] fArray = this.fieldParser.MFVec3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 34: {
                float[] fArray = this.fieldParser.MFVec4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 17: {
                double[] dArray = this.fieldParser.SFVec3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 35: {
                double[] dArray = this.fieldParser.SFVec4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 30: {
                double[] dArray = this.fieldParser.MFVec2d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 18: {
                double[] dArray = this.fieldParser.MFVec3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 36: {
                double[] dArray = this.fieldParser.MFVec4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 28: {
                String[] stringArray2 = this.fieldParser.MFString(stringArray);
                vRMLNodeType.setValue(n, stringArray2, stringArray2.length);
                break;
            }
            case 25: {
                int[] nArray = this.fieldParser.SFImage(stringArray);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 26: {
                int[] nArray = this.fieldParser.MFImage(stringArray);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 21: {
                float[] fArray = this.fieldParser.SFColor(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 22: {
                float[] fArray = this.fieldParser.MFColor(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 23: {
                float[] fArray = this.fieldParser.SFColorRGBA(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 24: {
                float[] fArray = this.fieldParser.MFColorRGBA(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 37: {
                float[] fArray = this.fieldParser.SFMatrix3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 39: {
                float[] fArray = this.fieldParser.SFMatrix4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 38: {
                float[] fArray = this.fieldParser.MFMatrix3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 40: {
                float[] fArray = this.fieldParser.MFMatrix4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 41: {
                double[] dArray = this.fieldParser.SFMatrix3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 43: {
                double[] dArray = this.fieldParser.SFMatrix4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 42: {
                double[] dArray = this.fieldParser.MFMatrix3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 44: {
                double[] dArray = this.fieldParser.MFMatrix4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type provided to ProtoBuilder in parseField(VRMLNodeType,int,int,String[])! " + n2, null);
            }
        }
    }

    private void parseField(VRMLProtoDeclare vRMLProtoDeclare, int n, int n2, String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 27: 
            case 31: {
                this.errorReporter.warningReport("Field not parsable as String[]. " + vRMLProtoDeclare.getVRMLNodeName() + " index: " + n + " val: " + stringArray[0], null);
                break;
            }
            case 4: {
                int[] nArray = this.fieldParser.MFInt32(stringArray);
                vRMLProtoDeclare.setValue(n, nArray, nArray.length);
                break;
            }
            case 10: {
                double[] dArray = this.fieldParser.MFTime(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 8: {
                double[] dArray = this.fieldParser.MFDouble(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 32: {
                long[] lArray = this.fieldParser.MFLong(stringArray);
                vRMLProtoDeclare.setValue(n, lArray, lArray.length);
                break;
            }
            case 19: {
                float[] fArray = this.fieldParser.SFRotation(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 20: {
                float[] fArray = this.fieldParser.MFRotation(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 2: {
                boolean[] blArray = this.fieldParser.MFBool(stringArray);
                vRMLProtoDeclare.setValue(n, blArray, blArray.length);
                break;
            }
            case 6: {
                float[] fArray = this.fieldParser.MFFloat(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 13: {
                float[] fArray = this.fieldParser.SFVec2f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 15: {
                float[] fArray = this.fieldParser.SFVec3f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 33: {
                float[] fArray = this.fieldParser.SFVec4f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 14: {
                float[] fArray = this.fieldParser.MFVec2f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 16: {
                float[] fArray = this.fieldParser.MFVec3f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 34: {
                float[] fArray = this.fieldParser.MFVec4f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 17: {
                double[] dArray = this.fieldParser.SFVec3d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 35: {
                double[] dArray = this.fieldParser.SFVec4d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 36: {
                double[] dArray = this.fieldParser.MFVec4d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 18: {
                double[] dArray = this.fieldParser.MFVec3d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 30: {
                double[] dArray = this.fieldParser.MFVec2d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 28: {
                String[] stringArray2 = this.fieldParser.MFString(stringArray);
                vRMLProtoDeclare.setValue(n, stringArray2, stringArray2.length);
                break;
            }
            case 25: {
                int[] nArray = this.fieldParser.SFImage(stringArray);
                vRMLProtoDeclare.setValue(n, nArray, nArray.length);
                break;
            }
            case 26: {
                int[] nArray = this.fieldParser.MFImage(stringArray);
                vRMLProtoDeclare.setValue(n, nArray, nArray.length);
                break;
            }
            case 21: {
                float[] fArray = this.fieldParser.SFColor(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 22: {
                float[] fArray = this.fieldParser.MFColor(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 23: {
                float[] fArray = this.fieldParser.SFColorRGBA(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 24: {
                float[] fArray = this.fieldParser.MFColorRGBA(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 37: {
                float[] fArray = this.fieldParser.SFMatrix3f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 39: {
                float[] fArray = this.fieldParser.SFMatrix4f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 38: {
                float[] fArray = this.fieldParser.MFMatrix3f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 40: {
                float[] fArray = this.fieldParser.MFMatrix4f(stringArray);
                vRMLProtoDeclare.setValue(n, fArray, fArray.length);
                break;
            }
            case 41: {
                double[] dArray = this.fieldParser.SFMatrix3d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 43: {
                double[] dArray = this.fieldParser.SFMatrix4d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 42: {
                double[] dArray = this.fieldParser.MFMatrix3d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 44: {
                double[] dArray = this.fieldParser.MFMatrix4d(stringArray);
                vRMLProtoDeclare.setValue(n, dArray, dArray.length);
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type provided to ProtoBuilder in parseField(VRMLProtoDeclar,int,int,String[])! " + n2, null);
            }
        }
    }
}

