/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes;

import java.util.List;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.SceneGraphTraversalDetailObserver;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometricPropertyNodeType;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLMaterialNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.nodes.VRMLSoundNodeType;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureTransformNodeType;

public class SceneGraphTraverser {
    private boolean inUse = false;
    private HashSet usedNodes = new HashSet();
    private SceneGraphTraversalDetailObserver detailObs;
    private SceneGraphTraversalSimpleObserver simpleObs;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void setObserver(SceneGraphTraversalDetailObserver sceneGraphTraversalDetailObserver) {
        this.simpleObs = null;
        this.detailObs = sceneGraphTraversalDetailObserver;
    }

    public void setObserver(SceneGraphTraversalSimpleObserver sceneGraphTraversalSimpleObserver) {
        this.detailObs = null;
        this.simpleObs = sceneGraphTraversalSimpleObserver;
    }

    public void traverseGraph(VRMLNode vRMLNode) throws IllegalStateException {
        this.traverseGraph(null, vRMLNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverseGraph(VRMLNode vRMLNode, VRMLNode vRMLNode2) throws IllegalStateException {
        if (this.inUse) {
            throw new IllegalStateException("Currently traversing");
        }
        if (this.detailObs == null && this.simpleObs == null || vRMLNode2 == null) {
            return;
        }
        this.inUse = true;
        try {
            if (this.simpleObs != null) {
                this.processSimpleNode((VRMLNodeType)vRMLNode, -1, (VRMLNodeType)vRMLNode2);
            } else {
                this.recurseDetailSceneGraph((VRMLNodeType)vRMLNode, -1, (VRMLNodeType)vRMLNode2);
            }
        }
        finally {
            this.inUse = false;
        }
    }

    public void reset() {
        this.usedNodes.clear();
    }

    private void recurseSimpleSceneGraphChild(VRMLNodeType vRMLNodeType) {
        int[] nArray = vRMLNodeType.getNodeFieldIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length == 1) {
            try {
                VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(nArray[0]);
                if (vRMLFieldData.dataType == 13) {
                    for (int i = 0; i < vRMLFieldData.numElements; ++i) {
                        if (vRMLFieldData.nodeArrayValue[i] == null) continue;
                        this.processSimpleNode(vRMLNodeType, nArray[0], (VRMLNodeType)vRMLFieldData.nodeArrayValue[i]);
                    }
                } else if (vRMLFieldData.nodeValue != null) {
                    this.processSimpleNode(vRMLNodeType, nArray[0], (VRMLNodeType)vRMLFieldData.nodeValue);
                }
            }
            catch (InvalidFieldException invalidFieldException) {}
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                VRMLFieldData vRMLFieldData;
                try {
                    vRMLFieldData = vRMLNodeType.getFieldValue(nArray[i]);
                }
                catch (InvalidFieldException invalidFieldException) {
                    continue;
                }
                if (vRMLFieldData.dataType == 13) {
                    for (int j = 0; j < vRMLFieldData.numElements; ++j) {
                        if (vRMLFieldData.nodeArrayValue[j] == null) continue;
                        this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeArrayValue[j]);
                    }
                    continue;
                }
                if (vRMLFieldData.nodeValue == null) continue;
                this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeValue);
            }
        }
    }

    private void processSimpleNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2) {
        boolean bl = this.usedNodes.contains(vRMLNodeType2);
        if (!bl) {
            this.usedNodes.add(vRMLNodeType2);
        }
        try {
            this.simpleObs.observedNode(vRMLNodeType, vRMLNodeType2, n, bl);
        }
        catch (Exception exception) {
            this.errorReporter.warningReport("Traversal error ", exception);
        }
        this.recurseSimpleSceneGraphChild(vRMLNodeType2);
    }

    private void recurseDetailSceneGraph(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2) {
        int n2 = vRMLNodeType2.getPrimaryType();
        boolean bl = this.usedNodes.contains(vRMLNodeType2);
        if (!bl) {
            this.usedNodes.add(vRMLNodeType2);
        }
        switch (n2) {
            case 22: {
                VRMLGroupingNodeType vRMLGroupingNodeType = (VRMLGroupingNodeType)vRMLNodeType2;
                try {
                    this.detailObs.groupingNode((VRMLGroupingNodeType)vRMLNodeType, vRMLGroupingNodeType, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                if (bl) break;
                VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
                int n3 = vRMLGroupingNodeType.getFieldIndex("children");
                for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                    this.recurseDetailSceneGraph(vRMLGroupingNodeType, n3, vRMLNodeTypeArray[i]);
                }
                break;
            }
            case 43: {
                VRMLShapeNodeType vRMLShapeNodeType = (VRMLShapeNodeType)vRMLNodeType2;
                try {
                    this.detailObs.shapeNode((VRMLGroupingNodeType)vRMLNodeType, vRMLShapeNodeType, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                if (bl) break;
                VRMLNodeType vRMLNodeType3 = vRMLShapeNodeType.getAppearance();
                if (vRMLNodeType3 != null) {
                    this.recurseDetailSceneGraph(vRMLShapeNodeType, -1, vRMLNodeType3);
                }
                if ((vRMLNodeType3 = vRMLShapeNodeType.getGeometry()) == null) break;
                this.recurseDetailSceneGraph(vRMLShapeNodeType, -1, vRMLNodeType3);
                break;
            }
            case 2: {
                VRMLAppearanceNodeType vRMLAppearanceNodeType = (VRMLAppearanceNodeType)vRMLNodeType2;
                try {
                    this.detailObs.appearanceNode((VRMLShapeNodeType)vRMLNodeType, vRMLAppearanceNodeType, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                if (bl) break;
                VRMLNodeType vRMLNodeType4 = vRMLAppearanceNodeType.getMaterial();
                if (vRMLNodeType4 != null) {
                    this.recurseDetailSceneGraph(vRMLAppearanceNodeType, -1, vRMLNodeType4);
                }
                if ((vRMLNodeType4 = vRMLAppearanceNodeType.getTexture()) != null) {
                    this.recurseDetailSceneGraph(vRMLAppearanceNodeType, -1, vRMLNodeType4);
                }
                if ((vRMLNodeType4 = vRMLAppearanceNodeType.getTextureTransform()) == null) break;
                this.recurseDetailSceneGraph(vRMLAppearanceNodeType, -1, vRMLNodeType4);
                break;
            }
            case 45: {
                VRMLAudioClipNodeType vRMLAudioClipNodeType;
                VRMLSoundNodeType vRMLSoundNodeType = (VRMLSoundNodeType)vRMLNodeType2;
                try {
                    this.detailObs.soundNode((VRMLGroupingNodeType)vRMLNodeType, vRMLSoundNodeType, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                if (bl || (vRMLAudioClipNodeType = vRMLSoundNodeType.getSource()) == null) break;
                this.recurseDetailSceneGraph(vRMLSoundNodeType, -1, vRMLAudioClipNodeType);
                break;
            }
            case 29: {
                try {
                    this.detailObs.materialNode((VRMLAppearanceNodeType)vRMLNodeType, (VRMLMaterialNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 50: {
                try {
                    this.detailObs.textureNode((VRMLAppearanceNodeType)vRMLNodeType, (VRMLTextureNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 51: {
                try {
                    this.detailObs.textureTransformNode((VRMLAppearanceNodeType)vRMLNodeType, (VRMLTextureTransformNodeType)vRMLNodeType2, false);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 21: 
            case 58: {
                try {
                    this.detailObs.geometryNode((VRMLShapeNodeType)vRMLNodeType, (VRMLGeometryNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                if (n2 != 58) break;
                VRMLNodeType[] vRMLNodeTypeArray = ((VRMLComponentGeometryNodeType)vRMLNodeType2).getComponents();
                for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                    this.recurseDetailSceneGraph(vRMLNodeType2, -1, vRMLNodeTypeArray[i]);
                }
                break;
            }
            case 9: 
            case 11: 
            case 34: 
            case 48: {
                try {
                    this.detailObs.geometricPropertyNode((VRMLComponentGeometryNodeType)vRMLNodeType, (VRMLGeometricPropertyNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 3: {
                try {
                    this.detailObs.audioClipNode((VRMLSoundNodeType)vRMLNodeType, (VRMLAudioClipNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 25: {
                try {
                    this.detailObs.interpolatorNode((VRMLGroupingNodeType)vRMLNodeType, (VRMLInterpolatorNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 13: 
            case 14: 
            case 26: 
            case 36: 
            case 42: 
            case 78: {
                try {
                    this.detailObs.sensorNode((VRMLGroupingNodeType)vRMLNodeType, (VRMLSensorNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 24: {
                try {
                    this.detailObs.inlineNode((VRMLGroupingNodeType)vRMLNodeType, (VRMLInlineNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 27: {
                try {
                    this.detailObs.lightNode((VRMLGroupingNodeType)vRMLNodeType, (VRMLLightNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 31: 
            case 55: {
                try {
                    this.detailObs.bindableNode((VRMLGroupingNodeType)vRMLNodeType, (VRMLBindableNodeType)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                break;
            }
            case 41: {
                VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)vRMLNodeType2;
                try {
                    this.detailObs.scriptNode((VRMLGroupingNodeType)vRMLNodeType, vRMLScriptNodeType, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                if (bl) break;
                List list = vRMLScriptNodeType.getAllFields();
                this.processFieldList(vRMLScriptNodeType, list);
                break;
            }
            case 38: {
                try {
                    this.detailObs.protoNode(vRMLNodeType, (VRMLProtoInstance)vRMLNodeType2, bl);
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
                if (bl) break;
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
                List list = vRMLProtoInstance.getAllFields();
                this.processFieldList(vRMLProtoInstance, list);
                break;
            }
            default: {
                try {
                    this.detailObs.miscellaneousNode(vRMLNodeType, n, vRMLNodeType2, bl);
                    break;
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport("Traversal error ", exception);
                }
            }
        }
    }

    private void recurseDetailSceneGraphInternal(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2) {
        if (vRMLNodeType2 == null) {
            return;
        }
        int n2 = vRMLNodeType2.getPrimaryType();
        boolean bl = this.usedNodes.contains(vRMLNodeType2);
        if (!bl) {
            this.usedNodes.add(vRMLNodeType2);
        }
        try {
            this.detailObs.customNode(vRMLNodeType, n, vRMLNodeType2, bl);
        }
        catch (Exception exception) {
            this.errorReporter.warningReport("Traversal error ", exception);
        }
        if (bl) {
            return;
        }
        switch (n2) {
            case 22: {
                VRMLGroupingNodeType vRMLGroupingNodeType = (VRMLGroupingNodeType)vRMLNodeType2;
                VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
                int n3 = vRMLGroupingNodeType.getFieldIndex("children");
                for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                    this.recurseDetailSceneGraph(vRMLGroupingNodeType, n3, vRMLNodeTypeArray[i]);
                }
                break;
            }
            case 43: {
                VRMLShapeNodeType vRMLShapeNodeType = (VRMLShapeNodeType)vRMLNodeType2;
                VRMLNodeType vRMLNodeType3 = vRMLShapeNodeType.getAppearance();
                if (vRMLNodeType3 != null) {
                    this.recurseDetailSceneGraph(vRMLShapeNodeType, -1, vRMLNodeType3);
                }
                if ((vRMLNodeType3 = vRMLShapeNodeType.getGeometry()) == null) break;
                this.recurseDetailSceneGraph(vRMLShapeNodeType, -1, vRMLNodeType3);
                break;
            }
            case 2: {
                VRMLAppearanceNodeType vRMLAppearanceNodeType = (VRMLAppearanceNodeType)vRMLNodeType2;
                VRMLNodeType vRMLNodeType4 = vRMLAppearanceNodeType.getMaterial();
                if (vRMLNodeType4 != null) {
                    this.recurseDetailSceneGraph(vRMLAppearanceNodeType, -1, vRMLNodeType4);
                }
                if ((vRMLNodeType4 = vRMLAppearanceNodeType.getTexture()) != null) {
                    this.recurseDetailSceneGraph(vRMLAppearanceNodeType, -1, vRMLNodeType4);
                }
                if ((vRMLNodeType4 = vRMLAppearanceNodeType.getTextureTransform()) == null) break;
                this.recurseDetailSceneGraph(vRMLAppearanceNodeType, -1, vRMLNodeType4);
                break;
            }
            case 45: {
                VRMLSoundNodeType vRMLSoundNodeType = (VRMLSoundNodeType)vRMLNodeType2;
                VRMLAudioClipNodeType vRMLAudioClipNodeType = vRMLSoundNodeType.getSource();
                if (vRMLAudioClipNodeType == null) break;
                this.recurseDetailSceneGraph(vRMLSoundNodeType, -1, vRMLAudioClipNodeType);
                break;
            }
            case 41: {
                VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)vRMLNodeType2;
                List list = vRMLScriptNodeType.getAllFields();
                this.processFieldList(vRMLScriptNodeType, list);
                break;
            }
            case 38: {
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
                List list = vRMLProtoInstance.getAllFields();
                this.processFieldList(vRMLProtoInstance, list);
                break;
            }
        }
    }

    private void processFieldList(VRMLNodeType vRMLNodeType, List list) {
        for (VRMLFieldDeclaration vRMLFieldDeclaration : list) {
            VRMLFieldData vRMLFieldData;
            int n;
            int n2 = vRMLFieldDeclaration.getFieldType();
            if (n2 != 11 && n2 != 12 || (n = vRMLFieldDeclaration.getAccessType()) == 1 || n == 4) continue;
            int n3 = vRMLNodeType.getFieldIndex(vRMLFieldDeclaration.getName());
            try {
                vRMLFieldData = vRMLNodeType.getFieldValue(n3);
            }
            catch (InvalidFieldException invalidFieldException) {
                this.errorReporter.warningReport("Traverser can't find field data", null);
                continue;
            }
            if (vRMLFieldData == null) {
                this.errorReporter.warningReport("Traverser can't find field data", null);
                continue;
            }
            if (vRMLFieldData.dataType == 7) {
                this.recurseDetailSceneGraphInternal(vRMLNodeType, n3, (VRMLNodeType)vRMLFieldData.nodeValue);
                continue;
            }
            for (int i = 0; i < vRMLFieldData.numElements; ++i) {
                VRMLNodeType vRMLNodeType2 = (VRMLNodeType)vRMLFieldData.nodeArrayValue[i];
                this.recurseDetailSceneGraphInternal(vRMLNodeType, n3, vRMLNodeType2);
            }
        }
    }
}

