/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.lang;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldTypeException;

public class VRMLFieldDeclaration {
    public static final String UNKNOWN_IMPORT = "UnknownImportedField";
    private static final HashMap fieldTypeMap = new HashMap();
    private String name;
    private int access;
    private int type;
    private String typeString;

    public VRMLFieldDeclaration(int n, String string, String string2) throws InvalidFieldTypeException {
        this.name = string2;
        this.access = n;
        this.typeString = string;
        Integer n2 = (Integer)fieldTypeMap.get(string);
        if (n2 == null) {
            throw new InvalidFieldTypeException("Unknown Type: " + string);
        }
        this.type = n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VRMLFieldDeclaration)) {
            return false;
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)object;
        return this.access == vRMLFieldDeclaration.access && this.type == vRMLFieldDeclaration.type && this.name.equals(vRMLFieldDeclaration.name);
    }

    public String toString() {
        return this.toString(false);
    }

    public String getName() {
        return this.name;
    }

    public int getAccessType() {
        return this.access;
    }

    public int getFieldType() {
        return this.type;
    }

    public int getFieldSize() {
        int n;
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                n = 1;
                break;
            }
            case 25: 
            case 26: {
                n = 1;
                break;
            }
            case 13: 
            case 14: 
            case 30: {
                n = 2;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                n = 3;
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n = 4;
                break;
            }
            case 37: 
            case 38: 
            case 41: 
            case 42: {
                n = 9;
                break;
            }
            case 39: 
            case 40: 
            case 43: 
            case 44: {
                n = 16;
                break;
            }
            case -1: {
                n = 0;
                break;
            }
            default: {
                System.out.println("Unhandled field type in VRMLFieldDeclaration.getFieldSize");
                n = 1;
            }
        }
        return n;
    }

    public String getFieldTypeString() {
        return this.typeString;
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(VRMLFieldDeclaration.toAccessTypeString(this.access, bl));
        stringBuffer.append(this.typeString);
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public static String toAccessTypeString(int n, boolean bl) {
        String string = null;
        if (bl) {
            switch (n) {
                case 1: {
                    string = "eventIn ";
                    break;
                }
                case 4: {
                    string = "eventOut ";
                    break;
                }
                case 2: {
                    string = "field ";
                    break;
                }
                case 3: {
                    string = "exposedField ";
                    break;
                }
                case -1: {
                    string = "invalidVRMLType ";
                }
            }
        } else {
            switch (n) {
                case 1: {
                    string = "inputOnly ";
                    break;
                }
                case 4: {
                    string = "outputOnly ";
                    break;
                }
                case 2: {
                    string = "initializeOnly ";
                    break;
                }
                case 3: {
                    string = "inputOutput ";
                    break;
                }
                case -1: {
                    string = "unknownFromIMPORT ";
                }
            }
        }
        return string;
    }

    static {
        fieldTypeMap.put("SFInt32", new Integer(3));
        fieldTypeMap.put("MFInt32", new Integer(4));
        fieldTypeMap.put("SFFloat", new Integer(5));
        fieldTypeMap.put("MFFloat", new Integer(6));
        fieldTypeMap.put("SFDouble", new Integer(7));
        fieldTypeMap.put("MFDouble", new Integer(8));
        fieldTypeMap.put("SFLong", new Integer(31));
        fieldTypeMap.put("MFLong", new Integer(32));
        fieldTypeMap.put("SFBool", new Integer(1));
        fieldTypeMap.put("MFBool", new Integer(2));
        fieldTypeMap.put("SFVec2f", new Integer(13));
        fieldTypeMap.put("MFVec2f", new Integer(14));
        fieldTypeMap.put("SFVec2d", new Integer(29));
        fieldTypeMap.put("MFVec2d", new Integer(30));
        fieldTypeMap.put("SFVec3f", new Integer(15));
        fieldTypeMap.put("MFVec3f", new Integer(16));
        fieldTypeMap.put("SFVec3d", new Integer(17));
        fieldTypeMap.put("MFVec3d", new Integer(18));
        fieldTypeMap.put("SFVec4f", new Integer(33));
        fieldTypeMap.put("MFVec4f", new Integer(34));
        fieldTypeMap.put("SFVec4d", new Integer(35));
        fieldTypeMap.put("MFVec4d", new Integer(36));
        fieldTypeMap.put("SFImage", new Integer(25));
        fieldTypeMap.put("MFImage", new Integer(26));
        fieldTypeMap.put("SFTime", new Integer(9));
        fieldTypeMap.put("MFTime", new Integer(10));
        fieldTypeMap.put("SFNode", new Integer(11));
        fieldTypeMap.put("MFNode", new Integer(12));
        fieldTypeMap.put("SFString", new Integer(27));
        fieldTypeMap.put("MFString", new Integer(28));
        fieldTypeMap.put("SFRotation", new Integer(19));
        fieldTypeMap.put("MFRotation", new Integer(20));
        fieldTypeMap.put("SFColor", new Integer(21));
        fieldTypeMap.put("MFColor", new Integer(22));
        fieldTypeMap.put("SFColorRGBA", new Integer(23));
        fieldTypeMap.put("MFColorRGBA", new Integer(24));
        fieldTypeMap.put("SFMatrix3f", new Integer(37));
        fieldTypeMap.put("MFMatrix3f", new Integer(38));
        fieldTypeMap.put("SFMatrix3d", new Integer(41));
        fieldTypeMap.put("MFMatrix3d", new Integer(42));
        fieldTypeMap.put("SFMatrix4f", new Integer(39));
        fieldTypeMap.put("MFMatrix4f", new Integer(40));
        fieldTypeMap.put("SFMatrix4d", new Integer(43));
        fieldTypeMap.put("MFMatrix4d", new Integer(44));
        fieldTypeMap.put(UNKNOWN_IMPORT, new Integer(-1));
    }
}

