/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.util.EmptyStackException;

public class SimpleStack {
    private static final int STACK_START_SIZE = 20;
    private static final int STACK_INCREMENT = 5;
    private Object[] stackContents;
    private int topOfStack;

    public SimpleStack() {
        this(20);
    }

    public SimpleStack(int n) {
        this.stackContents = new Object[n];
        this.topOfStack = -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SimpleStack { size ");
        stringBuffer.append(this.topOfStack);
        stringBuffer.append("\n");
        for (int i = this.topOfStack; i >= 0; --i) {
            stringBuffer.append(' ');
            stringBuffer.append(i);
            stringBuffer.append(": ");
            if (this.stackContents[i] == null) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(this.stackContents[i].getClass());
                stringBuffer.append("#");
                stringBuffer.append(this.stackContents[i].hashCode());
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int size() {
        return this.topOfStack + 1;
    }

    public boolean isEmpty() {
        return this.topOfStack == -1;
    }

    public void push(Object object) {
        this.resizeStack();
        ++this.topOfStack;
        this.stackContents[this.topOfStack] = object;
    }

    public Object peek() throws EmptyStackException {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        return this.stackContents[this.topOfStack];
    }

    public Object pop() {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        Object object = this.stackContents[this.topOfStack];
        this.stackContents[this.topOfStack] = null;
        --this.topOfStack;
        return object;
    }

    public boolean contains(Object object) {
        boolean bl = false;
        for (int i = this.topOfStack; i >= 0; --i) {
            if (this.stackContents[i] == object) {
                bl = true;
                break;
            }
            if (!this.stackContents[i].equals(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void remove(Object object) {
        int n;
        int n2 = -1;
        for (n = this.topOfStack; n >= 0; --n) {
            if (this.stackContents[n] == object) {
                n2 = n;
                break;
            }
            if (!this.stackContents[n].equals(object)) continue;
            n2 = n;
            break;
        }
        if (n2 != -1) {
            n = this.topOfStack - n2;
            if (n != 0) {
                System.arraycopy(this.stackContents, n2 + 1, this.stackContents, n2, n);
            }
            this.stackContents[this.topOfStack] = null;
            --this.topOfStack;
        }
    }

    public void clear() {
        for (int i = this.topOfStack; i >= 0; --i) {
            this.stackContents[i] = null;
        }
        this.topOfStack = -1;
    }

    private final void resizeStack() {
        int n = this.stackContents.length;
        if (this.topOfStack + 1 == n) {
            int n2 = n + 5;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.stackContents, 0, objectArray, 0, n);
            this.stackContents = objectArray;
        }
    }
}

