/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.image;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.image.ScaleFilter;

public class AreaAveragingScaleFilter
implements ScaleFilter {
    private int srcWidth;
    private int srcHeight;
    private NIOBufferImageType srcType;
    private boolean srcIsGrayScale;
    private int srcCmp;
    private ByteBuffer srcBuffer;
    private static Class scale_filter_class;
    private static Constructor scale_filter_constructor;
    private static Method scale_image_method;
    private static boolean hasNativeLib;
    private float[] red;
    private float[] green;
    private float[] blue;
    private float[] alpha;
    private float srcPixelCount;

    public AreaAveragingScaleFilter(NIOBufferImage nIOBufferImage) {
        if (nIOBufferImage == null) {
            throw new NullPointerException("AreaAveragingScaleFilter: Argument image must be non-null");
        }
        this.srcWidth = nIOBufferImage.getWidth();
        this.srcHeight = nIOBufferImage.getHeight();
        this.srcType = nIOBufferImage.getType();
        this.srcCmp = this.srcType.size;
        this.srcIsGrayScale = nIOBufferImage.isGrayScale();
        this.srcBuffer = nIOBufferImage.getBuffer();
        this.srcPixelCount = (float)this.srcWidth * (float)this.srcHeight;
    }

    public NIOBufferImage getScaledImage(int n, int n2) {
        NIOBufferImage nIOBufferImage = null;
        if (hasNativeLib) {
            try {
                Object t = scale_filter_constructor.newInstance("AreaAverage");
                ByteBuffer byteBuffer = (ByteBuffer)scale_image_method.invoke(t, this.srcWidth, this.srcHeight, this.srcCmp, this.srcBuffer, n, n2);
                nIOBufferImage = new NIOBufferImage(n, n2, this.srcType, this.srcIsGrayScale, byteBuffer);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * this.srcCmp);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.srcBuffer.rewind();
            switch (this.srcCmp) {
                case 4: {
                    this.fillFourCompBuffer(n, n2, this.srcBuffer, byteBuffer);
                    break;
                }
                case 3: {
                    this.fillThreeCompBuffer(n, n2, this.srcBuffer, byteBuffer);
                    break;
                }
                case 2: {
                    this.fillTwoCompBuffer(n, n2, this.srcBuffer, byteBuffer);
                    break;
                }
                case 1: {
                    this.fillOneCompBuffer(n, n2, this.srcBuffer, byteBuffer);
                }
            }
            nIOBufferImage = new NIOBufferImage(n, n2, this.srcType, this.srcIsGrayScale, byteBuffer);
        }
        return nIOBufferImage;
    }

    private void fillFourCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        this.green = new float[n];
        this.blue = new float[n];
        this.alpha = new float[n];
        byte[] byArray = new byte[n * this.srcCmp];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < this.srcHeight) {
            int n8;
            if (n6 == 0) {
                for (n8 = 0; n8 < n; ++n8) {
                    this.blue[n8] = 0.0f;
                    this.green[n8] = 0.0f;
                    this.red[n8] = 0.0f;
                    this.alpha[n8] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n9 = n4 < n6 ? n4 : n6;
            n8 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = this.srcWidth;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            while (n8 < this.srcWidth) {
                float f5;
                int n13;
                if (n11 == 0) {
                    n11 = n;
                    n13 = n8 * this.srcCmp;
                    f2 = 0xFF & byteBuffer.get(n7 + n13++);
                    f3 = 0xFF & byteBuffer.get(n7 + n13++);
                    f4 = 0xFF & byteBuffer.get(n7 + n13++);
                    f = 0xFF & byteBuffer.get(n7 + n13);
                    if (f != 255.0f) {
                        f5 = f / 255.0f;
                        f2 *= f5;
                        f3 *= f5;
                        f4 *= f5;
                    }
                }
                n13 = n11 < n12 ? n11 : n12;
                f5 = (float)n13 * (float)n9;
                int n14 = n10;
                this.alpha[n14] = this.alpha[n14] + f5 * f;
                int n15 = n10;
                this.red[n15] = this.red[n15] + f5 * f2;
                int n16 = n10;
                this.green[n16] = this.green[n16] + f5 * f3;
                int n17 = n10;
                this.blue[n17] = this.blue[n17] + f5 * f4;
                if ((n11 -= n13) == 0) {
                    ++n8;
                }
                if ((n12 -= n13) != 0) continue;
                ++n10;
                n12 = this.srcWidth;
            }
            if ((n6 -= n9) == 0) {
                this.process4CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n9) >= n9 && n9 == this.srcHeight);
            } else {
                n4 -= n9;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
            n7 += this.srcWidth * this.srcCmp;
        }
    }

    private void process4CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcPixelCount;
            int n3 = Math.round(this.alpha[i] / f);
            if (n3 <= 0) {
                n3 = 0;
            } else if (n3 >= 255) {
                n3 = 255;
            } else {
                f = this.alpha[i] / 255.0f;
            }
            int n4 = Math.round(this.red[i] / f);
            int n5 = Math.round(this.green[i] / f);
            int n6 = Math.round(this.blue[i] / f);
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 > 255) {
                n6 = 255;
            }
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)n5;
            byArray[n2++] = (byte)n6;
            byArray[n2++] = (byte)n3;
        }
    }

    private void fillThreeCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        this.green = new float[n];
        this.blue = new float[n];
        byte[] byArray = new byte[n * this.srcCmp];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < this.srcHeight) {
            int n8;
            if (n6 == 0) {
                for (n8 = 0; n8 < n; ++n8) {
                    this.blue[n8] = 0.0f;
                    this.green[n8] = 0.0f;
                    this.red[n8] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n9 = n4 < n6 ? n4 : n6;
            n8 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = this.srcWidth;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            while (n8 < this.srcWidth) {
                int n13;
                if (n11 == 0) {
                    n11 = n;
                    n13 = n8 * this.srcCmp;
                    f = 0xFF & byteBuffer.get(n7 + n13++);
                    f2 = 0xFF & byteBuffer.get(n7 + n13++);
                    f3 = 0xFF & byteBuffer.get(n7 + n13);
                }
                n13 = n11 < n12 ? n11 : n12;
                float f4 = (float)n13 * (float)n9;
                int n14 = n10;
                this.red[n14] = this.red[n14] + f4 * f;
                int n15 = n10;
                this.green[n15] = this.green[n15] + f4 * f2;
                int n16 = n10;
                this.blue[n16] = this.blue[n16] + f4 * f3;
                if ((n11 -= n13) == 0) {
                    ++n8;
                }
                if ((n12 -= n13) != 0) continue;
                ++n10;
                n12 = this.srcWidth;
            }
            if ((n6 -= n9) == 0) {
                this.process3CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n9) >= n9 && n9 == this.srcHeight);
            } else {
                n4 -= n9;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
            n7 += this.srcWidth * this.srcCmp;
        }
    }

    private void process3CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcPixelCount;
            int n3 = Math.round(this.red[i] / f);
            int n4 = Math.round(this.green[i] / f);
            int n5 = Math.round(this.blue[i] / f);
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            byArray[n2++] = (byte)n3;
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)n5;
        }
    }

    private void fillTwoCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        this.alpha = new float[n];
        byte[] byArray = new byte[n * this.srcCmp];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < this.srcHeight) {
            int n8;
            if (n6 == 0) {
                for (n8 = 0; n8 < n; ++n8) {
                    this.red[n8] = 0.0f;
                    this.alpha[n8] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n9 = n4 < n6 ? n4 : n6;
            n8 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = this.srcWidth;
            float f = 0.0f;
            float f2 = 0.0f;
            while (n8 < this.srcWidth) {
                float f3;
                int n13;
                if (n11 == 0) {
                    n11 = n;
                    n13 = n8 * this.srcCmp;
                    f2 = 0xFF & byteBuffer.get(n7 + n13++);
                    f = 0xFF & byteBuffer.get(n7 + n13);
                    if (f != 255.0f) {
                        f3 = f / 255.0f;
                        f2 *= f3;
                    }
                }
                n13 = n11 < n12 ? n11 : n12;
                f3 = (float)n13 * (float)n9;
                int n14 = n10;
                this.alpha[n14] = this.alpha[n14] + f3 * f;
                int n15 = n10;
                this.red[n15] = this.red[n15] + f3 * f2;
                if ((n11 -= n13) == 0) {
                    ++n8;
                }
                if ((n12 -= n13) != 0) continue;
                ++n10;
                n12 = this.srcWidth;
            }
            if ((n6 -= n9) == 0) {
                this.process2CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n9) >= n9 && n9 == this.srcHeight);
            } else {
                n4 -= n9;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
            n7 += this.srcWidth * this.srcCmp;
        }
    }

    private void process2CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcPixelCount;
            int n3 = Math.round(this.alpha[i] / f);
            if (n3 <= 0) {
                n3 = 0;
            } else if (n3 >= 255) {
                n3 = 255;
            } else {
                f = this.alpha[i] / 255.0f;
            }
            int n4 = Math.round(this.red[i] / f);
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)n3;
        }
    }

    private void fillOneCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        byte[] byArray = new byte[n * this.srcCmp];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < this.srcHeight) {
            int n8;
            if (n6 == 0) {
                for (n8 = 0; n8 < n; ++n8) {
                    this.red[n8] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n9 = n4 < n6 ? n4 : n6;
            n8 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = this.srcWidth;
            float f = 0.0f;
            while (n8 < this.srcWidth) {
                int n13;
                if (n11 == 0) {
                    n11 = n;
                    n13 = n8 * this.srcCmp;
                    f = 0xFF & byteBuffer.get(n7 + n13);
                }
                n13 = n11 < n12 ? n11 : n12;
                float f2 = (float)n13 * (float)n9;
                int n14 = n10;
                this.red[n14] = this.red[n14] + f2 * f;
                if ((n11 -= n13) == 0) {
                    ++n8;
                }
                if ((n12 -= n13) != 0) continue;
                ++n10;
                n12 = this.srcWidth;
            }
            if ((n6 -= n9) == 0) {
                this.process1CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n9) >= n9 && n9 == this.srcHeight);
            } else {
                n4 -= n9;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
            n7 += this.srcWidth * this.srcCmp;
        }
    }

    private void process1CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcPixelCount;
            int n3 = Math.round(this.red[i] / f);
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            byArray[n2++] = (byte)n3;
        }
    }

    static {
        try {
            scale_filter_class = Class.forName("vlc.image.ImageScaleFilter");
            scale_filter_constructor = scale_filter_class.getConstructor(String.class);
            scale_image_method = scale_filter_class.getMethod("getScaledImage", Integer.TYPE, Integer.TYPE, Integer.TYPE, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
            hasNativeLib = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

