/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.BufferedReader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.datum.DefaultVerticalDatum;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.MathTransformParser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;

public class Parser
extends MathTransformParser {
    private static final boolean ALLOW_ORACLE_SYNTAX = true;
    private static Map TYPES;
    protected final DatumFactory datumFactory;
    protected final CSFactory csFactory;
    protected final CRSFactory crsFactory;
    private transient ReferencingFactoryContainer factories;
    private final Map directions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Parser() {
        this(Symbols.DEFAULT);
    }

    public Parser(Symbols symbols) {
        this(symbols, ReferencingFactoryFinder.getDatumFactory(null), ReferencingFactoryFinder.getCSFactory(null), ReferencingFactoryFinder.getCRSFactory(null), ReferencingFactoryFinder.getMathTransformFactory(null));
    }

    public Parser(Symbols symbols, ReferencingFactoryContainer factories) {
        this(symbols, factories.getDatumFactory(), factories.getCSFactory(), factories.getCRSFactory(), factories.getMathTransformFactory());
        this.factories = factories;
    }

    public Parser(Symbols symbols, DatumFactory datumFactory, CSFactory csFactory, CRSFactory crsFactory, MathTransformFactory mtFactory) {
        super(symbols, mtFactory);
        this.datumFactory = datumFactory;
        this.csFactory = csFactory;
        this.crsFactory = crsFactory;
        AxisDirection[] values = AxisDirection.values();
        this.directions = new HashMap((int)Math.ceil((float)(values.length + 1) / 0.75f), 0.75f);
        for (int i = 0; i < values.length; ++i) {
            this.directions.put(values[i].name().trim().toUpperCase(), values[i]);
        }
    }

    public CoordinateReferenceSystem parseCoordinateReferenceSystem(String text) throws ParseException {
        Element element = this.getTree(text, new ParsePosition(0));
        CoordinateReferenceSystem crs = this.parseCoordinateReferenceSystem(element);
        element.close();
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element) throws ParseException {
        Object key = element.peek();
        if (key instanceof Element) {
            CoordinateReferenceSystem r;
            String keyword;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        GeographicCRS geographicCRS;
                                        keyword = ((Element)key).keyword.trim().toUpperCase(this.symbols.locale);
                                        r = null;
                                        try {
                                            if (!"GEOGCS".equals(keyword)) break block19;
                                            geographicCRS = r = this.parseGeoGCS(element);
                                            Object var7_12 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var7_20 = null;
                                            if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                                throw new AssertionError(element);
                                            }
                                            throw throwable;
                                        }
                                        if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                            throw new AssertionError(element);
                                        }
                                        return geographicCRS;
                                    }
                                    if (!"PROJCS".equals(keyword)) break block20;
                                    r = this.parseProjCS(element);
                                    ProjectedCRS projectedCRS = r;
                                    Object var7_13 = null;
                                    if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                        throw new AssertionError(element);
                                    }
                                    return projectedCRS;
                                }
                                if (!"GEOCCS".equals(keyword)) break block21;
                                r = this.parseGeoCCS(element);
                                GeocentricCRS geocentricCRS = r;
                                Object var7_14 = null;
                                if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                    throw new AssertionError(element);
                                }
                                return geocentricCRS;
                            }
                            if (!"VERT_CS".equals(keyword)) break block22;
                            r = this.parseVertCS(element);
                            VerticalCRS verticalCRS = r;
                            Object var7_15 = null;
                            if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                throw new AssertionError(element);
                            }
                            return verticalCRS;
                        }
                        if (!"LOCAL_CS".equals(keyword)) break block23;
                        r = this.parseLocalCS(element);
                        EngineeringCRS engineeringCRS = r;
                        Object var7_16 = null;
                        if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                            throw new AssertionError(element);
                        }
                        return engineeringCRS;
                    }
                    if (!"COMPD_CS".equals(keyword)) break block24;
                    r = this.parseCompdCS(element);
                    CompoundCRS compoundCRS = r;
                    Object var7_17 = null;
                    if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                        throw new AssertionError(element);
                    }
                    return compoundCRS;
                }
                if (!"FITTED_CS".equals(keyword)) break block25;
                r = this.parseFittedCS(element);
                DerivedCRS derivedCRS = r;
                Object var7_18 = null;
                if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                    throw new AssertionError(element);
                }
                return derivedCRS;
            }
            Object var7_19 = null;
            if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                throw new AssertionError(element);
            }
        }
        throw element.parseFailed(null, Errors.format(135, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object parse(Element element) throws ParseException {
        Object key = element.peek();
        if (key instanceof Element) {
            Object r;
            String keyword;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            CoordinateSystemAxis coordinateSystemAxis;
                                            keyword = ((Element)key).keyword.trim().toUpperCase(this.symbols.locale);
                                            r = null;
                                            try {
                                                if (!"AXIS".equals(keyword)) break block21;
                                                r = this.parseAxis(element, SI.METER, true);
                                                coordinateSystemAxis = r;
                                                Object var7_13 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var7_22 = null;
                                                if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                                    throw new AssertionError(element);
                                                }
                                                throw throwable;
                                            }
                                            if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                                throw new AssertionError(element);
                                            }
                                            return coordinateSystemAxis;
                                        }
                                        if (!"PRIMEM".equals(keyword)) break block22;
                                        r = this.parsePrimem(element, NonSI.DEGREE_ANGLE);
                                        PrimeMeridian primeMeridian = r;
                                        Object var7_14 = null;
                                        if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                            throw new AssertionError(element);
                                        }
                                        return primeMeridian;
                                    }
                                    if (!"TOWGS84".equals(keyword)) break block23;
                                    r = Parser.parseToWGS84(element);
                                    BursaWolfParameters bursaWolfParameters = r;
                                    Object var7_15 = null;
                                    if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                        throw new AssertionError(element);
                                    }
                                    return bursaWolfParameters;
                                }
                                if (!"SPHEROID".equals(keyword)) break block24;
                                r = this.parseSpheroid(element);
                                Ellipsoid ellipsoid = r;
                                Object var7_16 = null;
                                if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                    throw new AssertionError(element);
                                }
                                return ellipsoid;
                            }
                            if (!"VERT_DATUM".equals(keyword)) break block25;
                            r = this.parseVertDatum(element);
                            VerticalDatum verticalDatum = r;
                            Object var7_17 = null;
                            if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                                throw new AssertionError(element);
                            }
                            return verticalDatum;
                        }
                        if (!"LOCAL_DATUM".equals(keyword)) break block26;
                        r = this.parseLocalDatum(element);
                        EngineeringDatum engineeringDatum = r;
                        Object var7_18 = null;
                        if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                            throw new AssertionError(element);
                        }
                        return engineeringDatum;
                    }
                    if (!"DATUM".equals(keyword)) break block27;
                    r = this.parseDatum(element, DefaultPrimeMeridian.GREENWICH);
                    GeodeticDatum geodeticDatum = r;
                    Object var7_19 = null;
                    if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                        throw new AssertionError(element);
                    }
                    return geodeticDatum;
                }
                r = this.parseMathTransform(element, false);
                if (r == null) break block28;
                Object object = r;
                Object var7_20 = null;
                if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                    throw new AssertionError(element);
                }
                return object;
            }
            Object var7_21 = null;
            if (!$assertionsDisabled && !Parser.isValid(r, keyword)) {
                throw new AssertionError(element);
            }
        }
        return this.parseCoordinateReferenceSystem(element);
    }

    private static boolean isValid(Object parsed, String keyword) {
        if (parsed == null) {
            return true;
        }
        Class type = Parser.getClassOf(keyword);
        return type != null && type.isInstance(parsed);
    }

    protected Map alterProperties(Map properties) {
        return properties;
    }

    private Map parseAuthority(Element parent, String name) throws ParseException {
        HashMap<String, String> properties;
        boolean isRoot = parent.isRoot();
        Element element = parent.pullOptionalElement("AUTHORITY");
        if (element == null) {
            if (isRoot) {
                properties = new HashMap<String, String>(4);
                properties.put("name", name);
            } else {
                properties = Collections.singletonMap("name", name);
            }
        } else {
            String auth = element.pullString("name");
            String code = element.pullString("code");
            element.close();
            Citation authority = Citations.fromName(auth);
            properties = new HashMap<String, String>(4);
            properties.put("name", (String)((Object)new NamedIdentifier(authority, name)));
            properties.put("identifiers", (String)((Object)new NamedIdentifier(authority, code)));
        }
        if (isRoot) {
            properties = this.alterProperties(properties);
        }
        return properties;
    }

    private Unit parseUnit(Element parent, Unit unit) throws ParseException {
        Element element = parent.pullElement("UNIT");
        String name = element.pullString("name");
        double factor = element.pullDouble("factor");
        Map properties = this.parseAuthority(element, name);
        element.close();
        return factor != 1.0 ? unit.multiply(factor) : unit;
    }

    private CoordinateSystemAxis parseAxis(Element parent, Unit unit, boolean required) throws ParseException {
        Element element;
        if (required) {
            element = parent.pullElement("AXIS");
        } else {
            element = parent.pullOptionalElement("AXIS");
            if (element == null) {
                return null;
            }
        }
        String name = element.pullString("name");
        Element orientation = element.pullVoidElement("orientation");
        Map properties = this.parseAuthority(element, name);
        element.close();
        AxisDirection direction = (AxisDirection)this.directions.get(orientation.keyword.trim().toUpperCase());
        if (direction == null) {
            throw element.parseFailed(null, Errors.format(135, orientation));
        }
        try {
            return this.createAxis(properties, name, direction, unit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private CoordinateSystemAxis createAxis(Map properties, String abbreviation, AxisDirection direction, Unit unit) throws FactoryException {
        DefaultCoordinateSystemAxis candidate = DefaultCoordinateSystemAxis.getPredefined(abbreviation, direction);
        if (candidate != null && unit.equals(candidate.getUnit())) {
            return candidate;
        }
        if (properties == null) {
            properties = Collections.singletonMap("name", abbreviation);
        }
        return this.csFactory.createCoordinateSystemAxis(properties, abbreviation, direction, unit);
    }

    private PrimeMeridian parsePrimem(Element parent, Unit angularUnit) throws ParseException {
        Element element = parent.pullElement("PRIMEM");
        String name = element.pullString("name");
        double longitude = element.pullDouble("longitude");
        Map properties = this.parseAuthority(element, name);
        element.close();
        try {
            return this.datumFactory.createPrimeMeridian(properties, longitude, angularUnit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private static BursaWolfParameters parseToWGS84(Element parent) throws ParseException {
        Element element = parent.pullOptionalElement("TOWGS84");
        if (element == null) {
            return null;
        }
        BursaWolfParameters info = new BursaWolfParameters(DefaultGeodeticDatum.WGS84);
        info.dx = element.pullDouble("dx");
        info.dy = element.pullDouble("dy");
        info.dz = element.pullDouble("dz");
        if (element.peek() != null) {
            info.ex = element.pullDouble("ex");
            info.ey = element.pullDouble("ey");
            info.ez = element.pullDouble("ez");
            info.ppm = element.pullDouble("ppm");
        }
        element.close();
        return info;
    }

    private Ellipsoid parseSpheroid(Element parent) throws ParseException {
        Element element = parent.pullElement("SPHEROID");
        String name = element.pullString("name");
        double semiMajorAxis = element.pullDouble("semiMajorAxis");
        double inverseFlattening = element.pullDouble("inverseFlattening");
        Map properties = this.parseAuthority(element, name);
        element.close();
        if (inverseFlattening == 0.0) {
            inverseFlattening = Double.POSITIVE_INFINITY;
        }
        try {
            return this.datumFactory.createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, SI.METER);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private ParameterValueGroup parseProjection(Element parent, Ellipsoid ellipsoid, Unit linearUnit, Unit angularUnit) throws ParseException {
        ParameterValueGroup parameters;
        Element element = parent.pullElement("PROJECTION");
        String classification = element.pullString("name");
        Map properties = this.parseAuthority(element, classification);
        element.close();
        try {
            parameters = this.mtFactory.getDefaultParameters(classification);
        }
        catch (NoSuchIdentifierException exception) {
            throw element.parseFailed(exception, null);
        }
        Element param = parent;
        try {
            if (ellipsoid != null) {
                Unit axisUnit = ellipsoid.getAxisUnit();
                parameters.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), axisUnit);
                parameters.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), axisUnit);
            }
            while ((param = parent.pullOptionalElement("PARAMETER")) != null) {
                String paramName = param.pullString("name");
                double paramValue = param.pullDouble("value");
                ParameterValue parameter = parameters.parameter(paramName);
                Unit expected = ((ParameterDescriptor)parameter.getDescriptor()).getUnit();
                if (expected != null && !Unit.ONE.equals(expected)) {
                    if (linearUnit != null && SI.METER.isCompatible(expected)) {
                        parameter.setValue(paramValue, linearUnit);
                        continue;
                    }
                    if (angularUnit != null && SI.RADIAN.isCompatible(expected)) {
                        parameter.setValue(paramValue, angularUnit);
                        continue;
                    }
                }
                parameter.setValue(paramValue);
            }
        }
        catch (ParameterNotFoundException exception) {
            throw param.parseFailed(exception, Errors.format(129, exception.getParameterName()));
        }
        return parameters;
    }

    private GeodeticDatum parseDatum(Element parent, PrimeMeridian meridian) throws ParseException {
        Element element = parent.pullElement("DATUM");
        String name = element.pullString("name");
        Ellipsoid ellipsoid = this.parseSpheroid(element);
        BursaWolfParameters toWGS84 = Parser.parseToWGS84(element);
        HashMap<String, BursaWolfParameters> properties = this.parseAuthority(element, name);
        if (toWGS84 == null && element.peek() instanceof Number) {
            toWGS84 = new BursaWolfParameters(DefaultGeodeticDatum.WGS84);
            toWGS84.dx = element.pullDouble("dx");
            toWGS84.dy = element.pullDouble("dy");
            toWGS84.dz = element.pullDouble("dz");
            toWGS84.ex = element.pullDouble("ex");
            toWGS84.ey = element.pullDouble("ey");
            toWGS84.ez = element.pullDouble("ez");
            toWGS84.ppm = element.pullDouble("ppm");
        }
        element.close();
        if (toWGS84 != null) {
            if (!(properties instanceof HashMap)) {
                properties = new HashMap<String, BursaWolfParameters>(properties);
            }
            properties.put("bursaWolf", toWGS84);
        }
        try {
            return this.datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private VerticalDatum parseVertDatum(Element parent) throws ParseException {
        Element element = parent.pullElement("VERT_DATUM");
        String name = element.pullString("name");
        int datum = element.pullInteger("datum");
        Map properties = this.parseAuthority(element, name);
        element.close();
        VerticalDatumType type = DefaultVerticalDatum.getVerticalDatumTypeFromLegacyCode(datum);
        if (type == null) {
            throw element.parseFailed(null, Errors.format(135, new Integer(datum)));
        }
        try {
            return this.datumFactory.createVerticalDatum(properties, type);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private EngineeringDatum parseLocalDatum(Element parent) throws ParseException {
        Element element = parent.pullElement("LOCAL_DATUM");
        String name = element.pullString("name");
        int datum = element.pullInteger("datum");
        Map properties = this.parseAuthority(element, name);
        element.close();
        try {
            return this.datumFactory.createEngineeringDatum(properties);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private EngineeringCRS parseLocalCS(Element parent) throws ParseException {
        Element element = parent.pullElement("LOCAL_CS");
        String name = element.pullString("name");
        EngineeringDatum datum = this.parseLocalDatum(element);
        Unit linearUnit = this.parseUnit(element, SI.METER);
        CoordinateSystemAxis axis = this.parseAxis(element, linearUnit, true);
        ArrayList<CoordinateSystemAxis> list = new ArrayList<CoordinateSystemAxis>();
        do {
            list.add(axis);
        } while ((axis = this.parseAxis(element, linearUnit, false)) != null);
        Map properties = this.parseAuthority(element, name);
        element.close();
        AbstractCS cs = new AbstractCS(Collections.singletonMap("name", name), list.toArray(new CoordinateSystemAxis[list.size()]));
        try {
            return this.crsFactory.createEngineeringCRS(properties, datum, cs);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private GeocentricCRS parseGeoCCS(Element parent) throws ParseException {
        Element element = parent.pullElement("GEOCCS");
        String name = element.pullString("name");
        Map properties = this.parseAuthority(element, name);
        PrimeMeridian meridian = this.parsePrimem(element, NonSI.DEGREE_ANGLE);
        GeodeticDatum datum = this.parseDatum(element, meridian);
        Unit linearUnit = this.parseUnit(element, SI.METER);
        CoordinateSystemAxis axis0 = this.parseAxis(element, linearUnit, false);
        try {
            CoordinateSystemAxis axis2;
            CoordinateSystemAxis axis1;
            if (axis0 != null) {
                axis1 = this.parseAxis(element, linearUnit, true);
                axis2 = this.parseAxis(element, linearUnit, true);
            } else {
                axis0 = this.createAxis(null, "X", AxisDirection.OTHER, linearUnit);
                axis1 = this.createAxis(null, "Y", AxisDirection.EAST, linearUnit);
                axis2 = this.createAxis(null, "Z", AxisDirection.NORTH, linearUnit);
            }
            element.close();
            return this.crsFactory.createGeocentricCRS(properties, datum, this.csFactory.createCartesianCS(properties, axis0, axis1, axis2));
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private VerticalCRS parseVertCS(Element parent) throws ParseException {
        Element element = parent.pullElement("VERT_CS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        VerticalDatum datum = this.parseVertDatum(element);
        Unit linearUnit = this.parseUnit(element, SI.METER);
        CoordinateSystemAxis axis = this.parseAxis(element, linearUnit, false);
        Map properties = this.parseAuthority(element, name);
        element.close();
        try {
            if (axis == null) {
                axis = this.createAxis(null, "Z", AxisDirection.UP, linearUnit);
            }
            return this.crsFactory.createVerticalCRS(properties, datum, this.csFactory.createVerticalCS(Collections.singletonMap("name", name), axis));
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private GeographicCRS parseGeoGCS(Element parent) throws ParseException {
        Element element = parent.pullElement("GEOGCS");
        String name = element.pullString("name");
        Map properties = this.parseAuthority(element, name);
        Unit angularUnit = this.parseUnit(element, SI.RADIAN);
        PrimeMeridian meridian = this.parsePrimem(element, angularUnit);
        GeodeticDatum datum = this.parseDatum(element, meridian);
        CoordinateSystemAxis axis0 = this.parseAxis(element, angularUnit, false);
        try {
            CoordinateSystemAxis axis1;
            if (axis0 != null) {
                axis1 = this.parseAxis(element, angularUnit, true);
            } else {
                axis0 = this.createAxis(null, "Lon", AxisDirection.EAST, angularUnit);
                axis1 = this.createAxis(null, "Lat", AxisDirection.NORTH, angularUnit);
            }
            element.close();
            return this.crsFactory.createGeographicCRS(properties, datum, this.csFactory.createEllipsoidalCS(properties, axis0, axis1));
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private ProjectedCRS parseProjCS(Element parent) throws ParseException {
        Element element = parent.pullElement("PROJCS");
        String name = element.pullString("name");
        Map properties = this.parseAuthority(element, name);
        GeographicCRS geoCRS = this.parseGeoGCS(element);
        Ellipsoid ellipsoid = ((GeodeticDatum)geoCRS.getDatum()).getEllipsoid();
        Unit linearUnit = this.parseUnit(element, SI.METER);
        Unit angularUnit = geoCRS.getCoordinateSystem().getAxis(0).getUnit();
        ParameterValueGroup projection = this.parseProjection(element, ellipsoid, linearUnit, angularUnit);
        CoordinateSystemAxis axis0 = this.parseAxis(element, linearUnit, false);
        try {
            CoordinateSystemAxis axis1;
            if (axis0 != null) {
                axis1 = this.parseAxis(element, linearUnit, true);
            } else {
                axis0 = this.createAxis(null, "X", AxisDirection.EAST, linearUnit);
                axis1 = this.createAxis(null, "Y", AxisDirection.NORTH, linearUnit);
            }
            element.close();
            if (this.factories == null) {
                Hints hints = new Hints(Collections.EMPTY_MAP);
                hints.put(Hints.DATUM_FACTORY, this.datumFactory);
                hints.put(Hints.CS_FACTORY, this.csFactory);
                hints.put(Hints.CRS_FACTORY, this.crsFactory);
                hints.put(Hints.MATH_TRANSFORM_FACTORY, this.mtFactory);
                this.factories = ReferencingFactoryContainer.instance(hints);
            }
            return this.factories.createProjectedCRS(properties, geoCRS, null, projection, this.csFactory.createCartesianCS(properties, axis0, axis1));
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private CompoundCRS parseCompdCS(Element parent) throws ParseException {
        CoordinateReferenceSystem[] CRS2 = new CoordinateReferenceSystem[2];
        Element element = parent.pullElement("COMPD_CS");
        String name = element.pullString("name");
        Map properties = this.parseAuthority(element, name);
        CRS2[0] = this.parseCoordinateReferenceSystem(element);
        CRS2[1] = this.parseCoordinateReferenceSystem(element);
        element.close();
        try {
            return this.crsFactory.createCompoundCRS(properties, CRS2);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private DerivedCRS parseFittedCS(Element parent) throws ParseException {
        Element element = parent.pullElement("FITTED_CS");
        String name = element.pullString("name");
        Map properties = this.parseAuthority(element, name);
        MathTransform toBase = this.parseMathTransform(element, true);
        CoordinateReferenceSystem base = this.parseCoordinateReferenceSystem(element);
        OperationMethod method = this.getOperationMethod();
        element.close();
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[toBase.getSourceDimensions()];
        StringBuffer buffer = new StringBuffer(name);
        buffer.append(" axis ");
        int start = buffer.length();
        try {
            for (int i = 0; i < axis.length; ++i) {
                String number = String.valueOf(i);
                buffer.setLength(start);
                buffer.append(number);
                axis[i] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", buffer.toString()), number, AxisDirection.OTHER, Unit.ONE);
            }
            return this.crsFactory.createDerivedCRS(properties, method, base, toBase.inverse(), new AbstractCS(properties, axis));
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    public static Class getClassOf(String element) {
        if (element == null) {
            return null;
        }
        element = element.trim().toUpperCase(Locale.US);
        Class type = (Class)Parser.getTypeMap().get(element);
        if (!($assertionsDisabled || type == null || type.equals(MathTransform.class) || element.equals(Parser.getNameOf(type)))) {
            throw new AssertionError(type);
        }
        return type;
    }

    public static String getNameOf(Class type) {
        if (type != null) {
            Iterator it = Parser.getTypeMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Class candidate = (Class)entry.getValue();
                if (!candidate.isAssignableFrom(type)) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    private static Map getTypeMap() {
        if (TYPES == null) {
            LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>(25);
            map.put("GEOGCS", GeographicCRS.class);
            map.put("PROJCS", ProjectedCRS.class);
            map.put("GEOCCS", GeocentricCRS.class);
            map.put("VERT_CS", VerticalCRS.class);
            map.put("LOCAL_CS", EngineeringCRS.class);
            map.put("COMPD_CS", CompoundCRS.class);
            map.put("FITTED_CS", DerivedCRS.class);
            map.put("AXIS", CoordinateSystemAxis.class);
            map.put("PRIMEM", PrimeMeridian.class);
            map.put("TOWGS84", BursaWolfParameters.class);
            map.put("SPHEROID", Ellipsoid.class);
            map.put("VERT_DATUM", VerticalDatum.class);
            map.put("LOCAL_DATUM", EngineeringDatum.class);
            map.put("DATUM", GeodeticDatum.class);
            map.put("PARAM_MT", MathTransform.class);
            map.put("CONCAT_MT", MathTransform.class);
            map.put("INVERSE_MT", MathTransform.class);
            map.put("PASSTHROUGH_MT", MathTransform.class);
            TYPES = map;
        }
        return TYPES;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        Integer indentation = arguments.getOptionalInteger("Indentation");
        String authority = arguments.getOptionalString("-authority");
        args = arguments.getRemainingArguments(0);
        if (indentation != null) {
            Formattable.setIndentation(indentation);
        }
        BufferedReader in = new BufferedReader(Arguments.getReader(System.in));
        try {
            Parser parser = new Parser();
            if (authority != null) {
                parser.setAuthority(Citations.fromName(authority));
            }
            parser.reformat(in, arguments.out, arguments.err);
        }
        catch (Exception exception) {
            exception.printStackTrace(arguments.err);
        }
    }

    static {
        $assertionsDisabled = !Parser.class.desiredAssertionStatus();
    }
}

