/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.prefs.Preferences;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.Formattable;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

final class AffineTransform2D
extends XAffineTransform
implements MathTransform2D,
LinearTransform,
Formattable {
    private static final long serialVersionUID = -5299837898367149069L;
    private transient AffineTransform2D inverse;

    protected AffineTransform2D(AffineTransform transform) {
        super(transform);
    }

    protected void checkPermission() {
        throw new UnsupportedOperationException(Errors.format(136));
    }

    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    public int getSourceDimensions() {
        return 2;
    }

    public int getTargetDimensions() {
        return 2;
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) {
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(2);
        } else {
            int dimension = ptDst.getDimension();
            if (dimension != 2) {
                throw new MismatchedDimensionException(Errors.format(69, "ptDst", new Integer(dimension), new Integer(2)));
            }
        }
        double[] array = ptSrc.getCoordinates();
        this.transform(array, 0, array, 0, 1);
        ptDst.setOrdinate(0, array[0]);
        ptDst.setOrdinate(1, array[1]);
        return ptDst;
    }

    public Matrix getMatrix() {
        return new Matrix3(this);
    }

    public Matrix derivative(Point2D point) {
        return new Matrix2(this.getScaleX(), this.getShearX(), this.getShearY(), this.getScaleY());
    }

    public Matrix derivative(DirectPosition point) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                try {
                    AffineTransform2D affineTransform2D = this;
                    synchronized (affineTransform2D) {
                        this.inverse = new AffineTransform2D(this.createInverse());
                        this.inverse.inverse = this;
                    }
                }
                catch (java.awt.geom.NoninvertibleTransformException exception) {
                    throw new NoninvertibleTransformException(exception.getLocalizedMessage(), exception);
                }
            }
        }
        return this.inverse;
    }

    public String formatWKT(Formatter formatter) {
        ParameterValueGroup parameters = this.getParameterValues();
        formatter.append(formatter.getName(parameters.getDescriptor()));
        formatter.append(parameters);
        return "PARAM_MT";
    }

    public String toWKT() {
        int indentation = 2;
        try {
            indentation = Preferences.userNodeForPackage(Formattable.class).getInt("Indentation", indentation);
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        Formatter formatter = new Formatter(Symbols.DEFAULT, indentation);
        formatter.append(this);
        return formatter.toString();
    }

    public String toString() {
        return this.toWKT();
    }
}

