/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.Stereographic;
import org.geotools.referencing.operation.projection.StereographicUSGS;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class EquatorialStereographic
extends StereographicUSGS {
    private static final double EPSILON = 1.0E-6;
    static final double k0 = 2.0;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected EquatorialStereographic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        this(parameters, Stereographic.Provider.PARAMETERS);
    }

    EquatorialStereographic(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
        super(parameters, descriptor);
        if (!$assertionsDisabled && ((StereographicUSGS)this).k0 != 2.0) {
            throw new AssertionError(((StereographicUSGS)this).k0);
        }
        this.latitudeOfOrigin = 0.0;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
            throw new AssertionError();
        }
        double chi = 2.0 * Math.atan(this.ssfn(y, Math.sin(y))) - 1.5707963267948966;
        double cosChi = Math.cos(chi);
        double A = 2.0 / (1.0 + cosChi * Math.cos(x));
        x = A * cosChi * Math.sin(x);
        y = A * Math.sin(chi);
        if (!$assertionsDisabled && !EquatorialStereographic.checkTransform(x, y, ptDst)) {
            throw new AssertionError();
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !EquatorialStereographic.class.desiredAssertionStatus();
    }

    static final class Spherical
    extends EquatorialStereographic {
        static final /* synthetic */ boolean $assertionsDisabled;

        Spherical(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
            super(parameters, descriptor);
            this.ensureSpherical();
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double coslat = Math.cos(y);
            double f = 1.0 + coslat * Math.cos(x);
            if (f < 1.0E-6) {
                throw new ProjectionException(Errors.format(146));
            }
            f = 2.0 / f;
            x = f * coslat * Math.sin(x);
            y = f * Math.sin(y);
            if (!$assertionsDisabled && !Spherical.checkTransform(x, y, ptDst)) {
                throw new AssertionError();
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (Math.abs(rho) < 1.0E-6) {
                y = 0.0;
                x = 0.0;
            } else {
                double c = 2.0 * Math.atan(rho / 2.0);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                y = Math.asin(y * sinc / rho);
                double t = x * sinc;
                double ct = rho * cosc;
                double d = x = Math.abs(t) < 1.0E-6 && Math.abs(ct) < 1.0E-6 ? 0.0 : Math.atan2(t, ct);
            }
            if (!$assertionsDisabled && !Spherical.checkInverseTransform(x, y, ptDst)) {
                throw new AssertionError();
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$EquatorialStereographic == null ? (class$org$geotools$referencing$operation$projection$EquatorialStereographic = EquatorialStereographic.class$("org.geotools.referencing.operation.projection.EquatorialStereographic")) : class$org$geotools$referencing$operation$projection$EquatorialStereographic).desiredAssertionStatus();
        }
    }
}

