/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.operation.builder.ExtendedPosition;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

class RubberSheetTransform
extends AbstractMathTransform
implements MathTransform2D {
    private HashMap trianglesToKeysMap;

    public RubberSheetTransform(HashMap trianglesToAffineTransform) {
        this.trianglesToKeysMap = trianglesToAffineTransform;
    }

    public final int getSourceDimensions() {
        return 2;
    }

    public final int getTargetDimensions() {
        return 2;
    }

    private HashMap mapTrianglesToPoints(ArrayList arraySrcPts) {
        HashMap trianglesToPoints = new HashMap();
        Iterator i = this.trianglesToKeysMap.keySet().iterator();
        while (i.hasNext()) {
            TINTriangle triangle = (TINTriangle)i.next();
            ArrayList<DirectPosition> pointsInTriangle = new ArrayList<DirectPosition>();
            Iterator k = arraySrcPts.iterator();
            while (k.hasNext()) {
                DirectPosition p = (DirectPosition)k.next();
                if (!triangle.containsOrIsVertex(p)) continue;
                pointsInTriangle.add(p);
            }
            trianglesToPoints.put(triangle, pointsInTriangle);
        }
        return trianglesToPoints;
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        ExtendedPosition ptSrc = null;
        ArrayList<ExtendedPosition> arraySrcPts = new ArrayList<ExtendedPosition>();
        while (--numPts >= 0) {
            DirectPosition2D coSrc = new DirectPosition2D(srcPts[srcOff++], srcPts[srcOff++]);
            DirectPosition2D coDst = new DirectPosition2D(0.0, 0.0);
            ptSrc = new ExtendedPosition(coSrc, coDst);
            arraySrcPts.add(ptSrc);
        }
        HashMap trianglestoPoints = this.mapTrianglesToPoints(arraySrcPts);
        Iterator k = trianglestoPoints.keySet().iterator();
        while (k.hasNext()) {
            TINTriangle triangle = (TINTriangle)k.next();
            AffineTransform AT = (AffineTransform)this.trianglesToKeysMap.get(triangle);
            Iterator j = ((ArrayList)trianglestoPoints.get(triangle)).iterator();
            while (j.hasNext()) {
                ExtendedPosition co = (ExtendedPosition)j.next();
                Point2D.Double ptS = new Point2D.Double(co.x, co.y);
                Point2D.Double ptD = new Point2D.Double();
                AT.transform(ptS, ptD);
                DirectPosition2D coDst = new DirectPosition2D(co.getCoordinateReferenceSystem(), ((Point2D)ptD).getX(), ((Point2D)ptD).getY());
                co.setMappedposition(coDst);
            }
        }
        Iterator j = arraySrcPts.iterator();
        while (j.hasNext()) {
            ExtendedPosition mc = (ExtendedPosition)j.next();
            dstPts[dstOff++] = mc.getMappedposition().getCoordinates()[0];
            dstPts[dstOff++] = mc.getMappedposition().getCoordinates()[1];
        }
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.trianglesToKeysMap.keySet().iterator();
        while (i.hasNext()) {
            TINTriangle trian = (TINTriangle)i.next();
            MathTransform mt = (MathTransform)this.trianglesToKeysMap.get(trian);
            buffer.append(trian.toString());
            buffer.append(lineSeparator);
            buffer.append(mt.toString());
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }
}

