/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.vecmath.MismatchedSizeException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.io.TableWriter;
import org.geotools.math.Statistics;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.metadata.iso.quality.QuantitativeResultImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefaultTransformation;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;

public abstract class MathTransformBuilder {
    private final List positions = new ArrayList();
    private final List unmodifiablePositions = Collections.unmodifiableList(this.positions);
    private CoordinateReferenceSystem sourceCRS;
    private CoordinateReferenceSystem targetCRS;
    private transient MathTransform transform;
    private transient Transformation transformation;
    protected final MathTransformFactory mtFactory;
    private final CRSFactory crsFactory;
    private final DatumFactory datumFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MathTransformBuilder() {
        this(null);
    }

    public MathTransformBuilder(Hints hints) {
        this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(hints);
        this.crsFactory = ReferencingFactoryFinder.getCRSFactory(hints);
        this.datumFactory = ReferencingFactoryFinder.getDatumFactory(hints);
    }

    public String getName() {
        return Utilities.getShortClassName(this) + " fit";
    }

    public abstract int getMinimumPointCount();

    public int getDimension() {
        return 2;
    }

    public List getMappedPositions() {
        return this.unmodifiablePositions;
    }

    public void setMappedPositions(List positions) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException {
        CoordinateReferenceSystem source = this.ensureValid(MathTransformBuilder.getPoints(positions, false), "sourcePoints");
        CoordinateReferenceSystem target = this.ensureValid(MathTransformBuilder.getPoints(positions, true), "targetPoints");
        this.positions.clear();
        this.positions.addAll(positions);
        this.sourceCRS = source;
        this.targetCRS = target;
        this.transform = null;
    }

    private static DirectPosition[] getPoints(List positions, boolean target) {
        DirectPosition[] points = new DirectPosition[positions.size()];
        for (int i = 0; i < points.length; ++i) {
            MappedPosition mp = (MappedPosition)positions.get(i);
            points[i] = target ? mp.getTarget() : mp.getSource();
        }
        return points;
    }

    private void setPoints(DirectPosition[] points, boolean target) throws MismatchedSizeException {
        this.transform = null;
        boolean add = this.positions.isEmpty();
        if (!add && points.length != this.positions.size()) {
            throw new MismatchedSizeException(Errors.format(67));
        }
        int dimension = this.getDimension();
        for (int i = 0; i < points.length; ++i) {
            MappedPosition mp;
            if (add) {
                mp = new MappedPosition(dimension);
                this.positions.add(mp);
            } else {
                mp = (MappedPosition)this.positions.get(i);
            }
            DirectPosition point = points[i];
            if (target) {
                mp.setTarget(point);
                continue;
            }
            mp.setSource(point);
        }
    }

    public DirectPosition[] getSourcePoints() {
        DirectPosition[] points = MathTransformBuilder.getPoints(this.getMappedPositions(), false);
        if (!$assertionsDisabled && !this.ensureValid(points, "sourcePoints", this.sourceCRS)) {
            throw new AssertionError();
        }
        return points;
    }

    public void setSourcePoints(DirectPosition[] points) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException {
        this.sourceCRS = this.ensureValid(points, "sourcePoints");
        this.setPoints(points, false);
    }

    public DirectPosition[] getTargetPoints() {
        DirectPosition[] points = MathTransformBuilder.getPoints(this.getMappedPositions(), true);
        if (!$assertionsDisabled && !this.ensureValid(points, "targetPoints", this.targetCRS)) {
            throw new AssertionError();
        }
        return points;
    }

    public void setTargetPoints(DirectPosition[] points) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException {
        this.targetCRS = this.ensureValid(points, "targetPoints");
        this.setPoints(points, true);
    }

    public void printPoints(Writer out, Locale locale) throws IOException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat source = this.getNumberFormat(locale, false);
        NumberFormat target = this.getNumberFormat(locale, true);
        TableWriter table = new TableWriter(out, " \u2502 ");
        table.setAlignment(1);
        table.writeHorizontalSeparator();
        try {
            int i;
            CoordinateSystem sourceCS = this.getSourceCRS().getCoordinateSystem();
            CoordinateSystem targetCS = this.getTargetCRS().getCoordinateSystem();
            int dimension = sourceCS.getDimension();
            for (i = 0; i < dimension; ++i) {
                table.write(sourceCS.getAxis(i).getName().getCode());
                table.nextColumn();
            }
            dimension = targetCS.getDimension();
            for (i = 0; i < dimension; ++i) {
                table.write(targetCS.getAxis(i).getName().getCode());
                table.nextColumn();
            }
            table.writeHorizontalSeparator();
        }
        catch (FactoryException e) {
            // empty catch block
        }
        table.setAlignment(2);
        Iterator it = this.getMappedPositions().iterator();
        while (it.hasNext()) {
            int i;
            MappedPosition mp = (MappedPosition)it.next();
            DirectPosition point = mp.getSource();
            int dimension = point.getDimension();
            for (i = 0; i < dimension; ++i) {
                table.write(source.format(point.getOrdinate(i)));
                table.nextColumn();
            }
            point = mp.getTarget();
            dimension = point.getDimension();
            for (i = 0; i < dimension; ++i) {
                table.write(target.format(point.getOrdinate(i)));
                table.nextColumn();
            }
            table.nextLine();
        }
        table.writeHorizontalSeparator();
        table.flush();
    }

    public CoordinateReferenceSystem getSourceCRS() throws FactoryException {
        if (this.sourceCRS == null) {
            this.sourceCRS = this.createEngineeringCRS(false);
        }
        if (!$assertionsDisabled && this.sourceCRS.getCoordinateSystem().getDimension() != this.getDimension()) {
            throw new AssertionError();
        }
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() throws FactoryException {
        if (this.targetCRS == null) {
            this.targetCRS = this.createEngineeringCRS(true);
        }
        if (!$assertionsDisabled && this.targetCRS.getCoordinateSystem().getDimension() != this.getDimension()) {
            throw new AssertionError();
        }
        return this.targetCRS;
    }

    /*
     * WARNING - void declaration
     */
    private EngineeringCRS createEngineeringCRS(boolean target) throws FactoryException {
        void var5_5;
        CoordinateSystem cs;
        CoordinateReferenceSystem oppositeCRS;
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", Vocabulary.format(176));
        GeographicBoundingBox validArea = this.getValidArea(target);
        if (validArea != null) {
            ExtentImpl extent = new ExtentImpl();
            extent.getGeographicElements().add(validArea);
            properties.put("domainOfValidity", extent.unmodifiable());
        }
        CoordinateReferenceSystem coordinateReferenceSystem = oppositeCRS = target ? this.sourceCRS : this.targetCRS;
        if (oppositeCRS != null) {
            cs = oppositeCRS.getCoordinateSystem();
        } else {
            switch (this.getDimension()) {
                case 2: {
                    cs = DefaultCartesianCS.GENERIC_2D;
                    break;
                }
                case 3: {
                    cs = DefaultCartesianCS.GENERIC_3D;
                    break;
                }
                default: {
                    throw new FactoryException(Errors.format(140));
                }
            }
        }
        return this.crsFactory.createEngineeringCRS(properties, this.datumFactory.createEngineeringDatum(properties), (CoordinateSystem)var5_5);
    }

    private NumberFormat getNumberFormat(Locale locale, boolean target) {
        int digits;
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        GeneralEnvelope envelope = this.getEnvelope(target);
        double length = 0.0;
        int i = envelope.getDimension();
        while (--i >= 0) {
            double candidate = envelope.getLength(i);
            if (!(candidate > length)) continue;
            length = candidate;
        }
        if (length > 0.0 && (digits = Math.max(0, 3 - (int)Math.ceil(XMath.log10(length)))) < 16) {
            format.setMinimumFractionDigits(digits);
            format.setMaximumFractionDigits(digits);
        }
        return format;
    }

    private GeneralEnvelope getEnvelope(boolean target) {
        GeneralEnvelope envelope = null;
        CoordinateReferenceSystem crs = null;
        Iterator it = this.getMappedPositions().iterator();
        while (it.hasNext()) {
            MappedPosition mp = (MappedPosition)it.next();
            DirectPosition point = target ? mp.getTarget() : mp.getSource();
            if (point == null) continue;
            if (envelope == null) {
                double[] coordinates = point.getCoordinates();
                envelope = new GeneralEnvelope(coordinates, coordinates);
            } else {
                envelope.add(point);
            }
            crs = MathTransformBuilder.getCoordinateReferenceSystem(point, crs);
        }
        if (envelope != null) {
            envelope.setCoordinateReferenceSystem(crs);
        }
        return envelope;
    }

    private GeographicBoundingBox getValidArea(boolean target) {
        GeneralEnvelope envelope = this.getEnvelope(target);
        if (envelope != null) {
            try {
                return new GeographicBoundingBoxImpl(envelope);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    private static CoordinateReferenceSystem getCoordinateReferenceSystem(DirectPosition point, CoordinateReferenceSystem previousCRS) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem candidate = point.getCoordinateReferenceSystem();
        if (candidate != null) {
            if (previousCRS == null) {
                return candidate;
            }
            if (!previousCRS.equals(candidate)) {
                throw new MismatchedReferenceSystemException(Errors.format(197));
            }
        }
        return previousCRS;
    }

    public Class getCoordinateSystemType() {
        return CoordinateSystem.class;
    }

    private CoordinateReferenceSystem ensureValid(DirectPosition[] points, String label) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException {
        int necessaryNumber = this.getMinimumPointCount();
        if (points.length < necessaryNumber) {
            throw new MismatchedSizeException(Errors.format(198, new Integer(points.length), new Integer(necessaryNumber)));
        }
        CoordinateReferenceSystem crs = null;
        int dimension = this.getDimension();
        for (int i = 0; i < points.length; ++i) {
            DirectPosition point = points[i];
            int pointDim = point.getDimension();
            if (pointDim != dimension) {
                throw new MismatchedDimensionException(Errors.format(69, label + '[' + i + ']', new Integer(pointDim), new Integer(dimension)));
            }
            crs = MathTransformBuilder.getCoordinateReferenceSystem(point, crs);
        }
        if (crs != null) {
            CoordinateSystem cs = crs.getCoordinateSystem();
            if (!this.getCoordinateSystemType().isAssignableFrom(cs.getClass())) {
                throw new MismatchedReferenceSystemException(Errors.format(151, cs.getName()));
            }
        }
        return crs;
    }

    private boolean ensureValid(DirectPosition[] points, String label, CoordinateReferenceSystem expected) {
        CoordinateReferenceSystem actual = this.ensureValid(points, label);
        return actual == null || actual == expected;
    }

    public Statistics getErrorStatistics() throws FactoryException {
        MathTransform mt = this.getMathTransform();
        Statistics stats = new Statistics();
        GeneralDirectPosition buffer = new GeneralDirectPosition(this.getDimension());
        Iterator it = this.getMappedPositions().iterator();
        while (it.hasNext()) {
            double error;
            MappedPosition mp = (MappedPosition)it.next();
            try {
                error = mp.getError(mt, buffer);
            }
            catch (TransformException e) {
                throw new FactoryException(Errors.format(199), e);
            }
            stats.add(error);
        }
        return stats;
    }

    protected abstract MathTransform computeMathTransform() throws FactoryException;

    public final MathTransform getMathTransform() throws FactoryException {
        if (this.transform == null) {
            this.transform = this.computeMathTransform();
        }
        return this.transform;
    }

    public Transformation getTransformation() throws FactoryException {
        if (this.transformation == null) {
            double error;
            GeographicBoundingBox validArea;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("name", this.getName());
            CoordinateReferenceSystem sourceCRS = this.getSourceCRS();
            CoordinateReferenceSystem targetCRS = this.getTargetCRS();
            GeographicBoundingBox sourceBox = CRS.getGeographicBoundingBox(sourceCRS);
            GeographicBoundingBox targetBox = CRS.getGeographicBoundingBox(targetCRS);
            if (sourceBox == null) {
                validArea = targetBox;
            } else if (targetBox == null) {
                validArea = sourceBox;
            } else {
                GeneralEnvelope area = new GeneralEnvelope(sourceBox);
                area.intersect(new GeneralEnvelope(sourceBox));
                try {
                    validArea = new GeographicBoundingBoxImpl(area);
                }
                catch (TransformException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (validArea != null) {
                ExtentImpl extent = new ExtentImpl();
                extent.getGeographicElements().add(validArea);
                properties.put("domainOfValidity", extent.unmodifiable());
            }
            if (!Double.isNaN(error = this.getErrorStatistics().rms())) {
                InternationalString description = Vocabulary.formatInternational(232);
                QuantitativeResultImpl result = new QuantitativeResultImpl();
                result.setValues(new double[]{error});
                result.setValueUnit(CRSUtilities.getUnit(targetCRS.getCoordinateSystem()));
                result.setErrorStatistic(description);
                PositionalAccuracyImpl accuracy = new PositionalAccuracyImpl(result);
                accuracy.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
                accuracy.setEvaluationMethodDescription(description);
                properties.put("coordinateOperationAccuracy", accuracy.unmodifiable());
            }
            MathTransform transform = this.getMathTransform();
            this.transformation = new DefaultTransformation(properties, sourceCRS, targetCRS, transform, new DefaultOperationMethod(transform));
        }
        return this.transformation;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            this.printPoints(out, null);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return out.toString();
    }

    static {
        $assertionsDisabled = !MathTransformBuilder.class.desiredAssertionStatus();
    }
}

