/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.ParameterWriter;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.MathTransformParser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.Arguments;
import org.geotools.resources.LazySet;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CanonicalSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

public class DefaultMathTransformFactory
extends ReferencingFactory
implements MathTransformFactory {
    private static final Hints HINTS = null;
    private transient MathTransformParser parser;
    private transient MathTransformProvider lastProvider;
    private final ThreadLocal lastMethod = new ThreadLocal();
    private final CanonicalSet pool = new CanonicalSet();
    private final FactoryRegistry registry;

    public DefaultMathTransformFactory() {
        this(new Class[]{MathTransformProvider.class});
    }

    private DefaultMathTransformFactory(Class[] categories) {
        this.registry = new FactoryRegistry(Arrays.asList(categories));
    }

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    public Set getAvailableMethods(Class type) {
        return new LazySet(this.registry.getServiceProviders(MathTransformProvider.class, (ServiceRegistry.Filter)(type != null ? new MethodFilter(type) : null), HINTS));
    }

    public OperationMethod getLastMethodUsed() {
        return (OperationMethod)this.lastMethod.get();
    }

    public OperationMethod getLastUsedMethod() {
        return this.getLastMethodUsed();
    }

    public OperationMethod getOperationMethod(String name) throws NoSuchIdentifierException {
        return this.getProvider(name);
    }

    private synchronized MathTransformProvider getProvider(String method) throws NoSuchIdentifierException {
        MathTransformProvider provider = this.lastProvider;
        if (provider != null && provider.nameMatches(method)) {
            return provider;
        }
        Iterator providers = this.registry.getServiceProviders(MathTransformProvider.class, null, HINTS);
        while (providers.hasNext()) {
            provider = (MathTransformProvider)providers.next();
            if (!provider.nameMatches(method)) continue;
            this.lastProvider = provider;
            return this.lastProvider;
        }
        throw new NoSuchIdentifierException(Errors.format(103, method), method);
    }

    public ParameterValueGroup getDefaultParameters(String method) throws NoSuchIdentifierException {
        return (ParameterValueGroup)this.getProvider(method).getParameters().createValue();
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws FactoryException {
        throw new FactoryException("Not implemented.");
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform;
        MathTransformProvider provider;
        String classification = parameters.getDescriptor().getName().getCode();
        OperationMethod method = provider = this.getProvider(classification);
        try {
            parameters = provider.ensureValidValues(parameters);
            transform = provider.createMathTransform(parameters);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        if (transform instanceof MathTransformProvider.Delegate) {
            MathTransformProvider.Delegate delegate = (MathTransformProvider.Delegate)transform;
            method = delegate.method;
            transform = delegate.transform;
        }
        transform = (MathTransform)this.pool.unique(transform);
        this.lastMethod.set(method);
        return transform;
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameters, Collection methods) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform = this.createParameterizedTransform(parameters);
        if (methods != null) {
            methods.add(this.lastMethod.get());
        }
        return transform;
    }

    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        return (MathTransform)this.pool.unique(ProjectiveTransform.create(matrix));
    }

    public MathTransform createConcatenatedTransform(MathTransform transform1, MathTransform transform2) throws FactoryException {
        MathTransform tr;
        try {
            tr = ConcatenatedTransform.create(transform1, transform2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        tr = (MathTransform)this.pool.unique(tr);
        return tr;
    }

    public MathTransform createPassThroughTransform(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) throws FactoryException {
        MathTransform tr;
        try {
            tr = PassThroughTransform.create(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        tr = (MathTransform)this.pool.unique(tr);
        return tr;
    }

    public MathTransform createFromXML(String xml) throws FactoryException {
        throw new FactoryException("Not yet implemented.");
    }

    public synchronized MathTransform createFromWKT(String text) throws FactoryException {
        if (this.parser == null) {
            this.parser = new MathTransformParser(Symbols.DEFAULT, this);
        }
        try {
            return this.parser.parseMathTransform(text);
        }
        catch (ParseException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception);
        }
    }

    public void scanForPlugins() {
        this.registry.scanForPlugins();
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        boolean printAll = arguments.getFlag("-all");
        Class type = null;
        if (arguments.getFlag("-projections")) {
            Class clazz = type = Projection.class;
        }
        if (arguments.getFlag("-conversions")) {
            type = Conversion.class;
        }
        args = arguments.getRemainingArguments(1);
        try {
            DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
            ParameterWriter writer = new ParameterWriter(arguments.out);
            writer.setLocale(arguments.locale);
            Set<MathTransformProvider> transforms = Collections.EMPTY_SET;
            if (printAll || args.length == 0) {
                HashSet<String> scopes = new HashSet<String>();
                scopes.add("EPSG");
                scopes.add("Geotools");
                transforms = new TreeSet<MathTransformProvider>(AbstractIdentifiedObject.NAME_COMPARATOR);
                transforms.addAll(factory.getAvailableMethods(type));
                writer.summary(transforms, scopes);
            }
            if (!printAll) {
                transforms = args.length == 0 ? Collections.EMPTY_SET : Collections.singleton(factory.getProvider(args[0]));
            }
            Iterator it = transforms.iterator();
            String lineSeparator = System.getProperty("line.separator", "\n");
            while (it.hasNext()) {
                arguments.out.write(lineSeparator);
                writer.format((OperationMethod)it.next());
            }
        }
        catch (NoSuchIdentifierException exception) {
            arguments.err.println(exception.getLocalizedMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(arguments.err);
            return;
        }
        arguments.out.flush();
    }

    private static final class MethodFilter
    implements ServiceRegistry.Filter {
        private final Class type;

        public MethodFilter(Class type) {
            this.type = type;
        }

        public boolean filter(Object element) {
            Class t;
            return !(element instanceof MathTransformProvider) || (t = ((MathTransformProvider)element).getOperationType()) == null || this.type.isAssignableFrom(t);
        }
    }
}

