/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;

public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection coordinateOperationAccuracy;
    protected final Extent domainOfValidity;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(definition);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.operationVersion = definition.getOperationVersion();
        this.coordinateOperationAccuracy = definition.getCoordinateOperationAccuracy();
        this.domainOfValidity = definition.getDomainOfValidity();
        this.scope = definition.getScope();
        this.transform = transform;
    }

    public AbstractCoordinateOperation(Map properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        this(properties, new HashMap(), sourceCRS, targetCRS, transform);
    }

    private AbstractCoordinateOperation(Map properties, Map subProperties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(properties, subProperties, LOCALIZABLES);
        this.domainOfValidity = (Extent)subProperties.get("domainOfValidity");
        this.scope = (InternationalString)subProperties.get("scope");
        this.operationVersion = (String)subProperties.get("operationVersion");
        Object[] positionalAccuracy = (PositionalAccuracy[])subProperties.get("coordinateOperationAccuracy");
        if (positionalAccuracy == null || positionalAccuracy.length == 0) {
            positionalAccuracy = null;
        } else {
            positionalAccuracy = (PositionalAccuracy[])positionalAccuracy.clone();
            for (int i = 0; i < positionalAccuracy.length; ++i) {
                AbstractCoordinateOperation.ensureNonNull("coordinateOperationAccuracy", positionalAccuracy, i);
            }
        }
        this.coordinateOperationAccuracy = AbstractCoordinateOperation.asSet(positionalAccuracy);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.transform = transform;
        if (!(this instanceof Conversion) || transform != null || sourceCRS != null || targetCRS != null) {
            AbstractCoordinateOperation.ensureNonNull("sourceCRS", transform);
            AbstractCoordinateOperation.ensureNonNull("targetCRS", transform);
            AbstractCoordinateOperation.ensureNonNull("transform", transform);
            AbstractCoordinateOperation.checkDimension("sourceCRS", sourceCRS, transform.getSourceDimensions());
            AbstractCoordinateOperation.checkDimension("targetCRS", targetCRS, transform.getTargetDimensions());
        }
    }

    private static void checkDimension(String name, CoordinateReferenceSystem crs, int expected) {
        int actual = crs.getCoordinateSystem().getDimension();
        if (actual != expected) {
            throw new IllegalArgumentException(Errors.format(69, name, new Integer(actual), new Integer(expected)));
        }
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public String getOperationVersion() {
        return this.operationVersion;
    }

    public Collection getCoordinateOperationAccuracy() {
        return this.coordinateOperationAccuracy != null ? this.coordinateOperationAccuracy : Collections.EMPTY_SET;
    }

    public Collection getPositionalAccuracy() {
        return this.coordinateOperationAccuracy != null ? this.coordinateOperationAccuracy : Collections.EMPTY_SET;
    }

    public double getAccuracy() {
        return AbstractCoordinateOperation.getAccuracy0(this);
    }

    public static double getAccuracy(CoordinateOperation operation) {
        if (operation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)operation).getAccuracy();
        }
        return AbstractCoordinateOperation.getAccuracy0(operation);
    }

    private static double getAccuracy0(CoordinateOperation operation) {
        Collection accuracies = operation.getPositionalAccuracy();
        Iterator it = accuracies.iterator();
        while (it.hasNext()) {
            Collection results = ((PositionalAccuracy)it.next()).getResults();
            Iterator it2 = results.iterator();
            while (it2.hasNext()) {
                Unit unit;
                QuantitativeResult quantity;
                Collection r;
                Result accuracy = (Result)it2.next();
                if (!(accuracy instanceof QuantitativeResult) || (r = (quantity = (QuantitativeResult)accuracy).getValues()) == null || (unit = quantity.getValueUnit()) == null || !SI.METER.isCompatible(unit)) continue;
                Iterator i = r.iterator();
                while (i.hasNext()) {
                    Number d = (Number)i.next();
                    if (d == null) continue;
                    double value = d.doubleValue();
                    value = unit.getConverterTo(SI.METER).convert(value);
                    return value;
                }
            }
        }
        if (operation instanceof Conversion) {
            return 0.0;
        }
        if (operation instanceof Transformation) {
            if (!accuracies.contains(PositionalAccuracyImpl.DATUM_SHIFT_OMITTED) && accuracies.contains(PositionalAccuracyImpl.DATUM_SHIFT_APPLIED)) {
                return 25.0;
            }
            return 1000.0;
        }
        double accuracy = Double.NaN;
        if (operation instanceof ConcatenatedOperation) {
            List components = ((ConcatenatedOperation)operation).getOperations();
            Iterator it2 = components.iterator();
            while (it2.hasNext()) {
                double candidate = Math.abs(AbstractCoordinateOperation.getAccuracy((CoordinateOperation)it2.next()));
                if (Double.isNaN(candidate)) continue;
                if (Double.isNaN(accuracy)) {
                    accuracy = candidate;
                    continue;
                }
                accuracy += candidate;
            }
        }
        return accuracy;
    }

    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    public Extent getValidArea() {
        return this.domainOfValidity;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class getType(CoordinateOperation object) {
        if (object instanceof Transformation) {
            return Transformation.class;
        }
        if (object instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (object instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (object instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (object instanceof Projection) {
            return Projection.class;
        }
        if (object instanceof Conversion) {
            return Conversion.class;
        }
        if (object instanceof Operation) {
            return Operation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCoordinateOperation that = (AbstractCoordinateOperation)object;
            if (AbstractCoordinateOperation.equals(this.sourceCRS, that.sourceCRS, compareMetadata) && Utilities.equals(this.transform, that.transform)) {
                if (!(!compareMetadata || Utilities.equals(this.domainOfValidity, that.domainOfValidity) && Utilities.equals(this.scope, that.scope) && Utilities.equals(this.coordinateOperationAccuracy, that.coordinateOperationAccuracy))) {
                    return false;
                }
                Boolean comparing = (Boolean)AbstractDerivedCRS._COMPARING.get();
                if (comparing != null && comparing.booleanValue()) {
                    return true;
                }
                try {
                    AbstractDerivedCRS._COMPARING.set(Boolean.TRUE);
                    boolean bl = AbstractCoordinateOperation.equals(this.targetCRS, that.targetCRS, compareMetadata);
                    return bl;
                }
                finally {
                    AbstractDerivedCRS._COMPARING.set(Boolean.FALSE);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int code = -598790243;
        if (this.sourceCRS != null) {
            code ^= this.sourceCRS.hashCode();
        }
        if (this.targetCRS != null) {
            code ^= this.targetCRS.hashCode();
        }
        if (this.transform != null) {
            code ^= this.transform.hashCode();
        }
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        AbstractCoordinateOperation.append(formatter, this.sourceCRS, "SOURCE");
        AbstractCoordinateOperation.append(formatter, this.targetCRS, "TARGET");
        return super.formatWKT(formatter);
    }

    static void append(Formatter formatter, IdentifiedObject object, final String type) {
        if (object != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>(4);
            properties.put("name", formatter.getName(object));
            properties.put("identifiers", formatter.getIdentifier(object));
            formatter.append(new AbstractIdentifiedObject(properties){

                protected String formatWKT(Formatter formatter) {
                    return type;
                }
            });
        }
    }
}

