/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.wms.Auto42001;
import org.geotools.referencing.factory.wms.Auto42002;
import org.geotools.referencing.factory.wms.Auto42003;
import org.geotools.referencing.factory.wms.Auto42004;
import org.geotools.referencing.factory.wms.Auto42005;
import org.geotools.referencing.factory.wms.Code;
import org.geotools.referencing.factory.wms.Factlet;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.util.InternationalString;

public class AutoCRSFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    private static final Citation AUTHORITY;
    private final Map factlets = new TreeMap();

    public AutoCRSFactory() {
        this(null);
    }

    public AutoCRSFactory(Hints hints) {
        super(hints, 50);
        this.add(Auto42001.DEFAULT);
        this.add(Auto42002.DEFAULT);
        this.add(Auto42003.DEFAULT);
        this.add(Auto42004.DEFAULT);
        this.add(Auto42005.DEFAULT);
    }

    private void add(Factlet f) {
        int code = f.code();
        if (this.factlets.put(new Integer(code), f) != null) {
            throw new IllegalArgumentException(String.valueOf(code));
        }
    }

    private Factlet findFactlet(Code code) throws NoSuchAuthorityCodeException {
        Integer key;
        Factlet fac;
        if ((code.authority.equalsIgnoreCase("AUTO") || code.authority.equalsIgnoreCase("AUTO2")) && (fac = (Factlet)this.factlets.get(key = new Integer(code.code))) != null) {
            return fac;
        }
        throw this.noSuchAuthorityCode(code.type, code.toString());
    }

    public Citation getAuthority() {
        return AUTHORITY;
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        if (type.isAssignableFrom(ProjectedCRS.class)) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            Iterator it = this.factlets.keySet().iterator();
            while (it.hasNext()) {
                Integer code = (Integer)it.next();
                set.add(String.valueOf(code));
            }
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        Code c = new Code(code, ProjectedCRS.class);
        return new SimpleInternationalString(this.findFactlet(c).getName());
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.createProjectedCRS(code);
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        Code c = new Code(code, ProjectedCRS.class);
        return this.findFactlet(c).create(c, this.factories);
    }

    static {
        CitationImpl c = new CitationImpl(Citations.AUTO2);
        c.getIdentifiers().addAll(Citations.AUTO.getIdentifiers());
        AUTHORITY = (Citation)((Object)c.unmodifiable());
    }
}

