/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.units.Unit;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultImageCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.referencing.crs.DefaultVerticalCRS;
import org.geotools.referencing.cs.DefaultAffineCS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultCylindricalCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.cs.DefaultLinearCS;
import org.geotools.referencing.cs.DefaultPolarCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.cs.DefaultUserDefinedCS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultEngineeringDatum;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultImageDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.datum.DefaultTemporalDatum;
import org.geotools.referencing.datum.DefaultVerticalDatum;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.wkt.Parser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.CanonicalSet;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;

public class ReferencingObjectFactory
extends ReferencingFactory
implements CSFactory,
DatumFactory,
CRSFactory,
BufferedFactory {
    private transient Parser parser;
    private final CanonicalSet pool = new CanonicalSet();

    public Ellipsoid createEllipsoid(Map properties, double semiMajorAxis, double semiMinorAxis, Unit unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createEllipsoid(properties, semiMajorAxis, semiMinorAxis, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        ellipsoid = (Ellipsoid)this.pool.unique(ellipsoid);
        return ellipsoid;
    }

    public Ellipsoid createFlattenedSphere(Map properties, double semiMajorAxis, double inverseFlattening, Unit unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        ellipsoid = (Ellipsoid)this.pool.unique(ellipsoid);
        return ellipsoid;
    }

    public PrimeMeridian createPrimeMeridian(Map properties, double longitude, Unit angularUnit) throws FactoryException {
        PrimeMeridian meridian;
        try {
            meridian = new DefaultPrimeMeridian(properties, longitude, angularUnit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        meridian = (PrimeMeridian)this.pool.unique(meridian);
        return meridian;
    }

    public GeodeticDatum createGeodeticDatum(Map properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        GeodeticDatum datum;
        try {
            datum = new DefaultGeodeticDatum(properties, ellipsoid, primeMeridian);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = (GeodeticDatum)this.pool.unique(datum);
        return datum;
    }

    public VerticalDatum createVerticalDatum(Map properties, VerticalDatumType type) throws FactoryException {
        VerticalDatum datum;
        try {
            datum = new DefaultVerticalDatum(properties, type);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = (VerticalDatum)this.pool.unique(datum);
        return datum;
    }

    public TemporalDatum createTemporalDatum(Map properties, Date origin) throws FactoryException {
        TemporalDatum datum;
        try {
            datum = new DefaultTemporalDatum(properties, origin);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = (TemporalDatum)this.pool.unique(datum);
        return datum;
    }

    public EngineeringDatum createEngineeringDatum(Map properties) throws FactoryException {
        EngineeringDatum datum;
        try {
            datum = new DefaultEngineeringDatum(properties);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = (EngineeringDatum)this.pool.unique(datum);
        return datum;
    }

    public ImageDatum createImageDatum(Map properties, PixelInCell pixelInCell) throws FactoryException {
        ImageDatum datum;
        try {
            datum = new DefaultImageDatum(properties, pixelInCell);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = (ImageDatum)this.pool.unique(datum);
        return datum;
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(Map properties, String abbreviation, AxisDirection direction, Unit unit) throws FactoryException {
        CoordinateSystemAxis axis;
        try {
            axis = new DefaultCoordinateSystemAxis(properties, abbreviation, direction, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        axis = (CoordinateSystemAxis)this.pool.unique(axis);
        return axis;
    }

    public CartesianCS createCartesianCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        CartesianCS cs;
        try {
            cs = new DefaultCartesianCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (CartesianCS)this.pool.unique(cs);
        return cs;
    }

    public CartesianCS createCartesianCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        CartesianCS cs;
        try {
            cs = new DefaultCartesianCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (CartesianCS)this.pool.unique(cs);
        return cs;
    }

    public AffineCS createAffineCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        AffineCS cs;
        try {
            cs = new DefaultAffineCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (AffineCS)this.pool.unique(cs);
        return cs;
    }

    public AffineCS createAffineCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        AffineCS cs;
        try {
            cs = new DefaultAffineCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (AffineCS)this.pool.unique(cs);
        return cs;
    }

    public PolarCS createPolarCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        PolarCS cs;
        try {
            cs = new DefaultPolarCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (PolarCS)this.pool.unique(cs);
        return cs;
    }

    public CylindricalCS createCylindricalCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        CylindricalCS cs;
        try {
            cs = new DefaultCylindricalCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (CylindricalCS)this.pool.unique(cs);
        return cs;
    }

    public SphericalCS createSphericalCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        SphericalCS cs;
        try {
            cs = new DefaultSphericalCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (SphericalCS)this.pool.unique(cs);
        return cs;
    }

    public EllipsoidalCS createEllipsoidalCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        EllipsoidalCS cs;
        try {
            cs = new DefaultEllipsoidalCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (EllipsoidalCS)this.pool.unique(cs);
        return cs;
    }

    public EllipsoidalCS createEllipsoidalCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        EllipsoidalCS cs;
        try {
            cs = new DefaultEllipsoidalCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (EllipsoidalCS)this.pool.unique(cs);
        return cs;
    }

    public VerticalCS createVerticalCS(Map properties, CoordinateSystemAxis axis) throws FactoryException {
        VerticalCS cs;
        try {
            cs = new DefaultVerticalCS(properties, axis);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (VerticalCS)this.pool.unique(cs);
        return cs;
    }

    public TimeCS createTimeCS(Map properties, CoordinateSystemAxis axis) throws FactoryException {
        TimeCS cs;
        try {
            cs = new DefaultTimeCS(properties, axis);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (TimeCS)this.pool.unique(cs);
        return cs;
    }

    public LinearCS createLinearCS(Map properties, CoordinateSystemAxis axis) throws FactoryException {
        LinearCS cs;
        try {
            cs = new DefaultLinearCS(properties, axis);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (LinearCS)this.pool.unique(cs);
        return cs;
    }

    public UserDefinedCS createUserDefinedCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        UserDefinedCS cs;
        try {
            cs = new DefaultUserDefinedCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (UserDefinedCS)this.pool.unique(cs);
        return cs;
    }

    public UserDefinedCS createUserDefinedCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        UserDefinedCS cs;
        try {
            cs = new DefaultUserDefinedCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = (UserDefinedCS)this.pool.unique(cs);
        return cs;
    }

    public CompoundCRS createCompoundCRS(Map properties, CoordinateReferenceSystem[] elements) throws FactoryException {
        CompoundCRS crs;
        try {
            crs = new DefaultCompoundCRS(properties, elements);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (CompoundCRS)this.pool.unique(crs);
        return crs;
    }

    public EngineeringCRS createEngineeringCRS(Map properties, EngineeringDatum datum, CoordinateSystem cs) throws FactoryException {
        EngineeringCRS crs;
        try {
            crs = new DefaultEngineeringCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (EngineeringCRS)this.pool.unique(crs);
        return crs;
    }

    public ImageCRS createImageCRS(Map properties, ImageDatum datum, AffineCS cs) throws FactoryException {
        ImageCRS crs;
        try {
            crs = new DefaultImageCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (ImageCRS)this.pool.unique(crs);
        return crs;
    }

    public TemporalCRS createTemporalCRS(Map properties, TemporalDatum datum, TimeCS cs) throws FactoryException {
        TemporalCRS crs;
        try {
            crs = new DefaultTemporalCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (TemporalCRS)this.pool.unique(crs);
        return crs;
    }

    public VerticalCRS createVerticalCRS(Map properties, VerticalDatum datum, VerticalCS cs) throws FactoryException {
        VerticalCRS crs;
        try {
            crs = new DefaultVerticalCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (VerticalCRS)this.pool.unique(crs);
        return crs;
    }

    public GeocentricCRS createGeocentricCRS(Map properties, GeodeticDatum datum, CartesianCS cs) throws FactoryException {
        GeocentricCRS crs;
        try {
            crs = new DefaultGeocentricCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (GeocentricCRS)this.pool.unique(crs);
        return crs;
    }

    public GeocentricCRS createGeocentricCRS(Map properties, GeodeticDatum datum, SphericalCS cs) throws FactoryException {
        GeocentricCRS crs;
        try {
            crs = new DefaultGeocentricCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (GeocentricCRS)this.pool.unique(crs);
        return crs;
    }

    public GeographicCRS createGeographicCRS(Map properties, GeodeticDatum datum, EllipsoidalCS cs) throws FactoryException {
        GeographicCRS crs;
        try {
            crs = new DefaultGeographicCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (GeographicCRS)this.pool.unique(crs);
        return crs;
    }

    public DerivedCRS createDerivedCRS(Map properties, OperationMethod method, CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws FactoryException {
        DerivedCRS crs;
        try {
            crs = new DefaultDerivedCRS(properties, method, base, baseToDerived, derivedCS);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (DerivedCRS)this.pool.unique(crs);
        return crs;
    }

    public DerivedCRS createDerivedCRS(Map properties, CoordinateReferenceSystem baseCRS, Conversion conversionFromBase, CoordinateSystem derivedCS) throws FactoryException {
        throw new FactoryException("Not yet implemented.");
    }

    public ProjectedCRS createProjectedCRS(Map properties, OperationMethod method, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws FactoryException {
        ProjectedCRS crs;
        try {
            crs = new DefaultProjectedCRS(properties, method, base, baseToDerived, derivedCS);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = (ProjectedCRS)this.pool.unique(crs);
        return crs;
    }

    public ProjectedCRS createProjectedCRS(Map properties, GeographicCRS baseCRS, Conversion conversionFromBase, CartesianCS derivedCS) throws FactoryException {
        throw new FactoryException("Not yet implemented.");
    }

    public CoordinateReferenceSystem createFromXML(String xml) throws FactoryException {
        throw new FactoryException("Not yet implemented");
    }

    public synchronized CoordinateReferenceSystem createFromWKT(String wkt) throws FactoryException {
        if (this.parser == null) {
            Hints hints = new Hints(this.getImplementationHints());
            this.parser = new Parser(Symbols.DEFAULT, ReferencingFactoryFinder.getDatumFactory(hints), this, this, ReferencingFactoryFinder.getMathTransformFactory(hints));
        }
        try {
            return this.parser.parseCoordinateReferenceSystem(wkt);
        }
        catch (ParseException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception);
        }
    }
}

