/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.units.ConversionException;
import javax.units.Unit;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class ReferencingFactoryContainer
extends ReferencingFactory {
    private static FactoryRegistry cache;
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private MathTransformFactory mtFactory;
    private final ThreadLocal lastMethod = new ThreadLocal();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReferencingFactoryContainer(DatumFactory datumFactory, CSFactory csFactory, CRSFactory crsFactory, MathTransformFactory mtFactory) {
        this.datumFactory = datumFactory;
        this.csFactory = csFactory;
        this.crsFactory = crsFactory;
        this.mtFactory = mtFactory;
    }

    public ReferencingFactoryContainer(Hints userHints) {
        Hints reduced = new Hints((Map)userHints);
        this.datumFactory = (DatumFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.DATUM_FACTORY));
        this.csFactory = (CSFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.CS_FACTORY));
        this.crsFactory = (CRSFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.CRS_FACTORY));
        this.mtFactory = (MathTransformFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.MATH_TRANSFORM_FACTORY));
        if (!reduced.isEmpty()) {
            this.setHintsInto(reduced);
            this.hints.putAll(reduced);
            this.initialize();
            this.hints.clear();
        }
    }

    private static Factory extract(Map reduced, Hints.Key key) {
        Object candidate;
        if (reduced != null && (candidate = reduced.get(key)) instanceof Factory) {
            reduced.remove(key);
            return (Factory)candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencingFactoryContainer instance(Hints hints) {
        Hints completed = GeoTools.getDefaultHints();
        if (hints != null) {
            completed.add(hints);
        }
        Class clazz = ReferencingFactoryFinder.class;
        synchronized (clazz) {
            if (cache == null) {
                cache = new FactoryCreator(Arrays.asList(ReferencingFactoryContainer.class));
                cache.registerServiceProvider(new ReferencingFactoryContainer(null), ReferencingFactoryContainer.class);
            }
            Class clazz2 = ReferencingFactoryContainer.class;
            return (ReferencingFactoryContainer)cache.getServiceProvider(clazz2, null, completed, null);
        }
    }

    private void initialize() {
        this.mtFactory = this.getMathTransformFactory();
        this.datumFactory = this.getDatumFactory();
        this.csFactory = this.getCSFactory();
        this.crsFactory = this.getCRSFactory();
    }

    private void setHintsInto(Map hints) {
        if (this.crsFactory != null) {
            hints.put(Hints.CRS_FACTORY, this.crsFactory);
        }
        if (this.csFactory != null) {
            hints.put(Hints.CS_FACTORY, this.csFactory);
        }
        if (this.datumFactory != null) {
            hints.put(Hints.DATUM_FACTORY, this.datumFactory);
        }
        if (this.mtFactory != null) {
            hints.put(Hints.MATH_TRANSFORM_FACTORY, this.mtFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (this.hints.isEmpty()) {
                this.initialize();
                this.setHintsInto(this.hints);
            }
        }
        return super.getImplementationHints();
    }

    private Hints hints() {
        Hints completed = new Hints(this.hints);
        this.setHintsInto(completed);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.datumFactory = ReferencingFactoryFinder.getDatumFactory(this.hints());
            }
        }
        return this.datumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSFactory getCSFactory() {
        if (this.csFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.csFactory = ReferencingFactoryFinder.getCSFactory(this.hints());
            }
        }
        return this.csFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.crsFactory = ReferencingFactoryFinder.getCRSFactory(this.hints());
            }
        }
        return this.crsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(this.hints());
            }
        }
        return this.mtFactory;
    }

    public OperationMethod getOperationMethod(String name) throws NoSuchIdentifierException {
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        if (mtFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mtFactory).getOperationMethod(name);
        }
        Set operations = mtFactory.getAvailableMethods(Operation.class);
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            OperationMethod method = (OperationMethod)it.next();
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)method, name)) continue;
            return method;
        }
        throw new NoSuchIdentifierException(Errors.format(103, name), name);
    }

    public OperationMethod getLastUsedMethod() {
        Object candidate = this.lastMethod.get();
        if (candidate instanceof OperationMethod) {
            return (OperationMethod)candidate;
        }
        if (candidate instanceof String) {
            MathTransformFactory mtFactory = this.getMathTransformFactory();
            Set operations = mtFactory.getAvailableMethods(Operation.class);
            String classification = (String)candidate;
            Iterator it = operations.iterator();
            while (it.hasNext()) {
                OperationMethod method = (OperationMethod)it.next();
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)method.getParameters(), classification)) continue;
                this.lastMethod.set(method);
                return method;
            }
        }
        return null;
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        MathTransform transform = mtFactory.createParameterizedTransform(parameters);
        if (mtFactory instanceof DefaultMathTransformFactory) {
            this.lastMethod.set(((DefaultMathTransformFactory)mtFactory).getLastUsedMethod());
        } else {
            this.lastMethod.set(parameters.getDescriptor().getName().getCode());
        }
        return transform;
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameters, Collection methods) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform = this.createParameterizedTransform(parameters);
        if (methods != null) {
            methods.add(this.getLastUsedMethod());
        }
        return transform;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws NoSuchIdentifierException, FactoryException {
        int targetDim;
        int sourceDim;
        Matrix swap3;
        Matrix swap1;
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(baseCRS);
        if (ellipsoid != null) {
            Unit axisUnit = ellipsoid.getAxisUnit();
            Parameters.ensureSet(parameters, "semi_major", ellipsoid.getSemiMajorAxis(), axisUnit, false);
            Parameters.ensureSet(parameters, "semi_minor", ellipsoid.getSemiMinorAxis(), axisUnit, false);
        }
        CoordinateSystem sourceCS = baseCRS.getCoordinateSystem();
        try {
            swap1 = AbstractCS.swapAndScaleAxis(sourceCS, AbstractCS.standard(sourceCS));
            swap3 = AbstractCS.swapAndScaleAxis(AbstractCS.standard(derivedCS), derivedCS);
        }
        catch (IllegalArgumentException cause) {
            throw new FactoryException(cause);
        }
        catch (ConversionException cause) {
            throw new FactoryException(cause);
        }
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        MathTransform step1 = mtFactory.createAffineTransform(swap1);
        MathTransform step3 = mtFactory.createAffineTransform(swap3);
        MathTransform step2 = this.createParameterizedTransform(parameters);
        int numTrailingOrdinates = step3.getSourceDimensions() - step2.getTargetDimensions();
        if (numTrailingOrdinates > 0) {
            step2 = mtFactory.createPassThroughTransform(0, step2, numTrailingOrdinates);
        }
        if ((sourceDim = step1.getTargetDimensions()) > (targetDim = step2.getSourceDimensions())) {
            XMatrix drop = MatrixFactory.create(targetDim + 1, sourceDim + 1);
            drop.setElement(targetDim, sourceDim, 1.0);
            step1 = mtFactory.createConcatenatedTransform(mtFactory.createAffineTransform(drop), step1);
        }
        MathTransform transform = mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(step1, step2), step3);
        if (!$assertionsDisabled && !AbstractIdentifiedObject.nameMatches((IdentifiedObject)parameters.getDescriptor(), this.getLastUsedMethod())) {
            throw new AssertionError();
        }
        return transform;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS, Collection methods) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform = this.createBaseToDerived(baseCRS, parameters, derivedCS);
        if (methods != null) {
            methods.add(this.getLastUsedMethod());
        }
        return transform;
    }

    public ProjectedCRS createProjectedCRS(Map properties, GeographicCRS baseCRS, Conversion conversionFromBase, CartesianCS derivedCS) throws FactoryException {
        ParameterValueGroup parameters = conversionFromBase.getParameterValues();
        MathTransform mt = this.createBaseToDerived(baseCRS, parameters, derivedCS);
        OperationMethod method = conversionFromBase.getMethod();
        if (!(method instanceof MathTransformProvider) && !properties.containsKey("conversionType") && (method = this.getLastUsedMethod()) instanceof MathTransformProvider) {
            properties = new HashMap<String, Class>(properties);
            properties.put("conversionType", ((MathTransformProvider)method).getOperationType());
        }
        return new DefaultProjectedCRS((Map)properties, conversionFromBase, baseCRS, mt, derivedCS);
    }

    public ProjectedCRS createProjectedCRS(Map properties, GeographicCRS baseCRS, OperationMethod method, ParameterValueGroup parameters, CartesianCS derivedCS) throws FactoryException {
        MathTransform mt = this.createBaseToDerived(baseCRS, parameters, derivedCS);
        if (method == null) {
            method = this.getLastUsedMethod();
        }
        return this.getCRSFactory().createProjectedCRS(properties, method, baseCRS, mt, derivedCS);
    }

    public CoordinateReferenceSystem toGeodetic3D(CompoundCRS crs) throws FactoryException {
        SingleCRS[] components = DefaultCompoundCRS.getSingleCRS(crs);
        SingleCRS horizontal = null;
        VerticalCRS vertical = null;
        int hi = 0;
        int vi = 0;
        for (int i = 0; i < components.length; ++i) {
            SingleCRS candidate = components[i];
            if (candidate instanceof VerticalCRS) {
                if (vertical == null && VerticalDatumType.ELLIPSOIDAL.equals(((VerticalDatum)(vertical = (VerticalCRS)candidate).getDatum()).getVerticalDatumType())) {
                    vi = i;
                    continue;
                }
                return crs;
            }
            if (!(candidate instanceof GeographicCRS) && !(candidate instanceof ProjectedCRS)) continue;
            if (horizontal == null && (horizontal = candidate).getCoordinateSystem().getDimension() == 2) {
                hi = i;
                continue;
            }
            return crs;
        }
        if (horizontal != null && vertical != null && Math.abs(vi - hi) == 1) {
            boolean classic = hi < vi;
            SingleCRS single = this.toGeodetic3D(components.length == 2 ? crs : null, horizontal, vertical, classic);
            if (components.length == 2) {
                return single;
            }
            CoordinateReferenceSystem[] c = new CoordinateReferenceSystem[components.length - 1];
            int i = classic ? hi : vi;
            System.arraycopy(components, 0, c, 0, i);
            c[i] = single;
            System.arraycopy(components, i + 2, c, i + 1, components.length - (i + 2));
            return this.crsFactory.createCompoundCRS(AbstractIdentifiedObject.getProperties(crs), c);
        }
        return crs;
    }

    /*
     * WARNING - void declaration
     */
    private SingleCRS toGeodetic3D(CompoundCRS crs, SingleCRS horizontal, VerticalCRS vertical, boolean classic) throws FactoryException {
        void var11_11;
        SingleCRS single;
        Map crsName;
        Map csName;
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[3];
        CoordinateSystem cs = horizontal.getCoordinateSystem();
        axis[classic ? 0 : 1] = cs.getAxis(0);
        axis[classic ? 1 : 2] = cs.getAxis(1);
        axis[classic ? 2 : 0] = vertical.getCoordinateSystem().getAxis(0);
        if (crs != null) {
            csName = AbstractIdentifiedObject.getProperties(crs.getCoordinateSystem());
            crsName = AbstractIdentifiedObject.getProperties(crs);
        } else {
            csName = ReferencingFactoryContainer.getTemporaryName(cs);
            crsName = ReferencingFactoryContainer.getTemporaryName(horizontal);
        }
        CSFactory csFactory = this.getCSFactory();
        CRSFactory crsFactory = this.getCRSFactory();
        if (horizontal instanceof GeographicCRS) {
            single = crsFactory.createGeographicCRS(crsName, (GeodeticDatum)horizontal.getDatum(), csFactory.createEllipsoidalCS(csName, axis[0], axis[1], axis[2]));
        } else if (horizontal instanceof ProjectedCRS) {
            ProjectedCRS projected = (ProjectedCRS)horizontal;
            GeographicCRS baseCRS = (GeographicCRS)projected.getBaseCRS();
            baseCRS = (GeographicCRS)this.toGeodetic3D(null, baseCRS, vertical, classic);
            Conversion projection = projected.getConversionFromBase();
            single = this.createProjectedCRS(crsName, baseCRS, projection, csFactory.createCartesianCS(csName, axis[0], axis[1], axis[2]));
        } else {
            throw new AssertionError(horizontal);
        }
        return var11_11;
    }

    public CoordinateReferenceSystem separate(CoordinateReferenceSystem crs, int[] dimensions) throws FactoryException {
        int length = dimensions.length;
        int crsDimension = crs.getCoordinateSystem().getDimension();
        if (length == 0 || dimensions[0] < 0 || dimensions[length - 1] >= crsDimension || !XArray.isStrictlySorted(dimensions)) {
            throw new IllegalArgumentException(Errors.format(167, "dimension"));
        }
        if (length == crsDimension) {
            return crs;
        }
        if (crs instanceof CompoundCRS) {
            int count = 0;
            int lowerDimension = 0;
            int lowerIndex = 0;
            List sources = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Object[] targets = new CoordinateReferenceSystem[sources.size()];
            Iterator it = sources.iterator();
            block0: while (it.hasNext()) {
                CoordinateReferenceSystem source = (CoordinateReferenceSystem)it.next();
                int upperDimension = lowerDimension + source.getCoordinateSystem().getDimension();
                if (lowerIndex == dimensions.length) break;
                while (dimensions[lowerIndex] < lowerDimension) {
                    if (++lowerIndex != dimensions.length) continue;
                    break block0;
                }
                int upperIndex = lowerIndex;
                while (dimensions[upperIndex] < upperDimension && ++upperIndex != dimensions.length) {
                }
                if (lowerIndex != upperIndex) {
                    int[] sub = new int[upperIndex - lowerIndex];
                    for (int j = 0; j < sub.length; ++j) {
                        sub[j] = dimensions[j + lowerIndex] - lowerDimension;
                    }
                    targets[count++] = this.separate(source, sub);
                }
                lowerDimension = upperDimension;
                lowerIndex = upperIndex;
            }
            if (count == 1) {
                return targets[0];
            }
            return this.getCRSFactory().createCompoundCRS(ReferencingFactoryContainer.getTemporaryName(crs), (CoordinateReferenceSystem[])XArray.resize(targets, count));
        }
        throw new FactoryException(Errors.format(164, crs.getName().getCode()));
    }

    private static Map getTemporaryName(IdentifiedObject source) {
        return Collections.singletonMap("name", source.getName().getCode() + " (3D)");
    }

    static {
        $assertionsDisabled = !ReferencingFactoryContainer.class.desiredAssertionStatus();
    }
}

