/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Iterator;
import java.util.Set;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.AuthorityFactoryProxy;
import org.geotools.referencing.factory.ReferencingFactory;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public class IdentifiedObjectFinder {
    final AuthorityFactoryProxy proxy;
    private boolean fullScan = true;

    IdentifiedObjectFinder(IdentifiedObjectFinder finder) {
        this.proxy = finder.proxy;
    }

    protected IdentifiedObjectFinder(AuthorityFactory factory, Class type) {
        this.proxy = AuthorityFactoryProxy.getInstance(factory, type);
    }

    public boolean isFullScanAllowed() {
        return this.fullScan;
    }

    public void setFullScanAllowed(boolean fullScan) {
        this.fullScan = fullScan;
    }

    public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate = this.createFromIdentifiers(object);
        if (candidate != null) {
            return candidate;
        }
        candidate = this.createFromNames(object);
        if (candidate != null) {
            return candidate;
        }
        return this.fullScan ? this.createFromCodes(object) : null;
    }

    public String findIdentifier(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate = this.find(object);
        return candidate != null ? this.getIdentifier(candidate) : null;
    }

    final String getIdentifier(IdentifiedObject object) {
        ReferenceIdentifier identifier;
        Citation authority = this.proxy.getAuthorityFactory().getAuthority();
        if (ReferencingFactory.ALL.equals(authority)) {
            authority = null;
        }
        if ((identifier = AbstractIdentifiedObject.getIdentifier(object, authority)) == null) {
            identifier = object.getName();
        }
        String codespace = identifier.getCodeSpace();
        String code = identifier.getCode();
        if (codespace != null) {
            return codespace + ':' + code;
        }
        return code;
    }

    final IdentifiedObject createFromIdentifiers(IdentifiedObject object) throws FactoryException {
        Citation authority = this.proxy.getAuthorityFactory().getAuthority();
        boolean isAll = ReferencingFactory.ALL.equals(authority);
        Iterator it = object.getIdentifiers().iterator();
        while (it.hasNext()) {
            IdentifiedObject candidate;
            Identifier id = (Identifier)it.next();
            if (!isAll && !Citations.identifierMatches(authority, id.getAuthority())) continue;
            try {
                candidate = this.proxy.create(id.getCode());
            }
            catch (NoSuchAuthorityCodeException e) {
                continue;
            }
            if ((candidate = this.deriveEquivalent(candidate, object)) == null) continue;
            return candidate;
        }
        return null;
    }

    final IdentifiedObject createFromNames(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate;
        try {
            candidate = this.proxy.create(object.getName().getCode());
            candidate = this.deriveEquivalent(candidate, object);
            if (candidate != null) {
                return candidate;
            }
        }
        catch (FactoryException e) {
            // empty catch block
        }
        Iterator it = object.getAlias().iterator();
        while (it.hasNext()) {
            GenericName id = (GenericName)it.next();
            try {
                candidate = this.proxy.create(((Object)id).toString());
            }
            catch (FactoryException e) {
                continue;
            }
            if ((candidate = this.deriveEquivalent(candidate, object)) == null) continue;
            return candidate;
        }
        return null;
    }

    final IdentifiedObject createFromCodes(IdentifiedObject object) throws FactoryException {
        Set codes = this.getCodeCandidates(object);
        Iterator it = codes.iterator();
        while (it.hasNext()) {
            IdentifiedObject candidate;
            String code = (String)it.next();
            try {
                candidate = this.proxy.create(code);
            }
            catch (FactoryException e) {
                continue;
            }
            if ((candidate = this.deriveEquivalent(candidate, object)) == null) continue;
            return candidate;
        }
        return null;
    }

    protected Set getCodeCandidates(IdentifiedObject object) throws FactoryException {
        return this.proxy.getAuthorityCodes();
    }

    protected IdentifiedObject deriveEquivalent(IdentifiedObject candidate, IdentifiedObject model) throws FactoryException {
        return CRS.equalsIgnoreMetadata(candidate, model) ? candidate : null;
    }

    public String toString() {
        return this.proxy.toString(IdentifiedObjectFinder.class);
    }

    static class Adapter
    extends IdentifiedObjectFinder {
        protected final IdentifiedObjectFinder finder;

        protected Adapter(IdentifiedObjectFinder finder) {
            super(finder);
            this.finder = finder;
        }

        public void setFullScanAllowed(boolean fullScan) {
            this.finder.setFullScanAllowed(fullScan);
            super.setFullScanAllowed(fullScan);
        }

        protected Set getCodeCandidates(IdentifiedObject object) throws FactoryException {
            return this.finder.getCodeCandidates(object);
        }

        protected IdentifiedObject deriveEquivalent(IdentifiedObject candidate, IdentifiedObject model) throws FactoryException {
            return this.finder.deriveEquivalent(candidate, model);
        }
    }
}

