/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.units.Unit;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class FallbackAuthorityFactory
extends AuthorityFactoryAdapter {
    private final AbstractAuthorityFactory fallback;
    private static int failureCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    static boolean chainable(AuthorityFactory primary, AuthorityFactory fallback) {
        return (FallbackAuthorityFactory.interfaceMask(primary) & FallbackAuthorityFactory.interfaceMask(fallback)) != 0;
    }

    protected FallbackAuthorityFactory(AuthorityFactory primary, AuthorityFactory fallback) {
        super(primary, fallback);
        FallbackAuthorityFactory.ensureNonNull("fallback", fallback);
        this.fallback = fallback instanceof AbstractAuthorityFactory ? (AbstractAuthorityFactory)fallback : new AuthorityFactoryAdapter(fallback);
    }

    public static AuthorityFactory create(Class type, Collection factories) throws FactoryNotFoundException, ClassCastException {
        FallbackAuthorityFactory.ensureNonNull("type", type);
        FallbackAuthorityFactory.ensureNonNull("factories", factories);
        if (factories.isEmpty()) {
            throw new FactoryNotFoundException(Errors.format(189, Utilities.getShortName(type)));
        }
        return FallbackAuthorityFactory.create(false, FallbackAuthorityFactory.interfaceMask(type), factories.iterator());
    }

    public static AuthorityFactory create(Collection factories) throws FactoryNotFoundException {
        FallbackAuthorityFactory.ensureNonNull("factories", factories);
        if (factories.isEmpty()) {
            throw new FactoryNotFoundException(Errors.format(189, Utilities.getShortName(AuthorityFactory.class)));
        }
        return FallbackAuthorityFactory.create(false, FallbackAuthorityFactory.interfaceMask(factories), factories.iterator());
    }

    private static AuthorityFactory create(boolean automatic, int interfaceMask, Iterator factories) throws FactoryNotFoundException {
        AuthorityFactory primary = (AuthorityFactory)factories.next();
        if (factories.hasNext()) {
            AuthorityFactory fallback = FallbackAuthorityFactory.create(true, interfaceMask, factories);
            while (fallback != primary) {
                if (!FallbackAuthorityFactory.sameAuthorityCodes(fallback, primary)) {
                    if (automatic) {
                        interfaceMask &= FallbackAuthorityFactory.interfaceMask(primary) | FallbackAuthorityFactory.interfaceMask(fallback);
                    }
                    primary = FallbackAuthorityFactory.create(interfaceMask, primary, fallback);
                    break;
                }
                if (!(fallback instanceof FallbackAuthorityFactory)) break;
                fallback = ((FallbackAuthorityFactory)fallback).fallback;
            }
        }
        return primary;
    }

    Collection dependencies() {
        Collection dep = super.dependencies();
        dep.add(this.fallback);
        return dep;
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        LinkedHashSet codes = new LinkedHashSet(super.getAuthorityCodes(type));
        codes.addAll(this.fallback.getAuthorityCodes(type));
        return codes;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        try {
            return super.getDescriptionText(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("getDescriptionText", exception);
            try {
                return this.fallback.getDescriptionText(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        try {
            return super.createObject(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createObject", exception);
            try {
                return this.fallback.createObject(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public org.opengis.referencing.datum.Datum createDatum(String code) throws FactoryException {
        try {
            return super.createDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createDatum", exception);
            try {
                return this.fallback.createDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        try {
            return super.createEngineeringDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEngineeringDatum", exception);
            try {
                return this.fallback.createEngineeringDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public ImageDatum createImageDatum(String code) throws FactoryException {
        try {
            return super.createImageDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createImageDatum", exception);
            try {
                return this.fallback.createImageDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        try {
            return super.createVerticalDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createVerticalDatum", exception);
            try {
                return this.fallback.createVerticalDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        try {
            return super.createTemporalDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createTemporalDatum", exception);
            try {
                return this.fallback.createTemporalDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        try {
            return super.createGeodeticDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createGeodeticDatum", exception);
            try {
                return this.fallback.createGeodeticDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        try {
            return super.createEllipsoid(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEllipsoid", exception);
            try {
                return this.fallback.createEllipsoid(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        try {
            return super.createPrimeMeridian(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createPrimeMeridian", exception);
            try {
                return this.fallback.createPrimeMeridian(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public Extent createExtent(String code) throws FactoryException {
        try {
            return super.createExtent(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createExtent", exception);
            try {
                return this.fallback.createExtent(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        try {
            return super.createCoordinateSystem(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateSystem", exception);
            try {
                return this.fallback.createCoordinateSystem(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public CartesianCS createCartesianCS(String code) throws FactoryException {
        try {
            return super.createCartesianCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCartesianCS", exception);
            try {
                return this.fallback.createCartesianCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public PolarCS createPolarCS(String code) throws FactoryException {
        try {
            return super.createPolarCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createPolarCS", exception);
            try {
                return this.fallback.createPolarCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        try {
            return super.createCylindricalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCylindricalCS", exception);
            try {
                return this.fallback.createCylindricalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public SphericalCS createSphericalCS(String code) throws FactoryException {
        try {
            return super.createSphericalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createSphericalCS", exception);
            try {
                return this.fallback.createSphericalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        try {
            return super.createEllipsoidalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEllipsoidalCS", exception);
            try {
                return this.fallback.createEllipsoidalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public VerticalCS createVerticalCS(String code) throws FactoryException {
        try {
            return super.createVerticalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createVerticalCS", exception);
            try {
                return this.fallback.createVerticalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public TimeCS createTimeCS(String code) throws FactoryException {
        try {
            return super.createTimeCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createTimeCS", exception);
            try {
                return this.fallback.createTimeCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        try {
            return super.createCoordinateSystemAxis(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateSystemAxis", exception);
            try {
                return this.fallback.createCoordinateSystemAxis(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public Unit createUnit(String code) throws FactoryException {
        try {
            return super.createUnit(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createUnit", exception);
            try {
                return this.fallback.createUnit(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        try {
            return super.createCoordinateReferenceSystem(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateReferenceSystem", exception);
            try {
                return this.fallback.createCoordinateReferenceSystem(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        try {
            return super.createCompoundCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCompoundCRS", exception);
            try {
                return this.fallback.createCompoundCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        try {
            return super.createDerivedCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createDerivedCRS", exception);
            try {
                return this.fallback.createDerivedCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        try {
            return super.createEngineeringCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEngineeringCRS", exception);
            try {
                return this.fallback.createEngineeringCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        try {
            return super.createGeographicCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createGeographicCRS", exception);
            try {
                return this.fallback.createGeographicCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        try {
            return super.createGeocentricCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createGeocentricCRS", exception);
            try {
                return this.fallback.createGeocentricCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public ImageCRS createImageCRS(String code) throws FactoryException {
        try {
            return super.createImageCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createImageCRS", exception);
            try {
                return this.fallback.createImageCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        try {
            return super.createProjectedCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createProjectedCRS", exception);
            try {
                return this.fallback.createProjectedCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        try {
            return super.createTemporalCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createTemporalCRS", exception);
            try {
                return this.fallback.createTemporalCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        try {
            return super.createVerticalCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createVerticalCRS", exception);
            try {
                return this.fallback.createVerticalCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        try {
            return super.createParameterDescriptor(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createParameterDescriptor", exception);
            try {
                return this.fallback.createParameterDescriptor(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public OperationMethod createOperationMethod(String code) throws FactoryException {
        try {
            return super.createOperationMethod(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createOperationMethod", exception);
            try {
                return this.fallback.createOperationMethod(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        try {
            return super.createCoordinateOperation(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateOperation", exception);
            try {
                return this.fallback.createCoordinateOperation(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        try {
            return super.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createFromCoordinateReferenceSystemCodes", exception);
            try {
                return this.fallback.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new Finder(type);
    }

    private static void notifyFailure(String method, FactoryException exception) {
        ++failureCount;
        if (LOGGER.isLoggable(Level.FINE)) {
            LogRecord record = Logging.format(Level.FINE, 45, exception);
            record.setSourceClassName(FallbackAuthorityFactory.class.getName());
            record.setSourceMethodName(method);
            LOGGER.log(record);
        }
    }

    static int getFailureCount() {
        return failureCount;
    }

    private static int interfaceMask(Collection factories) {
        int mask = 0;
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            mask |= FallbackAuthorityFactory.interfaceMask((AuthorityFactory)it.next());
        }
        return mask;
    }

    private static int interfaceMask(AuthorityFactory factory) {
        return FallbackAuthorityFactory.interfaceMask(factory.getClass());
    }

    private static int interfaceMask(Class type) {
        int mask = 0;
        if (CoordinateOperationAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 1;
        }
        if (CSAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 2;
        }
        if (DatumAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 4;
        }
        if (CRSAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 8;
        }
        return mask;
    }

    /*
     * WARNING - void declaration
     */
    private static AuthorityFactory create(int mask, AuthorityFactory primary, AuthorityFactory fallback) {
        void var3_3;
        if (!$assertionsDisabled && (mask & ~(FallbackAuthorityFactory.interfaceMask(primary) | FallbackAuthorityFactory.interfaceMask(fallback))) != 0) {
            throw new AssertionError(mask);
        }
        switch (mask) {
            case 15: {
                FallbackAuthorityFactory factory = new All(primary, fallback);
                break;
            }
            case 14: {
                FallbackAuthorityFactory factory = new CRS_Datum_CS(primary, fallback);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                FallbackAuthorityFactory factory = new CRS(primary, fallback);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                FallbackAuthorityFactory factory = new Datum(primary, fallback);
                break;
            }
            case 2: 
            case 3: {
                FallbackAuthorityFactory factory = new CS(primary, fallback);
                break;
            }
            case 1: {
                FallbackAuthorityFactory factory = new Operation(primary, fallback);
                break;
            }
            case 0: {
                FallbackAuthorityFactory factory = new FallbackAuthorityFactory(primary, fallback);
                break;
            }
            default: {
                throw new AssertionError(mask);
            }
        }
        if (!$assertionsDisabled && (FallbackAuthorityFactory.interfaceMask((AuthorityFactory)var3_3) & ~mask) != 0) {
            throw new AssertionError(mask);
        }
        return var3_3;
    }

    static {
        $assertionsDisabled = !FallbackAuthorityFactory.class.desiredAssertionStatus();
    }

    private static final class All
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory,
    CSAuthorityFactory,
    DatumAuthorityFactory,
    CoordinateOperationAuthorityFactory {
        All(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class CRS_Datum_CS
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory,
    CSAuthorityFactory,
    DatumAuthorityFactory {
        CRS_Datum_CS(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class Operation
    extends FallbackAuthorityFactory
    implements CoordinateOperationAuthorityFactory {
        Operation(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class Datum
    extends FallbackAuthorityFactory
    implements DatumAuthorityFactory {
        Datum(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class CS
    extends FallbackAuthorityFactory
    implements CSAuthorityFactory {
        CS(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class CRS
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory {
        CRS(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private final class Finder
    extends AuthorityFactoryAdapter.Finder {
        private transient IdentifiedObjectFinder fallback;

        Finder(Class type) throws FactoryException {
            super(type);
        }

        private void ensureFallback() throws FactoryException {
            if (this.fallback == null) {
                this.fallback = FallbackAuthorityFactory.this.fallback.getIdentifiedObjectFinder(this.proxy.getType());
            }
            this.fallback.setFullScanAllowed(this.isFullScanAllowed());
        }

        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = this.finder.find(object);
            if (candidate != null) {
                return candidate;
            }
            this.ensureFallback();
            candidate = this.fallback.find(object);
            return candidate;
        }

        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            String candidate = this.finder.findIdentifier(object);
            if (candidate != null) {
                return candidate;
            }
            this.ensureFallback();
            candidate = this.fallback.findIdentifier(object);
            return candidate;
        }
    }
}

