/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.units.Unit;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class AuthorityFactoryAdapter
extends AbstractAuthorityFactory
implements OptionalFactory {
    private static final Hints.Key[] TYPES = new Hints.Key[]{Hints.CRS_AUTHORITY_FACTORY, Hints.CS_AUTHORITY_FACTORY, Hints.DATUM_AUTHORITY_FACTORY, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY};
    protected final DatumAuthorityFactory datumFactory;
    protected final CSAuthorityFactory csFactory;
    protected final CRSAuthorityFactory crsFactory;
    protected final CoordinateOperationAuthorityFactory operationFactory;
    private transient ReferencingFactoryContainer factories;

    AuthorityFactoryAdapter(int priority) {
        super(priority);
        this.datumFactory = null;
        this.csFactory = null;
        this.crsFactory = null;
        this.operationFactory = null;
    }

    protected AuthorityFactoryAdapter(AuthorityFactory factory) {
        this(factory, null);
    }

    AuthorityFactoryAdapter(AuthorityFactory factory, AuthorityFactory fallback) {
        this(factory instanceof CRSAuthorityFactory ? (CRSAuthorityFactory)factory : (fallback instanceof CRSAuthorityFactory ? (CRSAuthorityFactory)fallback : null), factory instanceof CSAuthorityFactory ? (CSAuthorityFactory)factory : (fallback instanceof CSAuthorityFactory ? (CSAuthorityFactory)fallback : null), factory instanceof DatumAuthorityFactory ? (DatumAuthorityFactory)factory : (fallback instanceof DatumAuthorityFactory ? (DatumAuthorityFactory)fallback : null), factory instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)factory : (fallback instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)fallback : null));
    }

    protected AuthorityFactoryAdapter(CRSAuthorityFactory crsFactory, CSAuthorityFactory csFactory, DatumAuthorityFactory datumFactory, CoordinateOperationAuthorityFactory opFactory) {
        super(Math.max(AuthorityFactoryAdapter.getPriority(datumFactory), Math.max(AuthorityFactoryAdapter.getPriority(csFactory), Math.max(AuthorityFactoryAdapter.getPriority(crsFactory), AuthorityFactoryAdapter.getPriority(opFactory)))));
        if (this instanceof CRSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("crsFactory", crsFactory);
        }
        if (this instanceof CSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("csFactory", csFactory);
        }
        if (this instanceof DatumAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("datumFactory", datumFactory);
        }
        if (this instanceof CoordinateOperationAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("opFactory", opFactory);
        }
        this.datumFactory = datumFactory;
        this.store(Hints.DATUM_AUTHORITY_FACTORY, this.datumFactory);
        this.csFactory = csFactory;
        this.store(Hints.CS_AUTHORITY_FACTORY, this.csFactory);
        this.crsFactory = crsFactory;
        this.store(Hints.CRS_AUTHORITY_FACTORY, this.crsFactory);
        this.operationFactory = opFactory;
        this.store(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.operationFactory);
    }

    private static int getPriority(AuthorityFactory factory) {
        return factory instanceof AbstractFactory ? ((AbstractFactory)((Object)factory)).getPriority() : 50;
    }

    private void store(Hints.Key key, AuthorityFactory factory) {
        if (factory != null && this.hints.put(key, factory) != null) {
            throw new AssertionError(key);
        }
    }

    protected AuthorityFactoryAdapter(String authority, Hints userHints) throws FactoryRegistryException {
        this(ReferencingFactoryFinder.getCRSAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.CRS_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getCSAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.CS_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getDatumAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.DATUM_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY)));
    }

    private static Hints trim(Hints userHints, Hints.Key keep) {
        Hints reduced = userHints;
        if (userHints != null) {
            for (int i = 0; i < TYPES.length; ++i) {
                Hints.Key key = TYPES[i];
                if (keep.equals(key)) continue;
                if (reduced == userHints) {
                    if (!userHints.containsKey(key)) continue;
                    reduced = new Hints((Map)userHints);
                }
                reduced.remove(key);
            }
        }
        return reduced;
    }

    private Hints hints() {
        Hints extended = new Hints(this.hints);
        AuthorityFactoryAdapter.addAll(this.operationFactory, extended);
        AuthorityFactoryAdapter.addAll(this.datumFactory, extended);
        AuthorityFactoryAdapter.addAll(this.csFactory, extended);
        AuthorityFactoryAdapter.addAll(this.crsFactory, extended);
        extended.putAll((Map<?, ?>)this.hints);
        return extended;
    }

    private static void addAll(AuthorityFactory factory, Hints hints) {
        if (factory instanceof Factory) {
            hints.putAll((Map<?, ?>)((Factory)((Object)factory)).getImplementationHints());
        }
    }

    Collection dependencies() {
        Object factory;
        ArrayList<Object> dep = new ArrayList<Object>(4);
        try {
            factory = this.getAuthorityFactory(null);
        }
        catch (FactoryException e) {
            factory = e;
        }
        dep.add(factory);
        return dep;
    }

    boolean sameAuthorityCodes(AuthorityFactory factory) {
        if (!this.isCodeMethodOverriden() && AuthorityFactoryAdapter.sameAuthorityCodes(this.crsFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.csFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.datumFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.operationFactory, factory)) {
            return true;
        }
        return super.sameAuthorityCodes(factory);
    }

    static boolean sameAuthorityCodes(AuthorityFactory backingStore, AuthorityFactory factory) {
        if (backingStore instanceof AbstractAuthorityFactory && ((AbstractAuthorityFactory)backingStore).sameAuthorityCodes(factory)) {
            return true;
        }
        return factory == backingStore || backingStore == null;
    }

    public boolean isAvailable() {
        return AuthorityFactoryAdapter.isAvailable(this.crsFactory) && AuthorityFactoryAdapter.isAvailable(this.csFactory) && AuthorityFactoryAdapter.isAvailable(this.datumFactory) && AuthorityFactoryAdapter.isAvailable(this.operationFactory);
    }

    private static boolean isAvailable(AuthorityFactory factory) {
        return !(factory instanceof OptionalFactory) || ((OptionalFactory)((Object)factory)).isAvailable();
    }

    Unit replace(Unit units) throws FactoryException {
        return units;
    }

    CoordinateSystemAxis replace(CoordinateSystemAxis axis) throws FactoryException {
        return axis;
    }

    CoordinateSystem replace(CoordinateSystem cs) throws FactoryException {
        return cs;
    }

    Datum replace(Datum datum) throws FactoryException {
        return datum;
    }

    CoordinateReferenceSystem replace(CoordinateReferenceSystem crs) throws FactoryException {
        return crs;
    }

    CoordinateOperation replace(CoordinateOperation operation) throws FactoryException {
        return operation;
    }

    private IdentifiedObject replaceObject(IdentifiedObject object) throws FactoryException {
        if (object instanceof CoordinateReferenceSystem) {
            return this.replace((CoordinateReferenceSystem)object);
        }
        if (object instanceof CoordinateSystem) {
            return this.replace((CoordinateSystem)object);
        }
        if (object instanceof CoordinateSystemAxis) {
            return this.replace((CoordinateSystemAxis)object);
        }
        if (object instanceof Datum) {
            return this.replace((Datum)object);
        }
        if (object instanceof CoordinateOperation) {
            return this.replace((CoordinateOperation)object);
        }
        return object;
    }

    private AbstractAuthorityFactory getGeotoolsFactory(String caller, String code) throws FactoryException {
        AuthorityFactory candidate = this.getAuthorityFactory(code);
        if (candidate instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)candidate;
        }
        if (caller == null) {
            return null;
        }
        throw new FactoryException(Errors.format(166, caller));
    }

    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory factory = this.getGeotoolsFactory(null, null);
        return factory != null ? factory.getBackingStoreDescription() : null;
    }

    public Citation getVendor() {
        return this.getAuthorityFactory().getVendor();
    }

    public Citation getAuthority() {
        return this.getAuthorityFactory().getAuthority();
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        return this.getAuthorityFactory(null).getAuthorityCodes(type);
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getAuthorityFactory(code).getDescriptionText(this.toBackingFactoryCode(code));
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.replaceObject(this.getAuthorityFactory(code).createObject(this.toBackingFactoryCode(code)));
    }

    public Datum createDatum(String code) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(code).createDatum(this.toBackingFactoryCode(code)));
    }

    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return (EngineeringDatum)this.replace(this.getDatumAuthorityFactory(code).createEngineeringDatum(this.toBackingFactoryCode(code)));
    }

    public ImageDatum createImageDatum(String code) throws FactoryException {
        return (ImageDatum)this.replace(this.getDatumAuthorityFactory(code).createImageDatum(this.toBackingFactoryCode(code)));
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return (VerticalDatum)this.replace(this.getDatumAuthorityFactory(code).createVerticalDatum(this.toBackingFactoryCode(code)));
    }

    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return (TemporalDatum)this.replace(this.getDatumAuthorityFactory(code).createTemporalDatum(this.toBackingFactoryCode(code)));
    }

    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return (GeodeticDatum)this.replace(this.getDatumAuthorityFactory(code).createGeodeticDatum(this.toBackingFactoryCode(code)));
    }

    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createEllipsoid(this.toBackingFactoryCode(code));
    }

    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createPrimeMeridian(this.toBackingFactoryCode(code));
    }

    public Extent createExtent(String code) throws FactoryException {
        return this.getGeotoolsFactory("createExtent", code).createExtent(this.toBackingFactoryCode(code));
    }

    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createCoordinateSystem(this.toBackingFactoryCode(code)));
    }

    public CartesianCS createCartesianCS(String code) throws FactoryException {
        return (CartesianCS)this.replace(this.getCSAuthorityFactory(code).createCartesianCS(this.toBackingFactoryCode(code)));
    }

    public PolarCS createPolarCS(String code) throws FactoryException {
        return (PolarCS)this.replace(this.getCSAuthorityFactory(code).createPolarCS(this.toBackingFactoryCode(code)));
    }

    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        return (CylindricalCS)this.replace(this.getCSAuthorityFactory(code).createCylindricalCS(this.toBackingFactoryCode(code)));
    }

    public SphericalCS createSphericalCS(String code) throws FactoryException {
        return (SphericalCS)this.replace(this.getCSAuthorityFactory(code).createSphericalCS(this.toBackingFactoryCode(code)));
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        return (EllipsoidalCS)this.replace(this.getCSAuthorityFactory(code).createEllipsoidalCS(this.toBackingFactoryCode(code)));
    }

    public VerticalCS createVerticalCS(String code) throws FactoryException {
        return (VerticalCS)this.replace(this.getCSAuthorityFactory(code).createVerticalCS(this.toBackingFactoryCode(code)));
    }

    public TimeCS createTimeCS(String code) throws FactoryException {
        return (TimeCS)this.replace(this.getCSAuthorityFactory(code).createTimeCS(this.toBackingFactoryCode(code)));
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createCoordinateSystemAxis(this.toBackingFactoryCode(code)));
    }

    public Unit createUnit(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createUnit(this.toBackingFactoryCode(code)));
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(code).createCoordinateReferenceSystem(this.toBackingFactoryCode(code)));
    }

    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return (CompoundCRS)this.replace(this.getCRSAuthorityFactory(code).createCompoundCRS(this.toBackingFactoryCode(code)));
    }

    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return (DerivedCRS)this.replace(this.getCRSAuthorityFactory(code).createDerivedCRS(this.toBackingFactoryCode(code)));
    }

    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return (EngineeringCRS)this.replace(this.getCRSAuthorityFactory(code).createEngineeringCRS(this.toBackingFactoryCode(code)));
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return (GeographicCRS)this.replace(this.getCRSAuthorityFactory(code).createGeographicCRS(this.toBackingFactoryCode(code)));
    }

    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return (GeocentricCRS)this.replace(this.getCRSAuthorityFactory(code).createGeocentricCRS(this.toBackingFactoryCode(code)));
    }

    public ImageCRS createImageCRS(String code) throws FactoryException {
        return (ImageCRS)this.replace(this.getCRSAuthorityFactory(code).createImageCRS(this.toBackingFactoryCode(code)));
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return (ProjectedCRS)this.replace(this.getCRSAuthorityFactory(code).createProjectedCRS(this.toBackingFactoryCode(code)));
    }

    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return (TemporalCRS)this.replace(this.getCRSAuthorityFactory(code).createTemporalCRS(this.toBackingFactoryCode(code)));
    }

    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return (VerticalCRS)this.replace(this.getCRSAuthorityFactory(code).createVerticalCRS(this.toBackingFactoryCode(code)));
    }

    public ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        return this.getGeotoolsFactory("createParameterDescriptor", code).createParameterDescriptor(this.toBackingFactoryCode(code));
    }

    public OperationMethod createOperationMethod(String code) throws FactoryException {
        return this.getGeotoolsFactory("createOperationMethod", code).createOperationMethod(this.toBackingFactoryCode(code));
    }

    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        return this.replace(this.getCoordinateOperationAuthorityFactory(code).createCoordinateOperation(this.toBackingFactoryCode(code)));
    }

    public Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        CoordinateOperationAuthorityFactory check;
        CoordinateOperationAuthorityFactory factory = this.getCoordinateOperationAuthorityFactory(sourceCode);
        if (factory != (check = this.getCoordinateOperationAuthorityFactory(targetCode))) {
            LogRecord record = Logging.format(Level.WARNING, 40, sourceCode, targetCode);
            record.setSourceMethodName("createFromCoordinateReferenceSystemCodes");
            record.setSourceClassName(AuthorityFactoryAdapter.class.getName());
            LOGGER.log(record);
            return Collections.EMPTY_SET;
        }
        return factory.createFromCoordinateReferenceSystemCodes(this.toBackingFactoryCode(sourceCode), this.toBackingFactoryCode(targetCode));
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new Finder(type);
    }

    private FactoryException missingFactory(Class category, String code) {
        return new NoSuchAuthorityCodeException(Errors.format(189, Utilities.getShortName(category)), Citations.getIdentifier(this.getAuthority()), this.trimAuthority(code));
    }

    private AuthorityFactory getAuthorityFactory() {
        try {
            return this.getAuthorityFactory(null);
        }
        catch (FactoryException cause) {
            IllegalStateException e = new IllegalStateException(Errors.format(125));
            e.initCause(cause);
            throw e;
        }
    }

    AuthorityFactory getAuthorityFactory(Class type, String code) throws FactoryException {
        if (CRSAuthorityFactory.class.equals(type)) {
            return this.getCRSAuthorityFactory(code);
        }
        if (CSAuthorityFactory.class.equals(type)) {
            return this.getCSAuthorityFactory(code);
        }
        if (DatumAuthorityFactory.class.equals(type)) {
            return this.getDatumAuthorityFactory(code);
        }
        if (CoordinateOperationAuthorityFactory.class.equals(type)) {
            return this.getCoordinateOperationAuthorityFactory(code);
        }
        throw new IllegalArgumentException(Errors.format(42, "type", type));
    }

    protected AuthorityFactory getAuthorityFactory(String code) throws FactoryException {
        if (this.crsFactory != null) {
            return this.crsFactory;
        }
        if (this.csFactory != null) {
            return this.csFactory;
        }
        if (this.datumFactory != null) {
            return this.datumFactory;
        }
        if (this.operationFactory != null) {
            return this.operationFactory;
        }
        throw this.missingFactory(AuthorityFactory.class, code);
    }

    protected DatumAuthorityFactory getDatumAuthorityFactory(String code) throws FactoryException {
        if (this.datumFactory == null) {
            throw this.missingFactory(DatumAuthorityFactory.class, code);
        }
        return this.datumFactory;
    }

    protected CSAuthorityFactory getCSAuthorityFactory(String code) throws FactoryException {
        if (this.csFactory == null) {
            throw this.missingFactory(CSAuthorityFactory.class, code);
        }
        return this.csFactory;
    }

    protected CRSAuthorityFactory getCRSAuthorityFactory(String code) throws FactoryException {
        if (this.crsFactory == null) {
            throw this.missingFactory(CRSAuthorityFactory.class, code);
        }
        return this.crsFactory;
    }

    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws FactoryException {
        if (this.operationFactory == null) {
            throw this.missingFactory(CoordinateOperationAuthorityFactory.class, code);
        }
        return this.operationFactory;
    }

    final CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryException {
        Factory factory;
        Map hints;
        Object candidate;
        if (this.operationFactory instanceof Factory && (candidate = (hints = (factory = (Factory)((Object)this.operationFactory)).getImplementationHints()).get(Hints.COORDINATE_OPERATION_FACTORY)) instanceof CoordinateOperationFactory) {
            return (CoordinateOperationFactory)candidate;
        }
        return ReferencingFactoryFinder.getCoordinateOperationFactory(this.hints());
    }

    final ReferencingFactoryContainer getFactoryContainer(boolean crs) {
        AuthorityFactory factory = crs ? this.crsFactory : this.csFactory;
        if (factory instanceof DirectAuthorityFactory) {
            return ((DirectAuthorityFactory)factory).factories;
        }
        if (this.factories == null) {
            this.factories = ReferencingFactoryContainer.instance(this.hints());
        }
        return this.factories;
    }

    protected String toBackingFactoryCode(String code) throws FactoryException {
        return code;
    }

    final boolean isCodeMethodOverriden() {
        Class[] arguments = new Class[]{String.class};
        Class<?> type = this.getClass();
        while (!(class$org$geotools$referencing$factory$AuthorityFactoryAdapter == null ? AuthorityFactoryAdapter.class$("org.geotools.referencing.factory.AuthorityFactoryAdapter") : class$org$geotools$referencing$factory$AuthorityFactoryAdapter).equals(type)) {
            block4: {
                try {
                    type.getDeclaredMethod("toBackingFactoryCode", arguments);
                }
                catch (NoSuchMethodException e) {
                    break block4;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    class Finder
    extends IdentifiedObjectFinder.Adapter {
        protected Finder(Class type) throws FactoryException {
            super(AuthorityFactoryAdapter.this.getGeotoolsFactory("getIdentifiedObjectFinder", null).getIdentifiedObjectFinder(type));
        }

        protected IdentifiedObject deriveEquivalent(IdentifiedObject candidate, IdentifiedObject model) throws FactoryException {
            IdentifiedObject modified = AuthorityFactoryAdapter.this.replaceObject(candidate);
            if (modified != candidate && CRS.equalsIgnoreMetadata(modified, model)) {
                return modified;
            }
            return super.deriveEquivalent(candidate, model);
        }
    }
}

