/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class AllAuthoritiesFactory
extends ManyAuthoritiesFactory {
    public static AllAuthoritiesFactory DEFAULT = new AllAuthoritiesFactory(null);
    private Collection authorityNames;

    public AllAuthoritiesFactory(Hints hints) {
        this(hints, null);
    }

    public AllAuthoritiesFactory(Hints hints, Collection factories) {
        this(hints, factories, '\u0000');
    }

    public AllAuthoritiesFactory(Hints hints, Collection factories, char separator) {
        super(hints, factories, separator);
        if (hints != null) {
            this.hints.putAll(hints);
        }
    }

    public Set getAuthorityNames() {
        return ReferencingFactoryFinder.getAuthorityNames();
    }

    synchronized Collection getFactories() {
        Set authorities = ReferencingFactoryFinder.getAuthorityNames();
        if (authorities != this.authorityNames) {
            this.authorityNames = authorities;
            Hints hints = this.getHints();
            LinkedHashSet factories = new LinkedHashSet();
            factories.addAll(ReferencingFactoryFinder.getCRSAuthorityFactories(hints));
            factories.addAll(ReferencingFactoryFinder.getCSAuthorityFactories(hints));
            factories.addAll(ReferencingFactoryFinder.getDatumAuthorityFactories(hints));
            factories.addAll(ReferencingFactoryFinder.getCoordinateOperationAuthorityFactories(hints));
            this.setFactories(factories);
        }
        return super.getFactories();
    }

    final AuthorityFactory fromFactoryRegistry(String authority, Class type) throws FactoryRegistryException {
        if (CRSAuthorityFactory.class.equals(type)) {
            return ReferencingFactoryFinder.getCRSAuthorityFactory(authority, this.getHints());
        }
        if (CSAuthorityFactory.class.equals(type)) {
            return ReferencingFactoryFinder.getCSAuthorityFactory(authority, this.getHints());
        }
        if (DatumAuthorityFactory.class.equals(type)) {
            return ReferencingFactoryFinder.getDatumAuthorityFactory(authority, this.getHints());
        }
        if (CoordinateOperationAuthorityFactory.class.equals(type)) {
            return ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(authority, this.getHints());
        }
        return super.fromFactoryRegistry(authority, type);
    }

    private Hints getHints() {
        if (this.hints.isEmpty()) {
            return ReferencingFactoryFinder.EMPTY_HINTS;
        }
        Hints hints = (Hints)ReferencingFactoryFinder.EMPTY_HINTS.clone();
        hints.putAll((Map<?, ?>)this.hints);
        return hints;
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new Finder(this, type);
    }

    private static final class Finder
    extends ManyAuthoritiesFactory.Finder {
        protected Finder(ManyAuthoritiesFactory factory, Class type) {
            super(factory, type);
        }

        private Set fromFactoryRegistry() {
            ManyAuthoritiesFactory factory = (ManyAuthoritiesFactory)this.proxy.getAuthorityFactory();
            Class type = this.proxy.getType();
            LinkedHashSet factories = new LinkedHashSet();
            Iterator it = ReferencingFactoryFinder.getAuthorityNames().iterator();
            while (it.hasNext()) {
                String authority = (String)it.next();
                factory.fromFactoryRegistry(authority, type, factories);
            }
            Collection done = this.getFactories();
            if (done != null) {
                factories.removeAll(done);
            }
            return factories;
        }

        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder finder;
            IdentifiedObject candidate = super.find(object);
            if (candidate != null) {
                return candidate;
            }
            Iterator it = this.fromFactoryRegistry().iterator();
            while ((finder = this.next(it)) != null && (candidate = finder.find(object)) == null) {
            }
            return candidate;
        }

        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObjectFinder finder;
            String candidate = super.findIdentifier(object);
            if (candidate != null) {
                return candidate;
            }
            Iterator it = this.fromFactoryRegistry().iterator();
            while ((finder = this.next(it)) != null && (candidate = finder.findIdentifier(object)) == null) {
            }
            return candidate;
        }
    }
}

