/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.AbstractDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private static final VerticalDatumType[] TYPES;
    private static final short[] LEGACY_CODES;
    private final VerticalDatumType type;
    public static final DefaultVerticalDatum GEOIDAL;
    public static final DefaultVerticalDatum ELLIPSOIDAL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultVerticalDatum(String name, VerticalDatumType type) {
        this(Collections.singletonMap("name", name), type);
    }

    public DefaultVerticalDatum(VerticalDatum datum) {
        super(datum);
        this.type = datum.getVerticalDatumType();
    }

    public DefaultVerticalDatum(Map properties, VerticalDatumType type) {
        super(properties);
        this.type = type;
        DefaultVerticalDatum.ensureNonNull("type", type);
    }

    public VerticalDatumType getVerticalDatumType() {
        return this.type;
    }

    final int getLegacyDatumType() {
        int ordinal = this.type.ordinal();
        if (ordinal >= 0 && ordinal < LEGACY_CODES.length) {
            if (!$assertionsDisabled && !this.type.equals(TYPES[ordinal])) {
                throw new AssertionError(this.type);
            }
            return LEGACY_CODES[ordinal];
        }
        return 0;
    }

    public static VerticalDatumType getVerticalDatumTypeFromLegacyCode(int code) {
        for (int i = 0; i < LEGACY_CODES.length; ++i) {
            if (LEGACY_CODES[i] != code) continue;
            return TYPES[i];
        }
        return null;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultVerticalDatum that = (DefaultVerticalDatum)object;
            return Utilities.equals(this.type, that.type);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.type.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        return "VERT_DATUM";
    }

    static {
        $assertionsDisabled = !DefaultVerticalDatum.class.desiredAssertionStatus();
        TYPES = VerticalDatumType.values();
        LEGACY_CODES = new short[TYPES.length];
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.GEOIDAL.ordinal()] = 2005;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.ELLIPSOIDAL.ordinal()] = 2002;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.DEPTH.ordinal()] = 2006;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.BAROMETRIC.ordinal()] = 2003;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.ORTHOMETRIC.ordinal()] = 2001;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.OTHER_SURFACE.ordinal()] = 2000;
        GEOIDAL = new DefaultVerticalDatum("Geoidal", VerticalDatumType.GEOIDAL);
        ELLIPSOIDAL = new DefaultVerticalDatum("Ellipsoidal", VerticalDatumType.ELLIPSOIDAL);
    }
}

