/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.geotools.referencing.cs.PredefinedCS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;

public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    private static final DefaultCoordinateSystemAxis[] DIRECTION_CHECKS;
    private final CoordinateSystemAxis[] axis;
    private transient Unit distanceUnit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractCS(CoordinateSystem cs) {
        super(cs);
        if (cs instanceof AbstractCS) {
            this.axis = ((AbstractCS)cs).axis;
        } else {
            this.axis = new CoordinateSystemAxis[cs.getDimension()];
            for (int i = 0; i < this.axis.length; ++i) {
                this.axis[i] = cs.getAxis(i);
            }
        }
    }

    public AbstractCS(String name, CoordinateSystemAxis[] axis) {
        this(Collections.singletonMap("name", name), axis);
    }

    public AbstractCS(Map properties, CoordinateSystemAxis[] axis) {
        super(properties);
        AbstractCS.ensureNonNull("axis", axis);
        this.axis = (CoordinateSystemAxis[])axis.clone();
        for (int i = 0; i < axis.length; ++i) {
            AbstractCS.ensureNonNull("axis", axis, i);
            AxisDirection direction = axis[i].getDirection();
            AbstractCS.ensureNonNull("direction", direction);
            if (!this.isCompatibleDirection(direction)) {
                throw new IllegalArgumentException(Errors.format(44, direction.name(), Utilities.getShortClassName(this)));
            }
            Unit unit = axis[i].getUnit();
            AbstractCS.ensureNonNull("unit", unit);
            if (!this.isCompatibleUnit(direction, unit)) {
                throw new IllegalArgumentException(Errors.format(54, unit));
            }
            AxisDirection check = direction.absolute();
            if (!check.equals(AxisDirection.OTHER)) {
                int j = i;
                while (--j >= 0) {
                    if (!check.equals(axis[j].getDirection().absolute())) continue;
                    String nameI = axis[i].getDirection().name();
                    String nameJ = axis[j].getDirection().name();
                    throw new IllegalArgumentException(Errors.format(27, nameI, nameJ));
                }
            }
            String name = axis[i].getName().getCode();
            for (int j = 0; j < DIRECTION_CHECKS.length; ++j) {
                DirectionAlongMeridian m;
                AxisDirection expected;
                DefaultCoordinateSystemAxis candidate = DIRECTION_CHECKS[j];
                if (!candidate.nameMatches(name) || direction.equals(expected = candidate.getDirection()) || (m = DirectionAlongMeridian.parse(direction)) != null) continue;
                throw new IllegalArgumentException(Errors.format(60, name, direction.name()));
            }
        }
    }

    static Map name(int key) {
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>(4);
        InternationalString name = Vocabulary.formatInternational(key);
        properties.put("name", ((Object)name).toString());
        properties.put("alias", name);
        return properties;
    }

    protected boolean isCompatibleDirection(AxisDirection direction) {
        return true;
    }

    protected boolean isCompatibleUnit(AxisDirection direction, Unit unit) {
        return true;
    }

    public int getDimension() {
        return this.axis.length;
    }

    public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
        return this.axis[dimension];
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem cs) {
        AxisDirection[] axis = new AxisDirection[cs.getDimension()];
        for (int i = 0; i < axis.length; ++i) {
            axis[i] = cs.getAxis(i).getDirection();
        }
        return axis;
    }

    public static Matrix swapAndScaleAxis(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws IllegalArgumentException, ConversionException {
        if (!Utilities.sameInterfaces(sourceCS.getClass(), targetCS.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Errors.format(149));
        }
        Object[] sourceAxis = AbstractCS.getAxisDirections(sourceCS);
        Object[] targetAxis = AbstractCS.getAxisDirections(targetCS);
        GeneralMatrix matrix = new GeneralMatrix((AxisDirection[])sourceAxis, (AxisDirection[])targetAxis);
        if (!$assertionsDisabled && Arrays.equals(sourceAxis, targetAxis) != matrix.isIdentity()) {
            throw new AssertionError(matrix);
        }
        int sourceDim = matrix.getNumCol() - 1;
        int targetDim = matrix.getNumRow() - 1;
        if (!$assertionsDisabled && sourceDim != sourceCS.getDimension()) {
            throw new AssertionError(sourceCS);
        }
        if (!$assertionsDisabled && targetDim != targetCS.getDimension()) {
            throw new AssertionError(targetCS);
        }
        for (int j = 0; j < targetDim; ++j) {
            Unit targetUnit = targetCS.getAxis(j).getUnit();
            for (int i = 0; i < sourceDim; ++i) {
                Unit sourceUnit;
                double element = matrix.getElement(j, i);
                if (element == 0.0 || Utilities.equals(sourceUnit = sourceCS.getAxis(i).getUnit(), targetUnit)) continue;
                Converter converter = sourceUnit.getConverterTo(targetUnit);
                if (!converter.isLinear()) {
                    throw new ConversionException(Errors.format(150, sourceUnit, targetUnit));
                }
                double offset = converter.convert(0.0);
                double scale = converter.derivative(0.0);
                matrix.setElement(j, i, element * scale);
                matrix.setElement(j, sourceDim, matrix.getElement(j, sourceDim) + element * offset);
            }
        }
        return matrix;
    }

    public static CoordinateSystem standard(CoordinateSystem cs) throws IllegalArgumentException {
        return PredefinedCS.standard(cs);
    }

    final Unit getDistanceUnit() throws ConversionException {
        Unit unit = this.distanceUnit;
        if (unit == null) {
            for (int i = 0; i < this.axis.length; ++i) {
                Unit candidate = this.axis[i].getUnit();
                if (candidate == null || candidate.isCompatible(SI.RADIAN)) continue;
                if (unit != null) {
                    Converter converter = candidate.getConverterTo(unit);
                    if (!converter.isLinear()) {
                        throw new ConversionException("Unit conversion is non-linear");
                    }
                    if (Math.abs(converter.derivative(0.0)) <= 1.0) continue;
                }
                unit = candidate;
            }
            this.distanceUnit = unit;
        }
        return unit;
    }

    final void ensureDimensionMatch(String name, double[] coordinates) throws MismatchedDimensionException {
        if (coordinates.length != this.axis.length) {
            throw new MismatchedDimensionException(Errors.format(69, name, new Integer(coordinates.length), new Integer(this.axis.length)));
        }
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        throw new UnsupportedOperationException();
    }

    final CoordinateSystemAxis[] axisUsingUnit(Unit unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] newAxis = null;
        for (int i = 0; i < this.axis.length; ++i) {
            DefaultCoordinateSystemAxis converted;
            CoordinateSystemAxis a = this.axis[i];
            if (unit.equals(a.getUnit())) continue;
            if (a instanceof DefaultCoordinateSystemAxis) {
                converted = (DefaultCoordinateSystemAxis)a;
            } else {
                converted = new DefaultCoordinateSystemAxis(a);
                a = converted;
            }
            converted = converted.usingUnit(unit);
            if (converted == a) continue;
            if (newAxis == null) {
                newAxis = new CoordinateSystemAxis[this.axis.length];
                System.arraycopy(this.axis, 0, newAxis, 0, i);
            }
            newAxis[i] = converted;
        }
        return newAxis;
    }

    private static DefaultCoordinateSystemAxis[] getDefaultAxis(CoordinateSystem cs) {
        DefaultCoordinateSystemAxis[] axis = new DefaultCoordinateSystemAxis[cs.getDimension()];
        for (int i = 0; i < axis.length; ++i) {
            CoordinateSystemAxis a = cs.getAxis(i);
            DefaultCoordinateSystemAxis c = DefaultCoordinateSystemAxis.getPredefined(a);
            if (c == null) {
                c = a instanceof DefaultCoordinateSystemAxis ? (DefaultCoordinateSystemAxis)a : new DefaultCoordinateSystemAxis(a);
            }
            axis[i] = c;
        }
        return axis;
    }

    final boolean axisColinearWith(CoordinateSystem userCS) {
        if (userCS.getDimension() != this.getDimension()) {
            return false;
        }
        DefaultCoordinateSystemAxis[] axis0 = AbstractCS.getDefaultAxis(this);
        DefaultCoordinateSystemAxis[] axis1 = AbstractCS.getDefaultAxis(userCS);
        for (int i = 0; i < axis0.length; ++i) {
            block5: {
                DefaultCoordinateSystemAxis direct = axis0[i];
                DefaultCoordinateSystemAxis opposite = direct.getOpposite();
                for (int j = 0; j < axis1.length; ++j) {
                    DefaultCoordinateSystemAxis candidate = axis1[j];
                    if (candidate == null || !candidate.equals(direct, false, false) && (opposite == null || !candidate.equals(opposite, false, false))) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            axis1[j] = null;
        }
        if (!$assertionsDisabled && !this.directionColinearWith(userCS)) {
            throw new AssertionError();
        }
        return true;
    }

    final boolean directionColinearWith(CoordinateSystem userCS) {
        int i;
        if (userCS.getDimension() != this.axis.length) {
            return false;
        }
        AxisDirection[] checks = new AxisDirection[this.axis.length];
        for (i = 0; i < checks.length; ++i) {
            checks[i] = userCS.getAxis(i).getDirection().absolute();
        }
        for (i = 0; i < this.axis.length; ++i) {
            block5: {
                AxisDirection direction = this.axis[i].getDirection().absolute();
                for (int j = 0; j < checks.length; ++j) {
                    AxisDirection candidate = checks[j];
                    if (candidate == null || !candidate.equals(direction)) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            checks[j] = null;
        }
        return true;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCS that = (AbstractCS)object;
            return AbstractCS.equals(this.axis, that.axis, compareMetadata);
        }
        return false;
    }

    public int hashCode() {
        int code = 1480995944;
        for (int i = 0; i < this.axis.length; ++i) {
            code = code * 37 + this.axis[i].hashCode();
        }
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        for (int i = 0; i < this.axis.length; ++i) {
            formatter.append(this.axis[i]);
        }
        formatter.setInvalidWKT(CoordinateSystem.class);
        return super.formatWKT(formatter);
    }

    static {
        $assertionsDisabled = !AbstractCS.class.desiredAssertionStatus();
        DIRECTION_CHECKS = new DefaultCoordinateSystemAxis[]{DefaultCoordinateSystemAxis.NORTHING, DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.SOUTHING, DefaultCoordinateSystemAxis.WESTING};
    }
}

