/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.units.Converter;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

public class DefaultTemporalCRS
extends AbstractSingleCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    public static Unit MILLISECOND = SI.MILLI(SI.SECOND);
    private transient Converter toMillis;
    private transient long origin;

    public DefaultTemporalCRS(TemporalCRS crs) {
        super(crs);
    }

    public DefaultTemporalCRS(String name, TemporalDatum datum, TimeCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultTemporalCRS(Map properties, TemporalDatum datum, TimeCS cs) {
        super(properties, datum, cs);
    }

    public static DefaultTemporalCRS wrap(TemporalCRS crs) {
        if (crs == null || crs instanceof DefaultTemporalCRS) {
            return (DefaultTemporalCRS)crs;
        }
        return new DefaultTemporalCRS(crs);
    }

    private void initializeConverter() {
        this.origin = ((TemporalDatum)this.datum).getOrigin().getTime();
        this.toMillis = this.coordinateSystem.getAxis(0).getUnit().getConverterTo(MILLISECOND);
    }

    public Date toDate(double value) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return new Date(Math.round(this.toMillis.convert(value)) + this.origin);
    }

    public double toValue(Date time) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return this.toMillis.inverse().convert(time.getTime() - this.origin);
    }

    public int hashCode() {
        return 0x86FFB877 ^ super.hashCode();
    }
}

