/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.measure.Measure;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;

public class DefaultGeographicCRS
extends AbstractSingleCRS
implements GeographicCRS {
    private static final long serialVersionUID = 861224913438092335L;
    public static final DefaultGeographicCRS WGS84;
    public static final DefaultGeographicCRS WGS84_3D;

    public DefaultGeographicCRS(GeographicCRS crs) {
        super(crs);
    }

    public DefaultGeographicCRS(String name, GeodeticDatum datum, EllipsoidalCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeographicCRS(Map properties, GeodeticDatum datum, EllipsoidalCS cs) {
        super(properties, datum, cs);
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (!(this.coordinateSystem instanceof DefaultEllipsoidalCS)) {
            throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
        }
        Ellipsoid ellipsoid = ((GeodeticDatum)this.datum).getEllipsoid();
        if (!(ellipsoid instanceof DefaultEllipsoid)) {
            throw new UnsupportedImplementationException(ellipsoid.getClass());
        }
        DefaultEllipsoidalCS cs = (DefaultEllipsoidalCS)this.coordinateSystem;
        DefaultEllipsoid e = (DefaultEllipsoid)ellipsoid;
        if (coord1.length != 2 || coord2.length != 2 || cs.getDimension() != 2) {
            return super.distance(coord1, coord2);
        }
        return new Measure(e.orthodromicDistance(cs.getLongitude(coord1), cs.getLatitude(coord1), cs.getLongitude(coord2), cs.getLatitude(coord2)), e.getAxisUnit());
    }

    public int hashCode() {
        return 0xED31AC2F ^ super.hashCode();
    }

    static Unit getAngularUnit(CoordinateSystem coordinateSystem) {
        Unit unit = NonSI.DEGREE_ANGLE;
        int i = coordinateSystem.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = coordinateSystem.getAxis(i);
            Unit candidate = axis.getUnit();
            if (!NonSI.DEGREE_ANGLE.isCompatible(candidate)) continue;
            unit = candidate;
            if (!AxisDirection.EAST.equals(axis.getDirection().absolute())) continue;
            break;
        }
        return unit;
    }

    protected String formatWKT(Formatter formatter) {
        Unit oldUnit = formatter.getAngularUnit();
        Unit unit = DefaultGeographicCRS.getAngularUnit(this.coordinateSystem);
        formatter.setAngularUnit(unit);
        formatter.append(this.datum);
        formatter.append(((GeodeticDatum)this.datum).getPrimeMeridian());
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append(this.coordinateSystem.getAxis(i));
        }
        if (!unit.equals(this.getUnit())) {
            formatter.setInvalidWKT(GeographicCRS.class);
        }
        formatter.setAngularUnit(oldUnit);
        return "GEOGCS";
    }

    static {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", "WGS84");
        properties.put("domainOfValidity", ExtentImpl.WORLD);
        WGS84 = new DefaultGeographicCRS(properties, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        WGS84_3D = new DefaultGeographicCRS(properties, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_3D);
    }
}

