/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.crs.UnprefixedMap;
import org.geotools.referencing.operation.DefaultConversion;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

public class AbstractDerivedCRS
extends AbstractSingleCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    public static final String CONVERSION_TYPE_KEY = "conversionType";
    public static final ThreadLocal _COMPARING = new ThreadLocal();
    protected final CoordinateReferenceSystem baseCRS;
    protected final Conversion conversionFromBase;

    protected AbstractDerivedCRS(GeneralDerivedCRS crs) {
        super(crs);
        this.baseCRS = crs.getBaseCRS();
        this.conversionFromBase = crs.getConversionFromBase();
    }

    protected AbstractDerivedCRS(Map properties, Conversion conversionFromBase, CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, AbstractDerivedCRS.getDatum(base), derivedCS);
        AbstractDerivedCRS.ensureNonNull("conversionFromBase", conversionFromBase);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", baseToDerived);
        this.baseCRS = base;
        AbstractDerivedCRS.checkDimensions(base, baseToDerived, derivedCS);
        DefaultOperationMethod.checkDimensions(conversionFromBase.getMethod(), baseToDerived);
        Class typeHint = (Class)properties.get(CONVERSION_TYPE_KEY);
        this.conversionFromBase = DefaultConversion.create(conversionFromBase, base, this, baseToDerived, typeHint);
    }

    protected AbstractDerivedCRS(Map properties, OperationMethod method, CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, AbstractDerivedCRS.getDatum(base), derivedCS);
        AbstractDerivedCRS.ensureNonNull("method", method);
        AbstractDerivedCRS.ensureNonNull("baseToDerived", baseToDerived);
        this.baseCRS = base;
        AbstractDerivedCRS.checkDimensions(base, baseToDerived, derivedCS);
        DefaultOperationMethod.checkDimensions(method, baseToDerived);
        Class clazz = this instanceof ProjectedCRS ? Projection.class : Conversion.class;
        this.conversionFromBase = (Conversion)DefaultOperation.create(new UnprefixedMap(properties, "conversion."), base, this, baseToDerived, method, clazz);
    }

    private static Datum getDatum(CoordinateReferenceSystem base) {
        AbstractDerivedCRS.ensureNonNull("base", base);
        return base instanceof SingleCRS ? ((SingleCRS)base).getDatum() : null;
    }

    private static void checkDimensions(CoordinateReferenceSystem base, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        int dimSource = baseToDerived.getSourceDimensions();
        int dimTarget = baseToDerived.getTargetDimensions();
        int dim1 = dimSource;
        int dim2 = base.getCoordinateSystem().getDimension();
        if (dim1 != dim2 || (dim1 = dimTarget) != (dim2 = derivedCS.getDimension())) {
            throw new MismatchedDimensionException(Errors.format(68, new Integer(dim1), new Integer(dim2)));
        }
    }

    public CoordinateReferenceSystem getBaseCRS() {
        return this.baseCRS;
    }

    public Conversion getConversionFromBase() {
        return this.conversionFromBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractDerivedCRS that = (AbstractDerivedCRS)object;
            if (AbstractDerivedCRS.equals(this.baseCRS, that.baseCRS, compareMetadata)) {
                Boolean comparing = (Boolean)_COMPARING.get();
                if (comparing != null && comparing.booleanValue()) {
                    return true;
                }
                try {
                    _COMPARING.set(Boolean.TRUE);
                    boolean bl = AbstractDerivedCRS.equals(this.conversionFromBase, that.conversionFromBase, compareMetadata);
                    return bl;
                }
                finally {
                    _COMPARING.set(Boolean.FALSE);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return 0x550241F2 ^ this.baseCRS.hashCode() ^ this.conversionFromBase.getName().hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        MathTransform inverse = this.conversionFromBase.getMathTransform();
        try {
            inverse = inverse.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            IllegalStateException e = new IllegalStateException(exception.getLocalizedMessage());
            e.initCause(exception);
            throw e;
        }
        formatter.append(inverse);
        formatter.append(this.baseCRS);
        return "FITTED_CS";
    }
}

