/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.util.MapEntry;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.CoordinateOperation;

final class Properties
extends AbstractMap {
    private final IdentifiedObject info;
    private transient Set entries;
    private static final String[] KEYS = new String[]{"name", "identifiers", "alias", "remarks", "scope", "domainOfValidity", "operationVersion", "coordinateOperationAccuracy"};

    public Properties(IdentifiedObject info) {
        this.info = info;
        AbstractIdentifiedObject.ensureNonNull("info", info);
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            String s = ((String)key).trim();
            for (int i = 0; i < KEYS.length; ++i) {
                if (!KEYS[i].equalsIgnoreCase(s)) continue;
                return this.get(i);
            }
        }
        return null;
    }

    private Object get(int key) {
        switch (key) {
            case 0: {
                return this.info.getName();
            }
            case 1: {
                return this.info.getIdentifiers().toArray(AbstractIdentifiedObject.EMPTY_IDENTIFIER_ARRAY);
            }
            case 2: {
                return this.info.getAlias().toArray(AbstractIdentifiedObject.EMPTY_ALIAS_ARRAY);
            }
            case 3: {
                return this.info.getRemarks();
            }
            case 4: {
                return this.info instanceof CoordinateOperation ? ((CoordinateOperation)this.info).getScope() : null;
            }
            case 5: {
                return this.info instanceof CoordinateOperation ? ((CoordinateOperation)this.info).getValidArea() : null;
            }
            case 6: {
                return this.info instanceof CoordinateOperation ? ((CoordinateOperation)this.info).getOperationVersion() : null;
            }
            case 7: {
                return this.info instanceof CoordinateOperation ? ((CoordinateOperation)this.info).getPositionalAccuracy().toArray(AbstractCoordinateOperation.EMPTY_ACCURACY_ARRAY) : null;
            }
        }
        return null;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new HashSet(Math.round((float)KEYS.length / 0.75f) + 1, 0.75f);
            for (int i = 0; i < KEYS.length; ++i) {
                Object value = this.get(i);
                if (value == null) continue;
                this.entries.add(new MapEntry(KEYS[i], value));
            }
            this.entries = Collections.unmodifiableSet(this.entries);
        }
        return this.entries;
    }
}

