/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.geotools.util.WeakValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public class NamedIdentifier
implements ReferenceIdentifier,
GenericName,
Serializable {
    private static final long serialVersionUID = 8474731565582774497L;
    private static final String REMARKS_KEY = "remarks";
    private static Map SCOPES;
    private final String code;
    private final String codespace;
    private final Citation authority;
    private final String version;
    private final InternationalString remarks;
    private GenericName name;

    public NamedIdentifier(Map properties) throws IllegalArgumentException {
        this(properties, true);
    }

    public NamedIdentifier(Citation authority, InternationalString code) {
        this(authority, code.toString(Locale.US));
        this.name = this.getName(authority, code);
    }

    public NamedIdentifier(Citation authority, String code) {
        this(authority, code, null);
    }

    public NamedIdentifier(Citation authority, String code, String version) {
        this(NamedIdentifier.toMap(authority, code, version));
    }

    private static Map toMap(Citation authority, String code, String version) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        if (authority != null) {
            properties.put("authority", authority);
        }
        if (code != null) {
            properties.put("code", code);
        }
        if (version != null) {
            properties.put("version", version);
        }
        return properties;
    }

    NamedIdentifier(Map properties, boolean standalone) throws IllegalArgumentException {
        NamedIdentifier.ensureNonNull("properties", properties);
        Object code = null;
        String codespace = null;
        Object version = null;
        Object authority = null;
        Object remarks = null;
        GrowableInternationalString growable = null;
        String key = null;
        Object value = null;
        Iterator it = properties.entrySet().iterator();
        block10: while (it.hasNext()) {
            Map.Entry entry = it.next();
            key = ((String)entry.getKey()).trim().toLowerCase();
            value = entry.getValue();
            switch (key.hashCode()) {
                case 3373707: {
                    if (standalone || !key.equals("name")) break;
                    code = value;
                    continue block10;
                }
                case 3059181: {
                    if (!key.equals("code")) break;
                    code = value;
                    continue block10;
                }
                case -1108676807: {
                    if (!key.equals("codespace")) break;
                    codespace = value;
                    continue block10;
                }
                case 351608024: {
                    if (!key.equals("version")) break;
                    version = value;
                    continue block10;
                }
                case 1475610435: {
                    if (!key.equals("authority")) break;
                    if (value instanceof String) {
                        value = Citations.fromName(value.toString());
                    }
                    authority = value;
                    continue block10;
                }
                case 1091415283: {
                    if (!standalone || !key.equals(REMARKS_KEY) || !(value instanceof InternationalString)) break;
                    remarks = value;
                    continue block10;
                }
            }
            if (!standalone || !(value instanceof String)) continue;
            if (growable == null) {
                growable = remarks instanceof GrowableInternationalString ? (GrowableInternationalString)remarks : new GrowableInternationalString();
            }
            growable.add(REMARKS_KEY, key, value.toString());
        }
        if (growable != null && !growable.getLocales().isEmpty()) {
            if (remarks == null) {
                remarks = growable;
            } else {
                Logging.getLogger("org.geotools.referencing").log(org.geotools.resources.i18n.Logging.format(Level.WARNING, 10));
            }
        }
        if (codespace == null && authority instanceof Citation) {
            codespace = NamedIdentifier.getCodeSpace((Citation)authority);
        }
        try {
            key = "code";
            value = code;
            this.code = (String)value;
            key = "version";
            value = version;
            this.version = (String)value;
            key = "codespace";
            value = codespace;
            this.codespace = value;
            key = "authority";
            value = authority;
            this.authority = (Citation)value;
            key = REMARKS_KEY;
            value = remarks;
            this.remarks = (InternationalString)value;
        }
        catch (ClassCastException exception) {
            InvalidParameterValueException e = new InvalidParameterValueException(Errors.format(42, key, value), key, value);
            e.initCause(exception);
            throw e;
        }
        NamedIdentifier.ensureNonNull("code", code);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new InvalidParameterValueException(Errors.format(105, name), name, object);
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeSpace() {
        return this.codespace;
    }

    public Citation getAuthority() {
        return this.authority;
    }

    public String getVersion() {
        return this.version;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    private GenericName getName() {
        if (this.name == null) {
            this.name = this.getName(this.authority, this.code);
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericName getName(Citation authority, CharSequence code) {
        GenericName scope;
        if (authority == null) {
            return new LocalName(code);
        }
        CharSequence title = this.codespace != null ? this.codespace : NamedIdentifier.getShortestTitle(authority);
        Class clazz = NamedIdentifier.class;
        synchronized (clazz) {
            if (SCOPES == null) {
                SCOPES = new WeakValueHashMap();
            }
            if ((scope = (GenericName)SCOPES.get(title)) == null) {
                scope = new LocalName(title);
                SCOPES.put(title, scope);
            }
        }
        return new ScopedName(scope, code);
    }

    private static InternationalString getShortestTitle(Citation authority) {
        InternationalString title = authority.getTitle();
        int length = title.length();
        Collection alt = authority.getAlternateTitles();
        if (alt != null) {
            Iterator it = alt.iterator();
            while (it.hasNext()) {
                InternationalString candidate = (InternationalString)it.next();
                int candidateLength = candidate.length();
                if (candidateLength <= 0 || candidateLength >= length) continue;
                title = candidate;
                length = candidateLength;
            }
        }
        return title;
    }

    private static String getCodeSpace(Citation authority) {
        String title;
        Collection identifiers = authority.getIdentifiers();
        if (identifiers != null) {
            Iterator it = identifiers.iterator();
            while (it.hasNext()) {
                String identifier = (String)it.next();
                if (!NamedIdentifier.isValidCodeSpace(identifier)) continue;
                return identifier;
            }
        }
        if (NamedIdentifier.isValidCodeSpace(title = NamedIdentifier.getShortestTitle(authority).toString(Locale.US))) {
            return title;
        }
        return null;
    }

    private static boolean isValidCodeSpace(String codespace) {
        if (codespace == null) {
            return false;
        }
        int i = codespace.length();
        while (--i >= 0) {
            if (Character.isJavaIdentifierPart(codespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public org.opengis.util.LocalName name() {
        return this.getName().name();
    }

    public org.opengis.util.LocalName asLocalName() {
        return this.getName().asLocalName();
    }

    public NameSpace scope() {
        return this.getName().scope();
    }

    public GenericName getScope() {
        return this.getName().getScope();
    }

    public int depth() {
        return this.getName().depth();
    }

    public List getParsedNames() {
        return this.getName().getParsedNames();
    }

    public org.opengis.util.ScopedName push(GenericName scope) {
        return this.getName().push(scope);
    }

    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    public org.opengis.util.ScopedName asScopedName() {
        return this.getName().asScopedName();
    }

    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    public String toString() {
        return ((Object)this.getName()).toString();
    }

    public int compareTo(Object object) {
        return this.getName().compareTo(object);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            NamedIdentifier that = (NamedIdentifier)object;
            return Utilities.equals(this.code, that.code) && Utilities.equals(this.codespace, that.codespace) && Utilities.equals(this.version, that.version) && Utilities.equals(this.authority, that.authority) && Utilities.equals(this.remarks, that.remarks);
        }
        return false;
    }

    public int hashCode() {
        int hash = 895086817;
        if (this.code != null) {
            hash ^= this.code.hashCode();
        }
        if (this.version != null) {
            hash = hash * 37 + this.version.hashCode();
        }
        return hash;
    }
}

