/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.BufferedAuthorityFactory;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSAuthorityFactory;

final class DefaultAuthorityFactory
extends BufferedAuthorityFactory
implements CRSAuthorityFactory {
    static /* synthetic */ Class class$org$opengis$referencing$crs$CoordinateReferenceSystem;

    DefaultAuthorityFactory(boolean longitudeFirst) {
        super(DefaultAuthorityFactory.getBackingFactory(longitudeFirst));
    }

    private static AbstractAuthorityFactory getBackingFactory(boolean longitudeFirst) {
        Hints hints = GeoTools.getDefaultHints();
        if (longitudeFirst) {
            hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        }
        Collection<CRSAuthorityFactory> factories = ReferencingFactoryFinder.getCRSAuthorityFactories(hints);
        if (Boolean.TRUE.equals(hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE))) {
            factories = new ArrayList(factories);
            LinkedHashSet<Citation> authorities = new LinkedHashSet<Citation>();
            Iterator it = factories.iterator();
            while (it.hasNext()) {
                authorities.add(((CRSAuthorityFactory)it.next()).getAuthority());
            }
            it = ReferencingFactoryFinder.getCRSAuthorityFactories(hints).iterator();
            block1: while (it.hasNext()) {
                CRSAuthorityFactory factory = (CRSAuthorityFactory)it.next();
                Citation authority = factory.getAuthority();
                if (authorities.contains(authority)) continue;
                Iterator it2 = authorities.iterator();
                while (it2.hasNext()) {
                    if (!Citations.identifierMatches(authority, (Citation)it2.next())) continue;
                    continue block1;
                }
                factories.add(factory);
            }
        }
        return new ManyAuthoritiesFactory(factories);
    }

    static Set getSupportedCodes(String authority) {
        LinkedHashSet result = Collections.EMPTY_SET;
        boolean isSetCopied = false;
        Iterator i = ReferencingFactoryFinder.getCRSAuthorityFactories(null).iterator();
        while (i.hasNext()) {
            Set codes;
            CRSAuthorityFactory factory = (CRSAuthorityFactory)i.next();
            if (!Citations.identifierMatches(factory.getAuthority(), authority)) continue;
            try {
                codes = factory.getAuthorityCodes(class$org$opengis$referencing$crs$CoordinateReferenceSystem == null ? DefaultAuthorityFactory.class$("org.opengis.referencing.crs.CoordinateReferenceSystem") : class$org$opengis$referencing$crs$CoordinateReferenceSystem);
            }
            catch (Exception exception) {
                CRS.unexpectedException("getSupportedCodes", exception);
                continue;
            }
            if (codes == null || codes.isEmpty()) continue;
            if (result.isEmpty()) {
                result = codes;
                continue;
            }
            if (!isSetCopied) {
                result = new LinkedHashSet(result);
                isSetCopied = true;
            }
            result.addAll(codes);
        }
        return result;
    }

    static Set getSupportedAuthorities(boolean returnAliases) {
        Set authorityFactories = ReferencingFactoryFinder.getCRSAuthorityFactories(null);
        LinkedHashSet result = new LinkedHashSet();
        Iterator i = authorityFactories.iterator();
        block0: while (i.hasNext()) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)i.next();
            Collection identifiers = factory.getAuthority().getIdentifiers();
            Iterator j = identifiers.iterator();
            while (j.hasNext()) {
                result.add(j.next());
                if (returnAliases) continue;
                continue block0;
            }
        }
        return result;
    }
}

