/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.Command;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.UnsupportedImplementationException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class CRS {
    private static final String LOGGER = "org.geotools.referencing";
    private static CRSAuthorityFactory defaultFactory;
    private static CRSAuthorityFactory xyFactory;
    private static CoordinateOperationFactory strictFactory;
    private static CoordinateOperationFactory lenientFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    private CRS() {
    }

    public static synchronized CRSAuthorityFactory getAuthorityFactory(boolean longitudeFirst) throws FactoryRegistryException {
        CRSAuthorityFactory factory;
        CRSAuthorityFactory cRSAuthorityFactory = factory = longitudeFirst ? xyFactory : defaultFactory;
        if (factory == null) {
            try {
                factory = new DefaultAuthorityFactory(longitudeFirst);
                if (longitudeFirst) {
                    xyFactory = factory;
                } else {
                    defaultFactory = factory;
                }
            }
            catch (NoSuchElementException exception) {
                throw new FactoryNotFoundException(null, exception);
            }
        }
        return factory;
    }

    public static synchronized CoordinateOperationFactory getCoordinateOperationFactory(boolean lenient) {
        CoordinateOperationFactory factory;
        CoordinateOperationFactory coordinateOperationFactory = factory = lenient ? lenientFactory : strictFactory;
        if (factory == null) {
            Hints hints = GeoTools.getDefaultHints();
            if (lenient) {
                hints.put(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            }
            factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
            if (lenient) {
                lenientFactory = factory;
            } else {
                strictFactory = factory;
            }
        }
        return factory;
    }

    public static Version getVersion(String authority) throws FactoryRegistryException {
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory(authority, null);
        HashSet<CRSAuthorityFactory> guard = new HashSet<CRSAuthorityFactory>();
        while (factory instanceof Factory && guard.add(factory)) {
            Map hints = ((Factory)((Object)factory)).getImplementationHints();
            Object version = hints.get(Hints.VERSION);
            if (version instanceof Version) {
                return (Version)version;
            }
            factory = hints.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set getSupportedCodes(String authority) {
        return DefaultAuthorityFactory.getSupportedCodes(authority);
    }

    public static Set getSupportedAuthorities(boolean returnAliases) {
        return DefaultAuthorityFactory.getSupportedAuthorities(returnAliases);
    }

    public static CoordinateReferenceSystem decode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode(code, false);
    }

    public static CoordinateReferenceSystem decode(String code, boolean longitudeFirst) throws NoSuchAuthorityCodeException, FactoryException {
        code = code.trim().toUpperCase();
        return CRS.getAuthorityFactory(longitudeFirst).createCoordinateReferenceSystem(code);
    }

    public static CoordinateReferenceSystem parseWKT(String wkt) throws FactoryException {
        return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(wkt);
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem crs) {
        CoordinateReferenceSystem sourceCRS;
        Envelope envelope = CRS.getGeographicEnvelope(crs);
        if (envelope != null && (sourceCRS = envelope.getCoordinateReferenceSystem()) != null) {
            try {
                crs = CRSUtilities.getCRS2D(crs);
                if (!CRS.equalsIgnoreMetadata(sourceCRS, crs)) {
                    GeneralEnvelope e = CRS.transform(CRS.findMathTransform(sourceCRS, crs, true), envelope);
                    e.setCoordinateReferenceSystem(crs);
                    envelope = e;
                }
            }
            catch (FactoryException exception) {
                envelope = null;
                CRS.unexpectedException("getEnvelope", exception);
            }
            catch (TransformException exception) {
                envelope = null;
                CRS.unexpectedException("getEnvelope", exception);
            }
        }
        return envelope;
    }

    private static Envelope getGeographicEnvelope(CoordinateReferenceSystem crs) {
        Extent validArea;
        GeneralEnvelope envelope = null;
        if (crs != null && (validArea = crs.getValidArea()) != null) {
            Iterator it = validArea.getGeographicElements().iterator();
            while (it.hasNext()) {
                GeographicBoundingBox bounds;
                GeographicExtent geo = (GeographicExtent)it.next();
                if (geo instanceof GeographicBoundingBox) {
                    bounds = (GeographicBoundingBox)geo;
                    Boolean inclusion = bounds.getInclusion();
                    if (inclusion == null || !inclusion.booleanValue()) continue;
                } else {
                    if (!(geo instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeneralEnvelope candidate = new GeneralEnvelope(new double[]{bounds.getWestBoundLongitude(), bounds.getSouthBoundLatitude()}, new double[]{bounds.getEastBoundLongitude(), bounds.getNorthBoundLatitude()});
                candidate.setCoordinateReferenceSystem(DefaultGeographicCRS.WGS84);
                if (envelope == null) {
                    envelope = candidate;
                    continue;
                }
                envelope.add(candidate);
            }
        }
        return envelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        Envelope envelope = CRS.getGeographicEnvelope(crs);
        if (envelope != null) {
            try {
                return new GeographicBoundingBoxImpl(envelope);
            }
            catch (TransformException exception) {
                CRS.unexpectedException("getGeographicBoundingBox", exception);
            }
        }
        return null;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof SingleCRS && crs.getCoordinateSystem().getDimension() == 2) {
            CoordinateReferenceSystem base = crs;
            while (base instanceof GeneralDerivedCRS) {
                base = ((GeneralDerivedCRS)base).getBaseCRS();
            }
            if (base instanceof GeographicCRS) {
                return (SingleCRS)crs;
            }
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                SingleCRS candidate = CRS.getHorizontalCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof ProjectedCRS) {
            return (ProjectedCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ProjectedCRS candidate = CRS.getProjectedCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                VerticalCRS candidate = CRS.getVerticalCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                TemporalCRS candidate = CRS.getTemporalCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Ellipsoid candidate = CRS.getEllipsoid((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object1).equals((AbstractIdentifiedObject)object2, false);
        }
        return object1 != null && object1.equals(object2);
    }

    public static String lookupIdentifier(IdentifiedObject object, boolean fullScan) throws FactoryException {
        AbstractAuthorityFactory xyFactory = (AbstractAuthorityFactory)((Object)CRS.getAuthorityFactory(true));
        IdentifiedObjectFinder finder = xyFactory.getIdentifiedObjectFinder(object.getClass());
        finder.setFullScanAllowed(fullScan);
        return finder.findIdentifier(object);
    }

    public static String lookupIdentifier(CoordinateReferenceSystem crs, Set authorities, boolean fullScan) {
        if (authorities == null) {
            authorities = CRS.getSupportedAuthorities(false);
        }
        Iterator it = crs.getIdentifiers().iterator();
        while (it.hasNext()) {
            String identifier;
            CoordinateReferenceSystem candidate;
            Identifier id = (Identifier)it.next();
            try {
                candidate = CRS.decode(id.toString());
            }
            catch (FactoryException e) {
                continue;
            }
            if (!CRS.equalsIgnoreMetadata(candidate, crs) || (identifier = CRS.getSRSFromCRS(candidate, authorities)) == null) continue;
            return identifier;
        }
        try {
            String identifier;
            CoordinateReferenceSystem candidate = CRS.decode(crs.getName().toString());
            if (CRS.equalsIgnoreMetadata(candidate, crs) && (identifier = CRS.getSRSFromCRS(candidate, authorities)) != null) {
                return identifier;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!fullScan) {
            return null;
        }
        Iterator itAuth = authorities.iterator();
        while (itAuth.hasNext()) {
            String authority = (String)itAuth.next();
            Set codes = CRS.getSupportedCodes(authority);
            Iterator itCodes = codes.iterator();
            while (itCodes.hasNext()) {
                String code = (String)itCodes.next();
                try {
                    CoordinateReferenceSystem candidate = code.indexOf(58) == -1 ? CRS.decode(authority + ':' + code) : CRS.decode(code);
                    if (!CRS.equalsIgnoreMetadata(candidate, crs)) continue;
                    return CRS.getSRSFromCRS(candidate, Collections.singleton(authority));
                }
                catch (Exception e) {
                }
            }
        }
        return null;
    }

    private static String getSRSFromCRS(CoordinateReferenceSystem crs, Set authorities) {
        Iterator itAuth = authorities.iterator();
        while (itAuth.hasNext()) {
            String authority = (String)itAuth.next();
            String prefix = authority + ":";
            Iterator itIdent = crs.getIdentifiers().iterator();
            while (itIdent.hasNext()) {
                NamedIdentifier id = (NamedIdentifier)itIdent.next();
                String idName = id.toString();
                if (!idName.startsWith(prefix)) continue;
                return idName;
            }
        }
        return null;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return CRS.findMathTransform(sourceCRS, targetCRS, false);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            return IdentityTransform.create(sourceCRS.getCoordinateSystem().getDimension());
        }
        return CRS.getCoordinateOperationFactory(lenient).createOperation(sourceCRS, targetCRS).getMathTransform();
    }

    public static GeneralEnvelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        return CRS.transform(transform, envelope, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static GeneralEnvelope transform(MathTransform transform, Envelope envelope, GeneralDirectPosition targetPt) throws TransformException {
        int n;
        if (envelope == null) {
            return null;
        }
        if (transform.isIdentity()) {
            GeneralEnvelope e = new GeneralEnvelope(envelope);
            e.setCoordinateReferenceSystem(null);
            return e;
        }
        int sourceDim = transform.getSourceDimensions();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(Errors.format(68, new Integer(sourceDim), new Integer(envelope.getDimension())));
        }
        int coordinateNumber = 0;
        GeneralEnvelope transformed = null;
        if (targetPt == null) {
            targetPt = new GeneralDirectPosition(transform.getTargetDimensions());
        }
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(sourceDim);
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt.setOrdinate(i, envelope.getMinimum(i));
        }
        block6: while (true) {
            if (targetPt != transform.transform(sourcePt, targetPt)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (transformed != null) {
                transformed.add(targetPt);
            } else {
                transformed = new GeneralEnvelope(targetPt, targetPt);
            }
            n = ++coordinateNumber;
            int i2 = sourceDim;
            block7: while (true) {
                if (--i2 < 0) {
                    return transformed;
                }
                switch (n % 3) {
                    case 0: {
                        sourcePt.setOrdinate(i2, envelope.getMinimum(i2));
                        n /= 3;
                        continue block7;
                    }
                    case 1: {
                        sourcePt.setOrdinate(i2, envelope.getMaximum(i2));
                        continue block6;
                    }
                    case 2: {
                        sourcePt.setOrdinate(i2, envelope.getCenter(i2));
                        continue block6;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError(n);
    }

    public static GeneralEnvelope transform(CoordinateOperation operation, Envelope envelope) throws TransformException {
        CoordinateReferenceSystem crs;
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (crs = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(crs, sourceCRS)) {
            throw new MismatchedReferenceSystemException(Errors.format(197));
        }
        MathTransform mt = operation.getMathTransform();
        GeneralDirectPosition centerPt = new GeneralDirectPosition(mt.getTargetDimensions());
        GeneralEnvelope transformed = CRS.transform(mt, envelope, centerPt);
        CoordinateReferenceSystem targetCRS = operation.getTargetCRS();
        if (targetCRS == null) {
            return transformed;
        }
        transformed.setCoordinateReferenceSystem(targetCRS);
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null) {
            return transformed;
        }
        GeneralEnvelope generalEnvelope = null;
        DirectPosition sourcePt = null;
        DirectPosition targetPt = null;
        int dimension = targetCS.getDimension();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            boolean testMax = false;
            do {
                double extremum;
                double d = extremum = testMax ? axis.getMaximumValue() : axis.getMinimumValue();
                if (Double.isInfinite(extremum) || Double.isNaN(extremum)) continue;
                if (targetPt == null) {
                    try {
                        mt = mt.inverse();
                    }
                    catch (NoninvertibleTransformException exception) {
                        if (dimension >= mt.getSourceDimensions()) {
                            CRS.unexpectedException("transform", exception);
                        }
                        return transformed;
                    }
                    targetPt = new GeneralDirectPosition(mt.getSourceDimensions());
                    for (int j = 0; j < dimension; ++j) {
                        targetPt.setOrdinate(j, centerPt.getOrdinate(j));
                    }
                    generalEnvelope = envelope instanceof GeneralEnvelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
                }
                targetPt.setOrdinate(i, extremum);
                try {
                    sourcePt = mt.transform(targetPt, sourcePt);
                }
                catch (TransformException e) {
                    continue;
                }
                if (!generalEnvelope.contains(sourcePt)) continue;
                transformed.add(targetPt);
            } while (testMax = !testMax);
            if (targetPt == null) continue;
            targetPt.setOrdinate(i, centerPt.getOrdinate(i));
        }
        return transformed;
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        return CRS.transform(transform, envelope, destination, new Point2D.Double());
    }

    private static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination, Point2D.Double point) throws TransformException {
        if (envelope == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 8; ++i) {
            point.x = (i & 1) == 0 ? envelope.getMinX() : envelope.getMaxX();
            point.y = (i & 2) == 0 ? envelope.getMinY() : envelope.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    point.x = envelope.getCenterX();
                    break;
                }
                case 8: {
                    point.x = envelope.getCenterX();
                }
                case 4: 
                case 7: {
                    point.y = envelope.getCenterY();
                }
            }
            if (point != transform.transform(point, point)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (destination != null) {
            destination.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
        } else {
            destination = XRectangle2D.createFromExtremums(xmin, ymin, xmax, ymax);
        }
        if (!$assertionsDisabled && destination != envelope && !XRectangle2D.equalsEpsilon(destination, CRS.transform(transform, (Envelope)new Envelope2D(null, envelope)).toRectangle2D())) {
            throw new AssertionError(destination);
        }
        return destination;
    }

    public static Rectangle2D transform(CoordinateOperation operation, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        if (envelope == null) {
            return null;
        }
        MathTransform transform = operation.getMathTransform();
        if (!(transform instanceof MathTransform2D)) {
            throw new MismatchedDimensionException(Errors.format(101));
        }
        MathTransform2D mt = (MathTransform2D)transform;
        Point2D.Double center = new Point2D.Double();
        destination = CRS.transform(mt, envelope, destination, center);
        CoordinateReferenceSystem targetCRS = operation.getTargetCRS();
        if (targetCRS == null) {
            return destination;
        }
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null || targetCS.getDimension() != 2) {
            return destination;
        }
        Point2D sourcePt = null;
        Point2D targetPt = null;
        for (int flag = 0; flag < 4; ++flag) {
            double extremum;
            int i = flag >> 1;
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            double d = extremum = (flag & 1) == 0 ? axis.getMinimumValue() : axis.getMaximumValue();
            if (Double.isInfinite(extremum) || Double.isNaN(extremum)) continue;
            if (targetPt == null) {
                try {
                    mt = (MathTransform2D)mt.inverse();
                }
                catch (NoninvertibleTransformException exception) {
                    CRS.unexpectedException("transform", exception);
                    return destination;
                }
                targetPt = new Point2D.Double();
            }
            switch (i) {
                case 0: {
                    targetPt.setLocation(extremum, center.y);
                    break;
                }
                case 1: {
                    targetPt.setLocation(center.x, extremum);
                    break;
                }
                default: {
                    throw new AssertionError(flag);
                }
            }
            try {
                sourcePt = mt.transform(targetPt, sourcePt);
            }
            catch (TransformException e) {
                continue;
            }
            if (!envelope.contains(sourcePt)) continue;
            destination.add(targetPt);
        }
        if (!$assertionsDisabled && destination != envelope && !XRectangle2D.equalsEpsilon(destination, CRS.transform(operation, (Envelope)new GeneralEnvelope(envelope)).toRectangle2D())) {
            throw new AssertionError(destination);
        }
        return destination;
    }

    static void unexpectedException(String methodName, Exception exception) {
        Logging.unexpectedException(LOGGER, CRS.class, methodName, (Throwable)exception);
    }

    public static void main(String[] args) {
        Command.execute(args);
    }

    static {
        $assertionsDisabled = !CRS.class.desiredAssertionStatus();
        GeoTools.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                Class clazz = class$org$geotools$referencing$CRS == null ? (class$org$geotools$referencing$CRS = CRS.class$("org.geotools.referencing.CRS")) : class$org$geotools$referencing$CRS;
                synchronized (clazz) {
                    defaultFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                }
            }
        });
    }
}

