/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;

final class ParameterValueList
extends AbstractList
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -7446077551686135264L;
    private final ParameterDescriptorGroup descriptor;
    private final List values;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParameterValueList(ParameterDescriptorGroup descriptor, List values) {
        this.descriptor = descriptor;
        this.values = values;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }

    public Object get(int i) {
        return this.values.get(i);
    }

    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    public boolean equals(Object o) {
        return ((Object)this.values).equals(o);
    }

    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean add(Object object) {
        return this.add((GeneralParameterValue)object);
    }

    public boolean add(GeneralParameterValue parameter) {
        ++this.modCount;
        GeneralParameterDescriptor type = parameter.getDescriptor();
        List descriptors = this.descriptor.descriptors();
        String name = type.getName().getCode();
        if (!descriptors.contains(type)) {
            Iterator it = descriptors.iterator();
            while (it.hasNext()) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)((GeneralParameterDescriptor)it.next()), name)) continue;
                throw new IllegalArgumentException(Errors.format(48, name));
            }
            Object value = parameter instanceof ParameterValue ? ((ParameterValue)parameter).getValue() : "(group)";
            throw new InvalidParameterNameException(Errors.format(42, name, value), name);
        }
        int max = type.getMaximumOccurs();
        if (max == 1) {
            int i = this.values.size();
            while (--i >= 0) {
                GeneralParameterValue oldValue = (GeneralParameterValue)this.values.get(i);
                GeneralParameterDescriptor oldDescriptor = oldValue.getDescriptor();
                if (!type.equals(oldDescriptor)) continue;
                if (!$assertionsDisabled && !AbstractIdentifiedObject.nameMatches((IdentifiedObject)oldDescriptor, name)) {
                    throw new AssertionError(parameter);
                }
                boolean same = parameter.equals(oldValue);
                this.values.set(i, parameter);
                return !same;
            }
        } else {
            int count = 0;
            Iterator it = this.values.iterator();
            while (it.hasNext()) {
                GeneralParameterValue value = (GeneralParameterValue)it.next();
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
                ++count;
            }
            if (count >= max) {
                throw new InvalidParameterCardinalityException(Errors.format(124, name, new Integer(count)), name);
            }
        }
        this.values.add(parameter);
        return true;
    }

    public Object remove(int index) {
        return this.remove(((GeneralParameterValue)this.values.get(index)).getDescriptor(), index);
    }

    private GeneralParameterValue remove(GeneralParameterDescriptor type, int index) {
        GeneralParameterValue value;
        ++this.modCount;
        int count = 0;
        String name = type.getName().getCode();
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            value = (GeneralParameterValue)it.next();
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            ++count;
        }
        int min = type.getMinimumOccurs();
        if (count <= min) {
            int max = type.getMaximumOccurs();
            throw new InvalidParameterCardinalityException(Errors.format(50, name, new Integer(count - 1), new Integer(min), new Integer(max)), name);
        }
        value = (GeneralParameterValue)this.values.remove(index);
        if (!($assertionsDisabled || value != null && type.equals(value.getDescriptor()))) {
            throw new AssertionError(value);
        }
        return value;
    }

    static {
        $assertionsDisabled = !ParameterValueList.class.desiredAssertionStatus();
    }
}

