/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.parameter.AbstractParameterDescriptor;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.IdentifiedObject;

public class DefaultParameterDescriptorGroup
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = -4613190550542423839L;
    private final int maximumOccurs;
    private final GeneralParameterDescriptor[] parameters;
    private transient List asList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultParameterDescriptorGroup(ParameterDescriptorGroup group) {
        super(group);
        this.maximumOccurs = group.getMaximumOccurs();
        List c = group.descriptors();
        this.parameters = c.toArray(new GeneralParameterDescriptor[c.size()]);
    }

    public DefaultParameterDescriptorGroup(String name, GeneralParameterDescriptor[] parameters) {
        this(Collections.singletonMap("name", name), parameters);
    }

    public DefaultParameterDescriptorGroup(Citation authority, String name, GeneralParameterDescriptor[] parameters) {
        this(Collections.singletonMap("name", new NamedIdentifier(authority, name)), parameters);
    }

    public DefaultParameterDescriptorGroup(Map properties, GeneralParameterDescriptor[] parameters) {
        this(properties, 1, 1, parameters);
    }

    public DefaultParameterDescriptorGroup(Map properties, int minimumOccurs, int maximumOccurs, GeneralParameterDescriptor[] parameters) {
        super(properties, minimumOccurs, maximumOccurs);
        int i;
        this.maximumOccurs = maximumOccurs;
        DefaultParameterDescriptorGroup.ensureNonNull("parameters", parameters);
        this.parameters = new GeneralParameterDescriptor[parameters.length];
        for (i = 0; i < parameters.length; ++i) {
            this.parameters[i] = parameters[i];
            DefaultParameterDescriptorGroup.ensureNonNull("parameters", parameters, i);
        }
        parameters = this.parameters;
        for (i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getName().getCode();
            for (int j = 0; j < parameters.length; ++j) {
                if (i == j || !DefaultParameterDescriptorGroup.nameMatches((IdentifiedObject)parameters[j], name)) continue;
                throw new InvalidParameterNameException(Errors.format(113, parameters[j].getName().getCode(), new Integer(j), name, new Integer(i)), name);
            }
        }
    }

    public int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    public GeneralParameterValue createValue() {
        return new ParameterGroup(this);
    }

    public List descriptors() {
        if (this.asList == null) {
            if (this.parameters == null) {
                this.asList = Collections.EMPTY_LIST;
            } else {
                switch (this.parameters.length) {
                    case 0: {
                        this.asList = Collections.EMPTY_LIST;
                        break;
                    }
                    case 1: {
                        this.asList = Collections.singletonList(this.parameters[0]);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.asList = new UnmodifiableArrayList(this.parameters);
                        break;
                    }
                    default: {
                        this.asList = new AsList(this.parameters);
                    }
                }
            }
        }
        return this.asList;
    }

    public GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        DefaultParameterDescriptorGroup.ensureNonNull("name", name);
        name = name.trim();
        LinkedList<GeneralParameterDescriptor> subgroups = null;
        List parameters = this.descriptors();
        while (parameters != null) {
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                GeneralParameterDescriptor param = (GeneralParameterDescriptor)it.next();
                if (param instanceof ParameterDescriptor) {
                    if (!DefaultParameterDescriptorGroup.nameMatches((IdentifiedObject)param, name)) continue;
                    return (ParameterDescriptor)param;
                }
                if (!(param instanceof DefaultParameterDescriptorGroup)) continue;
                if (subgroups == null) {
                    subgroups = new LinkedList<GeneralParameterDescriptor>();
                }
                if (!$assertionsDisabled && subgroups.contains(param)) {
                    throw new AssertionError(param);
                }
                subgroups.add(param);
            }
            if (subgroups == null || subgroups.isEmpty()) break;
            parameters = ((DefaultParameterDescriptorGroup)subgroups.remove(0)).descriptors();
        }
        throw new ParameterNotFoundException(Errors.format(71, name), name);
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultParameterDescriptorGroup that = (DefaultParameterDescriptorGroup)object;
            return Arrays.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int code = super.hashCode();
        for (int i = 0; i < this.parameters.length; ++i) {
            code = code * 37 + this.parameters[i].hashCode();
        }
        return code;
    }

    static {
        $assertionsDisabled = !DefaultParameterDescriptorGroup.class.desiredAssertionStatus();
    }

    private static final class AsList
    extends UnmodifiableArrayList {
        private static final long serialVersionUID = -2116304004367396735L;
        private transient Set asSet;

        public AsList(GeneralParameterDescriptor[] array) {
            super(array);
        }

        public boolean contains(Object object) {
            if (this.asSet == null) {
                this.asSet = new HashSet(this);
            }
            return this.asSet.contains(object);
        }
    }
}

