/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.TransformPathNotFoundException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.TransformException;

public abstract class Geometry
implements org.opengis.geometry.Geometry,
Serializable {
    private static final long serialVersionUID = -601532429079649232L;
    private static CoordinateOperationFactory coordinateOperationFactory;
    protected final CoordinateReferenceSystem crs;

    public Geometry(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getCoordinateDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public org.opengis.geometry.Geometry transform(CoordinateReferenceSystem newCRS) throws TransformException {
        if (coordinateOperationFactory == null) {
            try {
                coordinateOperationFactory = ReferencingFactoryFinder.getCoordinateOperationFactory(null);
            }
            catch (NoSuchElementException exception) {
                throw new TransformException("Can't transform the geometry", exception);
            }
        }
        try {
            return this.transform(newCRS, coordinateOperationFactory.createOperation(this.crs, newCRS).getMathTransform());
        }
        catch (FactoryException exception) {
            throw new TransformPathNotFoundException("Can't transform the geometry", exception);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

