/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import javax.units.ConversionException;
import javax.units.Unit;
import org.geotools.geometry.AbstractDirectPosition;
import org.geotools.geometry.AbstractEnvelope;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.Utilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.Cloneable;

public class GeneralEnvelope
extends AbstractEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private double[] ordinates;
    private CoordinateReferenceSystem crs;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GeneralEnvelope(int dimension) {
        this.ordinates = new double[dimension * 2];
    }

    public GeneralEnvelope(double min, double max) {
        this.ordinates = new double[]{min, max};
        this.checkCoherence();
    }

    public GeneralEnvelope(double[] minDP, double[] maxDP) throws IllegalArgumentException {
        GeneralEnvelope.ensureNonNull("minDP", minDP);
        GeneralEnvelope.ensureNonNull("maxDP", maxDP);
        GeneralEnvelope.ensureSameDimension(minDP.length, maxDP.length);
        this.ordinates = new double[minDP.length + maxDP.length];
        System.arraycopy(minDP, 0, this.ordinates, 0, minDP.length);
        System.arraycopy(maxDP, 0, this.ordinates, minDP.length, maxDP.length);
        this.checkCoherence();
    }

    public GeneralEnvelope(GeneralDirectPosition minDP, GeneralDirectPosition maxDP) throws IllegalArgumentException {
        this(minDP.ordinates, maxDP.ordinates);
        this.crs = GeneralEnvelope.getCoordinateReferenceSystem(minDP, maxDP);
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(this.crs, this.ordinates.length / 2);
    }

    public GeneralEnvelope(CoordinateReferenceSystem crs) {
        this(crs.getCoordinateSystem().getDimension());
        this.crs = crs;
    }

    public GeneralEnvelope(Envelope envelope) {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        if (envelope instanceof GeneralEnvelope) {
            GeneralEnvelope e = (GeneralEnvelope)envelope;
            this.ordinates = (double[])e.ordinates.clone();
            this.crs = e.crs;
        } else {
            this.crs = envelope.getCoordinateReferenceSystem();
            int dimension = envelope.getDimension();
            this.ordinates = new double[2 * dimension];
            for (int i = 0; i < dimension; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + dimension] = envelope.getMaximum(i);
            }
            this.checkCoherence();
        }
    }

    public GeneralEnvelope(GeographicBoundingBox box) {
        GeneralEnvelope.ensureNonNull("box", box);
        this.ordinates = new double[]{box.getWestBoundLongitude(), box.getSouthBoundLatitude(), box.getEastBoundLongitude(), box.getNorthBoundLatitude()};
        this.crs = DefaultGeographicCRS.WGS84;
    }

    public GeneralEnvelope(Rectangle2D rect) {
        GeneralEnvelope.ensureNonNull("rect", rect);
        this.ordinates = new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
        this.checkCoherence();
    }

    /*
     * WARNING - void declaration
     */
    public GeneralEnvelope(GridRange gridRange, PixelInCell gridType, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws IllegalArgumentException {
        GeneralEnvelope transformed;
        double offset;
        GeneralEnvelope.ensureNonNull("gridRange", gridRange);
        GeneralEnvelope.ensureNonNull("gridToCRS", gridToCRS);
        int dimRange = gridRange.getDimension();
        int dimSource = gridToCRS.getSourceDimensions();
        int dimTarget = gridToCRS.getTargetDimensions();
        GeneralEnvelope.ensureSameDimension(dimRange, dimSource);
        GeneralEnvelope.ensureSameDimension(dimRange, dimTarget);
        this.ordinates = new double[dimSource * 2];
        if (PixelInCell.CELL_CENTER.equals(gridType)) {
            offset = 0.5;
        } else if (PixelInCell.CELL_CORNER.equals(gridType)) {
            offset = 0.0;
        } else {
            throw new IllegalArgumentException(Errors.format(42, "gridType", gridType));
        }
        for (int i = 0; i < dimSource; ++i) {
            void var8_8;
            this.setRange(i, (double)gridRange.getLower(i) - var8_8, (double)gridRange.getUpper(i) - var8_8);
        }
        try {
            transformed = CRS.transform(gridToCRS, (Envelope)this);
        }
        catch (TransformException exception) {
            throw new IllegalArgumentException(Errors.format(15, Utilities.getShortClassName(gridToCRS)));
        }
        if (!$assertionsDisabled && transformed.ordinates.length != this.ordinates.length) {
            throw new AssertionError();
        }
        System.arraycopy(transformed.ordinates, 0, this.ordinates, 0, this.ordinates.length);
        this.setCoordinateReferenceSystem(crs);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(105, name));
        }
    }

    private static void ensureSameDimension(int dim1, int dim2) throws MismatchedDimensionException {
        if (dim1 != dim2) {
            throw new MismatchedDimensionException(Errors.format(68, new Integer(dim1), new Integer(dim2)));
        }
    }

    private void checkCoherence() throws IllegalArgumentException {
        int dimension = this.ordinates.length / 2;
        for (int i = 0; i < dimension; ++i) {
            if (this.ordinates[i] <= this.ordinates[dimension + i]) continue;
            throw new IllegalArgumentException(Errors.format(49, new Integer(i)));
        }
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(Envelope envelope) {
        CoordinateReferenceSystem crs;
        if (envelope == null) {
            return null;
        }
        if (envelope instanceof GeneralEnvelope) {
            return ((GeneralEnvelope)envelope).getCoordinateReferenceSystem();
        }
        if (envelope instanceof Envelope2D) {
            return ((Envelope2D)envelope).getCoordinateReferenceSystem();
        }
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        if (lower.getDimension() == upper.getDimension() && Utilities.equals(crs = lower.getCoordinateReferenceSystem(), upper.getCoordinateReferenceSystem())) {
            return crs;
        }
        throw new IllegalArgumentException(Errors.format(179));
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (!$assertionsDisabled && this.crs != null && this.crs.getCoordinateSystem().getDimension() != this.getDimension()) {
            throw new AssertionError();
        }
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    public final int getDimension() {
        return this.ordinates.length / 2;
    }

    public DirectPosition getLowerCorner() {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition position = new GeneralDirectPosition(dim);
        System.arraycopy(this.ordinates, 0, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    public DirectPosition getUpperCorner() {
        int dim = this.ordinates.length / 2;
        GeneralDirectPosition position = new GeneralDirectPosition(dim);
        System.arraycopy(this.ordinates, dim, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    public DirectPosition getCenter() {
        GeneralDirectPosition position = new GeneralDirectPosition(this.ordinates.length / 2);
        int i = position.ordinates.length;
        while (--i >= 0) {
            position.ordinates[i] = this.getCenter(i);
        }
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    public final double getMinimum(int dimension) {
        if (dimension < this.ordinates.length / 2) {
            return this.ordinates[dimension];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public final double getMaximum(int dimension) {
        if (dimension >= 0) {
            return this.ordinates[dimension + this.ordinates.length / 2];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public final double getCenter(int dimension) {
        return 0.5 * (this.ordinates[dimension] + this.ordinates[dimension + this.ordinates.length / 2]);
    }

    public final double getLength(int dimension) {
        return this.ordinates[dimension + this.ordinates.length / 2] - this.ordinates[dimension];
    }

    public double getLength(int dimension, Unit unit) throws ConversionException {
        Unit source;
        double value = this.getLength(dimension);
        if (this.crs != null && (source = this.crs.getCoordinateSystem().getAxis(dimension).getUnit()) != null) {
            value = source.getConverterTo(unit).convert(value);
        }
        return value;
    }

    public void setRange(int dimension, double minimum, double maximum) {
        if (minimum > maximum) {
            minimum = maximum = 0.5 * (minimum + maximum);
        }
        if (dimension < 0) {
            throw new ArrayIndexOutOfBoundsException(dimension);
        }
        this.ordinates[dimension + this.ordinates.length / 2] = maximum;
        this.ordinates[dimension] = minimum;
    }

    public void setEnvelope(GeneralEnvelope envelope) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), this.getDimension());
        System.arraycopy(envelope.ordinates, 0, this.ordinates, 0, this.ordinates.length);
        if (envelope.crs != null) {
            this.crs = envelope.crs;
            if (!$assertionsDisabled && this.crs.getCoordinateSystem().getDimension() != this.getDimension()) {
                throw new AssertionError(this.crs);
            }
            if (!$assertionsDisabled && envelope.getClass().equals(this.getClass()) && !this.equals(envelope)) {
                throw new AssertionError(envelope);
            }
        }
    }

    public void setToInfinite() {
        int mid = this.ordinates.length / 2;
        Arrays.fill(this.ordinates, 0, mid, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.ordinates, mid, this.ordinates.length, Double.POSITIVE_INFINITY);
        if (!$assertionsDisabled && !this.isInfinite()) {
            throw new AssertionError(this);
        }
    }

    public boolean isInfinite() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (!Double.isInfinite(this.ordinates[i])) continue;
            return true;
        }
        return false;
    }

    public void setToNull() {
        Arrays.fill(this.ordinates, Double.NaN);
        if (!$assertionsDisabled && !this.isNull()) {
            throw new AssertionError(this);
        }
    }

    public boolean isNull() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (Double.isNaN(this.ordinates[i])) continue;
            return false;
        }
        if (!$assertionsDisabled && !this.isEmpty()) {
            throw new AssertionError(this);
        }
        return true;
    }

    public boolean isEmpty() {
        int dimension = this.ordinates.length / 2;
        if (dimension == 0) {
            return true;
        }
        for (int i = 0; i < dimension; ++i) {
            if (this.ordinates[i] < this.ordinates[i + dimension]) continue;
            return true;
        }
        if (!$assertionsDisabled && this.isNull()) {
            throw new AssertionError(this);
        }
        return false;
    }

    private static boolean equalsIgnoreMetadata(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        return crs1 == null || crs2 == null || CRS.equalsIgnoreMetadata(crs1, crs2);
    }

    public void add(DirectPosition position) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", position);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("position", position.getDimension(), dim);
        if (!$assertionsDisabled && !GeneralEnvelope.equalsIgnoreMetadata(this.crs, position.getCoordinateReferenceSystem())) {
            throw new AssertionError(position);
        }
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (value < this.ordinates[i]) {
                this.ordinates[i] = value;
            }
            if (!(value > this.ordinates[i + dim])) continue;
            this.ordinates[i + dim] = value;
        }
        if (!($assertionsDisabled || this.isEmpty() || this.contains(position))) {
            throw new AssertionError();
        }
    }

    public void add(Envelope envelope) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        if (!$assertionsDisabled && !GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) {
            throw new AssertionError(envelope);
        }
        for (int i = 0; i < dim; ++i) {
            double min = envelope.getMinimum(i);
            double max = envelope.getMaximum(i);
            if (min < this.ordinates[i]) {
                this.ordinates[i] = min;
            }
            if (!(max > this.ordinates[i + dim])) continue;
            this.ordinates[i + dim] = max;
        }
        if (!($assertionsDisabled || this.isEmpty() || this.contains(envelope, true))) {
            throw new AssertionError();
        }
    }

    public boolean contains(DirectPosition position) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", position);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("point", position.getDimension(), dim);
        if (!$assertionsDisabled && !GeneralEnvelope.equalsIgnoreMetadata(this.crs, position.getCoordinateReferenceSystem())) {
            throw new AssertionError(position);
        }
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (!(value >= this.ordinates[i])) {
                return false;
            }
            if (value <= this.ordinates[i + dim]) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Envelope envelope, boolean edgesInclusive) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        if (!$assertionsDisabled && !GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) {
            throw new AssertionError(envelope);
        }
        for (int i = 0; i < dim; ++i) {
            double inner = envelope.getMinimum(i);
            double outer = this.ordinates[i];
            if (!(!edgesInclusive ? inner > outer : inner >= outer)) {
                return false;
            }
            inner = envelope.getMaximum(i);
            outer = this.ordinates[i + dim];
            if (!edgesInclusive ? inner < outer : inner <= outer) continue;
            return false;
        }
        if (!$assertionsDisabled && !this.intersects(envelope, edgesInclusive)) {
            throw new AssertionError();
        }
        return true;
    }

    public boolean intersects(Envelope envelope, boolean edgesInclusive) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        if (!$assertionsDisabled && !GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) {
            throw new AssertionError(envelope);
        }
        for (int i = 0; i < dim; ++i) {
            double inner = envelope.getMaximum(i);
            double outer = this.ordinates[i];
            if (!(!edgesInclusive ? inner > outer : inner >= outer)) {
                return false;
            }
            inner = envelope.getMinimum(i);
            outer = this.ordinates[i + dim];
            if (!edgesInclusive ? inner < outer : inner <= outer) continue;
            return false;
        }
        return true;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        if (!$assertionsDisabled && !GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) {
            throw new AssertionError(envelope);
        }
        for (int i = 0; i < dim; ++i) {
            double max;
            double min = Math.max(this.ordinates[i], envelope.getMinimum(i));
            if (min > (max = Math.min(this.ordinates[i + dim], envelope.getMaximum(i)))) {
                min = max = 0.5 * (min + max);
            }
            this.ordinates[i] = min;
            this.ordinates[i + dim] = max;
        }
    }

    public GeneralEnvelope getSubEnvelope(int lower, int upper) throws IndexOutOfBoundsException {
        int curDim = this.ordinates.length / 2;
        int newDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(Errors.format(42, "lower", new Integer(lower)));
        }
        if (newDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(Errors.format(42, "upper", new Integer(upper)));
        }
        GeneralEnvelope envelope = new GeneralEnvelope(newDim);
        System.arraycopy(this.ordinates, lower, envelope.ordinates, 0, newDim);
        System.arraycopy(this.ordinates, lower + curDim, envelope.ordinates, newDim, newDim);
        return envelope;
    }

    public GeneralEnvelope getReducedEnvelope(int lower, int upper) throws IndexOutOfBoundsException {
        int curDim = this.ordinates.length / 2;
        int rmvDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(Errors.format(42, "lower", new Integer(lower)));
        }
        if (rmvDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(Errors.format(42, "upper", new Integer(upper)));
        }
        GeneralEnvelope envelope = new GeneralEnvelope(curDim - rmvDim);
        System.arraycopy(this.ordinates, 0, envelope.ordinates, 0, lower);
        System.arraycopy(this.ordinates, lower, envelope.ordinates, upper, curDim - upper);
        return envelope;
    }

    public Rectangle2D toRectangle2D() throws IllegalStateException {
        if (this.ordinates.length == 4) {
            return XRectangle2D.createFromExtremums(this.ordinates[0], this.ordinates[1], this.ordinates[2], this.ordinates[3]);
        }
        throw new IllegalStateException(Errors.format(93, new Integer(this.getDimension())));
    }

    public int hashCode() {
        int code = GeneralDirectPosition.hashCode(this.ordinates);
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        if (!$assertionsDisabled && code != super.hashCode()) {
            throw new AssertionError();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralEnvelope that = (GeneralEnvelope)object;
            return Arrays.equals(this.ordinates, that.ordinates) && Utilities.equals(this.crs, that.crs);
        }
        return false;
    }

    public boolean equals(Envelope envelope, double eps) {
        return this.equals(envelope, eps, true);
    }

    public boolean equals(Envelope envelope, double eps, boolean relativeToLength) {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        int dimension = this.getDimension();
        if (envelope.getDimension() != dimension) {
            return false;
        }
        if (!$assertionsDisabled && !GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) {
            throw new AssertionError(envelope);
        }
        for (int i = 0; i < dimension; ++i) {
            double epsilon;
            epsilon = relativeToLength ? ((epsilon = Math.max(this.getLength(i), envelope.getLength(i))) > 0.0 && epsilon < Double.POSITIVE_INFINITY ? epsilon * eps : eps) : eps;
            if (Math.abs(this.getMinimum(i) - envelope.getMinimum(i)) <= epsilon && Math.abs(this.getMaximum(i) - envelope.getMaximum(i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            GeneralEnvelope e = (GeneralEnvelope)super.clone();
            e.ordinates = (double[])e.ordinates.clone();
            return e;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    static {
        $assertionsDisabled = !GeneralEnvelope.class.desiredAssertionStatus();
    }
}

