/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import org.geotools.geometry.AbstractDirectPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class DirectPosition1D
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3235094562875693710L;
    private CoordinateReferenceSystem crs;
    public double ordinate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DirectPosition1D() {
    }

    public DirectPosition1D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition1D(double ordinate) {
        this.ordinate = ordinate;
    }

    public DirectPosition1D(DirectPosition point) {
        this.setLocation(point);
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        DirectPosition1D.checkCoordinateReferenceSystemDimension(crs, 1);
        this.crs = crs;
    }

    public final int getDimension() {
        return 1;
    }

    public double[] getCoordinates() {
        return new double[]{this.ordinate};
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(dimension));
        }
        this.ordinate = value;
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        AbstractDirectPosition.ensureDimensionMatch("position", position.getDimension(), 1);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.ordinate = position.getOrdinate(0);
    }

    public int hashCode() {
        long value = Double.doubleToLongBits(this.ordinate);
        int code = 31 + ((int)value ^ (int)(value >>> 32));
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        if (!$assertionsDisabled && code != super.hashCode()) {
            throw new AssertionError();
        }
        return code;
    }

    static {
        $assertionsDisabled = !DirectPosition1D.class.desiredAssertionStatus();
    }
}

