/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.resolve.thttp;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.ietf.uri.URN;
import org.ietf.uri.UnresolvableURIException;
import org.ietf.uri.UnsupportedServiceException;
import org.ietf.uri.resolve.UnknownNIDException;
import vlc.net.resolve.thttp.ResourceDescriptor;

public class NamespaceResolver {
    private static final String URI_RES_QUERY = "/uri-res/";
    private static final int[] ALL_SERVICES = new int[]{3, 4, 1, 2, 7, 8, 5, 6, 9};
    private String nid;
    private ArrayList i2l_map = new ArrayList();
    private ArrayList i2ls_map = new ArrayList();
    private ArrayList i2n_map = new ArrayList();
    private ArrayList i2ns_map = new ArrayList();
    private ArrayList i2c_map = new ArrayList();
    private ArrayList i2cs_map = new ArrayList();
    private ArrayList i2r_map = new ArrayList();
    private ArrayList i2rs_map = new ArrayList();
    private ArrayList ii_map = new ArrayList();
    private ResourceDescriptor[] i2l_resolvers;
    private ResourceDescriptor[] i2ls_resolvers;
    private ResourceDescriptor[] i2n_resolvers;
    private ResourceDescriptor[] i2ns_resolvers;
    private ResourceDescriptor[] i2c_resolvers;
    private ResourceDescriptor[] i2cs_resolvers;
    private ResourceDescriptor[] i2r_resolvers;
    private ResourceDescriptor[] i2rs_resolvers;
    private ResourceDescriptor[] ii_resolvers;
    private boolean setup_done = false;

    public NamespaceResolver(String string) {
        this.nid = string;
    }

    String getNID() {
        return this.nid;
    }

    void addResource(String string, String string2) {
        int[] nArray = string2 != null ? this.parseServices(string2.toUpperCase()) : ALL_SERVICES;
        String string3 = null;
        int n = -1;
        int n2 = string.lastIndexOf(58);
        if (n2 == -1) {
            string3 = string;
        } else {
            string3 = string.substring(0, n2);
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            ResourceDescriptor resourceDescriptor = new ResourceDescriptor();
            resourceDescriptor.server = string3;
            resourceDescriptor.port = n;
            resourceDescriptor.path = new StringBuffer(URI_RES_QUERY);
            switch (nArray[i]) {
                case 3: {
                    resourceDescriptor.path.append("N2R?");
                    this.i2r_map.add(resourceDescriptor);
                    break;
                }
                case 4: {
                    resourceDescriptor.path.append("N2RS?");
                    this.i2rs_map.add(resourceDescriptor);
                    break;
                }
                case 1: {
                    resourceDescriptor.path.append("N2L?");
                    this.i2l_map.add(resourceDescriptor);
                    break;
                }
                case 2: {
                    resourceDescriptor.path.append("N2LS?");
                    this.i2ls_map.add(resourceDescriptor);
                    break;
                }
                case 7: {
                    resourceDescriptor.path.append("N2N?");
                    this.i2n_map.add(resourceDescriptor);
                    break;
                }
                case 8: {
                    resourceDescriptor.path.append("N2Ns?");
                    this.i2ns_map.add(resourceDescriptor);
                    break;
                }
                case 5: {
                    resourceDescriptor.path.append("N2C?");
                    this.i2c_map.add(resourceDescriptor);
                    break;
                }
                case 6: {
                    resourceDescriptor.path.append("N2CS?");
                    this.i2cs_map.add(resourceDescriptor);
                    break;
                }
                case 9: {
                    resourceDescriptor.path.append("II?");
                    this.ii_map.add(resourceDescriptor);
                }
            }
            resourceDescriptor.pathLength = resourceDescriptor.path.length();
        }
    }

    private int[] parseServices(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        int n = 0;
        int[] nArray = new int[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("N2R") || string2.equals("I2R")) {
                    nArray[n++] = 3;
                    continue;
                }
                if (string2.equals("N2RS") || string2.equals("I2RS")) {
                    nArray[n++] = 4;
                    continue;
                }
                if (string2.equals("N2L") || string2.equals("I2L")) {
                    nArray[n++] = 1;
                    continue;
                }
                if (string2.equals("N2LS") || string2.equals("I2LS")) {
                    nArray[n++] = 2;
                    continue;
                }
                if (string2.equals("N2N") || string2.equals("I2N")) {
                    nArray[n++] = 7;
                    continue;
                }
                if (string2.equals("N2NS") || string2.equals("I2NS")) {
                    nArray[n++] = 8;
                    continue;
                }
                if (string2.equals("N2C") || string2.equals("I2C")) {
                    nArray[n++] = 5;
                    continue;
                }
                if (string2.equals("N2CS") || string2.equals("I2CS")) {
                    nArray[n++] = 6;
                    continue;
                }
                if (!string2.equals("II")) continue;
                nArray[n++] = 9;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (nArray.length != n) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    void setupFinished() {
        if (this.setup_done) {
            return;
        }
        ResourceDescriptor[] resourceDescriptorArray = new ResourceDescriptor[]{};
        this.i2l_resolvers = this.i2l_map.toArray(resourceDescriptorArray);
        this.i2ls_resolvers = this.i2ls_map.toArray(resourceDescriptorArray);
        this.i2n_resolvers = this.i2n_map.toArray(resourceDescriptorArray);
        this.i2ns_resolvers = this.i2ns_map.toArray(resourceDescriptorArray);
        this.i2c_resolvers = this.i2c_map.toArray(resourceDescriptorArray);
        this.i2cs_resolvers = this.i2cs_map.toArray(resourceDescriptorArray);
        this.i2r_resolvers = this.i2r_map.toArray(resourceDescriptorArray);
        this.i2rs_resolvers = this.i2rs_map.toArray(resourceDescriptorArray);
        this.ii_resolvers = this.ii_map.toArray(resourceDescriptorArray);
        this.i2l_map = null;
        this.i2ls_map = null;
        this.i2n_map = null;
        this.i2ns_map = null;
        this.i2c_map = null;
        this.i2cs_map = null;
        this.i2r_map = null;
        this.i2rs_map = null;
        this.ii_map = null;
        this.setup_done = true;
    }

    public ResourceDescriptor decode(URN uRN, int n) throws UnknownNIDException, UnresolvableURIException {
        ResourceDescriptor resourceDescriptor;
        String string = uRN.getNamespace();
        if (!this.nid.equals(string)) {
            throw new UnknownNIDException();
        }
        switch (n) {
            case 3: {
                resourceDescriptor = this.i2r_resolvers[0];
                break;
            }
            case 4: {
                resourceDescriptor = this.i2rs_resolvers[0];
                break;
            }
            case 1: {
                resourceDescriptor = this.i2l_resolvers[0];
                break;
            }
            case 2: {
                resourceDescriptor = this.i2ls_resolvers[0];
                break;
            }
            case 7: {
                resourceDescriptor = this.i2n_resolvers[0];
                break;
            }
            case 8: {
                resourceDescriptor = this.i2ns_resolvers[0];
                break;
            }
            case 5: {
                resourceDescriptor = this.i2c_resolvers[0];
                break;
            }
            case 6: {
                resourceDescriptor = this.i2cs_resolvers[0];
                break;
            }
            case 9: {
                resourceDescriptor = this.ii_resolvers[0];
                break;
            }
            default: {
                throw new UnresolvableURIException("Invalid service type");
            }
        }
        return resourceDescriptor;
    }

    public ResourceDescriptor[] decodeList(URN uRN, int n) throws UnknownNIDException, UnresolvableURIException {
        ResourceDescriptor[] resourceDescriptorArray;
        String string = uRN.getNamespace();
        if (!this.nid.equals(string)) {
            throw new UnsupportedServiceException();
        }
        switch (n) {
            case 3: {
                resourceDescriptorArray = this.i2r_resolvers;
                break;
            }
            case 4: {
                resourceDescriptorArray = this.i2rs_resolvers;
                break;
            }
            case 1: {
                resourceDescriptorArray = this.i2l_resolvers;
                break;
            }
            case 2: {
                resourceDescriptorArray = this.i2ls_resolvers;
                break;
            }
            case 7: {
                resourceDescriptorArray = this.i2n_resolvers;
                break;
            }
            case 8: {
                resourceDescriptorArray = this.i2ns_resolvers;
                break;
            }
            case 5: {
                resourceDescriptorArray = this.i2c_resolvers;
                break;
            }
            case 6: {
                resourceDescriptorArray = this.i2cs_resolvers;
                break;
            }
            case 9: {
                resourceDescriptorArray = this.ii_resolvers;
                break;
            }
            default: {
                throw new UnresolvableURIException("Invalid service type");
            }
        }
        return resourceDescriptorArray;
    }

    public String toString() {
        return "Namespace resolver for " + this.nid;
    }
}

