/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.resolve.thttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import org.ietf.uri.resolve.ConfigErrorException;
import vlc.net.resolve.thttp.NamespaceResolver;

class FileParser {
    private static final String NID_TOKEN_STR = "NID:";
    private static final String RES_TOKEN_STR = "RES:";
    private static final int NID_TOKEN = 1;
    private static final int NID_ID = 2;
    private static final int RES_TOKEN = 3;
    private static final int RES_URL_STR = 4;
    private static final int RES_SERVICE_STR = 5;

    FileParser() {
    }

    public static HashMap parseBindingsFile(InputStream inputStream) throws IOException, ConfigErrorException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return FileParser.parseBindingsFile(inputStreamReader);
    }

    public static HashMap parseBindingsFile(Reader reader) throws IOException, ConfigErrorException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.commentChar(35);
        String string = null;
        int n = 1;
        NamespaceResolver namespaceResolver = null;
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, NamespaceResolver> hashMap = new HashMap<String, NamespaceResolver>();
        block12: while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -3) {
                System.out.println("Invalid token (" + streamTokenizer.nval + ") found in file on line " + streamTokenizer.lineno());
                continue;
            }
            String string2 = streamTokenizer.sval;
            switch (n) {
                case 1: {
                    if (string2.equalsIgnoreCase(NID_TOKEN_STR)) {
                        n = 2;
                        continue block12;
                    }
                    System.out.println("Invalid token for NID def " + string2 + " on line " + streamTokenizer.lineno());
                    FileParser.clearToNextNID(streamTokenizer);
                    continue block12;
                }
                case 2: {
                    if (namespaceResolver != null) {
                        namespaceResolver.setupFinished();
                    }
                    namespaceResolver = new NamespaceResolver(string2);
                    bl2 = false;
                    n = 3;
                    continue block12;
                }
                case 3: {
                    if (NID_TOKEN_STR.equals(string2)) {
                        streamTokenizer.pushBack();
                        n = 1;
                        continue block12;
                    }
                    if (string2.equalsIgnoreCase(RES_TOKEN_STR)) {
                        n = 4;
                        continue block12;
                    }
                    System.out.println("Invalid token for Resource def " + string2 + " on line " + streamTokenizer.lineno());
                    FileParser.clearToNextResource(streamTokenizer);
                    continue block12;
                }
                case 4: {
                    string = string2;
                    n = 5;
                    continue block12;
                }
                case 5: {
                    String string3 = null;
                    if (NID_TOKEN_STR.equals(string2)) {
                        streamTokenizer.pushBack();
                        n = 1;
                    } else {
                        string3 = string2;
                    }
                    try {
                        namespaceResolver.addResource(string, string3);
                        if (bl2) continue block12;
                        hashMap.put(namespaceResolver.getNID(), namespaceResolver);
                        bl2 = true;
                        continue block12;
                    }
                    catch (Exception exception) {
                        String string4 = "unexpected error in THTTP parser " + exception;
                        throw new ConfigErrorException(string4);
                    }
                    finally {
                        n = 3;
                        continue block12;
                    }
                }
            }
        }
        if (namespaceResolver != null) {
            namespaceResolver.setupFinished();
        }
        return hashMap;
    }

    private static boolean checkIsKeyword(String string) {
        return NID_TOKEN_STR.equalsIgnoreCase(string) || RES_TOKEN_STR.equalsIgnoreCase(string);
    }

    private static void clearToNextNID(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            if (!streamTokenizer.sval.equals(NID_TOKEN_STR)) continue;
            streamTokenizer.pushBack();
            break;
        }
    }

    private static void clearToNextResource(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            if (!streamTokenizer.sval.equals(RES_TOKEN_STR) && !streamTokenizer.sval.equals(NID_TOKEN_STR)) continue;
            streamTokenizer.pushBack();
            break;
        }
    }
}

