/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.resolve.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.HashMap;
import org.ietf.uri.NoURNBindingsException;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceFactory;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.ietf.uri.URN;
import org.ietf.uri.URNResolverService;
import org.ietf.uri.UnresolvableURIException;
import org.ietf.uri.UnsupportedServiceException;
import org.ietf.uri.resolve.ConfigErrorException;
import org.ietf.uri.resolve.UnknownNIDException;
import vlc.net.resolve.file.FileParser;
import vlc.net.resolve.file.NamespaceResolver;

public class Resolver
implements URNResolverService {
    private static final String URN_BINDINGS_FILE = "urn_bindings";
    private static final String URN_SYSTEM_PROP = "urn.bindings.path";
    private static final String BAD_TYPE_MSG = "File service does not support service type: ";
    private static HashMap namespace_resolvers;
    private URIResourceFactory resource_factory = null;

    public void init() throws ConfigErrorException {
        try {
            InputStream inputStream = null;
            String string = System.getProperty(URN_SYSTEM_PROP);
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                if (!string.endsWith("/")) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(URN_BINDINGS_FILE);
                java.net.URL uRL = new java.net.URL(stringBuffer.toString());
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                uRLConnection.getContentType();
                uRLConnection.getContentEncoding();
                uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
            } else {
                inputStream = ClassLoader.getSystemResourceAsStream(URN_BINDINGS_FILE);
            }
            if (inputStream == null) {
                throw new NoURNBindingsException("No stream to bindings file");
            }
            namespace_resolvers = FileParser.parseBindingsFile(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new NoURNBindingsException("Static init URN Bindings:\n" + iOException);
        }
    }

    public boolean checkService(int n) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean canResolve(String string) {
        return namespace_resolvers.containsKey(string);
    }

    public void setResourceFactory(URIResourceFactory uRIResourceFactory) {
        this.resource_factory = uRIResourceFactory;
    }

    public Object decode(URN uRN, int n) throws UnsupportedServiceException {
        String string = uRN.getNamespace();
        if (n != 1 && n != 3) {
            throw new UnsupportedServiceException(BAD_TYPE_MSG + n);
        }
        if (!this.canResolve(string)) {
            return null;
        }
        URL uRL = null;
        String string2 = null;
        NamespaceResolver namespaceResolver = (NamespaceResolver)namespace_resolvers.get(string);
        try {
            string2 = namespaceResolver.decode(uRN);
        }
        catch (UnknownNIDException unknownNIDException) {
        }
        catch (UnresolvableURIException unresolvableURIException) {
            // empty catch block
        }
        if (n == 1) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            try {
                String string3 = URI.getScheme((String)string2);
                String[] stringArray = URIUtils.getHostAndPortFromUrl((String)string2);
                String string4 = null;
                int n2 = 0;
                if (stringArray != null) {
                    string4 = stringArray[0];
                    n2 = Integer.parseInt(stringArray[1]);
                }
                String string5 = URIUtils.getPathFromUrlString((String)string2);
                String string6 = URIUtils.getQueryFromUrlString((String)string2);
                String string7 = string5 + "?" + string6;
                uRL = this.resource_factory.requestResource(string3, string4, n2, string7);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public Object[] decodeList(URN uRN, int n) throws UnsupportedServiceException {
        Object object;
        int n2;
        String string = uRN.getNamespace();
        if (n != 2 && n != 4) {
            throw new UnsupportedServiceException(BAD_TYPE_MSG + n);
        }
        if (!this.canResolve(string)) {
            return null;
        }
        NamespaceResolver namespaceResolver = (NamespaceResolver)namespace_resolvers.get(string);
        int n3 = 0;
        Object[] objectArray = null;
        String[] stringArray = null;
        try {
            stringArray = namespaceResolver.decodeList(uRN);
        }
        catch (UnknownNIDException unknownNIDException) {
            // empty catch block
        }
        if (n == 2) {
            n2 = stringArray != null ? stringArray.length : 0;
            objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    objectArray[n3++] = new URL(stringArray[i]);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        } else {
            n2 = stringArray != null ? stringArray.length : 0;
            objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    object = URI.getScheme((String)stringArray[i]);
                    String[] stringArray2 = URIUtils.getHostAndPortFromUrl((String)stringArray[i]);
                    String string2 = null;
                    int n4 = 0;
                    if (stringArray2 != null) {
                        string2 = stringArray2[0];
                        n4 = Integer.parseInt(stringArray2[1]);
                    }
                    String string3 = URIUtils.getPathFromUrlString((String)stringArray[i]);
                    String string4 = URIUtils.getQueryFromUrlString((String)stringArray[i]);
                    String string5 = string3 + "?" + string4;
                    objectArray[n3++] = this.resource_factory.requestResource((String)object, string2, n4, string5);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (n3 != n2) {
            object = new URL[n3];
            System.arraycopy(objectArray, 0, object, 0, n3);
            objectArray = object;
        }
        return objectArray;
    }
}

