/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.resolve.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import org.ietf.uri.resolve.ConfigErrorException;
import vlc.net.resolve.file.InvalidRegexException;
import vlc.net.resolve.file.NamespaceResolver;
import vlc.net.resolve.file.NoSuchGroupException;

class FileParser {
    private static final String NID_TOKEN_STR = "NID:";
    private static final String GROUP_TOKEN_STR = "GRP:";
    private static final String RES_TOKEN_STR = "RES:";
    private static final int NID_TOKEN = 1;
    private static final int NID_ID = 2;
    private static final int NID_REGEX_STR = 4;
    private static final int GROUP_TOKEN = 5;
    private static final int GROUP_ID = 6;
    private static final int RES_TOKEN = 7;
    private static final int RES_URL_STR = 8;
    private static final int RES_REGEX_STR = 9;

    FileParser() {
    }

    public static HashMap parseBindingsFile(InputStream inputStream) throws IOException, ConfigErrorException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return FileParser.parseBindingsFile(inputStreamReader);
    }

    public static HashMap parseBindingsFile(Reader reader) throws IOException, ConfigErrorException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.wordChars(33, 47);
        streamTokenizer.wordChars(58, 64);
        streamTokenizer.wordChars(91, 94);
        streamTokenizer.commentChar(35);
        streamTokenizer.quoteChar(34);
        String string = null;
        int n = 1;
        NamespaceResolver namespaceResolver = null;
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, NamespaceResolver> hashMap = new HashMap<String, NamespaceResolver>();
        block21: while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -3 && !bl) {
                System.out.println("Invalid token (" + streamTokenizer.nval + ") found in file on line " + streamTokenizer.lineno());
                continue;
            }
            String string2 = streamTokenizer.sval;
            switch (n) {
                case 1: {
                    if (string2.equalsIgnoreCase(NID_TOKEN_STR)) {
                        n = 2;
                        continue block21;
                    }
                    System.out.println("Invalid token for NID def " + string2 + " on line " + streamTokenizer.lineno());
                    FileParser.clearToNextNID(streamTokenizer);
                    continue block21;
                }
                case 2: {
                    namespaceResolver = new NamespaceResolver(string2);
                    bl2 = false;
                    n = 4;
                    continue block21;
                }
                case 4: {
                    try {
                        namespaceResolver.setNidRegex(string2);
                        n = 5;
                    }
                    catch (InvalidRegexException invalidRegexException) {
                        System.out.println("Invalid format for the NID Regex on line " + streamTokenizer.lineno());
                        FileParser.clearToNextNID(streamTokenizer);
                        n = 1;
                    }
                    continue block21;
                }
                case 5: {
                    if (string2.equalsIgnoreCase(GROUP_TOKEN_STR)) {
                        n = 6;
                        continue block21;
                    }
                    System.out.println("Invalid token for GROUP def " + string2 + " on line " + streamTokenizer.lineno());
                    FileParser.clearToNextGroup(streamTokenizer);
                    continue block21;
                }
                case 6: {
                    namespaceResolver.addGroup(string2);
                    n = 7;
                    continue block21;
                }
                case 7: {
                    if (NID_TOKEN_STR.equals(string2)) {
                        streamTokenizer.pushBack();
                        n = 1;
                        continue block21;
                    }
                    if (GROUP_TOKEN_STR.equals(string2)) {
                        streamTokenizer.pushBack();
                        n = 5;
                        continue block21;
                    }
                    if (string2.equalsIgnoreCase(RES_TOKEN_STR)) {
                        n = 8;
                        bl = true;
                        continue block21;
                    }
                    System.out.println("Invalid token for Resource def " + string2 + " on line " + streamTokenizer.lineno());
                    FileParser.clearToNextResource(streamTokenizer);
                    continue block21;
                }
                case 8: {
                    string = string2;
                    n = 9;
                    bl = false;
                    continue block21;
                }
                case 9: {
                    String string3;
                    try {
                        namespaceResolver.addResource(string, string2);
                        if (bl2) continue block21;
                        hashMap.put(namespaceResolver.getNID(), namespaceResolver);
                        continue block21;
                    }
                    catch (InvalidRegexException invalidRegexException) {
                        string3 = "The regular expression on line " + streamTokenizer.lineno() + " is invalid";
                        System.err.println(string3);
                        continue block21;
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        string3 = "Attempting to add a value to an unknown group  on line " + streamTokenizer.lineno();
                        System.err.println(string3);
                        continue block21;
                    }
                    catch (Throwable throwable) {
                        string3 = "ARGH! Something is really screwed that I can't determine the cause of on line " + streamTokenizer.lineno();
                        throw new ConfigErrorException(string3);
                    }
                    finally {
                        n = 7;
                        continue block21;
                    }
                }
            }
        }
        if (hashMap.size() == 0) {
            throw new ConfigErrorException("Unable to find any valid items");
        }
        return hashMap;
    }

    private static boolean checkIsKeyword(String string) {
        return NID_TOKEN_STR.equalsIgnoreCase(string) || GROUP_TOKEN_STR.equalsIgnoreCase(string) || RES_TOKEN_STR.equalsIgnoreCase(string);
    }

    private static void clearToNextNID(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            if (!streamTokenizer.sval.equals(NID_TOKEN_STR)) continue;
            streamTokenizer.pushBack();
            break;
        }
    }

    private static void clearToNextGroup(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            if (!streamTokenizer.sval.equals(GROUP_TOKEN_STR) && !streamTokenizer.sval.equals(NID_TOKEN_STR)) continue;
            streamTokenizer.pushBack();
            break;
        }
    }

    private static void clearToNextResource(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            if (!streamTokenizer.sval.equals(RES_TOKEN_STR) && !streamTokenizer.sval.equals(GROUP_TOKEN_STR) && !streamTokenizer.sval.equals(NID_TOKEN_STR)) continue;
            streamTokenizer.pushBack();
            break;
        }
    }
}

