/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.protocol.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.jar.JarFile;
import org.ietf.uri.JarResourceConnection;
import org.ietf.uri.URI;

public class JarConnection
extends JarResourceConnection {
    private InputStream input_stream = null;
    private String content_type = null;

    protected JarConnection(URI uRI, String string) throws MalformedURLException {
        super(uRI, string);
    }

    protected JarFile getJarFile() throws IOException {
        String string;
        if (!this.connected) {
            this.connect();
        }
        if (!(string = this.jarFileResource.getContentType()).equals("x-java/jar")) {
            throw new IOException("Resource does not point to a JAR file");
        }
        JarFile jarFile = null;
        try {
            jarFile = (JarFile)this.jarFileResource.getContent();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (jarFile == null) {
            throw new IOException("Cannot load content of JAR file");
        }
        return jarFile;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.input_stream == null) {
            if (this.jarEntryName != null) {
                if (this.jarEntry == null) {
                    this.getJarEntry();
                }
                this.input_stream = this.jarFile.getInputStream(this.jarEntry);
            } else {
                this.input_stream = this.jarFileResource.getInputStream();
            }
        }
        return this.input_stream;
    }

    public String getContentType() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.content_type == null) {
            this.content_type = this.jarEntryName != null ? JarConnection.findContentType((String)this.jarEntryName) : "x-java/jar";
        }
        return this.content_type;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.jarFileResource = this.jarFileURI.getResource();
        this.connected = true;
    }
}

